package name.panitz.util;
import java.util.Map;

public interface Logic{
  static record Var(String n) implements Logic{
     public String toString(){return n;}
  }
  static record Neg(Logic f) implements Logic{
     public String toString(){return "¬"+f;}
  }
  static record Implication(Logic l,Logic r) implements Logic{
     public String toString(){return "("+l+"→"+r+")";}
  }
  static record And(Logic l,Logic r) implements Logic{
     public String toString(){return "("+l+"∧"+r+")";}
  }
  static record Or(Logic l,Logic r) implements Logic{
     public String toString(){return "("+l+"∨"+r+")";}
  }

  default Logic transformImplications(){
    if (this instanceof Var v) return v;
    if (this instanceof Neg n) return new Neg(n.f.transformImplications());
    //TODO remaining cases

    throw new RuntimeException("unhandled Logic class case: "+this);
  }

  //utility function for easy creation
  default Logic and(Logic that){return new And(this,that);}
  default Logic or(Logic that){return new Or(this,that);}
  default Logic implication(Logic that){return new Implication(this,that);}
  default Logic neg(){return new Neg(this);}


}