

package name.panitz.util;

import java.util.Set;
import javax.annotation.processing.*;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.*;
import javax.tools.Diagnostic.Kind;

import javax.lang.model.type.*;
import java.io.*;



@SupportedAnnotationTypes("name.panitz.util.CheckDataObject")
@SupportedSourceVersion(SourceVersion.RELEASE_16)
public class DataObjectProcessor extends AbstractProcessor {



  @Override
  public boolean process(Set<?extends TypeElement>as,RoundEnvironment env){
    try{



      for (var element : env.getElementsAnnotatedWith(CheckDataObject.class)) {



        String packageName = ((PackageElement)element.getEnclosingElement())
           .getQualifiedName().toString();
        var cs = ((TypeElement)element);




        generateSetter(packageName,cs);
        checkArgumentTypes(packageName,cs);
        generateServlet(packageName,cs);
      }
      


      return false;
    }catch (Exception e){throw new RuntimeException(e);}
  }



  private void generateSetter(String packageName,TypeElement cs)
                                                      throws Exception{
    var simpleName = cs.getSimpleName();
    var name = simpleName+"Util";
    var fqn = packageName != null?packageName+"."+name:name;



    var  builderFile = processingEnv.getFiler().createSourceFile(fqn);
        
    var out = new PrintWriter(builderFile.openWriter()) ;



    if (packageName != null) {
       out.append("package ").append(packageName).append(";\n");
    }



    out.append("public class ").append(name).append("{");



    for (var rc:cs.getRecordComponents()){
      out.write("\n  static public "+simpleName);
      out.write(" set"+rc.getSimpleName());
      out.write("("+simpleName+" dies, "+ rc.asType() + " v){");
      out.write("\n    return new "+simpleName+"(");


      var first=true;
      for (var rc2:cs.getRecordComponents()){
        if (first) first=false; else out.write(", ");
        if (rc2.getSimpleName().equals(rc.getSimpleName())) out.write("v");
        else out.write("dies."+rc2.getSimpleName()+"()");
      }
      out.append(");").append("\n  }");
    } 


    out.write("\n}");
    out.close();
  }
  


  private void checkArgumentTypes(String packageName,TypeElement cs)
                                                        throws Exception{
    for (var rc:cs.getRecordComponents()){  
      if (!isAllowedFieldType(rc.asType()))
        processingEnv.getMessager().printMessage
           (Kind.ERROR, "illegal field type in DataObject "
           + rc.asType()+ " for field "+rc, cs);
    }
  }



  public static boolean isAllowedFieldType(TypeMirror type) {
    if (type instanceof  DeclaredType dt) {
      if (dt.asElement() instanceof TypeElement ce) {
        return 
           ce.toString().equals("name.panitz.util.UID")
         ||ce.toString().equals("java.lang.String")
         ||ce.getInterfaces().stream()
           .anyMatch(i->(""+i).equals("name.panitz.util.DataObject"));
      }
    }else if (type instanceof PrimitiveType){
      return !type.toString().equals("char");
    }
    return false;
  }


 private void generateServlet(String packageName,TypeElement cs)
                                                        throws Exception{
    var simpleName = cs.getSimpleName();
    var name = simpleName+"Servlet";
    var builderFile = processingEnv.getFiler().createSourceFile(name);
        
    var out = new PrintWriter(builderFile.openWriter()) ;
    if (packageName != null) {
       out.append("package ").append(packageName).append(";\n");
    }
    out.write(
"""
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import static name.panitz.util.DataObject.*;
public class  """);
    out.write(" "+name+" ");
    out.write(
"""
extends HttpServlet{

  @Override
  public void doGet(HttpServletRequest request,HttpServletResponse response) 
                                     throws IOException, ServletException {
    response.setContentType("text/xml");  
    response.setCharacterEncoding("UTF-8");
    String requestUri = request.getRequestURI();
    String rest = requestUri.substring((request.getContextPath()+"/"""
                  +simpleName+"/\").length());");



    out.write(
"""
 if (rest.startsWith("list")){
   //TODO
""");



    out.write(
"""
    }else if (rest.startsWith("get")){
       //TODO
""");



    out.write(
"""
    }else if (rest.startsWith("createTable")){
      //TODO
""");



    out.write(
"""
    }else if (rest.startsWith("save")){
      //TODO
""");



    out.write(
"""
    }else if (rest.startsWith("delete")){
       //TODO
""");




    out.write(
"""
    }else {
      response
        .getOutputStream()
        .println
          ("<info>no match "+rest+" in "+requestUri+"</info>");
    }
  }

  @Override
  public void doPost(HttpServletRequest rq,HttpServletResponse rp)
                                throws IOException, ServletException {
    doGet(rq,rp);
  }
}

""");
    out.close();
  }

}