
package de.hsrm.ads;

import static org.junit.Assert.*;
import org.junit.Test;


public class HashMapTestAbnahme {

	double tolerance = 0.01;

	@Test
	public void testInsertGetFull1() {
		HashMap<Integer> m = new HashMap<Integer>(10, 4);

		assertEquals(0. , m.fillRatio(), tolerance);
	}
	
	@Test
	public void testInsertGetFull2() {
		HashMap<Integer> m = new HashMap<Integer>(10, 4);

		// all inserted strings have the same hash code (5).
		// probing function is x**2 -> only 6 of ten places used.
		assertEquals( true, m.add("A", 1) );
		assertEquals( true, m.add("AA", 2) );
		assertEquals( true, m.add("AAA", 3) );
		assertEquals( true, m.add("AAAA", 4) );
		assertEquals( true, m.add("AAAAA", 5) );
		assertEquals( true, m.add("AAAAAA", 6) );
		
		assertEquals(0.6 , m.fillRatio(), tolerance);
	}
	
	@Test
	public void testInsertGetFull3() {
		HashMap<Integer> m = new HashMap<Integer>(10, 4);

		// all inserted strings have the same hash code (5).
		// probing function is x**2 -> only 6 of ten places used.
		assertEquals( true, m.add("A", 1) );
		assertEquals( true, m.add("AA", 2) );
		assertEquals( true, m.add("AAA", 3) );
		assertEquals( true, m.add("AAAA", 4) );
		assertEquals( true, m.add("AAAAA", 5) );
		assertEquals( true, m.add("AAAAAA", 6) );
		
		assertEquals( false, m.add("AAAAAAA", 7) );
		assertEquals( false, m.add("AAAAAAAA", 8) );

		assertEquals(0.6 , m.fillRatio(), tolerance);
	}
	
	@Test
	public void testInsertGetFull4() {
		HashMap<Integer> m = new HashMap<Integer>(10, 4);

		// all inserted strings have the same hash code (5).
		// probing function is x**2 -> only 6 of ten places used.
		assertEquals( true, m.add("A", 1) );
		assertEquals( true, m.add("AA", 2) );
		assertEquals( true, m.add("AAA", 3) );
		assertEquals( true, m.add("AAAA", 4) );
		assertEquals( true, m.add("AAAAA", 5) );
		assertEquals( true, m.add("AAAAAA", 6) );
		
		assertEquals( false, m.add("AAAAAAA", 7) );
		assertEquals( false, m.add("AAAAAAAA", 8) );

		assertEquals( 1, (int)m.get("A"));
		assertEquals( 2, (int)m.get("AA"));
		assertEquals( 3, (int)m.get("AAA"));
		assertEquals( 4, (int)m.get("AAAA"));
		assertEquals( 5, (int)m.get("AAAAA"));
		assertEquals( 6, (int)m.get("AAAAAA"));
		assertEquals( null, m.get("AAAAAAA"));
		assertEquals( null, m.get("AAAAAAAA"));
	}
	
}
