
package de.hsrm.ads;

import org.junit.Test;


import static org.junit.Assert.assertTrue;

import java.util.List;

import static org.junit.Assert.assertEquals;


public class SpellCorrectorTestAbnahme {

	
	public boolean equals(SpellCorrector.Entry e1, SpellCorrector.Entry e2) {
		return e1.nchanged() == e2.nchanged() &&
				e1.reducedWord.equals(e2.reducedWord) &&
				e1.origWord.equals(e2.origWord);
	}
	
	public void check(SpellCorrector.Entry[] expected, List<SpellCorrector.Entry> actual) {
		if (expected.length == 0 && actual == null)
			return;
		assertEquals(expected.length, actual.size());
		for (SpellCorrector.Entry a : actual) {
			boolean found = false;
			for (SpellCorrector.Entry e : expected) {
				if (equals(e, a)) {
					found = true;
					break;
				}
			}
			assertTrue(found);
		}
		for (SpellCorrector.Entry e : expected) {
			boolean found = false;
			for (SpellCorrector.Entry a : actual) {
				if (equals(e, a)) {
					found = true;
					break;
				}
			}
			assertTrue(found);
		}
	}
		
	// remove up to four chars from "abc"
	@Test
	public void testGenerate3() {
		
		SpellCorrector sc = new SpellCorrector(4, 101, 10);
		List<SpellCorrector.Entry> actual = sc.generate("abc", sc.K);

		SpellCorrector.Entry[] expected = new SpellCorrector.Entry[] {
				new SpellCorrector.Entry("", "abc"),
				new SpellCorrector.Entry("a", "abc"),
				new SpellCorrector.Entry("b", "abc"),
				new SpellCorrector.Entry("c", "abc"),
				new SpellCorrector.Entry("ab", "abc"),
				new SpellCorrector.Entry("ac", "abc"),
				new SpellCorrector.Entry("bc", "abc"),
				new SpellCorrector.Entry("abc", "abc"),				
		};
		check( expected, actual );
	}


	public void check(String[] expected, List<String> actual) {
		assertEquals(expected.length, actual.size());
		for (String e : expected) {
			boolean found = false;
			for (String a : actual) {
				if (e.equals(a)) {
					found = true;
					break;
				}
			}
			assertTrue(found);
		}
	}
	
	// tiny test: cannot find if too few changes in index
	@Test
	public void testMatch3() {

		List<String> actual;
		String[] expected;
		SpellCorrector sc = new SpellCorrector(1, 1001, 31);
		sc.add("abc");
		sc.add("def");
		sc.add("ghi");

		// ab -> abc
		actual = sc.match("ab");
		expected = new String[] {"abc"};
		check(expected, actual);
		
		// a -> abc
		actual = sc.match("a");
		expected = new String[] {};
		check(expected, actual);

	}
	
	
	// Leerer Index
	@Test
	public void testMatch7() {

		List<String> actual;
		String[] expected;
		SpellCorrector sc = new SpellCorrector(5, 1001, 31);

		actual = sc.match("raver");
		expected = new String[] {};
		check(expected, actual);
	}

	// Tricky: Ergebnisliste sollte *keine* Duplikate enthalten.
	// Hier könnte ein Duplikat entstehen, weil esso mit sos
	// über ss und so gematcht werden könnte.
	@Test
	public void testMatch8() {

		List<String> actual;
		String[] expected;
		SpellCorrector sc = new SpellCorrector(2, 1001, 31);
		sc.add("sos"); // os, ss, so

		actual = sc.match("esso");
		expected = new String[] {"sos"};
		check(expected, actual);
	}

}
