package name.panitz.util.streams;

import static org.junit.Assert.*;

import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

import org.junit.Before;
import org.junit.Test;

public class SpliterateStringTest{

  @Before
  public void setUp() throws Exception {
  }
  
  int i = 0;
  @Test
  public void test1() {
    SpliterateString ss1 = new SpliterateString("1234567890");
    i = 0;
    ss1.forEachRemaining(x->i++);
    assertEquals("»1234567890« sollte über 10 chars iterieren", 10, i);
  }

  @Test
  public void test2() {
    Stream<Character> stream 
    = StreamSupport
      .stream(new SpliterateString("hallo"), false);
    
    assertEquals("erster Aufruf sollte erstes Zeichen des String liefern", 'h', stream.findFirst().get().charValue());
  }
  @Test
  public void test3() {
    Stream<Character> stream 
    = StreamSupport
      .stream(new SpliterateString("hallo"), false);
    StringBuffer result = new StringBuffer();
    stream.forEach(c -> result.append(c));
    assertEquals("erster Aufruf sollte erstes Zeichen des String liefern", "hallo", result.toString());
  }

}