package name.panitz.util;

import static org.junit.Assert.*;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

import org.junit.Before;
import org.junit.Test;

public class ALSpliteratorTest{
  AL<String> xs;
  AL<Integer> is;

  static <A> Stream<A> stream(Spliterator<A> sp) {
    return StreamSupport.stream(sp, false);
  }
  static <A> Stream<A> parallelStream(Spliterator<A> sp) {
    return StreamSupport.stream(sp, true);
  }

  @Before
  public void setUp() {
    xs = new AL<>();
    is = new AL<>();
    for (int i = 0; i < 10000; i++) {
      is.add(i);
    }
    Arrays.asList("Freunde", "Römer", "Landsleute", "leiht", "mir", "Euer", "Ohr").forEach(x -> xs.add(x));
  }

  @Test
  public void test1() {
    assertEquals("xs.stream().count(): Anzahl der Elemente durch Iteration falsch", 7, xs.stream().count());
    assertEquals("is.stream().count(): Anzahl der Elemente durch Iteration falsch", 10000, is.stream().count());
  }

  @Test
  public void test2() {
    Spliterator<Integer> is1 = is.getSpliterator();
    Spliterator<Integer> is2 = is1.trySplit();
    assertNotNull("Spliterator ist null bei trySplit, soll aber neuen Spliterator erzeugen.", is2);
  }

  @Test
  public void test3() {
    Spliterator<Integer> is1 = is.getSpliterator();
    Spliterator<Integer> is2 = is1.trySplit();
    long countis1 = stream(is1).count();
    long countis2 = stream(is2).count();
    assertEquals("Anzahl der Elemente durch Iteration nach einem trySplit falsch", 10000, countis1 + countis2);
  }

  @Test
  public void test4() {
    Spliterator<Integer> is1 = is.getSpliterator();
    Spliterator<Integer> is2 = is1.trySplit();
    long countis1 = stream(is1).count();
    long countis2 = stream(is2).count();
    long abs = Math.abs(countis1 - countis2);
    assertTrue("Die zwei gesplitteten Spliterartoren sollen möglichst gleich groß sein. Differenz ist: " + abs,
        2 > abs);
  }
  @Test
  public void test5() {
    assertEquals("xs.parallelStream().count(): Anzahl der Elemente durch Iteration falsch", 7, xs.parallelStream().count());
    assertEquals("is.parallelStream().count(): Anzahl der Elemente durch Iteration falsch", 10000, is.parallelStream().count());
  }
  }