package name.panitz.util;

import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;


public interface Li<A> {
  int size();
  void add(A a);
  A get(int i);
  void addAll(java.util.Collection<? extends A> os);
  boolean containsWith(Predicate<A> p);
  default boolean contains(A o){
    return containsWith(x->x.equals(o));
  };
  void remove(int i);
  void add(A o, int i);
  
  Li<A> sublist(int from, int length);

  void forEach(Consumer<A> con);
  Li<A> filter(Predicate<A> p);
  <B> Li<B> map(Function<A, B> f);
  default Li<A> copy(){return map(x->x);}

  void sortBy(java.util.Comparator<? super A> comp);

  <B> B foldl(B start,BiFunction<B, A, B> op);

  Spliterator<A> getSpliterator();
  default Stream<A> stream(){
    return StreamSupport.stream(getSpliterator(), false);
  }
  default Stream<A> parallelStream(){
    return StreamSupport.stream(getSpliterator(), true);
  }
}