package name.panitz.util;

import static org.junit.Assert.*;

import java.util.Arrays;
import java.util.Spliterator;

import org.junit.Before;
import org.junit.Test;

public class LLTest {
  LL<String> xs;
  LL<Integer> is;
  int i2;
  static class I{int i=0;};
  I i;
  @Before
  public void setUp() throws Exception {
    xs = new LL<>();
    for (String x:Arrays.asList("ohr","euer","mir","leiht","Landsleute","Römer","Freunde"))
      xs = new LL<>(x,xs);
    
    is = new LL<>();
    for (int i : Arrays.asList(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20))
      is = new LL<>(i,is);
    i = new I();
    i2 = 0;
  }
  
  @Test
  public void test1() {
    xs.stream().forEach(x -> i.i++);
    assertEquals("Der Spliterator iteriert bei nicht paralleler Ausführung über falsche Elementanzahl.", 7, i.i);
  }

  @Test
  public void test4() {
    xs.parallelStream().forEach(x -> i.i++);
    assertEquals("Der Spliterator iteriert bei paralleler Ausführung über falsche Elementanzahl.", 7, i.i);
  }
    

  @Test
  public void test7() {
    Spliterator<Integer> spl1 = is.getSpliterator();
    Spliterator<Integer> spl2 = spl1.trySplit();
    spl1.forEachRemaining(x -> i.i++);
    spl2.forEachRemaining(x -> i2++);
    assertEquals("Die Spliteratoren nach einem trysplit haben nicht mehr richtige Elementanzahl zum Iterieren.", 20,  i.i+i2);
    assertTrue("Nach einem trySplit soll es zwei Spliteratoren geben, die jeweils mindestens 4 Elemente haben, sofern es ursprünglich mindestens 8 Elemente waren. Das ist hier nicht der Fall", i.i>3&&i2>3);
  }

  @Test
  public void test9() {
    xs = new LL<>();
    assertTrue("trySplit für leere Spliteratoren soll null ergeben: new LL<>().getSpliterator().trySplit()==null",xs.getSpliterator().trySplit()==null);
  }

  @Test
  public void test11() {
    is.stream().forEach(x -> i.i++);
    is.stream().forEach(x -> i.i++);
    is.stream().forEach(x -> i.i++);
    assertEquals("Mehrere Spliteratoren für eine Liste scheinen nicht unabhängig voneinander zu sein.", 60, i.i);
  }

}
