package saxblatt;

import static org.junit.Assert.*;

import java.io.StringReader;

import javax.xml.parsers.SAXParserFactory;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class GetCodeTest{
  @Rule
  public Timeout globalTimeout = Timeout.millis(500); 

  
  GetCode handler;
  String skript1 = "<?xml version=\"1.0\"?>\n"
      + "<?xml-stylesheet type=\"text/xsl\" href=\"toHTML.xsl\"?>\n"
      + "<skript lang=\"ngerman\">\n"
      + "\n"
      + "\n"
      + "<pakete>\n"
      + "</pakete>\n"
      + "\n"
      + "<titelseite>\n"
      + "<titel>Einführung in die Programmierung mit C</titel>\n"
      + "<untertitel>(Entwurf)</untertitel>\n"
      + "<tutor mark=\"false\"><bla></bla><untertitel>(Tutorenversion)</untertitel></tutor>\n"
      + "\n"
      + "<semester>WS 06/07</semester>\n"
      + "<autor>Sven Eric Panitz</autor>\n"
      + "<institution>FH Wiesbaden</institution> \n"
      + "\n"
      + "\n"
      + "<disclaimer>Die vorliegende Fassung des Skriptes ist ein Entwurf\n"
      + "für die Vorlesung des  Wintersemesters und wird im Laufe der\n"
      + "Vorlesung erst seine endgültige Form finden. Kapitel können dabei\n"
      + "umgestellt, vollkommen revidiert werden oder gar ganz wegfallen. \n"
      + "<p/>\n"
      + "Dieses Skript entsteht begleitend zur Vorlesung des\n"
      + "WS 06/07. \n"
      + "<p/>\n"
      + "Naturgemäß ist es in Aufbau und Qualität nicht mit einem Buch\n"
      + "vergleichbar. Flüchtigkeits- und Tippfehler werden sich im Eifer\n"
      + "des Gefechtes nicht vermeiden lassen und wahrscheinlich in nicht\n"
      + "geringem Maße auftreten. Ich bin natürlich stets dankbar, wenn\n"
      + "ich auf solche aufmerksam gemacht werde und diese korrigieren\n"
      + "kann.<p/>\n"
      + "\n"
      + "Der Quelltext dieses Skripts ist eine XML-Datei, die durch eine XQuery \n"
      + "in eine <LaTeX/>-Datei transformiert und für die schließlich eine\n"
      + "pdf-Datei und eine postscript-Datei\n"
      + "erzeugt wird. \n"
      + "Beispielprogramme werden direkt aus dem Skriptquelltext extrahiert und sind\n"
      + "auf der Webseite herunterzuladen.<p/>\n"
      + "<tutor>Von diesem Skript gibt es zwei Versionen: eine Studentenversion und eine\n"
      + "Tutorenversion mit Lösungen der Aufgaben. Sie halten die Tutorenversion in\n"
      + "Händen. Sie zeichnet sich durch zusätzliche Informationen aus. Textteile die\n"
      + "nicht in der Studentenversion des Skriptes stehen, sind jeweils zu Beginn und\n"
      + "Ende mit einem schwarzen Haken am Rand markiert.\n"
      + "Beide Versionen des Skriptes werden aus ein und\n"
      + "derselben XML-Quelltextdatei generiert.</tutor>\n"
      + "</disclaimer>\n"
      + "\n"
      + "</titelseite>\n"
      + "\n"
      + "<toc/>\n"
      + "\n"
      + "<kapitel titel=\"Einführung\"><label name=\"start\"/>\n"
      + "<vortrag>\n"
      + "\n"
      + "<datum>WS 2006/2007</datum>\n"
      + "<autor>Sven Eric Panitz</autor>\n"
      + "<email>sveneric@panitz.name</email>\n"
      + "<web>http://www.panitz.name</web>\n"
      + "<titel>Programmieren in C</titel>\n"
      + "</vortrag>\n"
      + "\n"
      + "<section titel=\"Erste Programme\">\n"
      + "Im Zuge dieses Kurse wollen wir zunächst einmal alle Überlegungen theoretischer\n"
      + "Natur auf später verschieben und direkt mit dem ersten Programm\n"
      + "anfangen. Hierzu betrachten wir zunächst das leere Programm, das erst einmal\n"
      + "nichts tut:\n"
      + "\n"
      + "<code class=\"DasLeereProgramm\" lang=\"c\" main=\"main\">int main(){\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "\n"
      + "Programme der Programmiersprache C sind in einer Textdatei zu speichern, deren\n"
      + "Dateiendung <tt>.c</tt> ist. Obiges Programm ist also in einer Textdatei \n"
      + "namens <tt>DasLeereProgramm.c</tt> zu speichern. Um Textdateien zu schreiben\n"
      + "und zu speichern benötigt man  ein weiteres Programm, einen Editor. Es gibt viele\n"
      + "Editoren, mit denen man dies bewerkstelligen kann. Es reichen hierzu\n"
      + "primitivste Editorprogramme. Unter dem Windows-Betriebssysteme findet sich in\n"
      + "der\n"
      + "Regel das Editorprogramm <tt>notepad</tt>. Ein schwer zu bedienender jedoch\n"
      + "auch sehr mächtiger und auf allen Plattformen verfügbarer Editor ist das\n"
      + "Programm <tt>vi</tt>. Auf Linux-Betriebssystemen findet sich zumeist das\n"
      + "Editorprogramm <tt>kate</tt>. Ich persönlich benutze seit Jahrzenten das\n"
      + "Editorprogramm <tt>emacs</tt>. Wählen Sie auf Ihrer Platform einen einfachen\n"
      + "Texteditor und schreiben und speichern mit ihm das obige \n"
      + "Programm: <tt>DasLeereProgramm.c</tt>.\n"
      + "\n"
      + "\n"
      + "Obwohl das Programm nichts tut, besteht es schon immerhin aus drei Zeilen. Man\n"
      + "hätte das Programm auch in einer Zeile schreiben können als:\n"
      + "\n"
      + "<code class=\"AuchDasLeereProgramm\" lang=\"c\" main=\"main\">int main(){return 0;}</code>\n"
      + "\n"
      + "Ob und wo man Zeilenumbrüche macht, ist im Prinzip für die Programmiersprache\n"
      + "C egal<footnote>Es gibt tatsächlich Programmiersprachen, in denen der Beginn\n"
      + "einer neuen Zeile eine Bedeutung hat, in C aber nicht.</footnote>. Trotzdem hat man sich auf\n"
      + "Konventionen verständigt, wann man eine neue Zeile beginnt und wann man eine\n"
      + "Zeile einrückt. Diese Konventionen erlauben es einen menschlichen Leser\n"
      + "Programme besser zu verstehen. Deshalb ist das Beachten solcher Konventionen in den meisten\n"
      + "Firmen Pflicht; und auch in unserem Programmierkurs werden wir ein paar wenige\n"
      + "Konventionen verbindlich machen. Die erste Konvention lautet:\n"
      + "\n"
      + "<wichtig>Wann immer die Programmiersprache C verlangt, das Code zwischen einer\n"
      + "öffnenden und einer schließenden geschweifte Klammer zu stehen hat, ist der Code\n"
      + "zwischen den Klammern ein Stückchen weiter einzurücken. \n"
      + "Nach der öffnenden Klammer ist eine neue\n"
      + "Zeile zu beginnen. Die schließende Klammer steht auf einer neuen Zeile.\n"
      + "\n"
      + "In wieweit eingerückt wird, ist einheitlich zu handhaben.\n"
      + "</wichtig> \n"
      + "\n"
      + "Die Programme dieses Skriptes halten sich weitgehendst \n"
      + "an diese Regel. Es wird dabei\n"
      + "jeweils um zwei Leerzeichen eingerückt.<footnote>Es wird bei den\n"
      + "Beispielprogrammen bei Einzeilern davon abgewichen.</footnote>\n"
      + "\n"
      + "\n"
      + "Das Programm <tt>AuchDasLeereProgramm.c</tt> verletzt diese\n"
      + "Konvention.<footnote>Und würde bei einer Benotung deshalb Abzüge bekommen.</footnote>\n"
      + "\n"
      + "\n"
      + "\n"
      + "Auch wenn die beiden obigen Programme noch nichts tun, wollen wir sie einmal\n"
      + "ausführen. Um ein Programm auf dem Computer ausführen zu können, muss es\n"
      + "in eine Form übersetzt werden, die der Computer versteht. Der Programmtext,\n"
      + "wie er mit dem Texteditor geschrieben wurde, kann nicht direkt vom Computer\n"
      + "ausgeführt werden. Er ist erst in eine Folge von Nullen und Einsen zu\n"
      + "übersetzen, die vom Betriebssystem aus gestartet und als Prozessorbefehle\n"
      + "direkt den Prozessor des Computers zum Ausführen gegeben werden können. Das\n"
      + "Übersetzen eines Programmtextes in ein ausführbares Programm unternimmt ein\n"
      + "weiteres Programm, der Übersetzer für eine bestimmte\n"
      + "Programmiersprache. Dieser wird auf \n"
      + "Englisch <em>compiler</em><index>Compiler</index> bezeichnet. Auf\n"
      + "Deutsch wird eher von einem <em>Übersetzer</em> als von \n"
      + "einem <em>Kompilierer</em> gesprochen.<footnote>Während sich im Französischen\n"
      + "das Wort <em>compilateur</em> durchgesetzt hat.</footnote> Meist benutzt man\n"
      + "auf Deutsch auch das englische Wort <em>compiler</em>.\n"
      + "\n"
      + "\n"
      + "Wir müssen also unseren obigen Programmtext, den wir mit einem Texteditor\n"
      + "geschrieben haben, einen Kompilierer für die Programmiersprache C geben, damit\n"
      + "wir ein ausführbares Programm erhalten. Den Programmtext den wir mit dem\n"
      + "Editor geschrieben haben, bezeichnen wir als Quelltext.<index>Quelltext</index>\n"
      + "\n"
      + "\n"
      + "Für die Programmiersprache C gibt es eine ganze Reihe von Kompilierern. Im\n"
      + "Laufe dieses Kurses werden wir den \n"
      + "Kompilierer <tt>gcc</tt> von <tt>gnu</tt> benutzen. Sein Vorteil ist, dass er\n"
      + "für unterschiedliche Rechnertypen und Betriebssysteme zur Verfügung steht. Wir\n"
      + "können somit unseren Quelltext mit der <tt>gcc</tt>-Version für Windows in ein\n"
      + "ausführbares Programm übersetzen lassen, das unter dem\n"
      + "Windows-Betriebssystemen läuft und den gleichen Quelltext mit \n"
      + "der <tt>gcc</tt>-Version für Linux in ein ausführbares Programm übersetzen\n"
      + "lassen, das auf dem Linux-Betriebssystem läuft. Allerdings lassen sich die\n"
      + "ausführbaren Programme nicht austauschen. Das Windowsprogramm kann nicht auf\n"
      + "Linux gestartet werden, und umgekehrt.\n"
      + "\n"
      + "\n"
      + "Um jetzt ein C-Programm mit dem Kompilierer <tt>gcc</tt> zu übersetzen, öffnen\n"
      + "wir eine Kommandozeile, gehen mit dem <tt>cd</tt>-Befehl des Betriebssystems \n"
      + "zum Wechseln in ein anderes Verzeichnis, in das Verzeichnis, in dem die\n"
      + "Quelltextdatei gespeichert wurde. Dann rufen wir dort den \n"
      + "Kompilierer <tt>gcc</tt> auf, geben mit <tt>-o</tt> gefolgt von einen\n"
      + "beliebigen Namen den Namen an, den das ausführbare Programm haben soll, und\n"
      + "geben schließlich noch an, welche Quelltextdatei übersetzt werden soll.\n"
      + "\n"
      + "Anschließen gibt es das erzeugte ausführbare Programm, das ausgeführt \n"
      + "werden kann.\n"
      + "\n"
      + "\n"
      + "Alles in allem erhalten wir folgende kleine Sitzung auf der Kommandozeile:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~> cd fh/c/student/src\n"
      + "sep@pc305-3:~/fh/c/student/src> gcc -o dasLeereProgramm DasLeereProgramm.c\n"
      + "sep@pc305-3:~/fh/c/student/src> ./dasLeereProgramm\n"
      + "sep@pc305-3:~/fh/c/student/src>]]></scode> \n"
      + "\n"
      + "Man sieht nicht sehr viel bei dieser Ausführung. Der Aufruf des Kompilierers \n"
      + "mit <tt>gcc -o dasLeereProgramm DasLeereProgramm.c</tt> führt zu keiner\n"
      + "weiteren Ausgabe auf dem Bildschirm. Das ist auch gut so, denn wenn der Aufruf\n"
      + "des Kompilerers zu Ausgaben auf der Kommandozeile führt, bedeutet das zumeist,\n"
      + "dass etwas faul ist, nämlich der Quelltext Fehler enthält, aufgrund derer der\n"
      + "Kompilierer kein ausführbares Programm erzeugen kann. Es ist gut sich mit\n"
      + "solchen Fehlermeldungen frühzeitig auseinander zu setzen, denn in der Praxis\n"
      + "werden wir sehr oft Fehler machen und manchmal verzweifelt nach einer Lösung\n"
      + "suchen. \n"
      + "\n"
      + "<seite titel=\"Schreiben und Übersetzen von C Programmen\">\n"
      + "<ul>\n"
      + "  <li><h2>Quelltextdatei mit Editor schreiben</h2></li>\n"
      + "  <li><h2>Kompilierer (gcc) erzeugt ausführbaren Code</h2></li>\n"
      + "  <li><h2>ausführbares Programm ist Hardware und Betriebssystem abhängig</h2></li>\n"
      + "</ul>\n"
      + "</seite>\n"
      + "\n"
      + "Schauen wir uns einmal an, was alles passiert, wenn wir in unser erstes leeres\n"
      + "Programm Fehler einbauen.\n"
      + "\n"
      + "Zunächst sei die schließende  Klammer am Ende des Programms vergessen: \n"
      + "\n"
      + "<code class=\"DasFalscheLeereProgramm1\" lang=\"c\" main=\"main\">int main(){\n"
      + "  return 0;\n"
      + "</code>\n"
      + "\n"
      + "Versuchen wir dieses zu übersetzen, so beschwert sich der Kompilierer über\n"
      + "einen syntaktischen Fehler:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student/src> gcc -o leeresProg DasFalscheLeereProgramm1.c\n"
      + "DasFalscheLeereProgramm1.c: In function `int main()':\n"
      + "DasFalscheLeereProgramm1.c:2: error: syntax error at end of input\n"
      + "sep@pc305-3:~/fh/c/student/src>]]></scode>\n"
      + "\n"
      + "Ihm fehlt etwas am Ende des Programms.\n"
      + "\n"
      + "\n"
      + "Als nächstes sei einmal die Zeile <tt>return 0;</tt> die <tt>0</tt> weggelassen:\n"
      + "\n"
      + "<code class=\"DasFalscheLeereProgramm2\" lang=\"c\" main=\"main\">int main(){\n"
      + "  return;\n"
      + "}</code>\n"
      + "\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student/src> gcc DasFalscheLeereProgramm2.c\n"
      + "DasFalscheLeereProgramm2.c: In function `int main()':\n"
      + "DasFalscheLeereProgramm2.c:2: error: return-statement with no value, in\n"
      + "   function declared with a non-void return type\n"
      + "sep@pc305-3:~/fh/c/student/src>]]></scode>\n"
      + "\n"
      + "Auch dieses führt zu einen Fehlermeldung. Diese ist für uns noch schwer zu\n"
      + "verstehen. Eine Funktion, die nicht <em>void</em> sei, soll einen Wert mit \n"
      + "dem <tt>return</tt> liefern. Später werden wir sehen, was \n"
      + "ein <em>void</em>-Funktion ist.\n"
      + "\n"
      + "\n"
      + "Ein weiterer simpler Fehler ist, das Semikolon am Ende \n"
      + "des <tt>return</tt>-Befehls zu vergessen\n"
      + "\n"
      + "<code class=\"DasFalscheLeereProgramm3\" lang=\"c\" main=\"main\">int main(){\n"
      + "  return 0\n"
      + "}</code>\n"
      + "\n"
      + "Hier meldet uns der Compiler, dass ihm irgendetwas vor der schließenden\n"
      + "Klammer zu fehlen scheint.\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student/src> gcc -Wall  DasFalscheLeereProgramm3.c\n"
      + "DasFalscheLeereProgramm3.c: In function `int main()':\n"
      + "DasFalscheLeereProgramm3.c:3: error: syntax error before `}' token\n"
      + "sep@pc305-3:~/fh/c/student/src>]]></scode>\n"
      + "\n"
      + "Leider kommt der Compiler nicht auf die Idee, uns auf das fehlenden Semikolon\n"
      + "explizit hinzuweisen.\n"
      + "\n"
      + "\n"
      + "Eine weitere interessante Fehlermeldung erhalten wir, wenn wir mit etwas zu\n"
      + "viel norddeutschen Blut in den Adern, die \n"
      + "Funktion <tt>main</tt> zu <tt>moin</tt> umbenennen:\n"
      + "\n"
      + "<code class=\"DasFalscheLeereProgramm4\" lang=\"c\" main=\"main\">int moin(){\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Nun werden wir in einer Fehlermeldung auf das Nichtvorhandensein der \n"
      + "Funktion <tt>main</tt> aufmerksam gemacht.\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student/src> gcc -o leeresProg DasFalscheLeereProgramm4.c\n"
      + "/usr/lib/gcc-lib/i586-suse-linux/3.3.3/../../../crt1.o(.text+0x18): In function `_start':\n"
      + "../sysdeps/i386/elf/start.S:98: undefined reference to `main'\n"
      + "collect2: ld returned 1 exit status\n"
      + "sep@pc305-3:~/fh/c/student/src>]]></scode>\n"
      + "\n"
      + "Das Interessante an dieser Fehlermeldung ist, dass sie nicht auf einen\n"
      + "syntaktischen Fehler hinweist, sondern auf das Fehlen einer Fuktionalität. Wie\n"
      + "wir später sehen werden, kommt dieser Fehler auch nicht direkt vom Compiler,\n"
      + "sondern einem kleinen Freund des Compilers, dem Linker.\n"
      + "\n"
      + "\n"
      + "\n"
      + "<seite titel=\"C Programme\">\n"
      + "<ul>\n"
      + "<li><h2>braucht eine Funktion mit Namen main</h2></li>\n"
      + "<li><h2>main-Funktion beginnt mit <tt>int main()</tt></h2></li>\n"
      + "<p/>\n"
      + "<li><h2>main-Funktion endet mit: <tt>return 0;</tt></h2></li>\n"
      + "<li><h2>Befehle enden mit einem Semikolon</h2></li>\n"
      + "<li><h2>Konvention: tiefer Einrücken innerhalb geschweifter Klammern</h2></li>\n"
      + "<li><h2>Kompilierer liefert Fehlermeldungen</h2></li>\n"
      + "</ul>\n"
      + "</seite>\n"
      + "\n"
      + "\n"
      + "Es ist schließlich an der Zeit auch Programme zu schreiben, die den ersten\n"
      + "sichtbaren Effekt erzielen. Hierzu wollen wir einen Text auf der Kommandozeile\n"
      + "ausgeben. Beliebige Texte können in C in Anführungszeichen eingeschlossen\n"
      + "geschrieben werden. Es gibt eine eingebaute Funktion \n"
      + "namens <tt>printf</tt>, der solche Texte übergeben werden können, damit sie\n"
      + "die Texte auf der Kommandozeile ausgibt. Um diese Standardfunktion benutzen zu\n"
      + "können, muß eine entsprechende Bibliothek für standard Ein- und Ausgabe, in\n"
      + "das Programm mit eingebunden werden.\n"
      + "\n"
      + "Das einfachste Programm, welches eine Ausgabe auf den Bildschirm tätigt, sieht\n"
      + "damit wie folgt aus:\n"
      + "\n"
      + "<code class=\"HalloFreunde\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"Hallo Freunde!\");\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Die anfängliche Zeile <tt>#include &lt;stdio.h&gt;</tt> bindet die\n"
      + "Standardbibliothek zur Ein- und Ausgabe ein. In der \n"
      + "Funktion <tt>main</tt> wird vor dem Befehl <tt>return</tt> ein weiterer\n"
      + "Befehl ausgeführt: der Aufruf der Funktion <tt>printf</tt>, mit dem \n"
      + "Text <tt>Hallo Freunde!</tt> als Argument. Argumente werden Funktionen in\n"
      + "runden Klammern übergeben.\n"
      + "\n"
      + "Texte werden in C als Zeichenketten in Anführungszeichen eingeschlossen. Diese\n"
      + "Zeichenketten werden in Programmiersprachen \n"
      + "als <tt>String</tt> bezeichnet.<footnote>Nicht zu verwechseln mit einem knappen\n"
      + "Teil Unterwäsche für junge Damen, wie einmal ein Student von mir \n"
      + "bemerkte.</footnote>\n"
      + "\n"
      + "In der Regel dürfen Zeichenketten keinen Zeilenumbruch beinhalten.\n"
      + "Das folgende Programm führt zu einem syntaktischen Fehler.\n"
      + "<code class=\"HalloIllja1\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"Hallo Freunde!\n"
      + "          Hallo Illja!\");\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Der Compiler beschwert sich mit einer ganzen Reihe von Fehlern\n"
      + "\n"
      + "<scode><![CDATA[HalloIllja1.c:3:10: missing terminating \" character\n"
      + "HalloIllja1.c: In function `main':\n"
      + "HalloIllja1.c:4: error: parse error before \"Hallo\"\n"
      + "HalloIllja1.c:4:23: missing terminating \" character\n"
      + "HalloIllja1.c:3:10: missing terminating \" character\n"
      + "HalloIllja1.c: In function `main':\n"
      + "HalloIllja1.c:4: error: parse error before \"Hallo\"\n"
      + "HalloIllja1.c:4:23: missing terminating \" character]]></scode>\n"
      + "\n"
      + "Will man trotzdem einen String aus Layout- oder Platzgründen auf mehrere\n"
      + "Zeilen verteilen, so ist am Ende der Zeile ein rückwärtiger Schrägstrich anzubringen: \n"
      + "\n"
      + "<code class=\"HalloIllja2\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"Hallo Freunde!\\n"
      + "          Hallo Illja!\");\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Dieses Programm übersetzt, hat aber bei der Ausgabe keinen Zeilenumbruch:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/HalloIllja2\n"
      + "Hallo Freunde!          Hallo Illja!sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Möchte man, das in einer Zeichenkette ein Zeilenumbruch auftritt, so ist\n"
      + "dieses mit einer sogenannten Fluchtsequenz zu markieren. Fluchtsequenzen\n"
      + "bestehen in einem String aus einem rückwärtigen Schrägstrich und einem\n"
      + "Buchstaben. Für einen Zeilenumbruch ist es die Sequenz <tt>\n</tt>. Um eine\n"
      + "Ausgabe mit Zeilenumbrüchen zu erzielen, ist also in einem String die\n"
      + "entsprechende Fluchtsequenz einzufügen:\n"
      + "\n"
      + "\n"
      + "<code class=\"HalloIllja3\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"Hallo Freunde!\nHallo Illja!\n\");\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Dieses Programm gibt dann die folgende Ausgabe:\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/HalloIllja3\n"
      + "Hallo Freunde!\n"
      + "Hallo Illja!\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Wir haben bisher die Funktion <tt>printf</tt> immer genau einmal\n"
      + "aufgerufen. In einem C Programm können mehrere Befehle nacheinander folgen und\n"
      + "werden dann von oben nach unten abgearbeitet.\n"
      + "\n"
      + "<code class=\"LichtAusSpotAn\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"Hallo Freunde!\n\");\n"
      + "  printf(\"Hallo Illja!\n\");\n"
      + "  printf(\"Licht aus!\n\");\n"
      + "  printf(\"Spot an!\n\");\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "Bisher haben wir nur Zeichenketten in Form eines Textes auf der Konsole\n"
      + "ausgegeben. Die Funktion <tt>printf</tt> in C ist ein ziemlich vertrackter und\n"
      + "mächtiger Befehl. Um eine ganze Zahl mit ihr ausgeben zu können, übergebe man\n"
      + "der Funktion zwei Argumente: zunächst eine Zeichenkette, in der mit den \n"
      + "Folge <tt>%i</tt> markiert wird, wo die ganze Zahl stehen soll, und dann nach\n"
      + "einem Komma, die Zahl die auszugeben ist.\n"
      + "\n"
      + "<code class=\"ErsteAntwort\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"Die Antwort lautet: \");\n"
      + "  printf(\"%i\",42);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Dieses Spielchen läßt sich beliebig weitertreiben und so in einer Zeile mehrere\n"
      + "Zahlen innerhalb eines Textes integriert ausgeben. \n"
      + "\n"
      + "<code class=\"MehrAntworten\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"Die Antwort: %i wenn man %i und %i verdoppelt.\n\",42,17,4);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</section>\n"
      + "\n"
      + "\n"
      + "<seite titel=\"Ausgabe auf Kommandozeile\">\n"
      + "<ul><li><h2>inkludieren der Standardbibliothek für Ein-/Ausgabe<p />\n"
      + "<tt><![CDATA[#include <stdio.h>]]></tt></h2></li></ul>\n"
      + "<ul><li><h2>printf -Befehl zur Ausgabe auf Kommandozeile<p />\n"
      + "<tt><![CDATA[printf(\"Hallo Freunde!\n\");]]></tt>\n"
      + "</h2></li></ul>\n"
      + "<ul><li><h2>mit <tt>%i</tt> können Zahlen auf Kommandozeile ausgegeben werden<p />\n"
      + "<tt><![CDATA[printf(\"= %i wenn man %i und %i verdoppelt.\n\",42,17,4);]]></tt></h2></li></ul>\n"
      + "</seite>\n"
      + "\n"
      + "\n"
      + "Nachdem wir nun einen Fuß in der Tür haben, werden wir in unserer Vorlesung in\n"
      + "Kapitel~<ref name=\"functionchapter\"></ref> die Grundbausteine zur\n"
      + "Strukturierung von Programmen kennenlernen: Ausdrücke, Funktionen und\n"
      + "zusammengesetzte Befehle. Anschließend \n"
      + "in Kapitel~<ref name=\"softwareengeneeringchapter\"></ref> wird es dann Zeit, \n"
      + "sich\n"
      + "einige Gedanken über die Softwareentwicklung zu machen. \n"
      + "Kapitel~<ref name=\"datachapter\"></ref> ist dann vollständig Daten gewidmet. In\n"
      + "weiteren Kapiteln werden dann die gelernten Konzepte an Beispielprogrammen und\n"
      + "durch Benutzung von Bibliotheken vertieft.\n"
      + "\n"
      + "<aufgabe blatt=\"1\">\n"
      + "Stellen Sie sich den anderen Kommilitonen und dem Dozenten Ihrer\n"
      + "Praktikumsstunde vor. Nennen Sie dabei grob Ihre Vorkenntnisse und äußern Sie\n"
      + "Ihre Erwartungen an die Veranstaltung.\n"
      + "</aufgabe>\n"
      + "\n"
      + "\n"
      + "\n"
      + "<aufgabe blatt=\"1\">\n"
      + "Starten Sie den C-Compiler mit dem Befehl <tt>gcc --version</tt> auf der\n"
      + "Kommandozeile. \n"
      + "</aufgabe>\n"
      + "\n"
      + "<aufgabe blatt=\"1\">\n"
      + "Compilieren und starten Sie die Programme aus Kapitel~1.\n"
      + "</aufgabe>\n"
      + "\n"
      + "<aufgabe blatt=\"1\">Schreiben  \n"
      + "Sie ein erstes eigenes C Programm, das Ihren Namen auf der\n"
      + "Kommandozeile ausgibt. Übersetzen Sie das Programm auf der Kommandozeile und\n"
      + "führen Sie es aus.\n"
      + "</aufgabe>\n"
      + "\n"
      + "\n"
      + "</kapitel>\n"
      + "\n"
      + "<kapitel titel=\"Grundkonzepte\"><label name=\"functionchapter\"/>\n"
      + "Im letzten Kapitel wurde ein Anfang gemacht. Wir können nun Programme\n"
      + "schreiben, die Ausgaben auf der Kommandozeile machen. Nun wollen wir aber auch\n"
      + "endlich Programme schreiben, die Rechnungen durchführen und das Ergebnis \n"
      + "dieser Rechnungen ausgeben.\n"
      + "\n"
      + "<section titel=\"Operatoren\">\n"
      + "In der Programmiersprache C gibt es die Rechenoperatoren, wie wir sie aus der\n"
      + "Grundschule bereits gewohnt sind.\n"
      + "\n"
      + "<subsection titel=\"arithmetische Grundrechenarten\">\n"
      + "Die einfachsten Operatoren<index>Operator</index> sind \n"
      + "Grundrechenarten. Ebenso wie wir es gewohnt\n"
      + "sind, werden die Operatoren in C zwischen die beiden Operanden\n"
      + "geschrieben. Man spricht von Infixoperatoren<index>Infix</index>. \n"
      + "Wie wohl kaum anders zu erwarten, kennt C die vier \n"
      + "Grundrechenarten: <tt>+, -, *, /</tt>.\n"
      + "\n"
      + "\n"
      + "<code class=\"EinsPlusEins\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "int main(){\n"
      + "  printf(\"%i\n\",<redv>1+1</redv>);\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Seit dem Mittelalter ist es üblich eine manchmal etwas verwirrende Konvention\n"
      + "zu berücksichtigen, in der die Operatoren der Punktrechnung stärker binden,\n"
      + "als die Operatoren der Strichrechnung. Auch C folgt dieser Konvention, so dass\n"
      + "das folgende Programm die Zahl 25 als Ergebnis ausgibt.\n"
      + "\n"
      + "<code class=\"PunktVorStrich\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "int main(){\n"
      + "  printf(\"%i\n\",<redv>17+4*2</redv>);\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Wünscht man diese Konvention zu durchbrechen, so lassen sich Unterausdrücke in\n"
      + "C explizit klammern. Das folgende Programm gibt endlich \n"
      + "die ersehnten Antwort <tt>42</tt> aus:\n"
      + "\n"
      + "<code class=\"Geklammert\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "int main(){\n"
      + "  printf(\"%i\n\",<redv>(17+4)*2</redv>);\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Die Division ist mit Sicherheit der problematischste Operator. \n"
      + "Bisher rechnen wir nur mit ganzen Zahlen. Was ist die Hälfte einer \n"
      + "ganzen Zahl?\n"
      + "Desweiteren ist die Division nicht definiert für den Teiler <tt>0</tt>. Was\n"
      + "passiert, wenn wir trotzdem versuchen, durch <tt>0</tt> zu teilen?\n"
      + "\n"
      + "\n"
      + "<code class=\"Division\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"%i\n\",84/2);\n"
      + "  printf(\"%i\n\",85/2);\n"
      + "  printf(\"%i\n\",-4/2);\n"
      + "  printf(\"%i\n\",1/0);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Die Division im ganzzahligen Bereich führt zu einen ganzzahligen Ergebnis.\n"
      + "Tatsächlich bricht das obige Programm schließlich ab, \n"
      + "wenn es dazu kommt, durch die Zahl <tt>0</tt> zu teilen.\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c> ./student/bin/Division\n"
      + "42\n"
      + "42\n"
      + "-2\n"
      + "Gleitkomma-Ausnahme\n"
      + "sep@pc305-3:~/fh/c>]]></scode>\n"
      + "\n"
      + "C kennt noch einen weiteren Operator, der sich mit der Division\n"
      + "beschäftigt. Dies ist der sogenannte Modulo-Operator.<index>Modulo</index> Er wird durch das \n"
      + "Symbol  <tt>%</tt> bezeichnet. Er hat als Ergebnis den ganzzahligen Rest, der\n"
      + "beim Teilen des ersten Operanden durch den zweiten Operanden übrig bleibt.\n"
      + "\n"
      + "<code class=\"Modulo\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"%i\n\",84%2);\n"
      + "  printf(\"%i\n\",85%2);\n"
      + "  printf(\"%i\n\",-4%2);\n"
      + "  printf(\"%i\n\",1%0);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "Auch der Modulo-Operator führt bei <tt>0</tt> als zweiten Operanden zu einen\n"
      + "Fehler. Es wäre ja der Rest, der bleibt, wenn durch <tt>0</tt> geteilt wird.\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Vergleichsoperatoren\">\n"
      + "C stellt weitere Operatoren zur Verfügung, die uns aus der Schule sicher\n"
      + "bekannt sind. Dabei geht es darum, zwei Zahlen zu vergleichen. Hierzu kennt C\n"
      + "die Operatoren <tt>&lt;, &gt;, ==, !=, &lt;=, &gt;=</tt> mit den naheliegenden\n"
      + "Bedeutungen. \n"
      + "\n"
      + "Die Frage ist allerdings, was ist das Ergebnis einer Vergleichsoperation. Der\n"
      + "Vergleich ist entweder wahr oder falsch. Schön wäre es, wenn C Werte für wahr\n"
      + "oder falsch kennen würde, so wie über 90\\% aller Programmiersprachen. Das\n"
      + "erstaunliche ist, dass C solche Werte nicht kennt, und eine wahre Aussage mit\n"
      + "der Zahl <tt>1</tt>  und eine falsche Aussage mit der \n"
      + "Zahl <tt>0</tt> ausdrückt. \n"
      + "\n"
      + "<code class=\"GleichUndUngleich\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"(17+4)*2==42: %i\n\",(17+4)*2==42);\n"
      + "  printf(\"(17+4)*2==25: %i\n\",(17+4)*2==25);\n"
      + "  printf(\"(17+4)*2!=42: %i\n\",(17+4)*2!=42);\n"
      + "  printf(\"(17+4)*2!=25: %i\n\",(17+4)*2!=25);\n"
      + "  printf(\"(17+4)*2>17+4*2: %i\n\",(17+4)*2>17+4*2);\n"
      + "  printf(\"(17+4)*2<17+4*2: %i\n\",(17+4)*2<17+4*2);\n"
      + "  printf(\"(17+4)*2>=17+4*2: %i\n\",(17+4)*2>=17+4*2);\n"
      + "  printf(\"(17+4)*2<=17+4*2: %i\n\",(17+4)*2<=17+4*2);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Das Programm führt zur entsprechenden Ausgabe:\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c> gcc student/src/GleichUndUngleich.c\n"
      + "sep@pc305-3:~/fh/c> ./a.out\n"
      + "(17+4)*2==42: 1\n"
      + "(17+4)*2==25: 0\n"
      + "(17+4)*2!=42: 0\n"
      + "(17+4)*2!=25: 1\n"
      + "(17+4)*2>17+4*2: 1\n"
      + "(17+4)*2<17+4*2: 0\n"
      + "(17+4)*2>=17+4*2: 1\n"
      + "(17+4)*2<=17+4*2: 0\n"
      + "sep@pc305-3:~/fh/c>]]></scode>\n"
      + "\n"
      + "\n"
      + "Fast alle anderen Programmiersprachen sind sich des fundamentalen Nutzen \n"
      + "von <wikipedia date=\"30. August 2006\" caption=\"George Boole\" width=\"0.9\">\n"
      + "George Boole (* 2. November 1815 in Lincoln, England; $\\dagger$ 8. Dezember\n"
      + "1864 in Ballintemple, Irland) war ein englischer Mathematiker (Autodidakt) und\n"
      + "Philosoph. \n"
      + "\n"
      + "Ursprünglich als Lehrer tätig, wurde er auf Grund seiner wissenschaftlichen\n"
      + "Arbeiten 1848 Mathematikprofessor am Queens College in Cork (Irland). \n"
      + "\n"
      + "Boole entwickelte 1847 den ersten algebraischen Logikkalkül für Klassen und\n"
      + "Aussagen im modernen Sinn. Damit begründete er die moderne mathematische\n"
      + "Logik. Booles Kalkül wird gelegentlich noch im Rahmen der traditionellen\n"
      + "Begriffslogik interpretiert, obwohl Boole bereits in The Mathematical Analysis\n"
      + "of Logic ausschließlich von Klassen spricht. \n"
      + "\n"
      + "Boole arbeitete in einem kommutativen Ring mit Multiplikation und Addition,\n"
      + "die den logischen \n"
      + "Verknüpfungen <em>und</em> und <em>entweder...oder</em> entsprechen; \n"
      + "in diesem booleschen Ring gilt\n"
      + "zusätzlich zu den bekannten Rechenregeln die Regel aa=a, in Worten (a und\n"
      + "a)=a. \n"
      + "\n"
      + "In der Boole-Schule wurde die zum booleschen Ring gleichwertige boolesche\n"
      + "Algebra entwickelt, die mit <em>und</em> und <em>oder</em> arbeitet. \n"
      + "Sie ist heute in der Aussagenlogik und Mengenlehre bekannter und\n"
      + "verbreiteter als der originale, rechnerisch elegantere boolesche Ring. \n"
      + "\n"
      + "George Boole ist der Vater von Ethel Lilian Voynich.\n"
      + "\n"
      + "Auf George Boole sind die booleschen Variablen zurückzuführen, die zu den\n"
      + "Grundlagen des Programmierens in der Informatik zählen. \n"
      + "</wikipedia>Wahrheitswerten<index>Wahrheitswert</index> bewusst \n"
      + "und kennen dafür einen eigenen Typen mit \n"
      + "Namen <tt>bool</tt> oder <tt>boolean</tt>. Dieser Typ hat stets die \n"
      + "zwei Werte  <tt>true</tt> und <tt>false</tt>. In C müssen wir, wenn wir einen\n"
      + "expliziten Typ für Wahrheitswerte benutzen wollen, \n"
      + "diesen selbst definieren, was wir später im\n"
      + "Kurs auch tun werden.\n"
      + "\n"
      + "Auch wenn es Wahrheitswerte in C explizit nicht gibt, so gibt es in C eine\n"
      + "ganze Reihe von Programmkonstrukten, die so tun, als wäre ein \n"
      + "Typ <tt>boolean</tt>  mit zwei Wahrheitswerten vorhanden. Hierzu gehören die\n"
      + "Konstrukte, um Verzweigungen und Wiederholungen im Programmfluss\n"
      + "auszudrücken. Zusätzlich gibt es aber auch eine Reihe von Operatoren, die nur\n"
      + "von zwei Zuständen für <tt>true</tt> und <tt>false</tt> ausgehen.\n"
      + "\n"
      + "\n"
      + "Auch wenn Wahrheitswerte in C, nichts anderes sind als die \n"
      + "Zahlen <tt>0</tt> und <tt>1</tt>, sollte man sich bemühen, die Wahrheitswerte\n"
      + "nicht als Zahlen zu benutzen und verwirrende Programme schreiben, wie z.B. das\n"
      + "Folgende, in dem auf das Ergebnis einer Vergleichsoperation eine arithmetische\n"
      + "Operation angewendet wird:\n"
      + "\n"
      + " <code class=\"WahrPlusEins\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"(1==1)+1 =  %i\n\",(1==1)+1);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</subsection>\n"
      + "\n"
      + "\n"
      + "<subsection titel=\"Logische Operatoren\">\n"
      + "Nun wollen wir aber auch mit Wahrheitswerten Rechnen. Als Grundoperationen\n"
      + "stehen hierzu ein logisches <em>und</em> im Zeichen <tt>&amp;&amp;</tt> und\n"
      + "ein logisches <em>oder</em> im Zeichen <tt>||</tt> zur Verfügung.\n"
      + "Sie sind die in der formalen Logik mit dem Zeichen <m>\\wedge</m> \n"
      + "für <em>und</em> und <m>\\vee</m>  für <em>oder</em> bezeichnete\n"
      + "Operatoren\n"
      + "\n"
      + "Es gibt die beiden Operatoren auch in einer einfachen statt der doppelten\n"
      + "Version. Angewendet auf reine Zahlen, die einen Wahrheitswert repräsentieren,\n"
      + "haben beide Versionen, die doppelte und die einfache, das gleiche\n"
      + "Endergebnis. Die beiden Versionen unterscheiden sich allerdings fundamental in\n"
      + "der Art der technischen Ausführung. Vorerst werden wir nur die doppelte\n"
      + "Version benutzen. \n"
      + "\n"
      + "<code class=\"LogikOPs\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"1==1 && 1==2: %i\n\",1==1 && 1==2);\n"
      + "  printf(\"1==1 || 1==2: %i\n\",1==1 || 1==2);\n"
      + "  printf(\"1==1 & 1==2: %i\n\",(1==1) & (1==2));\n"
      + "  printf(\"1==1 | 1==2: %i\n\",(1==1) | (1==2));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Ein weiterer Operator für Wahrheitswerte in C ist die Negation, ein\n"
      + "klassisches <em>nicht</em>. Es dreht einen Wahrheitswert um, macht \n"
      + "aus <em>wahr</em> ein <em>falsch</em> und umgekehrt. Dieser Operator wird in C\n"
      + "durch ein Ausrufezeichen ausgedrückt. In der formalen Logik wird das \n"
      + "Zeichen <m>\neg</m> für die Negation benutzt.\n"
      + "\n"
      + "<code class=\"Negation\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"!(1==1): %i\n\",!(1==1));\n"
      + "  printf(\"!(1==2): %i\n\",!(1==2));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Im Gegensatz zu den bisherigen Operatoren handelt es sich bei diesem Operator\n"
      + "um einen einstelligen. Er hat nur einen Operanden, wohingegen die übrigen\n"
      + "Operatoren bisher zweistellig waren. Sie hatten jeweils zwei Operanden. \n"
      + "\n"
      + "\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Bedingungsoperator\">\n"
      + "C kennt auch einen Operator mit drei Operanden. Er besteht aus zwei einzelnen\n"
      + "Zeichen, die als Trenner zwischen den Operanden stehen. Zunächst kommt der\n"
      + "erste Operand, dann das Zeichen <tt>?</tt>, dann der zweite Operand, gefolgt\n"
      + "vom Zeichen <tt>:</tt>, dem der dritte Operand folgt. Schematisch sehen die\n"
      + "Ausdrücke dieses Operators wie folgt aus:<p />\n"
      + "\n"
      + "<em>cond ? alt$_1$ : alt$_2$</em><p/>\n"
      + "\n"
      + "Das Ergebnis dieses Operators wird wie folgt berechnet:\n"
      + "Der erste Operand wird zu einem Wahrheitswert ausgewertet. Wenn \n"
      + "dieser <em>wahr</em> ist, so wird der zweite Operand als Ergebnis \n"
      + "ausgewertet, wenn er <em>falsch</em> ist, wird der dritte Operand als Ergebnis\n"
      + "ausgewertet. \n"
      + "\n"
      + "<code class=\"SoOderSo\" lang=\"c\" main=\"main\" commandchars=\"_$^\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf((17+4)*2==42?\"tatsaechlich gleich\n\":\"unterschiedlich\n\");\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Der Bedingungsoperator ist unser erstes\n"
      + "Konstrukt, um Verzweigungen auszudrücken.\n"
      + "Da der Bedingungsoperator auch einen Wert errechnet, können wir diesen\n"
      + "benutzen, um mit ihm weiterzurechenen. Der Bedingungsoperator kann also\n"
      + "tatsächlich ineinandergesteckt werden:\n"
      + "\n"
      + "\n"
      + "<code class=\"Signum1\" lang=\"c\" main=\"main\" commandchars=\"_$^\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"signum(42) = %i\n\",(42>0)?1:((42<0)?-1:0));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Hier wird zunächst geschaut, ob die Zahl 42 größer als 0 ist. Ist dieses\n"
      + "der Fall wird die Zahl 1 ausgegeben, ansonsten wird weitergeschaut, ob die\n"
      + "Zahl 42 kleiner 1 ist. Hier wird im Erfolgsfall die Zahl $-1$ ausgegeben. Wenn\n"
      + "beides nicht der Fall war, wird die Zahl $0$ ausgegeben.\n"
      + "\n"
      + "Zugegebener Maßen ist dieser Ausdruck schon schwer zu lesen. Wir werden später\n"
      + "bessere Konstrukte kennenlernen, um verschiedene Fälle zu unterscheiden. \n"
      + "</subsection>\n"
      + "\n"
      + "\n"
      + "<seite titel=\"Operatorausdrücke\">\n"
      + "<ul><li><h2>Infixschreibweise der Operatoren</h2></li></ul>\n"
      + "<ul><li><h2>Klammerungen möglich sonst übliche Präzedenzen</h2></li></ul>\n"
      + "<ul><li><h2>arithmetische Operatoren: <tt>+, -, *, /, %</tt></h2></li></ul>\n"
      + "<ul><li><h2>Vergleichsoperatoren: <tt>==, !=, &lt;, &gt;, &lt;=, &gt;=</tt></h2></li></ul>\n"
      + "<ul><li><h2>logische Operatoren: <tt>||, &amp;&amp;, !</tt></h2></li></ul>\n"
      + "<ul><li><h2>zweiteiliger Bedingungsoperator: <tt>...?...:...</tt></h2></li></ul>\n"
      + "</seite>\n"
      + "\n"
      + "\n"
      + "</section>\n"
      + "\n"
      + "<section titel=\"Funktionen\">\n"
      + "Im letzten Abschnitt haben wir die wichtigsten Operatoren in C\n"
      + "kennengelernt. Mit diesen lassen sich im Prinzip schon komplexe Berechnungen\n"
      + "durchführen. Allerdings können uns die theoretischen Informatiker beweisen,\n"
      + "dass wir mit den Operatorausdrücken allein noch nicht mächtig genug sind, um\n"
      + "alle erdenklichen berechenbaren mathematischen \n"
      + "Funktionen<index>Funktion</index> berechnen zu\n"
      + "können. Hierzu Bedarf es noch dem Konzept der Funktionen. Betrachten wir\n"
      + "hierzu eine Funktion im klassischen mathematischen Sinn: eine Funktion hat\n"
      + "eine Reihe von Argumenten und berechnet für die Argumente ein\n"
      + "Ergebnis. Wichtig ist, dass eine Funktion immer für die gleichen Argument ein\n"
      + "und dasselbe Ergebnis auf deterministische Weise errechnet. Die Anzahl der\n"
      + "Argumente einer Funktion wird als ihre Stelligkeit bezeichnet.\n"
      + "\n"
      + "Im folgenden Beispiel wird die Funktion <tt>quadrat</tt> definiert. Sie hat\n"
      + "ein Argument. Als Ergebnis gibt sie das Quadrat dieser Zahl zurück. \n"
      + "Nachdem diese Funktion definiert wurde, benutzen wir sie in der \n"
      + "Funktion <tt>main</tt> mehrfach, jeweils mit anderen Argumenten.\n"
      + "\n"
      + "<code class=\"Quadrat\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int quadrat(int x){\n"
      + "  return x*x;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"%i\n\",quadrat(5));\n"
      + "  printf(\"%i\n\",quadrat(10));\n"
      + "  printf(\"%i\n\",quadrat(0));\n"
      + "  printf(\"%i\n\",quadrat(-12));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Wichtig bei der Definition einer Funktion ist, \n"
      + "der <tt>return</tt>-Befehl. Eine Funktion berechnet ein Ergebnis. Dieses\n"
      + "Ergebnis ist der Ausdruck, der hinter dem Befehlswort <tt>return</tt> steht.\n"
      + "\n"
      + "\n"
      + "C wertet jetzt jedesmal wenn eine Funktion benutzt wird, diesen Aufruf aus und\n"
      + "ersetzt ihn quasi durch sein Ergebnis, nämlich den Ausdruck, der hinter dem\n"
      + "Befehlswort <tt>return</tt> steht. \n"
      + "\n"
      + "In Programmiersprachen werden die\n"
      + "Argumente einer Funktion als Parameter bezeichnet. Bei der Definition der\n"
      + "Funktion spricht man von den formalen Parametern, in unserem Falle \n"
      + "das <tt>x</tt>. Bei der Definition der formalen Parameter ist vor seinem\n"
      + "Namen, sein Typ zu schreiben.  Bisher arbeiten wir nur mit ganzen Zahlen, die\n"
      + "in C mit <tt>int</tt> bezeichnet werden.  \n"
      + "\n"
      + "Beim Aufruf der Funktion <tt>quadrat</tt> wird nun das <tt>x</tt> durch einen\n"
      + "konkreten Ausdruck, z.B.~die Zahl <tt>5</tt> ersetzt.\n"
      + "\n"
      + "In der Wahl des Namens für einen formalen Parameter ist der Programmierer\n"
      + "weitgehendst frei. Dieser Name existiert nur innerhalb des\n"
      + "Funktionsrumpfes. Verschiedene Funktionen können Parameter gleichen Namens\n"
      + "haben. Diese Parameter sind dann trotzdem vollkommen unabhängig.\n"
      + "\n"
      + "\n"
      + "\n"
      + "Wir können in C beliebig viele Funktionen definieren, und \n"
      + "auch <tt>main</tt> ist eine Funktion, die bisher immer parameterlos war. \n"
      + "Wir können, nachdem eine Funktion einmal definiert ist, sie beliebig oft und\n"
      + "an fast beliebig vielen Stellen aufrufen, sogar mehrfach verschachtelt:\n"
      + "\n"
      + "<code class=\"QuadratUndDoppel\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int quadrat(int x){\n"
      + "  return x*x;\n"
      + "}\n"
      + "int doppelt(int x){\n"
      + "  return x*x;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"%i\n\",doppelt(quadrat(5)));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Hier wird in der Funktion <tt>main</tt> zunächst die \n"
      + "Funktion <tt>quadrat</tt> mit der Zahl <tt>5</tt> aufgerufen, das \n"
      + "Ergebnis (die <tt>25</tt>) wird dann als Argument der \n"
      + "Funktion <tt>doppelt</tt> benutzt.\n"
      + "\n"
      + "\n"
      + "Innerhalb einer Funktion können auch andere Funktionen aufgerufen werden. \n"
      + "<code class=\"SummeDerQuadrate\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int quadrat(int x){\n"
      + "  return x*x;\n"
      + "}\n"
      + "\n"
      + "int summeDerQuadrate(int x,int y){\n"
      + "  return quadrat(x)+quadrat(y);\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"%i\n\",summeDerQuadrate(3,4));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "In diesem Programm ruft die zweistellige\n"
      + " Funktion <tt>summeDerQuadrate</tt> für jedes ihrer Argumente die \n"
      + "Funktion <tt>quadrat</tt> auf, und addiert anschließend die Ergebnisse.\n"
      + "\n"
      + "Die erste Zeile (bis zur öffnenden Klammer) einer Funktion wird als Signatur\n"
      + "bezeichnet. Sie beinhaltet den Rückgabetyp, den Namen und die Argumente der\n"
      + "Funktion. Alles innerhalb der geschweiften Klammern wird als Rumpf bezeichnet.\n"
      + "\n"
      + "\n"
      + "Die Berechnungen, die eine Funktion vornimmt, können beliebig komplexe\n"
      + "Ausdrücke sein:\n"
      + "\n"
      + "<code class=\"Signum2\" lang=\"c\" main=\"main\" commandchars=\"_$^\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int signum(int i){\n"
      + "  return (i>0)?1:((i<0)?-1:0);\n"
      + "}\n"
      + "int main(){\n"
      + "  printf(\"signum(42) = %i\n\",signum(42));\n"
      + "  printf(\"signum(-42) = %i\n\",signum(-42));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "<aufgabe  blatt=\"2\">Schreiben \n"
      + "Sie eine Funktion, mit zwei ganzzahligen Parametern. Die\n"
      + "Rückgabe soll die größere der beiden Zahlen sein. Testen Sie die Funktionen in\n"
      + "einer Hauptfunktion mit mindesten drei Aufrufen.\n"
      + "<loesung><code class=\"Greater\" lang=\"c\" main=\"main\"\n"
      + "commandchars=\"_$^\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int greater(int x,int y){\n"
      + "  return x>y?x:y;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"-17, 8: %i\n\",greater(-17,8));\n"
      + "  printf(\"8, -8: %i\n\",greater(8,-8));\n"
      + "  printf(\"8, 8: %i\n\",greater(8,8));\n"
      + "  return 0;\n"
      + "}]]></code></loesung>\n"
      + "</aufgabe>\n"
      + "\n"
      + "<aufgabe blatt=\"2\">In der formalen Logik ist ein häufiger Operator die \n"
      + "Implikation $a \rightarrow b$. Hierfür gibt es in C keinen eigenen\n"
      + "Operator. Implementieren Sie eine Funktion<br/>\n"
      + " <tt>int implication(int a,int b)</tt>, <br/>\n"
      + "die die Implikation aus beiden Argumenten berechnet. Die \n"
      + "Implikation $a \rightarrow b$ ist dabei definiert als: $\\neg a \\vee b$.\n"
      + "\n"
      + "Schreiben Sie ein paar kleine Tests ihrer Funktion.\n"
      + "\n"
      + "<code main=\"main\" lang=\"c\" class=\"Implication\"><![CDATA[#include <stdio.h>\n"
      + "int implication(int a,int b){\n"
      + " return !a || b;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"implication(1==0,1>2): %i\n\",implication(1==0,1>2));\n"
      + "  printf(\"implication(1>2,1==0): %i\n\",implication(1>2,1==0));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "</aufgabe>\n"
      + "\n"
      + "\n"
      + "\n"
      + "<seite titel=\"Funktionen\">\n"
      + "<ul><li><h2>Parameter sind die Daten, mit denen gerechnet wird</h2></li></ul>\n"
      + "<ul><li><h2>Anzahl der Parameter ist die Stelligkeit</h2></li></ul>\n"
      + "<ul><li><h2>müssen mit passender Parameteranzahl aufgerufen werden</h2></li></ul>\n"
      + "<ul><li><h2>Ergebnis wird mit <tt>return</tt> zurückgegeben</h2></li></ul>\n"
      + "<ul><li><h2>können erst aufgerufen werden, wenn sie deklariert sind</h2></li></ul>\n"
      + "<ul><li><h2>können beliebig oft auch ineinander verschachtelt aufgerufen werden</h2></li></ul>\n"
      + "\n"
      + "</seite>\n"
      + "\n"
      + "<subsection titel=\"Seiteneffekte\">\n"
      + "Bisher waren alle unsere Funktionen streng im mathematischen Sinne. Sie haben\n"
      + "nichts gemacht, außer ihr Ergebnis zu berechnen. Das Ergebnis war\n"
      + "deterministisch nur von den Argumenten abhängig. Wir können aber auch\n"
      + "Funktionen schreiben, die nebenbei noch etwas anderes \n"
      + "machen. Bisher haben wir noch\n"
      + "nicht viel Möglichkeiten etwas zu programmieren, außer Ausgaben auf die\n"
      + "Kommandozeile zu geben. Wir können Funktionen so schreiben, dass sie nicht nur\n"
      + "ihr Ergebnis berechnen, sondern zuvor noch eine Ausgabe auf der Kommandozeile\n"
      + "machen.\n"
      + "\n"
      + "<code class=\"Seiteneffekt\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int positiv(int x){\n"
      + "  printf(\"teste ob %i positiv ist.\n\",x);\n"
      + "  return x>0;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"%i\n\",positiv(6)&&positiv(5));\n"
      + "  printf(\"%i\n\",positiv(6)||positiv(5));\n"
      + "  printf(\"%i\n\",positiv(-6)&&positiv(5));\n"
      + "  printf(\"%i\n\",positiv(-6)||positiv(5));\n"
      + "  printf(\"%i\n\",positiv(6)&positiv(5));\n"
      + "  printf(\"%i\n\",positiv(6)|positiv(5));\n"
      + "  printf(\"%i\n\",positiv(-6)&positiv(5));\n"
      + "  printf(\"%i\n\",positiv(-6)|positiv(5));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + " \n"
      + "Wenn eine Funktion nicht nur ein Ergebnis berechnet, sondern quasi nebenher\n"
      + "noch etwas anderes macht, so spricht man von einem \n"
      + "Seiteneffekt<index>Seiteneffekt</index>. Seiteneffekte\n"
      + "scheinen zunächst nicht besonders tragisch zu sein, sofern es sich nur um ein\n"
      + "paar Ausgaben handelt. Wir werden in Kürze sehen, dass eine Funktion den Wert\n"
      + "von Speicherstellen als Seiteneffekt ändern kann. Je mehr Seiteneffekte ein\n"
      + "Programm enthält, umso schwerer wird es, das Programm zu verstehen. Deshalb\n"
      + "sollte man Seiteneffekte möglichst bewusst einsetzen. Aus der Problematik\n"
      + "heraus, dass Seiteneffekte ein Programm komplizierter zu verstehen machen,\n"
      + "wurden Programmiersprachen entwickelt, in denen keine Seiteneffekte\n"
      + "programmiert werden können. Solche Sprachen sind funktionale Sprachen \n"
      + "wie <em>Haskell</em><cite label=\"haskell-report1.4\"/> und <em\n"
      + ">Clean</em><cite label=\"cleanmanual\"/>. Auch die Sprache \n"
      + "ML<cite label=\"milner:90\"/> ist weitgehendst\n"
      + "Seiteneffektfrei. ML erlebt derzeit eine gewisse Renaissance, da Microsoft es\n"
      + "für die <em>Dot Net</em> Architektur unter den Namen F\\# implementiert hat.\n"
      + "\n"
      + "Betrachten wir die Ausgabe des obigen Programms einmal genau, so können wir\n"
      + "etwas über die Auswertung der verschiedenen logischen Operatoren lernen:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> ./a.out\n"
      + "teste ob 6 positiv ist.\n"
      + "teste ob 5 positiv ist.\n"
      + "1\n"
      + "teste ob 6 positiv ist.\n"
      + "1\n"
      + "teste ob -6 positiv ist.\n"
      + "0\n"
      + "teste ob -6 positiv ist.\n"
      + "teste ob 5 positiv ist.\n"
      + "1\n"
      + "teste ob 6 positiv ist.\n"
      + "teste ob 5 positiv ist.\n"
      + "1\n"
      + "teste ob 6 positiv ist.\n"
      + "teste ob 5 positiv ist.\n"
      + "1\n"
      + "teste ob -6 positiv ist.\n"
      + "teste ob 5 positiv ist.\n"
      + "0\n"
      + "teste ob -6 positiv ist.\n"
      + "teste ob 5 positiv ist.\n"
      + "1\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>  \n"
      + "\n"
      + "Die ersten zwei Zeilen der Ausgabe leuchten ein. Um herauszubekommen, ob\n"
      + "beides die <tt>6</tt> und die <tt>5</tt> eine positive Zahl sind, muss für\n"
      + "beide Zahlen die Funktion <tt>positiv</tt> ausgewertet werden. Beide Male\n"
      + "kommt es als Seiteneffekt zu der Ausgabe auf der Kommandozeile.\n"
      + "\n"
      + "Um aber zu testen, ob eine der Zahlen <tt>6</tt> und  <tt>5</tt> eine\n"
      + "positive Zahl ist, reicht es, wenn die Funktion <tt>positiv</tt> für \n"
      + "das Argument  <tt>6</tt> schon die <tt>1</tt> für <em>wahr</em> als Ergebnis\n"
      + "zurück gegeben hat. Damit ist einer der beiden Operanden \n"
      + "des <em>oder</em> bereits <em>wahr</em> und damit auch der gesamte\n"
      + "Oderausdruck. Warum also noch testen, ob auch die <tt>5</tt> positiv ist? Und\n"
      + "tatsächlich erhalten wir keinen Seiteneffekt, der angibt, dass auch die \n"
      + "Funktion <tt>positiv</tt> für das Argument <tt>5</tt> ausgewertet wurde.\n"
      + "\n"
      + "Ähnlich verhält es sich beim dritten Aufruf. Wenn der erste Operand \n"
      + "des <em>und</em> schon nicht <em>wahr</em> ist, braucht man sich den zweiten\n"
      + "gar nicht mehr anschauen.\n"
      + "\n"
      + "Nun sieht man den Unterschied \n"
      + "zwischen <tt>&amp;&amp;</tt> und <tt>&amp;</tt> sowie\n"
      + "zwischen <tt>||</tt> und <tt>|</tt>. Die einfachen Versionen werten beide\n"
      + "Operanden aus und errechnen dann aus den Teilergebnissen der Operanden ein \n"
      + "Gesamtergebnis. Die doppelten Versionen schauen sich zunächst den ersten\n"
      + "Operanden an, und entscheiden, ob es notwendig ist für das Gesamtergebnis sich\n"
      + "auch noch den zweiten Operanden anzuschauen. Die Ausgabe auf der\n"
      + "Kommandozeile, die wir als Seiteneffekt in die \n"
      + "Funktion <tt>positiv</tt>  eingebaut haben, macht diesen Unterschied sichtbar.\n"
      + "\n"
      + "Die einfache Version der logischen Operatoren werden auch \n"
      + "als <em>strikt</em> bezeichnet, die doppelte Version \n"
      + "als <em>nicht-strikt</em>.\n"
      + "\n"
      + "<aufgabe  blatt=\"2\">Schreiben Sie eine Funktion:\n"
      + "<code class=\"Condition\" lang=\"h\"\n"
      + ">int condition(int cond,int altTrue, int altFalse);</code>\n"
      + "\n"
      + "Sie soll wenn der Parameter <tt>cond</tt> dem Wert <em>wahr</em> entspricht,\n"
      + "den Parameter <tt>altTrue</tt> ansonsten den \n"
      + "Parameter <tt>altFalse</tt> zurückgeben.\n"
      + "\n"
      + "Führen Sie dann folgende Tests aus:\n"
      + "<code class=\"TestCondition\" lang=\"c\"\n"
      + "commandchars=\"_$^\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "#include \"Condition.h\"\n"
      + "\n"
      + "int trace(int x){\n"
      + "  printf(\"zahl %i\n\",x);\n"
      + "  return x;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"condition: %i\n\"\n"
      + "                ,condition(trace(1),trace(17),trace(4)));\n"
      + "  printf(\"operator:  %i\n\",trace(1)?trace(17):trace(4));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Was stellen Sie fest. Interpretieren Sie das Ergebnis.\n"
      + "\n"
      + "<loesung>\n"
      + "Die Implementierung ist natürlich die direkte Benutzung des\n"
      + "Bedingungsoperators. In der Aufgabe benutze ich hier aus technischen bereits\n"
      + "eine Headerdatei. Das sollen die Studenten noch nicht unbedingt machen, war ja\n"
      + "noch nicht erklärt.\n"
      + "\n"
      + "<code class=\"Condition\" lang=\"c\" commandchars=\"_$^\" \n"
      + "main=\"gcc -o TestCondition ../obj/TestCondition.o ../obj/Condition.o\"\n"
      + "\n"
      + "><![CDATA[#include \"Condition.h\"\n"
      + "int condition(int cond,int altTrue, int altFalse){\n"
      + "  return cond?altTrue:altFalse;\n"
      + "}]]></code>\n"
      + "\n"
      + "Interessant ist natürlich die Ausgabe:\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/tutor> ./testCondition\n"
      + "zahl 4\n"
      + "zahl 17\n"
      + "zahl 1\n"
      + "condition: 17\n"
      + "zahl 1\n"
      + "zahl 17\n"
      + "operator:  17\n"
      + "sep@pc305-3:~/fh/c/tutor>]]></scode>\n"
      + "\n"
      + "Man stellt fest, dass ein Funktionsaufruf dazu führt, dass immer alle\n"
      + "Argumente ausgewertet werden. Daher sehen wir die Ausgabe aller \n"
      + "drei <tt>trace</tt> Aufrufe. Interessanter Weise werden die Argumente von\n"
      + "rechts nach links ausgewertet.\n"
      + "\n"
      + "Der Bedingungsoperator hingegen hat eine\n"
      + "eingebaute Magie. Hier wird erst die Bedingung ausgewertet und dann nur noch\n"
      + "der Parameter, der für das Gesamtergebnis benötigt wird.\n"
      + "Nicht alle drei Operanden werden ausgewertet. Der Operator ist nicht-strikt\n"
      + "implementiert, während die Funktion <tt>condition</tt> strikt ausgewertet\n"
      + "wird.  </loesung>\n"
      + "\n"
      + "</aufgabe>\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Prozeduren\">\n"
      + "Manchmal will man gar keine Funktion schreiben, sondern ein mehrfach\n"
      + "aufrufbares Stück Programmcode, das im Prinzip nur einen oder mehrere \n"
      + "Seiteneffekt hat. Im Prinzip also Unterprogramme, die nichts Neues \n"
      + "berechnen, sondern etwas machen, z.B.~eine Mail verschicken, etwas in die\n"
      + "eine Datenbank schreiben oder sonstige beliebige Aktionen. Bisher haben alle\n"
      + "unsere Funktionen  ein\n"
      + "Ergebnis berechnet und zurückgegeben.\n"
      + "\n"
      + "Wenn kein Ergebnis berechnet wird, so ist einer Funktion statt eines\n"
      + "Rückgabetyps das Wort <tt>void</tt> voranzustellen.\n"
      + "\n"
      + "<code class=\"printNumber\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "void printNumber(int x){\n"
      + "  printf(\"%i.\n\",x);\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printNumber(1);\n"
      + "  printNumber(17+4);\n"
      + "  printNumber((17+4)*2);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Solche Funktionen werden gerne als <tt>void</tt>-Funktionen bezeichnet. Sie\n"
      + "brauchen keinen <tt>return</tt>-Befehl zum Abschluss. \n"
      + "\n"
      + "In der Informatik werden solche Funktionen auch  \n"
      + "als <em>Prozeduren</em><index>Prozedur</index> bezeichnet. \n"
      + "Besonders in der Programmiersprache Pascal<cite label=\"pascal\"/> hat  \n"
      + "man deutlich schon syntaktisch zwischen Funktionen und Prozeduren\n"
      + "unterschieden. \n"
      + "\n"
      + "</subsection>\n"
      + "\n"
      + "\n"
      + "<subsection titel=\"rekursive Funktionen\">\n"
      + "Sobald wir die Signatur einer Funktion oder Prozedur definiert haben, dürfen\n"
      + "wir sie  \n"
      + "benutzen, sprich aufrufen. Damit ergibt sich eine sehr mächtige Möglichkeit der\n"
      + "Programmierung. Wir können Funktionen bereits in ihren eigenen Rumpf\n"
      + "aufrufen. Solche Funktionen werden rekursiv<index>Rekursion</index> genannt. <em>Recurrere</em> ist\n"
      + "das lateinische Wort für zurücklaufen. Eine rekursive Funktion läuft während\n"
      + "ihrer Auswertung wieder zu sich selbst zurück. \n"
      + "\n"
      + "Damit lassen sich wiederholt Programmteile ausführen. Das folgende Programm\n"
      + "wird z.B.~nicht müde, uns mit dem Wort <tt>hallo</tt> zu erfreuen.\n"
      + "\n"
      + "<code class=\"HalloNerver\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "void halloNerver(){\n"
      + "  printf(\"hallo\n\");\n"
      + "  halloNerver();\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  halloNerver();\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Die Funktion <tt>main</tt> ruft die Funktion <tt>halloNerver</tt> auf. Diese\n"
      + "druckt einmal das Wort <tt>hallo</tt> auf die Konsole und ruft sich dann\n"
      + "selbst wieder auf. Dadurch wird wieder <tt>hallo</tt> auf die Konsole\n"
      + "geschrieben und so weiter. Wir haben ein endlos laufendes\n"
      + "Programm. Tatsächlich endlos? Lassen sie es mal möglichst lange auf ihren\n"
      + "Rechner laufen.\n"
      + "\n"
      + "\n"
      + "Was zunächst wie eine Spielerei anmutet, kann verfeinert werden, indem\n"
      + "mit Hilfe eines Arguments mitgezählt wird, wie oft die Prozedur bereits\n"
      + "rekursiv aufgerufen wurde:\n"
      + "\n"
      + "<code class=\"HalloZaehler\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "void halloZaehler(int i){\n"
      + "  printf(\"hallo %i\n\",i);\n"
      + "  halloZaehler(i+1);\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  halloZaehler(1);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Auch dieses Programm läuft endlos. \n"
      + "\n"
      + "Mit dem Bedingungsoperator haben wir aber ein Werkzeug, um zu verhindern, dass\n"
      + "rekursive Programme endlos laufen. Wir können den Bedingungsoperator nämlich\n"
      + "benutzen, um zu unterscheiden, ob wir ein weiteres Mal einen rekursiven Aufruf\n"
      + "vornehmen wollen, oder nicht mehr.\n"
      + "\n"
      + "Hierzu ein kleines Programm, in dem die rekursive Prozedur eine Zahl als\n"
      + "Parameter enthält. Zunächst druckt die Prozedur den Wert des Parameters auf\n"
      + "der Kommandozeile aus, dann unterscheidet die Prozedur. Wenn der \n"
      + "Parameter den Wert <tt>0</tt> hat, dann wird nur noch das \n"
      + "Wort <tt>ende</tt> ausgedruckt, ansonsten kommt es zu einen rekursiven\n"
      + "Aufruf. Für den rekursiven Aufruf wird der Parameter eins kleiner genommen,\n"
      + "als beim Originalaufruf.\n"
      + "\n"
      + "<code class=\"CountDown\" lang=\"c\" main=\"main\" commandchars=\"_$^\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "void countDown(int i){\n"
      + "  printf(\"hallo %i\n\",i);\n"
      + "  i==0?printf(\"ende\n\"):countDown(i-1);\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  countDown(10);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Damit verringert sich in jedem rekursiven Aufruf der Parameter um eins. Wenn\n"
      + "er anfänglich positiv war, wird er schließlich irgendwann \n"
      + "einmal <tt>0</tt> sein. Dann verhindert der Bedingungsoperator einen weiteren\n"
      + "rekursiven Aufruf. Die Auswertung endet. Man sagt, das Programm terminiert.\n"
      + "\n"
      + "\n"
      + "In diesem Zusammenhang gibt es mehrere interessante Ergebnisse aus der\n"
      + "theoretischen Informatik. Mit der Möglichkeit rekursive Funktionen zu\n"
      + "schreiben und mit der Möglichkeit über den Bedingungsoperator zu entscheiden,\n"
      + "wie weiter ausgewertet wird, hat eine Programmiersprache die Mächtigkeit, dass\n"
      + "mit ihr alle berechenbaren mathematischen Funktionen programmiert werden\n"
      + "können. \n"
      + "\n"
      + "Allerdings haben wir dafür auch einen Preis zu zahlen: wir können jetzt\n"
      + "Programme schreiben, die nicht terminieren. Und das muss auch so sein, denn\n"
      + "nach Ergebnissen der Theoretiker, muss es in einer Programmiersprache, die\n"
      + "alle berechenbaren mathematischen Funktionen ausdrücken kann, auch Programme\n"
      + "geben, die nicht terminieren.\n"
      + "\n"
      + "Nach soviel esoterisch anmutenden Ausflügen in die Theorie, wollen wir nun\n"
      + "auch eine rekursive Funktion schreiben, die etwas interessantes berechnet.\n"
      + "Hierzu schreiben wir einmal die Fakultätsfunktion, die mathematisch definiert\n"
      + "ist als:\n"
      + "<latex><![CDATA[\\begin{displaymath}\n"
      + "fac(n) = \\left\\{ \\begin{array}{ll}\n"
      + "1 & \\textrm{für $n=0$}\\\n"
      + "n*fac(n-1) & \\textrm{für $n>1$}\n"
      + "\\end{array}\right.\n"
      + "\\end{displaymath}]]></latex>\n"
      + "\n"
      + "Diese Definition läßt sich direkt in ein C Programm umsetzen:\n"
      + " \n"
      + "<code class=\"Fakultaet\" lang=\"c\" main=\"main\" commandchars=\"_$^\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int fac(int i){\n"
      + "  return i==0?1:i*fac(i-1);\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"fac(5) = %i\n\",fac(5));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + " \n"
      + "<aufgabe  blatt=\"2\">Nehmen Sie das Programm zur Berechnung der \n"
      + "Fakultät und testen sie\n"
      + "es mit verschiedenen größeren Argumenten.\n"
      + "\n"
      + "<loesung>\n"
      + "\n"
      + "\n"
      + "<code class=\"Fakultaet2\" lang=\"c\" main=\"main\" commandchars=\"_$^\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int fac(int i){\n"
      + "  return i==0?1:i*fac(i-1);\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"fac(5) = %i\n\",fac(5));\n"
      + "  printf(\"fac(10) = %i\n\",fac(10));\n"
      + "  printf(\"fac(15) = %i\n\",fac(15));\n"
      + "  printf(\"fac(20) = %i\n\",fac(20));\n"
      + "  printf(\"fac(20000) = %i\n\",fac(20000));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Die Ausgabe zeigt, wie schnell die Werte für die Fakultät wachsen, so dass\n"
      + "eine <tt>int</tt>-Zahl nicht mehr ausreicht, das Ergebnis zu speichern:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/tutor> bin/Fakultaet2\n"
      + "fac(5) = 120\n"
      + "fac(10) = 3628800\n"
      + "fac(15) = 2004310016\n"
      + "fac(20) = -2102132736\n"
      + "fac(20000) = 0\n"
      + "sep@pc305-3:~/fh/c/tutor>]]></scode>\n"
      + "</loesung>\n"
      + "</aufgabe>\n"
      + "\n"
      + "<aufgabe blatt=\"2\"><b>(1 Punkt)</b> Im Bestseller <em>Sakrileg \n"
      + "(der Da Vinci Code)</em> spielen die Fibonaccizahlen eine  \n"
      + " Rolle. Für eine\n"
      + "natürliche Zahl <m>n</m> ist ihre Fibonaccizahl definiert durch:\n"
      + "<latex><![CDATA[\\begin{displaymath}\n"
      + "f(n) = \\left\\{ \\begin{array}{ll}\n"
      + "n & \\textrm{für $n\\le 1$}\\\n"
      + "f(n-1)+f(n-2) & \textrm{für $n>1$}\n"
      + "\\end{array}\\right.\n"
      + "\\end{displaymath}]]></latex>\n"
      + "\n"
      + "Programmieren Sie eine Funktion <tt>int fib(int n)</tt>, die für eine Zahl,\n"
      + "die entsprechende Fibonaccizahl zurückgibt.\n"
      + "\n"
      + "Geben Sie in der Hauptfunktion die ersten 20 Fibonaccizahlen aus.\n"
      + "\n"
      + "<loesung>\n"
      + "Tatsächlich ist die Lösung ein Einzeiler, es muß ja nur die Formel aus der\n"
      + "Spezifikation direkt abgeschrieben werden.\n"
      + "<code main=\"main\" lang=\"c\" class=\"Fib\" commandchars=\"^~!\"\n"
      + "\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int fib(int n){\n"
      + "  return  n<=1?n:(fib(n-1)+fib(n-2));\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"fib(0): %i\n\",fib(0));\n"
      + "  printf(\"fib(1): %i\n\",fib(1));\n"
      + "  printf(\"fib(2): %i\n\",fib(2));\n"
      + "  printf(\"fib(3): %i\n\",fib(3));\n"
      + "  printf(\"fib(4): %i\n\",fib(4));\n"
      + "  printf(\"fib(5): %i\n\",fib(5));\n"
      + "  printf(\"fib(6): %i\n\",fib(6));\n"
      + "  printf(\"fib(7): %i\n\",fib(7));\n"
      + "  printf(\"fib(8): %i\n\",fib(8));\n"
      + "  printf(\"fib(9): %i\n\",fib(9));\n"
      + "  printf(\"fib(10): %i\n\",fib(10));\n"
      + "  printf(\"fib(11): %i\n\",fib(11));\n"
      + "  printf(\"fib(12): %i\n\",fib(12));\n"
      + "  printf(\"fib(13): %i\n\",fib(13));\n"
      + "  printf(\"fib(14): %i\n\",fib(14));\n"
      + "  printf(\"fib(15): %i\n\",fib(15));\n"
      + "  printf(\"fib(16): %i\n\",fib(16));\n"
      + "  printf(\"fib(17): %i\n\",fib(17));\n"
      + "  printf(\"fib(18): %i\n\",fib(18));\n"
      + "  printf(\"fib(19): %i\n\",fib(19));\n"
      + "  return 0;\n"
      + "}]]></code></loesung>\n"
      + "</aufgabe>\n";
    String skript4 =
        "\n"
      + "<seite titel=\"rekursive Funktionen\">\n"
      + "<ul><li><h2>Funktionen, die sich selbst wieder aufrufen</h2></li></ul>\n"
      + "<ul><li><h2>führt ohne Abbruchbedingung zu endlosen Programmlauf</h2></li></ul>\n"
      + "<ul><li><h2><b>daher</b>: Unterscheidung, wann rekursiv aufgerufen wird und wann nicht nötig</h2></li></ul>\n"
      + "<ul><li><h2><b>bisher</b>: bisher nur Bedingungsoperatore zur Unterscheidung</h2></li></ul>\n"
      + "<ul><li><h2>mit Bedingungsoperator und Rekursion alle berechenbaren Funktionen\n"
      + "programmierbar</h2></li></ul>\n"
      + "</seite>\n"
      + "</subsection>\n"
      + "</section>\n"
      + "\n"
      + "\n"
      + "\n"
      + "<section titel=\"Variablen\">\n"
      + "Bisher haben wir uns der Programmierung von einer sehr mathematischen\n"
      + "funktionalen Seite genähert. Ein Grundkonzept fast aller Programmiersprachen\n"
      + "leitet sich aus unserem tatsächlichen Rechnermodell her. Ein Computer hat\n"
      + "einen Speicher, der in verschiedene Speicherzellen eingeteilt ist. In den\n"
      + "Speicherzellen sind Zahlen gespeichert. In eine Speicherzelle können neue\n"
      + "Werte hineingeschrieben werden und sie können auch wieder ausgelesen werden. \n"
      + "\n"
      + "Die meisten Programmiersprachen bilden dieses Modell ab, indem sie das Konzept\n"
      + "der Variablen haben. Eine Variable steht dabei für eine Speicherzelle, in der\n"
      + "Werte geschrieben und später wieder ausgelesen werden können. \n"
      + "\n"
      + "<subsection titel=\"Zuweisung\">\n"
      + "Um eine Variable zu definieren ist zunächst zu definieren, welche Art von\n"
      + "Daten dort hinein geschrieben werden sollen. Bisher arbeiten wir nur mit\n"
      + "ganzen Zahlen und schreiben deshalb <tt>int</tt>. Dann folgt ein frei\n"
      + "wählbarer Name für die Variable. Schließlich kann in die Variable mit einem\n"
      + "Gleichheitszeichen ein Wert hinein geschrieben werden. Dieses wird dann als\n"
      + "Zuweisung bezeichnet. \n"
      + "\n"
      + "Im folgenden Programm wird eine Variable <tt>x</tt> deklariert, der sogleich\n"
      + "der Wert <tt>0</tt> zugewiesen wird. Anschließend wird die Variable\n"
      + "benutzt. Sie wird manipuliert, indem ihr neue Werte zugewiesen werden.\n"
      + "\n"
      + "<code class=\"Var1\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int main(){\n"
      + "  int x=0;\n"
      + "  printf(\"x = %i\n\",x);\n"
      + "  x=2;\n"
      + "  printf(\"x = %i\n\",x);\n"
      + "  x=x*x;\n"
      + "  printf(\"x = %i\n\",x);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "Interessant ist die Zeile 8. Hier wird der Variablen <tt>x</tt> ein neuer Wert\n"
      + "zugewiesen. Dieser neue Wert berechnet sich aus dem Quadrat des alten Werts\n"
      + "der Variablen <tt>x</tt>.\n"
      + "\n"
      + "Wir sind natürlich in der Zahl der benutzen Variablen nicht beschränkt. Das\n"
      + "folgende Programm benutzt zwei Variablen.\n"
      + "\n"
      + "<code class=\"Var2\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int main(){\n"
      + "  int x=17;\n"
      + "  int y=4;\n"
      + "  printf(\"x+y = %i\n\",x+y);\n"
      + "  x=x+y;\n"
      + "  printf(\"x = %i\n\",x);\n"
      + "  printf(\"y = %i\n\",y);\n"
      + "  y=x*2;\n"
      + "  printf(\"y = %i\n\",y);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "Variablen können natürlich dazu benutzt werden, um das Ergebnis einer Funktion\n"
      + "zu speichern:\n"
      + "\n"
      + "<code class=\"VarQuadrat\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int quadrat(int x){\n"
      + "  return x*x;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  int y = quadrat(quadrat(2));\n"
      + "  printf(\"%i\n\",y);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "Bisher haben wir direkt, nachdem eine Variable eingeführt wurde, ihr einen\n"
      + "Wert zugewiesen. Man kann das auch in zwei Schritten machen. Erst eine (oder\n"
      + "gleich mehrere) Variablen deklarieren, und sie dann benutzen, indem Ihnen Werte\n"
      + "zugewiesen werden.\n"
      + "\n"
      + "\n"
      + "<code class=\"Var3\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int main(){\n"
      + "  int x,y;\n"
      + "  x=17;\n"
      + "  y=4;\n"
      + "  printf(\"x+y = %i\n\",x+y);\n"
      + "  x=x+y;\n"
      + "  printf(\"x = %i\n\",x);\n"
      + "  printf(\"y = %i\n\",y);\n"
      + "  y=x*2;\n"
      + "  printf(\"y = %i\n\",y);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Nur welchen Wert hat eine Variable, bevor sie einen Wert explizit zugewiesen\n"
      + "bekommt? \n"
      + "<aufgabe blatt=\"3\">Schreiben Sie \n"
      + "ein Testprogramm, in dem sie eine Variable auf \n"
      + "der Kommandozeile ausgeben,  \n"
      + "bevor dieser Variablen ein Wert zugewiesen \n"
      + "wurde.\n"
      + "\n"
      + "<loesung><code class=\"NoInit\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  int x,y,z;\n"
      + "  printf(\"%i %i %i\n\",x,y,z);\n"
      + "  return 0;\n"
      + "}\n"
      + "]]></code>\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/tutor> bin/NoInit\n"
      + "134513600 1073834176 1075174352\n"
      + "sep@pc305-3:~/fh/c/tutor]]></scode>\n"
      + "</loesung>\n"
      + "</aufgabe>\n"
      + "\n"
      + "</subsection>\n"
      + "\n"
      + "\n"
      + "<subsection titel=\"lokale und globale Variablen\">\n"
      + "Bisher haben wir alle Variablen innerhalb der \n"
      + "Funktion <tt>main</tt> deklariert. Damit konnten diese Variablen auch nur\n"
      + "innerhalb der Funktion <tt>main</tt> benutzt werden. Nach dem Schließen der\n"
      + "geschweiften Klammer war die Variable dann wieder unbekannt. Solche Variablen,\n"
      + "die nur innerhalb einer Funktion (oder noch kleineren Einheit) bekannt sind,\n"
      + "werden als lokale Variablen bezeichnet. Man spricht vom Gültigkeitsbereich der\n"
      + "Variablen. Außerhalb des lokalen Bereichs, in dem sie definiert werden, sind\n"
      + "die Variablen nicht mehr gültig. Dort kann dann eine Variable gleichen Namens\n"
      + "deklariert werden. Diese Variablen gleichen Namens sind vollkommen unabhängig\n"
      + "voneinander. Sie bezeichnen tatsächlich unterschiedliche Stellen im\n"
      + "Speicher. Zusätzlich werden diese lokalen Variable bei jedem Aufruf der\n"
      + "Funktion wieder neu angelegt. Den Wert, den die Variablen am Ende einer\n"
      + "Ausführung hatten, werden sie am Anfang der nächsten \n"
      + "Ausführung nicht mehr kennen.\n"
      + "\n"
      + "Folgendes Programm veranschaulicht dieses. Es gibt tatsächlich drei Variablen\n"
      + "mit Namen <tt>y</tt>.\n"
      + " \n"
      + "<code class=\"Lokal\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int f1(){\n"
      + "  int y = 1; \n"
      + "  y=y+1;\n"
      + "  return y;\n"
      + "}\n"
      + "\n"
      + "int f2(){\n"
      + "  int y = 2; \n"
      + "  y=y*2;\n"
      + "  return y;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  int y = f1();\n"
      + "  printf(\"%i\n\",y);\n"
      + "  y = f1();\n"
      + "  printf(\"%i\n\",y);\n"
      + "  y = f2();\n"
      + "  printf(\"%i\n\",y);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "das Programm führt zu folgender Ausgabe:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/Lokal\n"
      + "2\n"
      + "2\n"
      + "4\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Im Gegensatz zu lokalen Variablen, kann man außerhalb von Funktionen auch\n"
      + "globale Variablen deklarieren. Diese sind dann tatsächlich für alle Funktionen\n"
      + "benutzbar und existieren dann nur einmal. \n"
      + "\n"
      + "\n"
      + "<code class=\"Global\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int y = 1; \n"
      + "\n"
      + "int f1(){\n"
      + "  y=y+1;\n"
      + "  return y;\n"
      + "}\n"
      + "\n"
      + "int f2(){\n"
      + "  y=y*2;\n"
      + "  return y;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  y = f1();\n"
      + "  printf(\"%i\n\",y);\n"
      + "  y = f1();\n"
      + "  printf(\"%i\n\",y);\n"
      + "  y = f2();\n"
      + "  printf(\"%i\n\",y);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Im Gegensatz zum  Programm <tt>Local</tt>   haben wir jetzt folgende Ausgabe:\n"
      + "\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/Global\n"
      + "2\n"
      + "3\n"
      + "6]]></scode>\n"
      + "\n"
      + "<aufgabe  blatt=\"3\">Probieren Sie aus, \n"
      + "ob es möglich ist,  eine globale Variable noch\n"
      + "einmal als lokale Variable zu deklarieren.\n"
      + "\n"
      + "<loesung><code class=\"Allreadydefined\" lang=\"c\">int x;\n"
      + "void f(int x){}\n"
      + "\n"
      + "int main(){\n"
      + "  int x;\n"
      + "  for(;;){\n"
      + "      int x;\n"
      + "  }\n"
      + "}</code></loesung>\n"
      + "</aufgabe>\n"
      + "\n"
      + "Die Benutzung von globalen Variablen ist gefährlich. Jedes Mal, wenn in einer\n"
      + "Funktion eine globale Variable benutzt und verändert wird, handelt es sich um\n"
      + "einen Seiteneffekt. Jetzt wird es richtig kompliziert, darüber Buch zu führen,\n"
      + "wann eine Variable durch welchen Funktionsaufruf aus welchem Grund verändert\n"
      + "wird. Um die Absicht einer globalen Variablen zu verstehen, muß man das ganze\n"
      + "Programm betrachten. Jede Funktion muß betrachtet werden, um zu sehen, ob sie\n"
      + "die globale Variable verändert. Damit widersprechen die globalen Variablen der\n"
      + "Idee, unabhängige Komponenten zu schaffen. Funktionen sind, so lange sie keine\n"
      + "globale Variablen benutzen, solche unabhängige Komponenten, wenn sie\n"
      + "allerdings globale Variablen benutzen, dann sind die Funktionen nicht mehr\n"
      + "unabhängige Komponenten.\n"
      + "\n"
      + "Daher sollte man weitgehendst versuchen, auf globale Variablen zu\n"
      + "verzichten. Nur in ganz bestimmten Situationen, um eine Information zu\n"
      + "speichern, die wirklich global ist, sollte man auch gobale Variablen\n"
      + "verwenden. \n"
      + "\n"
      + "\n"
      + "</subsection>\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "<subsection titel=\"statische Variablen\">\n"
      + "Es gibt auch eine Möglichkeit, Variablen\n"
      + "so zu deklarieren, dass sie über mehrere Aufrufe einer Funktion hinweg ihren\n"
      + "Wert behalten.  Hierzu ist bei der Deklaration der Variablen das \n"
      + "Wort <tt>static</tt> zu schreiben. Damit wird eine Variable als statisch\n"
      + "deklariert. Statische Variablen existieren nicht für jeden Programmdurchlauf\n"
      + "neu, sondern einmal für alle Aufrufe einer Funktion. \n"
      + "\n"
      + "Man veranschauliche sich das am folgenden Programm.\n"
      + "\n"
      + "<code class=\"Static\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int f1(){\n"
      + "  static int y= 0;\n"
      + "  y=y+1;\n"
      + "  return y;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  int y = f1();\n"
      + "  printf(\"%i\n\",y);\n"
      + "  y = f1();\n"
      + "  printf(\"%i\n\",y);\n"
      + "  y = f1();\n"
      + "  printf(\"%i\n\",y);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Wie man der Ausgabe entnehmen kann, erhöht jeder Aufruf der \n"
      + "Funktion <tt>f1</tt> die statische Variable <tt>y</tt> um eins. Der initiale\n"
      + "Wert <tt>0</tt>, der der Variablen bei der Deklaration mitgegeben wird, wird\n"
      + "nur beim allerersten Aufruf der Funktion der Variablen <tt>y</tt> gegeben.\n"
      + "\n"
      + "Es kommt zu folgender Ausgabe:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/Static\n"
      + "1\n"
      + "2\n"
      + "3\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Statisch bedeutet also, eine Variable für alle möglichen Aufrufe der\n"
      + "Funktion. Nicht statisch hingegen: jeder Aufruf der Funktion bekommt die\n"
      + "Variable wieder neu und frisch erstellt und mit einem initialen Wert belegt. \n"
      + "\n"
      + "Damit kann mit Hilfe statischer Variablen Information von einem Aufruf der\n"
      + "Funktion zum nächsten Aufruf der Funktion behalten werden. Die Aufrufe der\n"
      + "Funktion sind damit nicht mehr unabhängig voneinander. Im obigen Beispiel\n"
      + "zählt die statische Variable durch, wie oft die Funktion bereits aufgerufen\n"
      + "wurde. \n"
      + "\n"
      + "Damit widersprechen statische Variablen auch der Idee, möglichst unabhängige\n"
      + "Einheiten zu schaffen. Mit einer statischen Variablen ist eine Funktion nicht\n"
      + "mehr deterministisch: der gleiche Aufruf  einer Funktion nacheinander führt\n"
      + "jeweils zu unterschiedlichen Ergebnisse (und damit handelt es sich schon nicht\n"
      + "mehr um eine Funktion im mathematischen Sinne). \n"
      + "\n"
      + "<aufgabe blatt=\"3\"><b>(1 Punkt)</b>\n"
      + "Um eine Folge von Zahlen, die eine mehr oder weniger zufällige Verteilung\n"
      + "haben, zu erzeugen, kann man sich einer rekursiven Gleichung bedienen.\n"
      + "Ein sehr einfaches Verfahren benutzt drei konstante Werte:\n"
      + "<itemize>\n"
      + "<item>den Faktor <m>a</m>.</item>\n"
      + "<item>das Inkrement <m>c</m>.</item>\n"
      + "<item>den Modul <m>m</m>.</item>\n"
      + "</itemize>\n"
      + "\n"
      + "Zusätzliche wähle man einen Startwert <m>x_0</m>.\n"
      + "\n"
      + "Dann sei die Folge <m>(x_0, x_1, x_2,\\dots)</m> definiert durch die \n"
      + "Gleichung: <m>x_{i+1} = (a*x_i + c)~\\rm{\\sl mod}~m</m>.\n"
      + "\n"
      + "Damit gilt $x_i\\ge 0$ und $x_i&lt;m$ für $i\\ge 0$. \n"
      + "Man erhält also eine Folge von Zahlen\n"
      + "zwischen 0 und <m>m</m>.\n"
      + "\n"
      + "Schreiben Sie unter Benutzung statischer lokaler Variablen eine \n"
      + "Funktion:<br />\n"
      + "<tt>int zufall();</tt><br/>\n"
      + "Sie soll bei jeden Aufruf ein \n"
      + "weiteres Element der obigen Folge berechnen. Es seien\n"
      + "dabei folgende Werte gewählt: $a=21$, $c=17$, $m=100$ und $x_0=42$.\n"
      + "\n"
      + "Testen Sie ihre Funktion <tt>zufall</tt> mit folgenden Test:\n"
      + "<code commandchars=\"_$^\"><![CDATA[int schleife(int i){\n"
      + "  printf(\"%i \",zufall());\n"
      + "  return i>0?schleife(i-1):0;\n"
      + "}\n"
      + "int main(){\n"
      + "  schleife(100);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "\n"
      + "<loesung>\n"
      + "\n"
      + "<code lang=\"c\" class=\"Zufall\" main=\"main\" commandchars=\"_$^\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int zufall(){\n"
      + "  static int x=42;\n"
      + "  static int a=21; //factor\n"
      + "  static int c=17; //increment;\n"
      + "  static int m=100;//modul;\n"
      + "  x=(a*x+c)%m;\n"
      + "  return x;\n"
      + "}\n"
      + "\n"
      + "int schleife(int i){\n"
      + "  printf(\"%i \",zufall());\n"
      + "  return i>0?schleife(i-1):0;\n"
      + "}\n"
      + "int main(){\n"
      + "  schleife(100);\n"
      + "  return 0;\n"
      + "}]]></code></loesung>\n"
      + "</aufgabe>\n"
      + "\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Auch Parameter sind Variablen\">\n"
      + "Wir haben bisher den Zuweisungsbefehl für Variablen\n"
      + "kennengelernt. Erstaunlicher Weise kann man auch den Parametern einer Funktion\n"
      + "neue Werte zuweisen:\n"
      + "\n"
      + "<code class=\"AssignParam\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int f1(int x){\n"
      + "  x=2*x;\n"
      + "  return x;\n"
      + "}]]></code>\n"
      + "\n"
      + "Hier wird also ein Parameter auch als Variable benutzt. Was bedeutet das, wenn\n"
      + "die Funktion mit einer Variablen als Argument aufgerufen wird. Wird damit das\n"
      + "Argument im Aufruf auch verändert? Betrachten wir hierzu folgende \n"
      + "Funktion <tt>main</tt>:\n"
      + "\n"
      + "<code class=\"AssignParam\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[int main(){\n"
      + "  int y = 42;\n"
      + "  int z = f1(y);\n"
      + "  printf(\"y = %i\n\",y);\n"
      + "  printf(\"z = %i\n\",z);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Was passiert mit der Varaiblen <tt>y</tt> beim Aufruf der \n"
      + "Funktion <tt>f1</tt>? Verdoppelt sich auch ihr Wert oder nicht? Betrachten wir\n"
      + "hierzu die Ausgabe:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> ./bin/AssignParam\n"
      + "y = 42\n"
      + "z = 84\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Man sieht, dass sich der Wert von <tt>y</tt> durch den \n"
      + "Aufruf <tt>f1(y)</tt> nicht verändert hat. Der Parameter <tt>x</tt> der\n"
      + "Funktion <tt>f1</tt> verhält sich wie eine lokale Variable, die beim Aufruf\n"
      + "den Wert, mit dem die Funktion aufgerufen wird erhält. Ob dieser Wert aus\n"
      + "einer anderen Variablen ausgelesen wurde, spielt dabei keine Rolle. \n"
      + "Man bezeichnet dieses Verhalten als Parameterübergabe per Wert. Die\n"
      + "aufgerufene Funktion erhält nur den übergebenen Wert und hat keinerlei Zugriff\n"
      + "auf eventuelle Variablen, aus denen dieser Wert ursprünglich stammt.\n"
      + "\n"
      + "</subsection>\n"
      + "\n"
      + "\n"
      + "<subsection titel=\"Fragen des Stils\">\n"
      + "Es gibt vielfältige Möglichkeiten mit Variablen in C zu arbeiten. Welche\n"
      + "Empfehlung kann man dazu geben. Eine Empfehlung haben wir  bereits kennen\n"
      + "gelernt. Möglichst keine globalen Variablen zu benutzen.\n"
      + "Ebenso sollte man weitgehendst versuchen auf statische Variablen zu\n"
      + "verzichten. Auch sie widersprechen der Idee, eigenständige unabhängige\n"
      + "Komponenten zu schaffen. \n"
      + "\n"
      + "Wie sieht es mit Parametern aus? Soll man sich wie Variablen benutzen und ihnen\n"
      + "unter Umständen einen neuen Wert zuweisen. Auch hiervon ist besser\n"
      + "abzuraten. Ein Programm ist leichter zu lesen, wenn ein Parameter immer nur\n"
      + "den Wert enthält, den er beim Funktionsaufruf bekommen hat. \n"
      + "\n"
      + "Desweiteren: welcher Stil ist nun besser? Erst alle Variablen deklarieren und\n"
      + "ihnen dann \n"
      + "Werte zuweisen, also: <tt>int x; ... ;x=42;</tt>, oder aber gleich einen Anfangswert der Variablen mitgeben,\n"
      + "wenn sie deklariert wird: <tt>int x=42;</tt>? \n"
      + "Und wo soll man die Variable deklarieren? Ganz oben\n"
      + "im Programm oder erst da, wo man sie zum ersten Mal braucht?\n"
      + "\n"
      + "Die Antworten auf diese Fragen können sehr unterschiedlich ausfallen, je\n"
      + "nachdem, wen sie fragen. Mehrere Jahrzehnte wurde gelehrt, Variablen schön\n"
      + "übersichtlich alle am Anfang des Programms zu deklarieren, damit man einen\n"
      + "genauen Überblick hat, mit welchen Variablen man arbeitet. Es gab\n"
      + "Programmiersprachen, die dieses sogar zur Pflicht erhoben haben. Zusätzlich\n"
      + "ist der \n"
      + "klassische C Stil, eine Variable erst einmal zu deklarieren, und dann \n"
      + "erst bei Bedarf ihr einen Wert zuzuweisen. Seit geraumer Zeit wurden diese\n"
      + "Empfehlungen gerade umgedreht. Heute wird vielfach propagiert: Variablen so\n"
      + "spät wie möglich deklarieren, so dass sie einen möglichst begrenzten lokalen\n"
      + "Gültigkeitsbereich bekommen. Zusätzlich soll man Variablen dann direkt ihren\n"
      + "Wert zuweisen. Die Idee ist: warum soll ich mich am Anfang eines Programms mit\n"
      + "Variablen belasten, die ich irgendwann nur kurz brauche, um ein\n"
      + "Zwischenergebnis abzuspeichern. Am saubersten ist, wenn Variablen gar nicht\n"
      + "variabel sind, sondern nachdem sie einmal ihren Wert bekommen haben, diesen\n"
      + "Wert gar nicht mehr verändern. \n"
      + "</subsection>\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "<delete><aufgabe>Schreiben Sie eine rekursive Funktion, die die Fakultät ihres\n"
      + "Parameters als Rückgabe hat. Als Fakultät einer Zahl <m>n</m> wird das \n"
      + "Produkt <m>1*2*3*\\dots*(n-2)*(n-1)*n</m> bezeichnet.</aufgabe></delete>\n"
      + "\n"
      + "<delete>\n"
      + "kleines C++ Kapitel\n"
      + "<subsection titel=\"Referenzvariablen\">\n"
      + "In diesem Abschnitt sollen Parameter und lokale Variablen gemeinsam betrachtet\n"
      + "werden. Wie wollen einmal untersuchen, was genau eigentlich passiert, wenn\n"
      + "einer Variablen ein Wert zugewiesen wird, oder wenn ein Parameter durch einen\n"
      + "Funktionsaufruf einen Wert erhält. Betrachten wir noch einmal \n"
      + "folgendes Programm,\n"
      + "in dem in einer Funktion dem Parameter ein neuer Wert zugewiesen wird:\n"
      + "\n"
      + "<code class=\"NoRefparam\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int f1(int x1){\n"
      + "  x1=2*x1;\n"
      + "  return x1;\n"
      + "}]]></code>\n"
      + "\n"
      + "Nun sei einmal ausprobiert, in wiefern der Aufruf der \n"
      + "Funktion <tt>f1</tt> mit der Variable <tt>x</tt>, auf die \n"
      + "Variable <tt>x</tt> wirkt:\n"
      + "\n"
      + "<code class=\"NoRefparam\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[int main(){\n"
      + "  int x = 21;\n"
      + "  int y = f1(x);\n"
      + "  printf(\"x: %i\n\",x);\n"
      + "  printf(\"y: %i\n\",y);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Mit Sicherheit nehmen wir an, dass für die Variable <tt>y</tt> der \n"
      + "Wert <tt>42</tt> ausgegeben wird. Was aber ist mit der \n"
      + "Varialen <tt>x</tt>. Sie hat ursprünglich den Wert <tt>21</tt>. Dann wird die\n"
      + "Funktion <tt>f1</tt> mit dieser Variablen <tt>x</tt> aufgerufen. Innerhalb der\n"
      + "Funktion <tt>f1</tt> wird dem Parameter ein neuer Wert zugewiesen. Hat das \n"
      + "Einfluss auf die lokale Variable <tt>x</tt> der Funktion <tt>main</tt>.\n"
      + "\n"
      + "Betrachten wir hierzu einmal die Ausgabe:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/NoRefparam\n"
      + "x: 21\n"
      + "y: 42\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Offensichtlich wurde der Wert der Variablen <tt>x</tt> nicht verändert. Der\n"
      + "Aufruf der Funktion <tt>f1</tt> hatte keinen Seiteneffekt. Die \n"
      + "Funktion <tt>f1</tt> wurde nämlich nicht mit der \n"
      + "Variablen <tt>x1</tt> aufgerufen, sondern es wurde geschaut, \n"
      + "welche Zahl in dieser Variablen gespeichert ist.\n"
      + "\n"
      + "Man bezeichnet dieses Prinzip als eine Parameterübergabe über den\n"
      + " Wert (<em>by value</em>). Es ist dabei ganz egal, woher der Wert, mit dem\n"
      + "eine Funktion kommt aufgerufen wird, ob direkt mit einer Zahl, ob mit einem\n"
      + " komplexeren arithmetischen Ausdruck, der einen Wert berechnet oder ob mit\n"
      + " einer Variablen, in der ein Wert steht. Es wird dieser  Funktion nur eine\n"
      + " Zahl übergeben, egal wo diese Zahl herkommt. Diese Zahl wird im Parameter der\n"
      + " Funktion gespeichert und dieser Parameter ist damit wieder eine Variable, die\n"
      + " mit einer eventuellen Variablen in der vorher die Zahl stand, nichts zu tun\n"
      + " hat. \n"
      + "\n"
      + "Standardmäßig gibt es in C die Parameterübergabe mit Wert; aber man kann\n"
      + "dieses Standardverhalten ändern. Hierzu dient das Symbol <tt>&amp;</tt>. \n"
      + "Steht vor einer Variablen, in unserem Fall vor einem Parameternamen dieses\n"
      + "Symbol, so wird damit angezeigt, dass dieser Parameter einen anderen\n"
      + "Übergabemechanismus hat.\n"
      + "\n"
      + "Schreiben wir das letzte Programm mit dieser minimalen Änderung, dass vor dem\n"
      + "Variablennamen <tt>x1</tt> das Zeichen <tt>&amp;</tt> steht:\n"
      + "\n"
      + "<code class=\"RefParam\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int f1(int &x1){\n"
      + "  x1=2*x1;\n"
      + "  return x1;\n"
      + "}]]></code>\n"
      + "\n"
      + "Nun können wir den gleichen Test wie bei dem vorherigen Programm machen:\n"
      + "\n"
      + "<code class=\"RefParam\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[int main(){\n"
      + "  int x = 21;\n"
      + "  int y = f1(x);\n"
      + "  printf(\"x: %i\n\",x);\n"
      + "  printf(\"y: %i\n\",y);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Dieses mal bekommen wir eine andere Ausgabe:\n"
      + "\n"
      + "<scode><![CDATA[[sep@pc305-3:~/fh/c/student> bin/RefParam\n"
      + "x: 42\n"
      + "y: 42\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Nun wurde tatsächlich der in der Variablen <tt>x</tt> gespeicherte Wert durch\n"
      + "den Aufruf von <tt>f1</tt> verdoppelt. Variablen, vor deren Namen das \n"
      + "Symbol <tt>&amp;</tt> steht werden als Referenzvariablen und Parameter\n"
      + "bezeichnet.  Für Referenzparameter wird eine Funktion nicht per Wert\n"
      + "aufgerufen, sondern per Referenz. Das bedeutet, dass eine Referenzvariable gar\n"
      + "keine eigene neue Variable ist, sondern lediglich ein anderer Name für eine\n"
      + "bereits bestehende Variable. In unserem Beispiel ist die \n"
      + "Variable <tt>x1</tt> gar keine eigene Variable, sondern ein anderer Name für\n"
      + "die Variable, mit der die Funktion <tt>f1</tt> aufgerufen wird. Jede Änderung\n"
      + "der Variablen <tt>x1</tt> führt in unserem Beispiel, in \n"
      + "der <tt>f1</tt> mit <tt>x</tt> aufgerufen wird, wird also auch immer, \n"
      + "wenn <tt>x1</tt> ein neuer Wert zugewiesen wird auch <tt>x</tt> ein neuer Wert\n"
      + "zugewiesen. \n"
      + "\n"
      + "Da Referenzparameter nur einen anderen Namen für eine Variable darstellt, mit\n"
      + "der die Funktion für diesen Parameter aufgerufen wird, darf eine Funktion auch\n"
      + "nur mit einer Variablen aufgerufen werden. Schauen wir einmal, was passiert,\n"
      + "wenn wir versuchen die Funktion nicht mit einer Variablen aufzurufen. Hierzu\n"
      + "noch einmal die bekannte Funktion:\n"
      + "\n"
      + "\n"
      + "<code class=\"RefParamError1\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int f1(int &x1){\n"
      + "  x1=2*x1;\n"
      + "  return x1;\n"
      + "}]]></code>\n"
      + "\n"
      + "Jetzt sei die Funktion einmal nicht mit einer Variablen aufgerufen\n"
      + "\n"
      + "<code class=\"RefParamError1\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[int main(){\n"
      + "  int y = f1(21);\n"
      + "  int z = f1(17+4);\n"
      + "  printf(\"y: %i\n\",y);\n"
      + "  printf(\"z: %i\n\",z);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Schon bei der Kompilierung haut uns der Compiler auf die Finger:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> g++ src/RefParamError1.c\n"
      + "src/RefParamError1.c: In function `int main()':\n"
      + "src/RefParamError1.c:8: error: invalid initialization of non-const reference of\n"
      + "   type 'int&' from a temporary of type 'int'\n"
      + "src/RefParamError1.c:2: error: in passing argument 1 of `int f1(int&)'\n"
      + "src/RefParamError1.c:9: error: invalid initialization of non-const reference of\n"
      + "   type 'int&' from a temporary of type 'int'\n"
      + "src/RefParamError1.c:2: error: in passing argument 1 of `int f1(int&)'\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Die Fehlermeldung leuchtet auch ein. Der Referenzparameter soll ein anderer\n"
      + " Name einer bestehenden Variablen werden. Aber wird die Funktion nicht mit\n"
      + " einer Variablen aufgerufen, dann gibt es ja gar keine Varaible, für die\n"
      + " dieser\n"
      + "Paramter ein neuer Name sein könnte.\n"
      + "\n"
      + "\n"
      + "All das bisher gesagte gilt nicht nur für Parameter sondern eins-zu-eins in\n"
      + "gleicher Weise für Variablen. Analog können die obigen Programme auch für\n"
      + "lokale Variablen durchgeführt werden. Hier leuchtet die Übergabe per Wert\n"
      + "als Standardverhalten direkt ein:\n"
      + "\n"
      + "<code class=\"NoRefVar\" lang=\"c\" main=\"main\" \n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  int x = 21;\n"
      + "  int y = x;\n"
      + "  y = 2*y;\n"
      + "  printf(\"x: %i\n\",x);\n"
      + "  printf(\"y: %i\n\",y);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Hier sind zwei unabhängige Variablen deklariert. Die \n"
      + "Variable <tt>y</tt> erhält zwar durch die Zuweisung <tt>y=x</tt> ihren Wert\n"
      + "von der Variablen <tt>x</tt>. Da es sich um eine Wertzuweisung handelt haben\n"
      + "die beiden Variablen aber wieder nichts miteinander zu tun. Die Veränderung\n"
      + "von <tt>y</tt> hat keine Auswirkung auf <tt>x</tt>.\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/NoRefVar\n"
      + "x: 21\n"
      + "y: 42\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Ebenso wie Parameter können aber auch Variablen als Referenzvariablen\n"
      + "deklariert werden. Auch hierzu ist wieder das Symbol <tt>&amp;</tt> bei der\n"
      + "Deklaration der Variablen vor ihren Namen zu schreiben:\n"
      + "\n"
      + "<code class=\"RefVar\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  int x = 21;\n"
      + "  int &y = x;\n"
      + "  y = 2*y;\n"
      + "  printf(\"x: %i\n\",x);\n"
      + "  printf(\"y: %i\n\",y);\n"
      + "\n"
      + "  x = 2*x;\n"
      + "  printf(\"x: %i\n\",x);\n"
      + "  printf(\"y: %i\n\",y);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Nun ist die Variable <tt>y</tt> nur ein anderer Name für die \n"
      + "Variable <tt>x</tt>, d.h. jede Änderung an <tt>y</tt> wirkt sich auch\n"
      + "auf <tt>x</tt> aus und umgekehrt:\n"
      + "\n"
      + "<scode><![CDATA[]]></scode>\n"
      + "\n"
      + "Ebenso wie bei Referenzparameter gibt es bei Referenzvariablen die\n"
      + "Einschränkung, dass sie mit einer Variablen initialisiert werden\n"
      + "müssen. Ansonsten beschwert sich schon der Compiler:\n"
      + "\n"
      + "<code class=\"RefVarError\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  int x = 21;\n"
      + "  int &y = 2*(17+4);\n"
      + "  int &z;\n"
      + "  z = y\n"
      + "}]]></code>\n"
      + "\n"
      + "<scode><![CDATA[]]></scode>\n"
      + " \n"
      + "</subsection>\n"
      + "</delete>\n"
      + "<seite titel=\"Variablen\">\n"
      + "<ul>\n"
      + "<li><h2>Variablen bezeichnen Speicherzellen</h2></li>\n"
      + "<li><h2>bei der Deklaration einer Variablen ist der Typ anzugeben</h2></li>\n"
      + "<li><h2>mit dem Gleicheitssymbol werden Variablen Werte zugewiesen</h2></li>\n"
      + "</ul>\n"
      + "\n"
      + "</seite>\n"
      + "\n"
      + "<seite titel=\"Arten von Variablen\">\n"
      + "<ul>\n"
      + "<li><h2><b>lokale</b> Variablen sind innerhalb einer Funktion definiert</h2></li>\n"
      + "<li><h2><b>globale</b> Variablen stehen außerhalb einer Funktion</h2></li>\n"
      + "<li><h2>Seiteneffekt: eine Funktion verändert den Wert einer globalen Variablen</h2> </li>\n"
      + "<li><h2>lokale Variablen sind nur innerhalb des Funktionsrumpfes bekannt</h2></li>\n"
      + "</ul>\n"
      + "</seite>\n"
      + "\n"
      + "<seite titel=\"Parameter sind Variablen\">\n"
      + "<ul>\n"
      + "<li><h2>Parameter stellen Variablen dar. Sie bekommen beim Funktionsaufruf einen Wert</h2></li>\n"
      + "<li><h2>Funktionsaufrufe erfolgen per Wert, d.h. in eine seperate Speicherzelle\n"
      + "für den Parameter wird der Wert geschrieben, mit dem die Funktion aufgerufen\n"
      + "wird.</h2> </li>\n"
      + "</ul>\n"
      + "</seite>\n"
      + "\n"
      + "\n"
      + "<seite titel=\"statische Variablen\">\n"
      + "<ul>\n"
      + "<li><h2>lokale Variablen können als statisch markiert werden</h2></li>\n"
      + "<li><h2>statische Variablen werden nicht für jeden Funktionsaufruf neu\n"
      + "aufgerufen</h2></li>\n"
      + "<li><h2>damit behalten sie von einem zu einem anderen Aufruf ihren Wert</h2></li>\n"
      + "<li><h2>Beispielanwendung: Funktion, die Werte hoch zählt</h2></li>\n"
      + "</ul>\n"
      + "</seite>\n"
      + "</section>\n"
      + "\n"
      + "\n"
      + "\n"
      + "<section titel=\"Kontrollstrukturen\">\n"
      + "Bisher sind uns  die  wichtigsten Grundkonzepte, die auf ähnliche Wiese in\n"
      + "fast allen Programmiersprachen wiederzufinden sind, begegnet:\n"
      + "\n"
      + "<itemize>\n"
      + "<item>Ausdrücke zum Rechnen mit Zahlen und Wahrheitswerten. </item>\n"
      + "<item>Funktionen, als Möglichkeit ein Programm in unabhängige Komponenten zu\n"
      + "strukturieren. </item>\n"
      + "<item>Variablen, um Werte zwischenzuspeichern und später im Programm\n"
      + "wiederzuverwenden. </item>\n"
      + "</itemize>\n"
      + "\n"
      + "Damit sind die wichtigsten Grundkonzepte der Programmierung bereits\n"
      + "bekannt. Über den Trick der rekursiven Funktionen können wir sogar schon dafür\n"
      + "sorgen, dass bestimmte Programmteile wiederholt ausgeführt werden. Mit den\n"
      + "Bedingungsoperator ist es uns möglich, aufgrund eines bool'schen Werts zu\n"
      + "entscheiden, mit welchem Ausdruck weiter gearbeitet werden kann.\n"
      + "\n"
      + "In klassischen imperativen Programmiersprachen wie C, gibt es eingebaute\n"
      + "zusammengesetzte Befehle, die den Programmfluß, wann welcher Programmteil\n"
      + "abgearbeitet wird kontrollieren. Diese wollen wir in diesem Abschnitt\n"
      + "präsentieren. Erstaunlicher Weise basieren fast alle diese zusammengesetzten\n"
      + "Befehle auf einer Bedingung über einen Wahrheitswert und das, obwohl es einen\n"
      + "eigenen Datentypen für Wahrheitswerte in C überhaupt nicht gibt. \n"
      + "\n"
      + "<subsection titel=\"if Verzweigungen\">\n"
      + "Die <tt>if</tt>-Verzweigung ist ein Konstrukt, das erlaubt, einen bestimmten\n"
      + "Programmteil nur auszuführen, wenn eine bestimmte \n"
      + "Bedingung <tt>wahr</tt> ist. \n"
      + "\n"
      + "Die <tt>if</tt>-Verzweigung besteht aus dem Wort <tt>if</tt>, dann folgt in\n"
      + "runden Klammern Ausdruck, der einen Wahrheitswert berechnet, und in\n"
      + "geschweiften Klammern die Befehle, die ausgeführt werden sollen, wenn der\n"
      + "Warheitswert <em>wahr</em> entsprach:\n"
      + "\n"
      + "\n"
      + "<seite titel=\"Zusammengesetzte Befehler\">\n"
      + "<ul>\n"
      + "  <li><h2>Verzweigung: if-Anweisung</h2></li>\n"
      + "  <li><h2>Schleifen: while, do-while, for</h2></li>\n"
      + "  <li><h2>Fallunterscheidung: switch</h2></li>\n"
      + "</ul>\n"
      + "</seite>\n"
      + "\n"
      + "<code class=\"If1a\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "void f(int x){\n"
      + "  if (x>0) {\n"
      + "    printf(\"x ist groesser als 0\n\");\n"
      + "  }\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  f(42);\n"
      + "  f(-42);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Auf die geschweiften Klammern im if-Konstrukt, kann verzichtet werden, wenn\n"
      + "anschließend nur genau ein Befehl folgt. Das war im letzten Beispiel der\n"
      + "Fall. Es kann daher auch wie folgt geschrieben werden:  \n"
      + "\n"
      + "<code class=\"If1b\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "void f(int x){\n"
      + "  if (x>0) printf(\"x ist groesser als 0\n\");\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  f(42);\n"
      + "  f(-42);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Man sollte ein bißchen vorsichtig sein, wenn man auf die geschweiften Klammern\n"
      + "in einem if-Befehl verzichten möchten. Vielleicht fügt man irgendwann einen\n"
      + "weiteren Befehl im Rumpf des if-Befehls hinzu. Wenn man dann nicht die\n"
      + "Klammern hinzufügt, aber beide Befehle eingerückt hat, dann sieht es eventuell\n"
      + "so aus, als gehörten beide Befehle in den Rumpf des if-Befehls, tatsächlich\n"
      + "steht aber nur der erste von beiden im Rumpf des if-Befehls.\n"
      + "\n"
      + "\n"
      + "\n"
      + "Natürlich lassen sich in einer <tt>if</tt>-Verzweigung auch abhängig von einem\n"
      + "Wahrheitswert, Variablen verändern:\n"
      + "\n"
      + "<code class=\"If2\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int main(){\n"
      + "  int x=1;\n"
      + "  int y=0;\n"
      + "  if (x>0) {\n"
      + "    printf(\"x ist groesser als 0\n\");\n"
      + "    y=2*x;\n"
      + "  }\n"
      + "  printf(\"y = %i\n\",y);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "Optional kann eine <tt>if</tt>-Verzweigung noch \n"
      + "eine <tt>else</tt>-Klausel enthalten, hierin folgen die Befehle, die\n"
      + "auszuführen sind, wenn die Bedingung nicht wahr war:\n"
      + "\n"
      + "<code class=\"Else\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "void teste(int x){\n"
      + "  if (x>0) {\n"
      + "    printf(\"x ist groesser als 0\n\");\n"
      + "  }else {\n"
      + "    printf(\"x ist kleiner oder gleich 0\n\");\n"
      + "  }\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  teste(5);\n"
      + "  teste(0);\n"
      + "  teste(-5);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Mit der <tt>if</tt>-Verzwigung haben wir nun eine weitere Möglichkeit zu\n"
      + "kontrollieren, ob eine rekursive Funktion terminiert oder einen weiteren\n"
      + "rekursiven Aufruf vornimmt.  So läßt sich jetzt ziemlich einfach\n"
      + "programmieren, dass ein bestimmter Befehl mehrfach ausgeführt werden soll: \n"
      + "\n"
      + "<code class=\"WiederholtHallo1\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "void wiederhole(int x){\n"
      + "  printf(\"hallo\n\");\n"
      + "  if (x>0) {\n"
      + "    wiederhole(x-1);\n"
      + "  }\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  wiederhole(5);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Mit der <tt>else</tt>-Klausel lässt sich ebenso programmieren, was eine\n"
      + "rekursive Funktion im terminierenden Fall  noch machen soll.\n"
      + "\n"
      + "<code class=\"WiederholtHallo2\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "void wiederhole(int x){\n"
      + "  printf(\"hallo\n\");\n"
      + "  if (x>0) {\n"
      + "    wiederhole(x-1);\n"
      + "  }else{  \n"
      + "    printf(\"nun ist aber schluss\n\");\n"
      + "  }    \n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  wiederhole(5);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Die folgenden Version dieses Programms gibt zusätzlich jeweils noch aus, wie\n"
      + "oft die Rekursion noch durchlaufen wird. \n"
      + "\n"
      + "<code class=\"WiederholtHallo3\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "void wiederhole(int x){\n"
      + "  printf(\"hallo  %i\n\",x);\n"
      + "  if (x>0) {\n"
      + "    wiederhole(x-1);\n"
      + "  }\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  wiederhole(5);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Die vorherigen Programme bestanden alle aus einer rekursiven Prozedur. \n"
      + "Mit der  <tt>if</tt>-Verwzeigung lassen sich auch wunderbar rekursive\n"
      + "Funktionen schreiben, die ein bestimmtes Ergebnis berechnen. Folgendes\n"
      + "Programm summiert z.B.~die Zahlen von <tt>1</tt> bis zum \n"
      + "Parameter <tt>x</tt> auf.\n"
      + "\n"
      + "<code class=\"Summe1\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int summe(int x){\n"
      + "  int result=0;\n"
      + "  if (x<=0) {\n"
      + "    result=0;\n"
      + "  }else {\n"
      + "    int untersumme = summe(x-1); \n"
      + "    result=x+untersumme;\n"
      + "  }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"summe(5) = %i\n\",summe(5));\n"
      + "  printf(\"summe(0) = %i\n\",summe(0));\n"
      + "  printf(\"summe(100) = %i\n\",summe(100));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Um die Arbeitsweise einer solchen rekursiven Funktion besser zu verstehen,\n"
      + "können wir noch eine Ausgabe hinzufügen, die die jeweiligen Teilergebnisse auf\n"
      + "der Kommandozeile ausgibt:\n"
      + "\n"
      + "<code class=\"Summe2\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int summe(int x){\n"
      + "  int result=0;\n"
      + "\n"
      + "  if (x<=0) {\n"
      + "    result=0;\n"
      + "  }else {\n"
      + "    int untersumme = summe(x-1); \n"
      + "    result=x+untersumme;\n"
      + "    printf(\"  berechne summe(%i) = %i\n\",x,result);\n"
      + "  }\n"
      + "\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"summe(5) = %i\n\",summe(5));\n"
      + "  printf(\"summe(0) = %i\n\",summe(0));\n"
      + "  printf(\"summe(100) = %i\n\",summe(100));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Die Ausgabe zeigt schön, wie nacheinander für immer größer werdende Zahlen die\n"
      + "Summe errechnet wird und dann benutzt wird, um die Summe für die nächst höhere\n"
      + "Zahl zu berechnen:\n"
      + "\n"
      + "\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c> ./student/bin/Summe2\n"
      + "  berechne summe(1) = 1\n"
      + "  berechne summe(2) = 3\n"
      + "  berechne summe(3) = 6\n"
      + "  berechne summe(4) = 10\n"
      + "  berechne summe(5) = 15\n"
      + "summe(5) = 15...\n"
      + "]]></scode>\n"
      + "\n"
      + "<aufgabe blatt=\"3\">Das rekursive Programm zur Berechnung der \n"
      + "Summe <m>\\mbox{sum}(x)=\\sum_{i=1}^n i</m> läßt sich mit ein wenig Mathematik vollkommen ohne\n"
      + "Rekursion, <b>if</b>-Befehl oder Schleife schreiben. Hierzu benötigt man die\n"
      + "Summenformel aus der Mathematik. Suchen Sie diese aus dem Internet oder einer\n"
      + "Formelsmmlung und schreiben sie einen Einzeiler für <tt>int summe(int n);</tt>.\n"
      + "\n"
      + "<loesung>\n"
      + "Die anzuwendende Formel ist:<m>\\sum_{i=1}^n i=x*(x+1)/2</m>, also ist folgende\n"
      + "Funktion zu schreiben:\n"
      + "<code class=\"SimpleSum\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int sum(int x){ return x*(x+1)/2;}\n"
      + "int main(){\n"
      + "  printf(\"sum(1)=%i\n\",sum(1));\n"
      + "  printf(\"sum(2)=%i\n\",sum(2));\n"
      + "  printf(\"sum(3)=%i\n\",sum(3));\n"
      + "  printf(\"sum(4)=%i\n\",sum(4));\n"
      + "  printf(\"sum(5)=%i\n\",sum(5));\n"
      + "  printf(\"sum(6)=%i\n\",sum(6));\n"
      + "  printf(\"sum(7)=%i\n\",sum(7));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</loesung>\n"
      + "\n"
      + "\n"
      + "</aufgabe>\n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"unnötiges If\">\n"
      + "In Quelltext von Anfänger sieht man oft bei Funktionen, die einen\n"
      + "Wahrheitswert zurückgeben den if-Befehl in folgender Weise benutzt.\n"
      + "\n"
      + "<code class=\"NotLikeThis\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int f(int x){\n"
      + "  if (x>0) return 1;\n"
      + "  else return 0;\n"
      + "}\n"
      + "int main(){\n"
      + "  printf(\"%i\n\",f(42));\n"
      + "  return 0;\n"
      + "} \n"
      + "]]></code>\n"
      + "\n"
      + "In der Funktion <tt>f</tt> wird geprüft, ob <tt>x&gt;0</tt> ist. Wenn \n"
      + "das Ergebnis davon <em>wahr</em> ist, also 1, dann \n"
      + "soll <em>wahr</em> (also 1) zurückgegeben werden. \n"
      + "Wenn <tt>x&gt;0</tt>~<em>falsch</em> (also 0) ist, dann \n"
      + "soll <em>falsch</em> (also 0) zurückgegeben werden. Dann kann man aber gleich\n"
      + "auf die if-Bedingung verzichten und direkt <tt>x&gt;0</tt> zurückgeben. Das\n"
      + "Programm ist besser zu schreiben als:\n"
      + "\n"
      + "<code class=\"LikeThis\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int f(int x){\n"
      + "  return x>0;\n"
      + "}\n"
      + "int main(){\n"
      + "  printf(\"%i\n\",f(42));\n"
      + "  return 0;\n"
      + "} \n"
      + "]]></code>\n"
      + "</subsubsection>\n"
      + "\n"
      + "<aufgabe blatt=\"3\">Schreiben Sie das\n"
      + "Programm <tt>fakultaet</tt> so um, dass Sie den \n"
      + "Bedingungsoperator durch einen <tt>if</tt>-Befehl ausdrücken.\n"
      + "\n"
      + "\n"
      + "<loesung><code class=\"Fakultaet3\" lang=\"c\" main=\"main\" commandchars=\"_$^\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int fac(int i){\n"
      + "  if (i==0) return 1;\n"
      + "  return i*fac(i-1);\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"fac(5) = %i\n\",fac(5));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "</loesung>\n"
      + "</aufgabe>\n"
      + "\n"
      + "<seite titel=\"Verzweigung\">\n"
      + "<ul>\n"
      + "  <li><h2>if-Anweisung  kann mit oder ohne else-Klausel stehen</h2></li>\n"
      + "  <li><h2>hat anders als Bedingungsoperator keinen Wert</h2></li>\n"
      + "  <li><h2>statt: <tt>if (bed) {return true;}else {return false;}</tt></h2></li>\n"
      + "  <li><h2>besser: <tt>return bed;</tt></h2></li>\n"
      + "</ul>\n"
      + "\n"
      + "</seite>\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Schleifen\">\n"
      + "Bisher kennen wir nur den Trick der Rekursion, um einen Programmteil mehrfach\n"
      + "durchlaufen zu lassen. Die Terminierung der Rekursion haben wir dabei durch\n"
      + "die <tt>if</tt>-Verzweigung oder durch den Bedingungsoperator gesteuert. Es\n"
      + "gibt tatsächlich Programmiersprachen, in denen dieses der einzige Weg ist,\n"
      + "bestimmte Programmteile wiederholt zu durchlaufen. In den meisten\n"
      + "Programmiersprachen insbesondere in den sogenannten imperativen Sprachen, wozu\n"
      + "C zu rechnen ist, gibt es eingebaute besondere zusammengesetzte Befehle, mit\n"
      + "denen ohne eine Rekursion ausgedrückt werden kann, dass bestimmte\n"
      + "Programmteile mehrfach auszuführen sind. Diese Befehle werden als Schleifen\n"
      + "bezeichnet. Das Prinzip der Schleifen wird im Gegensatz zur Rekursion als\n"
      + "Iteration bezeichnet. In C gibt es drei verschiedene Schleifenbefehle.\n"
      + "\n"
      + "<subsubsection titel=\"while-Schleife\">\n"
      + "Die wahrscheinlich gebräuchlichste Schleife ist \n"
      + "die <tt>while</tt>-Schleife. Sie besteht aus dem Wort <tt>while</tt>, dem in\n"
      + "runden Klammern ein Ausdruck folgt, der einen Wahrheitswert berechnet. Dieser\n"
      + "Ausdruck wird als Schleifenbedingung bezeichnet.  \n"
      + "Schließlich folgt in geschweiften Klammern eine Folge von Befehlen, der\n"
      + "sogenannte Rumpf der Schleife. \n"
      + "\n"
      + "In folgendem ersten Beispiel ist die Schleifenbedingung rot und der\n"
      + "Schleifenrumpf blau gedruckt:\n"
      + "\n"
      + "<code class=\"CountDownWhile\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "int main(){\n"
      + "  int x=10;\n"
      + "  while <redv>(x&gt;0)</redv>{\n"
      + "    <bluev>printf(\"x = %i\n\",x)</bluev>;\n"
      + "    <bluev>x=x-1</bluev>;\n"
      + "  <bluev>}</bluev>\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Für die Ausführung einer <tt>while</tt> Schleife wird zunächst die Bedingung\n"
      + "ausgerechnet. Wenn diese nicht zu <em>wahr</em> ausgewertet wird, dann\n"
      + "passiert gar nichts weiter. Wird die Bedingung allerdings \n"
      + "zu <em>wahr</em> ausgewertet, so werden anschließend die Befehle des Rumpfes\n"
      + "ausgeführt. Anschließend geht es wieder von vorne los. Es wird ein weiteres\n"
      + "Mal das Ergebnis der Bedingung ausgerechnet und abhängig davon eine weiteres\n"
      + "der Rumpf der Schleife und immer so weiter.\n"
      + "\n"
      + "Ebenso wie bei einer Rekursion kann es auch bei einer Iteration dazu kommen,\n"
      + "dass das Programm nicht terminiert. Dieses ist der Fall, wenn die\n"
      + "Schleifenbedingung immer zu <em>wahr</em> ausgewertet wird, wie im folgenden Beispiel: \n"
      + "\n"
      + "<code class=\"NonterminatingIteration\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  while (1==1){\n"
      + "    printf(\"im Schleifenrumpf\n\");\n"
      + "  }\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Die Bedingung <tt>1==1</tt> ist selbstverständlich immer <em>wahr</em>, und\n"
      + "damit wird immer wieder der Rumpf der Schleife abgearbeitet. Damit eine\n"
      + "Schleife terminiert, muß der Rumpf dafür sorgen, dass darin Variablen so\n"
      + "verändert werden, dass irgendwann die Schleifenbedingung nicht mehr \n"
      + "zu <em>wahr</em> ausgewertet wird. Hierzu muss eine eine Variable geben, die\n"
      + "zur Auswertung der Schleifenbedingung benutzt wird und die ebenso im\n"
      + "Schleifenrumpf benutzt wird. In unserem ersten Beispiel war dieses die\n"
      + "Variable <tt>x</tt>. Es wurde darin so lange iteriert, bis diese Variable\n"
      + "nicht mehr positiv war. Im Schleifenrumpf wurde die Variable \n"
      + "um <tt>1</tt> verringert. Damit hat sie nach endlich vielen Durchgängen keinen\n"
      + "positiven Wert mit und die Iteration terminiert.\n"
      + "\n"
      + "Insofern sind Iterationen nur ein spezielles syntaktisches Konstrukt, um\n"
      + "Rekursionen auszudrücken. Auch in einer Rekursion gibt es eine Variable, von\n"
      + "der abhängt, ob ein weiterer rekursiver Durchlauf zu machen ist. Diese\n"
      + "Variable ist in der Rekursion ein Parameter der Funktion. Der Wert des\n"
      + "Parameters muss sich von rekusriven Durchlauf so verändern, dass die\n"
      + "Terminierngsbedingung einer Rekursion irgendwann erreicht wird.\n"
      + "\n"
      + "Somit läßt sich obige erstes Schleifenprogramm als Rekursion schreiben. Die\n"
      + "Schleifenbedingung wandert hierbei in eine <tt>if</tt>-Verzweigung. Der\n"
      + "Schleifenrumpf wird der Rumpf der <tt>if</tt>-Verzweigung. Statt die \n"
      + "Variable <tt>x</tt> zu verringern, wird ein rekursiver Aufruf mit einem \n"
      + "um <tt>1</tt> verringerten Parameter durchgeführt:\n"
      + "\n"
      + "<code class=\"CountDownRecursive\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "void whileErsatz(int x){\n"
      + "  if <redv>(x&gt;0)</redv>{\n"
      + "    <bluev>printf(\"x = %i\n\",x)</bluev>;\n"
      + "    <bluev>whileErsatz(x-1)</bluev>;\n"
      + "  <bluev>}</bluev>\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  whileErsatz(10);\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "\n"
      + "Schleifen haben zumeist eine Variable, die steuert, wie oft die Schleife zu\n"
      + "durchlaufen ist. Man spricht dabei auch von der Laufvariablen. \n"
      + "Zusätzlich kann es noch weitere Variablen geben, in denen\n"
      + "z.B.~nach und nach ein zu berechnendes Ergebnis gespeichert wird. \n"
      + "\n"
      + "Im folgenden Beispiel ist  <tt>x</tt> die Laufvariable und \n"
      + "in <tt>y</tt> wird das jeweilige Zwischenergebnis der eigentlichen \n"
      + "Berechnnung gespeichert.\n"
      + "\n"
      + "<code class=\"SummeWhile1\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  int x=10;\n"
      + "  int y=0;\n"
      + "  while (x>0){\n"
      + "    printf(\"x = %i y = %i\n\",x,y);\n"
      + "    y=y+x;\n"
      + "    x=x-1;\n"
      + "  }\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Machen wir uns einmal die Mühe, diese Schleife Stück für Stück von Hand\n"
      + "nachzuvollziehen. Hierzu notieren wir einfach die Werte, die nach und nach die\n"
      + "beiden Variablen <tt>x</tt> und <tt>y</tt> erhalten.\n"
      + "\n"
      + "<table layout=\"|l|l|l|l|l|l|l|l|l|l|l|l|\"><hline/>\n"
      + "<zeile><zelle><b>x</b></zelle><zelle>10</zelle><zelle>9</zelle><zelle>8</zelle><zelle>7</zelle><zelle>6</zelle><zelle>5</zelle><zelle>4</zelle><zelle>3</zelle><zelle>2</zelle><zelle>1</zelle><zelle>0</zelle></zeile><hline />\n"
      + "<zeile><zelle><b>y</b></zelle><zelle>0</zelle><zelle>10</zelle><zelle>19</zelle><zelle>27</zelle><zelle>34</zelle><zelle>40</zelle><zelle>45</zelle><zelle>49</zelle><zelle>52</zelle><zelle>54</zelle><zelle>55</zelle>\n"
      + "</zeile><hline />\n"
      + "</table>\n"
      + "\n"
      + "Die Ausgabe des Programms macht auch die Veränderung der beiden Variablen über\n"
      + "die Zeit deutlich:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c> tutor/bin/SummeWhile1\n"
      + "x = 10 y = 0\n"
      + "x = 9 y = 10\n"
      + "x = 8 y = 19\n"
      + "x = 7 y = 27\n"
      + "x = 6 y = 34\n"
      + "x = 5 y = 40\n"
      + "x = 4 y = 45\n"
      + "x = 3 y = 49\n"
      + "x = 2 y = 52\n"
      + "x = 1 y = 54\n"
      + "sep@pc305-3:~/fh/c>]]></scode>\n"
      + "\n"
      + "Bei der Wahl der Variablennamen sollten man versuchen schon deutlich zu\n"
      + "machen, welche Variable die Laufvariable für die Bedingung ist und welche\n"
      + "Ergebnisse der eigentlichen Anwendungslogik ist. In C werden häufig\n"
      + "Variablennamen <tt>i, j, k</tt> für Laufvariablen benutzt. Für die Variablen\n"
      + "der Anwendungslogik sollte man besser längere und sprechende Namen\n"
      + "nehmen. Insbesondere bietet sich der Name <tt>result</tt> für Variablen an, in\n"
      + "denen nach und nach das Ergebnis berechnet wird.\n"
      + "\n"
      + "So ließe sich eine Funktion zur Berechnung der Summe, wie folgt schreiben:\n"
      + "\n"
      + "<code class=\"SummeWhile2\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int summe(int x){\n"
      + "  int result=0;\n"
      + "  int i = x;\n"
      + "  while (i>0){\n"
      + "    result=result+i;\n"
      + "    i=i-1;\n"
      + "  }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"summe(5) = %i\n\",summe(5));\n"
      + "  printf(\"summe(0) = %i\n\",summe(0));\n"
      + "  printf(\"summe(100) = %i\n\",summe(100));\n"
      + "\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "<aufgabe blatt=\"3\">Schreiben Sie die Fakultät jetzt, indem Sie die Funktion\n"
      + "nicht über eine Rekursion, sondern über \n"
      + "eine <tt>while</tt>-Schleife realisieren.\n"
      + "\n"
      + "\n"
      + "<loesung><code lang=\"c\" class=\"FakIter\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int fak(int x){\n"
      + "  int result=1;\n"
      + "  while (x>0){\n"
      + "    result=result*x;\n"
      + "    x=x-1;\n"
      + "  }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"fak(0): %i\n\",fak(0));\n"
      + "  printf(\"fak(1): %i\n\",fak(1));\n"
      + "  printf(\"fak(2): %i\n\",fak(2));\n"
      + "  printf(\"fak(3): %i\n\",fak(3));\n"
      + "  printf(\"fak(4): %i\n\",fak(4));\n"
      + "  printf(\"fak(5): %i\n\",fak(5));\n"
      + "  return 0;\n"
      + "}\n"
      + "]]></code></loesung>\n"
      + "</aufgabe>\n"
      + "\n"
      + "<aufgabe blatt=\"3\">\n"
      + "Sie sollen eine Funktion zum Potenzieren realisieren:<br/>\n"
      + "<tt>int potenz(int x,int y)</tt><br/>\n"
      + "Die Funktion soll $x$ hoch $y$ rechnen, also: <m>\rm{potenz}(x,y)=x^y</m>. \n"
      + "Implementieren Sie diese Funktion einmal rekursiv und einmal mit Hilfe \n"
      + "einer <tt>while</tt>-Schleife und einmal mit Hilfe einer <tt>for</tt>-Schleife.\n"
      + "\n"
      + "\n"
      + "<loesung>\n"
      + "<code class=\"Potenz\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int potenz1(int x,int y){\n"
      + "  if (y==0) return 1;\n"
      + "  return x*potenz1(x,y-1);\n"
      + "}\n"
      + "\n"
      + "int potenz2(int x,int y){\n"
      + "  int result=1;\n"
      + "  while (y>0){\n"
      + "    result=result*x;\n"
      + "    y=y-1;\n"
      + "  }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "int potenz3(int x,int y){\n"
      + "  int result=1;\n"
      + "  for (;y>0;y--){\n"
      + "    result=result*x;\n"
      + "  }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"potenz1(3,9): %i\n\",potenz1(3,9));\n"
      + "  printf(\"potenz2(3,9): %i\n\",potenz2(3,9));\n"
      + "  printf(\"potenz2(3,9): %i\n\",potenz3(3,9));\n"
      + "  return 0;\n"
      + "}\n"
      + "]]></code></loesung>\n"
      + "</aufgabe>\n"
      + "\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"for-Schleifen\">\n"
      + "Im letzten Abschnitt haben wir gesehen, dass im Rumpf \n"
      + "der <tt>while</tt>-Schleife zwei Dinge zu geschehen haben:\n"
      + "<itemize>\n"
      + "<item>die Laufvariable muss so verändert werden, um irgendwann die\n"
      + "Terminierung der Schleife zu gewährleisten.</item>\n"
      + "<item>die eigentliche Berechnung für die Anwendungslogik ist \n"
      + "durchzuführen.   </item>\n"
      + "</itemize>\n"
      + "\n"
      + "Es gibt also im Rumpf der Schleife Code, zum Steuern der Anzahl der\n"
      + "Schleifendurchläufe und Code zum Berechnen des Ergebnisses. \n"
      + "Aus der Überlegung heraus, diese zwei Codeteile möglichst zu trennen, gibt es\n"
      + "in C (und vielen Sprachen die darauf aufbauen, wie z.B.~auch Java) eine\n"
      + "besondere Schleife, die <tt>for</tt>-Schleife. Auch \n"
      + "die <tt>for</tt>-Schleife hat einen Schleifenrumpf, allerdings sollte in ihrem\n"
      + "Schleifenrumpf kein Code stehen, der steuert, wie oft die Schleife durchlaufen\n"
      + "wird. Dieser Code soll möglichst komplett im sogenannten Schleifenkopf stehen\n"
      + "Der Schleifenkopf ist in runden Klammern eingeschlossen und enthält drei durch\n"
      + "Semikolon getrennte Teile:\n"
      + "\n"
      + "<itemize>\n"
      + "<item>die Initialisierung der Laufvariablen</item>\n"
      + "<item>die Schleifenbedingung</item>\n"
      + "<item>die Veränderung der Schleifenvariable pro Schleifendurchgang</item>\n"
      + "</itemize>\n"
      + "\n"
      + "\n"
      + "Im folgenden Beispiel sind die drei Teile der Schleifensteuerung farblich\n"
      + "markiert. \n"
      + "\n"
      + "<code class=\"CountDownFor\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "int main(){\n"
      + "  int i;\n"
      + "  for (<redv>i=10</redv>;<bluev>i&gt;0</bluev>;<greenv>i=i-1</greenv>){\n"
      + "    printf(\"i = %i\n\",i);\n"
      + "  }\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "In der Ausführung der <tt>for</tt>-Schleife wird als erstes (und dann auch\n"
      + "nicht mehr) die Initailisierung der Laufvariablen vorgenommen. Der rote Code im\n"
      + "obigen Beispiel. Nun wird die Schleifenbedingung geprüft. Ist diese \n"
      + "nicht  <em>wahr</em>, so passiert nichts weiter. Ansonsten wird jetzt der\n"
      + "Schleifenrumpf ausgeführt. Und dann erst der Code zur Veränderung der\n"
      + "Schleifenvariablen. Im Beispiel oben mit grün markiert. Nun geht es wieder mit\n"
      + "der Prüfung der Schleifenbedingung weiter.\n"
      + "\n"
      + "Vielleicht läßt sich am einfachsten die Abarbeitung \n"
      + "der <tt>for</tt>-Schleife nachvollziehen, wenn man sie in \n"
      + "eine äquivalente <tt>while</tt>-Schleife umschreibt. Wir benutzen die gleichen\n"
      + "farblichen Markierungen, wie in der <tt>for</tt>-Schleife:\n"
      + "\n"
      + "<code class=\"CountDownWhile2\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "int main(){\n"
      + "  int i;\n"
      + "  <redv>i=10</redv>;\n"
      + "  while (<bluev>i&gt;0</bluev>){\n"
      + "    printf(\"i = %i\n\",i);\n"
      + "    <greenv>i=i-1</greenv>;\n"
      + "  }\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Man sieht gut, wie das Weiterschalten der Schleifenvariablen am Ende des\n"
      + "Schleifenrumpfes geschieht, und die Initialisierung der Schleifenvariablen nur\n"
      + "einmal vor der eigentlichen Schleife.\n"
      + "\n"
      + "In neueren Programmiersprachen, sowie C++ und Java ist es möglich, die\n"
      + "Laufvariable einer <tt>for</tt>-Schleife nur lokal direkt im Schleifenkopf zu\n"
      + "deklarieren.  Damit kann die Schleifenvariable nicht außerhalb der Schleife\n"
      + "für andere Zwecke mißbraucht oder für eine weitere Schleife benutzt\n"
      + "werden. Dieses entspricht der Idee, Variablen so lokal wie nur möglich zu\n"
      + "deklarieren. Damit sähe das Programm wie folgt aus: \n"
      + "\n"
      + "<code class=\"CountDownForNonC\" compileoptions=\" echo -std=c99 \"\n"
      + " lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "int main(){\n"
      + "  for (int i=10;i&gt;0;i=i-1){\n"
      + "    printf(\"i = %i\n\",i);\n"
      + "  }\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Leider entspricht das nicht dem Standard  der Programmiersprache C wie sie\n"
      + "unser Compiler benutzt und unser\n"
      + "Compiler weist es auch mit einem Fehler zurück:\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> gcc src/CountDownForNonC.c\n"
      + "src/CountDownFor2.c: In function `main':\n"
      + "src/CountDownFor2.c:3: error: `for' loop initial declaration used outside C99 mode\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Wollen wir diese Art der Schleifenvariable benutzen, so müssen wir unseren\n"
      + "Compiler auf der Kommandozeile beim Aufruf darauf hinweisen, dass wir nach \n"
      + "dem C99 Standard programmieren wollen, dann verschwindet der Fehler:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> gcc -std=c99 src/CountDownFor2.c\n"
      + "]]></scode>\n"
      + "\n"
      + "Ansonsten müssen wir Wohl oder Übel die Schleifenvariable vor \n"
      + "der <tt>for</tt>-Schleife deklarieren, werden später in C++ und Java es aber\n"
      + "erst im Kopf der Schleife machen, versprochen.\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "Bisher haben wir im Beispiel für die <tt>for</tt>-Schleife noch keine\n"
      + "Berechnungen für ein Ergebnis vorgenommen, sondern nur als Seiteneffekt etwas\n"
      + "auf der Kommandozeile ausgegeben. Nach all dem Vorausgesagten ist deutlich, wie\n"
      + "sich das Programm zur Summenberechnung mit einer <tt>for</tt>-Schleife\n"
      + "präsentiert:\n"
      + "\n"
      + "<code class=\"SummeFor\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int summe(int x){\n"
      + "  int result=0;\n"
      + "  int z;\n"
      + "  for (z=1;x>=z;z=z+1){\n"
      + "    result=result+z;\n"
      + "  }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"summe(5) = %i\n\",summe(5));\n"
      + "  printf(\"summe(0) = %i\n\",summe(0));\n"
      + "  printf(\"summe(100) = %i\n\",summe(100));\n"
      + "\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "Interessanter Weise können von den drei Komponenten des Schleifenkkopfes\n"
      + "durchaus auch welche leer sein. Dann steht da einfach nichts. Und \n"
      + "eine <tt>for</tt>-Schleife mit leerer Initialisierung der Schleifenvariablen\n"
      + "und leerer Weiterschaltung ist nichts anderes mehr als \n"
      + "eine <tt>while</tt>-Schleife.\n"
      + "\n"
      + "<code class=\"PseudoWhile\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  int x=10;\n"
      + "  for (;x>0;){\n"
      + "    printf(\"x = %i\n\",x);\n"
      + "    x=x-1;\n"
      + "  }\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"do-while-Schleifen\">\n"
      + "Die <tt>while</tt>-Schleife (und als ihr Spezialfall auch \n"
      + "die <tt>for</tt>-Schleife) prüfen beide ersteinmal eine Schleifenbedingung,\n"
      + "bevor sie sich den Schleifenrumpf anschauen. Diese Art von Schleife wird daher\n"
      + "auch als vorgeprüfte Schleife bezeichnet. Bevor der Schleifenrrumpf überhaupt\n"
      + "in Betracht gezogen wird, wird ersteinmal die Bedingung geprüft. Ist diese\n"
      + "anfangs nicht <em>wahr</em>, so wird der Rumpf kein einiziges Mal ausgeführt. \n"
      + "\n"
      + "Im Gegensatz dazu gibt es auch noch eine besondere Schleife, die als\n"
      + "nachgeprüft bezeichnet wird, die <tt>do-while</tt>-Schleife. Sie beginnt mit\n"
      + "dem Wort <tt>do</tt>, dann folgt der Schleifenrumpf und nach dem\n"
      + "Schleifenrumpf erst das Wort <tt>while</tt> mit der Schleifenbedingung.\n"
      + "Bei der nachgeprüften Schleife, wird zunächst einmal der Schleifenrumpf einmal\n"
      + "garantiert ausgeführt. Anschließend wird mit der Bedingung geprüft, ob ein\n"
      + "weiterer Schleifendurchlauf zu bewerkstelligen ist.\n"
      + "\n"
      + "\n"
      + "<code class=\"DoWhile\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  int x=10;\n"
      + "  do {\n"
      + "    printf(\"x = %i\n\",x);\n"
      + "    x=x-1;\n"
      + "  } while (x>0);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Viel Programmierer vernachlässigen die nachgeprüfte Schleife ein wenig und man\n"
      + "sieht sie doch wesentlich seltener als die vorgeprüften Schleifen. Aber es\n"
      + "soll auch wahre Fans der nachgeprüften Schleifen geben.\n"
      + "\n"
      + "\n"
      + "Eine typische Anwendung für die nachgerprüfte Schleife ist das Erfragen von\n"
      + "Benutzereingaben. Hierzu gibt es eine quasi inverse Funktion \n"
      + "zu <tt>printf</tt>, nämlich <tt>scanf</tt>, die nicht Ausgaben tätigt, sondern\n"
      + "Eingaben abfragt. Es wird typischer Weise in einer vorgeprüften Schleife so\n"
      + "lange nach einer Eingabe gefragt, bis eine verarbeitbare Zahl eingegeben\n"
      + "wurde. \n"
      + "\n"
      + "<code class=\"input\" lang=\"c\" main=\"main\" commandchars=\"_$^\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int f(int n){return n==0?1:n*f(n-1);}\n"
      + "int main(){\n"
      + "  int x;\n"
      + "  do{\n"
      + "    printf(\"mit welcher Zahl soll gerechnet werden?\n\");\n"
      + "    scanf(\"%i\",&x);\n"
      + "  }while (x<0);\n"
      + "  printf(\"f(x) = %i\n\",f(x));\n"
      + "  return 0;\n"
      + "}\n"
      + "]]></code>\n"
      + "\n"
      + "\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Schleifen in Schleifen\">\n"
      + "Innerhalb des Schleifenrumpfs können beliebige Befehle stehen. Eine Schleife\n"
      + "ist auch nur ein Befehl, demnach kann in einem Schleifenrumpf wieder eine\n"
      + "Schleife stehen. Um eine solche verschachtelte Schleife zu verstehen, braucht\n"
      + "man kein neues Wissen, sondern kann es aus dem Wissen über Schleifen\n"
      + "ableiten. Ein zweidimensionaler Raum wird aufgebaut. Die äußere Schleife\n"
      + "entspricht den Wertebereich der ersten, die innere dem Wertebereich der\n"
      + "zweiten Dimension. \n"
      + "\n"
      + "Dieses läßt sich an der Ausgabe des folgenden Programms gut ersehen:\n"
      + "\n"
      + "\n"
      + "<code class=\"ZweiDimensionaleSchleife\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  int x;\n"
      + "  for (x=0;x<10;x=x+1){\n"
      + "    int y;\n"
      + "    for (y=0;y<20;y=y+1){\n"
      + "      printf(\"(x,y) = (%i,%i)\n\",x,y);\n"
      + "    }\n"
      + "  }\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Zweidimensionale Räume begegnen einem bei der Programmierung natürlich\n"
      + "permanent, bei Bildern und Grafiken, aber auch Spielbrettern. In diesen Fällen\n"
      + "wird man immer zwei inneinander verschachtelte Schleifen benötigen.\n"
      + "\n"
      + "<aufgabe  blatt=\"3\"><b>(1 Punkt)</b> Schreiben Sie ein C \n"
      + "Programm, das die folgenden Ausgabe auf der\n"
      + "Kommandozeile hat:\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c> ./a.out\n"
      + ".XXXXXXXXXXXXXXXXXXX\n"
      + "X.XXXXXXXXXXXXXXXXXX\n"
      + "XX.XXXXXXXXXXXXXXXXX\n"
      + "XXX.XXXXXXXXXXXXXXXX\n"
      + "XXXX.XXXXXXXXXXXXXXX\n"
      + "XXXXX.XXXXXXXXXXXXXX\n"
      + "XXXXXX.XXXXXXXXXXXXX\n"
      + "XXXXXXX.XXXXXXXXXXXX\n"
      + "XXXXXXXX.XXXXXXXXXXX\n"
      + "XXXXXXXXX.XXXXXXXXXX\n"
      + "XXXXXXXXXX.XXXXXXXXX\n"
      + "XXXXXXXXXXX.XXXXXXXX\n"
      + "XXXXXXXXXXXX.XXXXXXX\n"
      + "XXXXXXXXXXXXX.XXXXXX\n"
      + "XXXXXXXXXXXXXX.XXXXX\n"
      + "XXXXXXXXXXXXXXX.XXXX\n"
      + "XXXXXXXXXXXXXXXX.XXX\n"
      + "XXXXXXXXXXXXXXXXX.XX\n"
      + "XXXXXXXXXXXXXXXXXX.X\n"
      + "XXXXXXXXXXXXXXXXXXX.\n"
      + "sep@pc305-3:~/fh/c>]]></scode>\n"
      + "\n"
      + "<seite titel=\"Schleifen\">\n"
      + "<ul>\n"
      + "  <li><h2>Iteration (im Gegensatz zur Rekursion)</h2></li>\n"
      + "  <li><h2>bestehen aus Bedingung und Rumpf</h2></li>\n"
      + "  <li><h2>vorgeprüft: Schleifenrumpf wird eventuell nie ausgeführt</h2></li>\n"
      + "  <li><h2>nachgeprüft: mindestens ein Schleifendurchlauf garantiert</h2></li>\n"
      + "  <li><h2>Scheifen brauchen i.d.R. eine Schleifen- (Lauf-)Variable</h2></li>\n"
      + "  <li><h2>Schleifenvariable wird im Rumpf verändert, so dass Bedingung \n"
      + "          irgendwann <tt>false</tt></h2></li>\n"
      + "  <li><h2>Achtung: Schleifen können nicht terminieren</h2></li>\n"
      + "</ul>\n"
      + "</seite>\n"
      + "\n"
      + "\n"
      + "\n"
      + "<seite titel=\"For-Schleifen\">\n"
      + "<ul>\n"
      + "  <li><h2>bündelt die Schleifensteuerung im Kopf</h2></li>\n"
      + "  <li><h2>Drei Teile zur Scheifensteuerung:</h2></li>\n"
      + "  <li><ol>\n"
      + "        <li><h2>Initialisierung der Schleifenvariablen</h2></li>\n"
      + "        <li><h2>Bedingungstest</h2></li>\n"
      + "        <li><h2>Weiterschalten der Schleifenvariablen</h2></li>\n"
      + "      </ol>\n"
      + "  </li>\n"
      + "  <li><h2>wenn Initialisierung in Weiterschalten leer, wie while-Schleife </h2></li>\n"
      + "</ul>\n"
      + "</seite>\n"
      + "\n"
      + "\n"
      + "\n"
      + "<loesung><code class=\"Diagonal\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "void printDiagonale(){\n"
      + "  int x;\n"
      + "  int y;\n"
      + "  for (x=0;x<20;x++){\n"
      + "    for (y=0;y<20;y++){\n"
      + "      if (x==y){\n"
      + "        printf(\".\");\n"
      + "      }else printf(\"x\");\n"
      + "    }\n"
      + "    printf(\"\n\");\n"
      + "  }\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printDiagonale();\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</loesung>\n"
      + "\n"
      + "</aufgabe>\n"
      + "\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Schleifen irregulär abbrechen\">\n"
      + "Wie oft eine Schleife durchlaufen wird, hängt von der Schleifenbedingung ab,\n"
      + "aber leider nicht nur. Innerhalb einer Schleife kann der \n"
      + "Befehl <tt>break</tt> benutzt werden, mit dem auch das Durchlaufen einer\n"
      + "Schleife gesteuert werden kann. So kann man sogar eine while-Schleife\n"
      + "schreiben, deren Bedingung immer <em>wahr</em> ist, die aber trotzdem\n"
      + "terminiert.  Der Befehl <tt>break</tt> kann beliebig innerhalb einer Schleife\n"
      + "stehen, und führt bei seiner Ausführung zum sofortigen Abbruch der Schleife:\n"
      + "\n"
      + "<code class=\"CountDownWhileBreak\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "int main(){\n"
      + "  int x=10;\n"
      + "  while (0==0){\n"
      + "    printf(\"x = %i\n\",x);\n"
      + "    x=x-1;\n"
      + "    <bluev>if (x&lt;=0) break</bluev>;\n"
      + "  }\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Der Befehl <tt>break</tt> ist auch mit Vorsicht zu benutzen. Irgendwo im\n"
      + "Schleifenrumpf kann er verstecken, dass die Schleife, unabhängig von der\n"
      + "Schleifenbedingung, doch verlassen werden soll. Man umgeht damit die\n"
      + "Schleifenbedingung. Die Schleifenbedingung suggeriert, dass sie steuert, wie\n"
      + "oft die Schleife durchlaufen wird, und irgendwo im Rumpf wird etwas ganz\n"
      + "anderes gemacht.\n"
      + "\n"
      + "Ein akzeptabler Einsatz des Befehls <tt>break</tt> ist in echten Fehler- oder\n"
      + "Susnahmesituationen. Normaler Weise steuert der Schleifenkopf, wie oft die\n"
      + "Schleife durchlaufen wird, nur in besonderen Spezialfällen bricht die Schleife\n"
      + "dann auch entgegen den Bedingungen im Schleifenkopf ab.\n"
      + "</subsubsection>\n";

    String skript3 = 
        "\n"
      + "<subsubsection titel=\"Schleifenrumpf temporär abbrechen \">\n"
      + "Ein noch brutalerer Befehl, der es erlaubt zu steuern, wie die Schleife\n"
      + "durchlaufen wird, ist der Befehl <tt>continue</tt>. Er sorgt dafür, dass der\n"
      + "Schleifenrumpf sofort verlassen wird, alle nachfolgenden Befehle des Rumpf\n"
      + "werden nicht mehr ausgeführt. Die Schleife selbst wird aber nicht verlassen,\n"
      + "sondern es wird mit der Schleifensteuerung weiter geprüft, ob der Rumpf ein\n"
      + "weiteres Mal auszuführen ist.\n"
      + "\n"
      + "Ein kleines Beispiel für den Befehl <tt>continue</tt>:\n"
      + "<code class=\"Continue\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "int main(){\n"
      + "  int x=10;\n"
      + "  while (x&gt;=0){\n"
      + "    printf(\"x = %i\n\",x);\n"
      + "    x=x-1; \n"
      + "\n"
      + "    if (x%2!=0){\n"
      + "      continue;\n"
      + "    }\n"
      + "    printf(\"x ist eine ungerade Zahl\n\");\n"
      + "  }\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "\n"
      + "Der Nutzen des Befehls <tt>continue</tt> ist recht fraglich. Er macht\n"
      + "Schleifen noch einmal komplexer zu verstehen. In meiner bisherigen Laufbahn als\n"
      + "Programmierer habe ich ihn bisher noch kein einziges Mal benutzt, obwohl er es\n"
      + "in Sprachen wie z.B.~Java als altes C-Erbe geschafft hat.\n"
      + "</subsubsection>\n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"Schleifen und return\">\n"
      + "Es gibt noch eine weitere Möglichkeit, eine Schleife zu verlassen; und dafür\n"
      + "kann die Schleife gar nicht einmal etwas. Es handelt sich dabei nämlich nicht\n"
      + "um einen schleifenspezifischen Befehl, sondern um den \n"
      + "Befehl <tt>return</tt>, mit dem eine Funktion verlassen wird. Bisher haben wir\n"
      + "jedes Mal den Befehl <tt>return</tt> als letzten Befehl des Rumpfes einer\n"
      + "Funktion gehabt. Mit ihm wurde die Funktion verlassen und mit ihm wurde das\n"
      + "Funktionsergebnis festgelegt. Der Befehl <tt>return</tt>  kann aber\n"
      + "tatsächlich an \n"
      + "beliebiger Stelle eines Funktionsrumpfes stehen. Dann sorgt er auch dafür,\n"
      + "dass die Berechnung des Funktionswertes beendet wird und kein weiterer Code im\n"
      + "Funktionsrumpfs ausgeführt wird:\n"
      + "\n"
      + "<code class=\"WhileReturn\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "int f(int x){\n"
      + "  int i = x;\n"
      + "  int result = 0;\n"
      + "  while (0==0){\n"
      + "    if (i==0) <redv>return result</redv>;\n"
      + "    result= result+i;\n"
      + "    i=i-1; \n"
      + "  }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"f(10) = %i\n\",f(10));\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Man sieht, dass es schon mit den wenigen Konstrukten, die wir bisher\n"
      + "kennengelernt haben, doch möglich ist, Programme zu schreiben, die in ihrer\n"
      + "Ablaufsteuerung recht komplex sind. Die Programmiersprache C gibt dem\n"
      + "Programmierer sehr viel Freiheiten, sich auszudrücken. Leider damit auch sehr\n"
      + "viel Möglichkeiten sich vertrackt und kompliziert auszudrücken. Daraus machen\n"
      + "sich manche Programmierer gar einen Sport und es gibt den \n"
      + "sogenannten <em>obfuscated C contest</em>, in dem es darum geht, möglichst\n"
      + "vertrackte und unverständliche Programme zu schreiben.\n"
      + "\n"
      + "Normaler Weise möchte man aber verstanden werden und sollte sich mit einfachen\n"
      + "Worten und kurzen Sätzen ausdrücken. Das gilt auch in der Programmierung. Auf\n"
      + "undurchsichtige Schleifensteuerung sollte möglichst verzichtet werden.\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "<seite titel=\"irreguläres Abbrechen von Schleifen\">\n"
      + "<ul>\n"
      + "  <li><h2>break bricht Schleife komplett ab</h2></li>\n"
      + "  <li><h2>continue bricht im Rumpf ab und geht wieder zum Schleifenkopf</h2></li>\n"
      + "  <li><h2>return verläßt eine Funktion und damit auch eine Schleife</h2></li>\n"
      + "</ul>\n"
      + "</seite>\n"
      + "\n"
      + "</subsubsection>\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"switch Verzweigungen\">\n"
      + "Der letzte zusammengesetzte Befehl, den C kennt, ist eine besondere Art der\n"
      + "Verzweigung, der <tt>switch</tt>-Befehl. Er erlaubt es, abhängig vom Wert\n"
      + "einer Zahl nach verschiedenen Fällem, die konstant festgelegt sind, zu\n"
      + "unterscheiden. Er beginnt mit dem Wort <tt>switch</tt>, in runden Klammern\n"
      + "gefolgt von einem Ausdruck, der zu einer Zahl auswertet. Dann folgen in\n"
      + "geschweiften Klammern eingeschlossen die verschiedenen Fälle. Jeder Fall\n"
      + "beginnt mit dem Wort <tt>case</tt>. Dann kommt eine Konstante, die den Fall\n"
      + "beschreibt, der hier behandelt wird. Nach einem Doppelpunkt folgen dann die\n"
      + "spezifischen Befehle für diesen Fall.\n"
      + "\n"
      + "\n"
      + "Ein besonderer Fall wird mit dem Wort <tt>default</tt> bezeichnet. Er trifft\n"
      + "immer zu, egal welchen Wert der in Frage kommende Ausdruck, nach dem die\n"
      + "Fallunterscheidung vorgenommen wurde, hat.\n"
      + "\n"
      + "Ein erstes kleines Beispiel für die <tt>switch</tt>-Anweisung:\n"
      + "\n"
      + "<code class=\"Switch1\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "\n"
      + "void f(int x){\n"
      + "  switch (x) {\n"
      + "    case 1: printf(\"eins \");\n"
      + "    case 2: printf(\"zwei \");\n"
      + "    case 3: printf(\"drei \");\n"
      + "    case 4: printf(\"vier \");\n"
      + "    case 5: printf(\"fuenf \");\n"
      + "    case 6: printf(\"sechs \");\n"
      + "    case 7: printf(\"sieben \");\n"
      + "    case 8: printf(\"acht \");\n"
      + "    case 9: printf(\"neun \");\n"
      + "    case 0: printf(\"null \");\n"
      + "    default: printf(\"keine Ziffer\");\n"
      + "  }\n"
      + "  printf(\"\n\");\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  f(8);\n"
      + "  f(3);\n"
      + "  f(19);\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Dieses Programm führt nicht ganz zu der vom vernünftigen Menschenverstand\n"
      + "erwartete Ausgabe:\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> ./Switch1\n"
      + "acht neun null keine Ziffer\n"
      + "drei vier fuenf sechs sieben acht neun null keine Ziffer\n"
      + "keine Ziffer\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Wie man sieht, wird zwar direkt zu dem Fall gesprungen, der für den \n"
      + "Parameter <tt>x</tt> zutrifft, allerdings wird nicht nur dieser Fall\n"
      + "ausgeführt, sondern alle folgenden Fälle auch noch. Wenn man nicht möchte,\n"
      + "dass nachdem zu einem bestimmten Fall gesprungen wurde, auch noch alle\n"
      + "folgenden Fälle auszuführen sind, so muss man am Ende eines Falls immer noch\n"
      + "den uns bereits von den Schleifen bekannte Befehl <tt>break</tt> setzten:\n"
      + "\n"
      + "<code class=\"Switch2\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "\n"
      + "void f(int x){\n"
      + "  switch(x) {\n"
      + "    case 1: printf(\"eins \");break;\n"
      + "    case 2: printf(\"zwei \");break;\n"
      + "    case 3: printf(\"drei \");break;\n"
      + "    case 4: printf(\"vier \");break;\n"
      + "    case 5: printf(\"fuenf \");break;\n"
      + "    case 6: printf(\"sechs \");break;\n"
      + "    case 7: printf(\"sieben \");break;\n"
      + "    case 8: printf(\"acht \");break;\n"
      + "    case 9: printf(\"neun \");break;\n"
      + "    case 0: printf(\"null \");break;\n"
      + "    default: printf(\"keine Ziffer\");break;\n"
      + "  }\n"
      + "  printf(\"\n\");\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  f(8);\n"
      + "  f(3);\n"
      + "  f(19);\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Dann Funktioniert das Programm so, wie man es doch tatsächlich erwartet hätte:\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/Switch2\n"
      + "acht\n"
      + "drei\n"
      + "keine Ziffer\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode> \n"
      + "\n"
      + "Tatsächlich ist es ein häufiger Fehler, dass das <tt>break</tt> am Ende eines\n"
      + "Falls vergessen wurde.\n"
      + "\n"
      + "<aufgabe  blatt=\"4\"><b>(1 Punkt)</b>Schreiben Sie eine \n"
      + "Prozedur <tt>alsText</tt>, die eine Zahl als Argument erhält. Sie\n"
      + "soll die Ziffern dieser Zahl als Text auf der Kommandozeile ausdrucken. Der\n"
      + "Aufruf  <tt>alsText(-142)</tt> soll zur \n"
      + "Ausgabe <tt>minus eins vier zwei</tt> führen.<p/>\n"
      + "\n"
      + "<b>Hinweis</b>: Schreiben Sie dabei folgende Hilfsfunktionen:<br />\n"
      + "<tt>int hoechsteZehnerPotenz(int i);</tt><br />\n"
      + "Sie soll für einstellige Zahlen <tt>1</tt>, für zweistellige \n"
      + "Zahlen <tt>10</tt>, für dreistellige Zahlen <tt>100</tt> usw. als Ergebnis\n"
      + "haben. <p/>\n"
      + "\n"
      + "<tt>void printZiffer(int i);</tt><br />\n"
      + "Hier gehen Sie davon aus, dass <m>0\\le i\\le 9</m>. Diese Ziffer soll dann als\n"
      + "Wort auf der Kommandozeile ausgegeben werden.\n"
      + "\n"
      + "\n"
      + "<loesung>\n"
      + "<code class=\"AlsText\" lang=\"c\" \n"
      + " compileoptions=\" echo -std=c99 \"\n"
      + "main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "void printZiffer(int i){\n"
      + "  switch (i) {\n"
      + "    case 0: printf(\"null\");break;\n"
      + "    case 1: printf(\"eins\");break;\n"
      + "    case 2: printf(\"zwei\");break;\n"
      + "    case 3: printf(\"drei\");break;\n"
      + "    case 4: printf(\"vier\");break;\n"
      + "    case 5: printf(\"fünf\");break;\n"
      + "    case 6: printf(\"sechs\");break;\n"
      + "    case 7: printf(\"sieben\");break;\n"
      + "    case 8: printf(\"acht\");break;\n"
      + "    case 9: printf(\"neun\");break;\n"
      + "    default: ;\n"
      + "  }\n"
      + "}\n"
      + "\n"
      + "int hoechsteZehnerPotenz(int i){\n"
      + "  int result = 1;\n"
      + "  while (i>=10){\n"
      + "    result=result*10;\n"
      + "    i=i / 10;\n"
      + "  }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "void alsText(int i){\n"
      + "  if (i<0){ \n"
      + "    printf(\"minus \");\n"
      + "    i= -i;\n"
      + "  }\n"
      + "  for (int hoechsteStelle = hoechsteZehnerPotenz(i)\n"
      + "      ;hoechsteStelle>0\n"
      + "      ;hoechsteStelle=hoechsteStelle/10) {\n"
      + "    printZiffer(i/hoechsteStelle);\n"
      + "    printf(\" \");\n"
      + "    i=i%hoechsteStelle;\n"
      + "  }\n"
      + "  printf(\"\n\");\n"
      + "}\n"
      + "\n"
      + "void alsTextrec1(int i);\n"
      + "\n"
      + "void alsTextrec(int i){\n"
      + "  if (i==0){ printf(\"null\");\n"
      + "  }else if (i<0){ \n"
      + "    printf(\"minus\");\n"
      + "    alsTextrec1(-i);\n"
      + "  }else alsTextrec1(i);\n"
      + "  printf(\"\n\");\n"
      + "}\n"
      + "\n"
      + "void alsTextrec1(int i){\n"
      + "  if (i!=0) {\n"
      + "    alsTextrec1(i/10);\n"
      + "    printf(\" \");\n"
      + "    printZiffer(i%10);\n"
      + "  }\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  alsText(-142);\n"
      + "  alsText(1024);\n"
      + "  alsText(0);\n"
      + "  alsText(-0);\n"
      + "  alsText((17+4)*2);\n"
      + "\n"
      + "  alsTextrec(-142);\n"
      + "  alsTextrec(1024);\n"
      + "  alsTextrec(0);\n"
      + "  alsTextrec(-0);\n"
      + "  alsTextrec((17+4)*2);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</loesung>\n"
      + "\n"
      + "</aufgabe>\n"
      + "</subsection>\n"
      + "\n"
      + "<seite titel=\"Fallunterscheidung\">\n"
      + "<ul>\n"
      + "  <li><h2>switch-Anweisung zum Unterscheiden nach konstanten Zahlenwerten</h2></li>\n"
      + "  <li><h2>Achtung ohne break werden alle folgenden Fälle berücksichtigt</h2></li>\n"
      + "  <li><h2>default-Klausel erlaubt Spezifikation von Standardfall</h2></li>\n"
      + "</ul>\n"
      + "</seite>\n"
      + "</section>\n"
      + "\n"
      + "<section titel=\"Zuweisung und Operatoren\">\n"
      + "Wir haben dieses Kapitel mit Operatoren begonnen, die nach unserer Kenntnis\n"
      + "von mathematischen Operatoren funktionierten. Operatorausdrücke hatten zumeist\n"
      + "zwei Operanden. Aus diesen Operanden wurde ein Ergebnis des Operatorausdrucks\n"
      + "berechnet. Die Operanden wurden dabei in keinster Weise berührt. Im\n"
      + "Zusammenhang mit Variablen haben wir dann den Zuweisungsbefehl\n"
      + "kennengelernt. Auf seiner linken Seite stand dabei eine Variable, der der Wert\n"
      + "der rechten Seite zugewiesen wurde.\n"
      + "\n"
      + "In C gibt es jetzt eine Reihe von seltsamen Operatoren, die zwei Dinge auf\n"
      + "einmal machen: eine Operation ausrechnen und eine Variable verändern. \n"
      + "\n"
      + "<subsection titel=\"Zuweisungsoperatoren\">\n"
      + "Für fast alle Operatoren in C gibt es eine Version, die den Operator und eine\n"
      + "Zuweisung vereint. Will man zu einer Variablen <tt>x</tt> etwa eine Zahl \n"
      + "hinzuzählen, so ist zunächst die Addition durchzuführen <tt>x+5</tt>, um \n"
      + "dann schließlich\n"
      + "das Ergebnis der Variablen wieder zuzuweisen, also <tt>x=x+5</tt>. Diese\n"
      + "Berechnung und anschließende Zuweisung kann man in C abkürzen mit Hilfe des\n"
      + "Additionszuweisungsoperators <tt>+=</tt>. Obiger Ausdruck kann dann\n"
      + "schließlich als <tt>x+=5</tt> geschrieben werden. Interessanter Weise \n"
      + "hat <tt>x+=5</tt> das gleiche Ergebnis wie <tt>x+5</tt>. Zusätzlich hat der\n"
      + "Ausdruck noch den Seiteneffekt, dass dieses Ergebnis der \n"
      + "Variable <tt>x</tt> zugewiesen wird.\n"
      + "\n"
      + "Ein paar Beispiele der Zuweisungsoperatoren für arithmetische Ausdrücke:\n"
      + "\n"
      + "<code class=\"AssignOperation\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "int main(){\n"
      + "  int x=42;\n"
      + "  printf(\"x+=2 : %i\n\",x+=2);\n"
      + "  printf(\"x    : %i\n\",x);\n"
      + "  printf(\"x-=2 : %i\n\",x-=2);\n"
      + "  printf(\"x    : %i\n\",x);\n"
      + "  printf(\"x*=2 : %i\n\",x*=2);\n"
      + "  printf(\"x    : %i\n\",x);\n"
      + "  printf(\"x/=2 : %i\n\",x/=2);\n"
      + "  printf(\"x    : %i\n\",x);\n"
      + "  printf(\"x%%=2 : %i\n\",x%=2);\n"
      + "  printf(\"x    : %i\n\",x);\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Wie man der Ausgabe entnehmen kann, wird die Variable tatsächlich verändert.\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/AssignOperation\n"
      + "x+=2 : 44\n"
      + "x    : 44\n"
      + "x-=2 : 42\n"
      + "x    : 42\n"
      + "x*=2 : 84\n"
      + "x    : 84\n"
      + "x/=2 : 42\n"
      + "x    : 42\n"
      + "x%=2 : 0\n"
      + "x    : 0\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Wenn auf der linken Seite eines Zuweisungsoperators keine Variable steht, kann\n"
      + "auch nichts entsprechendes zugewiesen werden. Deshalb verbietet der C-Compiler\n"
      + "Zuweisungsausdrücke, die auf der linken seite keine Variable haben:\n"
      + "\n"
      + "<code class=\"AssignError\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "int main(){\n"
      + "  printf(\"5+=6 : %i\n\",5+=6);\n"
      + "}</code>\n"
      + "\n"
      + "Es kommt zu folgender Fehlermeldung:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> gcc src/AssignError.c\n"
      + "src/AssignError.c: In function `main':\n"
      + "src/AssignError.c:3: error: invalid lvalue in assignment\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Wir haben Seiteneffekte schon als gefährlich gegeißelt: Seiteneffekte machen\n"
      + "Programme komplizierter zu verstehen. Daher sollen Funktionen mit\n"
      + "Seiteneffekten nur ganz bewußt und sparsam eingesetzt werden. Das gleiche gilt\n"
      + "im verstärkten Maße für die Zuweisungsoperatoren. Sie sollten tatsächlich nur \n"
      + "als abkürzende Schreibweise für <tt>x=x+5</tt> auf einer eigenen Zeile benutzt\n"
      + "werden. Auf komplexere Asdrücke wie <tt>42+(x*=x+=5)</tt> sollte\n"
      + "verzichtet werden, es sei denn man\n"
      + "möchte am <em>obfuscated C</em>-Wettbewerb teilnehmen.\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Inkrement und Dekrement\">\n"
      + "Es gibt sogar noch speziellere Formen, eine Variable zu modifizieren.\n"
      + "Sehr oft tritt die Situation ein, dass eine Variable um eins erhöht oder\n"
      + "verringert werden soll. Hierzu kennt C eigene einstellige Operatoren, die auf\n"
      + "Variablen angewendet werden können, die \n"
      + "Operatoren <tt>++</tt> und <tt>--</tt>. Dabei können die \n"
      + "Operatoren nach der Variable stehen. \n"
      + "\n"
      + "Betrachten wir den Unterschied am Beispiel:\n"
      + "\n"
      + "<code class=\"IncDec\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "int main(){\n"
      + "  int x=42;\n"
      + "  printf(\"x++ : %i\n\",x++);\n"
      + "  printf(\"x   : %i\n\",x);\n"
      + "  printf(\"x-- : %i\n\",x--);\n"
      + "  printf(\"x   : %i\n\",x);\n"
      + "  printf(\"++x : %i\n\",++x);\n"
      + "  printf(\"x   : %i\n\",x);\n"
      + "  printf(\"--x : %i\n\",--x);\n"
      + "  printf(\"x   : %i\n\",x);\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "An der Ausgabe kann man erkennen, dass die Operatoren eine Variable\n"
      + "tatsächlich um eins erhöhen oder verringern.\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/IncDec\n"
      + "x++ : 42\n"
      + "x   : 43\n"
      + "x-- : 43\n"
      + "x   : 42\n"
      + "++x : 43\n"
      + "x   : 43\n"
      + "--x : 42\n"
      + "x   : 42\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Das Ergebnis des Operatorausdruck hängt dabei davon ab, ob der Operator der\n"
      + "Variablen vor oder nachgestellt war. Ist er der Variablen nachgestellt, so ist\n"
      + "das Ergebnis des Ausdrucks der Wert vor Erhöhen bzw.~Verringern der\n"
      + "Variable. Ist der Operator nachgestellt, so hat der Gesamtausdruck den Wert\n"
      + "der Variable bevor sie verändert wird. Ist der Operator vorangestellt, so hat\n"
      + "der Gesamtausdruck den Wert der Variablen nach der Modifikation.\n"
      + "\n"
      + "Auch für diese beiden Operatoren gilt: sparsam und nur in recht klaren\n"
      + "Situationen benutzen. Die einzige Stelle, in der er von mir tatsächlich\n"
      + "benutzt wird ist im Kopf einer <tt>for</tt>-Schleife:\n"
      + "\n"
      + "<code class=\"CountDownFor2\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "int main(){\n"
      + "  int i;\n"
      + "  for (i=10;i&gt;0;<redv>i--</redv>){\n"
      + "    printf(\"i = %i\n\",i);\n"
      + "  }\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Hier sind diese beiden Operatoren recht gut aufgehoben. Eine Variable wird in\n"
      + "einem Bereich herauf und heruntergezählt.\n"
      + "</subsection>\n"
      + "\n"
      + "<seite titel=\"Zuweisungsoperatoren\">\n"
      + "<ul>\n"
      + "  <li><h2>Berechnen Ausdruck und weisen Variablen neuen Wert zu</h2></li>\n"
      + "  <li><h2>Sind nur mit Variablen anwendbar</h2></li>\n"
      + "  <li><h2>nützlich zum Weiterschalten der Laufvariablen einer Schleife</h2></li>\n"
      + "\n"
      + "</ul>\n"
      + "</seite>\n"
      + "</section>\n"
      + "\n"
      + "<aufgabe blatt=\"3a\"><b>(Zusatzaufgabe)</b><br />\n"
      + "In dieser Aufgabe machen wir einen kleinen Vorgriff auf Funktionen als\n"
      + "Argumente. \n"
      + "<unteraufgaben>\n"
      + "<teil>\n"
      + "Schreiben Sie ein Programm, mit dem Sie auf der Kommandozeile den Graphen\n"
      + "einer bestimmten Funktion ausgeben können. Es soll für die Funktion:<br />\n"
      + "<tt>int f1(int x){return x*x/6-12;}</tt><br />\n"
      + "zu folgender Ausgabe kommen:\n"
      + "<scode><![CDATA[              X                     X\n"
      + "\n"
      + "\n"
      + "\n"
      + "               X                   X\n"
      + "\n"
      + "\n"
      + "                X                 X\n"
      + "\n"
      + "\n"
      + "                 X               X\n"
      + "\n"
      + "                  X             X\n"
      + "\n"
      + "                   X           X\n"
      + "\n"
      + "                    X         X\n"
      + "\n"
      + "                     X       X\n"
      + "                      X     X\n"
      + "                       XXXXX\n"
      + "]]></scode>\n"
      + "</teil>\n"
      + "\n"
      + "<teil>Im ersten Teil haben Sie den Graphen für genau eine Funktion\n"
      + "auf der Kommandozeile angezeigt. Überlegen Sie jetzt, wie Sie eine \n"
      + "allgemeine Funktion zum Zeichnen von Graphen beliebiger Funktionen\n"
      + "schreiben können. Hierzu müssen Sie eine Funktion als Parameter übergeben. Sie\n"
      + "sollen eine Prozedur mit folgender Signatur schreiben:<br />\n"
      + "<tt>void druckeGraph(int f(int));</tt>\n"
      + "\n"
      + "Rufen Sie dann diese Prozedur mit mehreren unterschiedlichen Funktionen in\n"
      + "einem Test auf.\n"
      + "</teil>\n"
      + "\n"
      + "</unteraufgaben>\n"
      + "\n"
      + "\n"
      + "<loesung>\n"
      + "<code class=\"fun\" compileoptions=\" echo -std=c99 \" lang=\"c\" main=\"main\"  commandchars=\"_$^\" \n"
      + "><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int f1(int x){return x*x/6-12;}\n"
      + "int f2(int x){return x*x*x/100;}\n"
      + "\n"
      + "void druckeGraph(int f(int)){\n"
      + "  for (int y=0;y<30;y++){\n"
      + "    for (int x=0;x<50;x++){\n"
      + "      int y2=15-y;\n"
      + "      printf(f(x-25)==y2?\"X\":\" \");\n"
      + "    }\n"
      + "    printf(\"\n\");\n"
      + "  }\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"Funktionsgraph für f1\n\");\n"
      + "  druckeGraph(f1);\n"
      + "  printf(\"Funktionsgraph für f2\n\");\n"
      + "  druckeGraph(f2);\n"
      + "  return 0;\n"
      + "}\n"
      + "]]></code>\n"
      + "</loesung>\n"
      + "</aufgabe>\n"
      + "</kapitel>\n"
      + "\n"
      + "<kapitel titel=\"Softwarentwicklung\"><label name=\"softwareengeneeringchapter\"></label>\n"
      + "<section titel=\"Programmieren\">\n"
      + "\n"
      + "<subsection titel=\"Disziplinen der Programmierung\">\n"
      + "Mit dem Begriff Programmierung wird zunächst \n"
      + "die eigentliche Codierung eines Programms assoziiert. \n"
      + "Eine genauerer Blick offenbart jedoch, daß dieses nur ein kleiner \n"
      + "Teil von vielen recht unterschiedlichen Schritten ist, die zur\n"
      + "Erstellung von Software notwendig sind:\n"
      + "\n"
      + "\n"
      + "<itemize>\n"
      + "<item><b>Spezifikation:</b> Bevor eine Programmieraufgabe\n"
      + "bewerkstelligt werden kann, muß  das zu lösende\n"
      + "Problem spezifiziert werden. Dieses kann informell durch eine\n"
      + "natürlichsprachliche Beschreibung bis hin zu mathematisch\n"
      + "beschriebenen Funktionen geschehen. Gegen die Spezifikation \n"
      + "wird programmiert. Sie beschreibt das gewünschte Verhalten\n"
      + "des zu erstellenden Programms. </item>\n"
      + "\n"
      + "<item><b>Modellieren:</b> Bevor es an die eigentliche Codierung\n"
      + "geht, wird in der Regel die Struktur des Programms modelliert.\n"
      + "Auch dieses kann in unterschiedlichen Detaillierungsgraden geschehen.\n"
      + "Manchmal reichen Karteikarten als hilfreiches Mittel aus,\n"
      + "andernfalls empfiehlt sich eine umfangreiche Modellierung \n"
      + "mit Hilfe rechnergestützter Werkzeuge. Für die objektorientierte\n"
      + "Programmierung hat sich  UML als eine geeignete Modellierungssprache\n"
      + "durchgesetzt. In ihr lassen sich Klassendiagramme, Klassenhierarchien\n"
      + "und Abhängigkeiten graphisch darstellen. Mit bestimmten Werkzeugen\n"
      + "wie <em>Together</em> oder <em>Rational Rose</em> läßt sich direkt \n"
      + "für eine UML-Modellierung Programmtext generieren.</item>\n"
      + "\n"
      + "<item><b>Codieren:</b> Die eigentliche Codierung ist in der\n"
      + "Regel der einzige Schritt, der direkt Code in der gewünschten\n"
      + "Programmiersprache von Hand erzeugt. Alle anderen Schritte \n"
      + "der Programmierung\n"
      + "sind mehr oder weniger unabhängig von der zugrundeliegenden\n"
      + "Programmiersprache.\n"
      + "<p/>\n"
      + "Für die Codierung empfiehlt es sich, Konventionen zu verabreden, wie \n"
      + "der Code geschrieben wird, was für Bezeichner benutzt werden, in\n"
      + "welcher Weise der Programmtext eingerückt wird. Entwicklungsabteilungen\n"
      + "haben zumeist schriftlich verbindlich festgeschriebene Richtlinien\n"
      + "für den Programmierstil. Dieses erleichtert, den Code der Kollegen im\n"
      + "Projekt schnell zu verstehen.\n"
      + "</item>\n"
      + "\n"
      + "<item><b>Testen:</b> Beim Testen sind generell zu unterscheiden:\n"
      + "<itemize>\n"
      + "<item><em>Entwicklertests:</em> Diese werden von den Entwicklern\n"
      + "während der Programmierung selbst geschrieben, um einzelne Programmteile\n"
      + "(Methoden<index>Methode</index>, \n"
      + "Funktionen) separat zu testen. Es gibt eine Schule, die\n"
      + "propagiert, Entwicklertests vor dem Code zu \n"
      + "schreiben (<em>test first</em>). Die Tests dienen in diesem Fall als\n"
      + "kleine Spezifikationen.</item>\n"
      + "\n"
      + "<item><em>Qualitätssicherung:</em> In der Qualitätssicherung werden\n"
      + "die fertigen Programme gegen ihre Spezifikation getestet (<em>black\n"
      + "box tests</em>). Hierzu\n"
      + "werden in der Regel automatisierte Testläufe geschrieben. \n"
      + "Die Qualitätssicherung ist  personell von der Entwicklung\n"
      + "getrennt. Es kann\n"
      + "in der Praxis durchaus vorkommen, daß die Qualitätsabteilung \n"
      + "mehr Mitarbeiter hat als die Entwicklungsabteilung.</item>\n"
      + "</itemize>\n"
      + "</item>\n"
      + "\n"
      + "<item><b>Optimieren:</b> Sollten sich bei Tests oder in der \n"
      + "Praxis Performanzprobleme zeigen, sei es durch zu hohen \n"
      + "Speicherverbrauch als auch durch zu lange Ausführungszeiten, so wird\n"
      + "versucht, ein Programm zu optimieren. Hierzu bedient man sich\n"
      + "spezieller Werkzeuge (<em>profiler</em>), die für einen Programmdurchlauf\n"
      + "ein Raum- und Zeitprofil erstellen. In diesem Profil können \n"
      + "Programmteile, die besonders häufig durchlaufen werden, oder Objekte,\n"
      + "die im großen Maße Speicher belegen, identifiziert werden. Mit diesen \n"
      + "Informationen lassen sich gezielt inperformante Programmteile \n"
      + "optimieren.</item>\n"
      + "\n"
      + "<item><b>Verifizieren:</b> Eine formale Verifikation eines Programms\n"
      + "ist ein mathematischer Beweis der Korrektheit bezüglich der\n"
      + "Spezifikation. Das setzt natürlich voraus, daß die Spezifikation\n"
      + "auch formal vorliegt. Man unterscheidet:\n"
      + "<itemize>\n"
      + "<item><em>partielle Korrektheit:</em> wenn das Programm für\n"
      + "eine bestimte Eingabe ein Ergebnis liefert, dann ist dieses bezüglich\n"
      + "der Spezifikation korrekt.</item>\n"
      + "<item><em>totale Korrektheit:</em> Das Programm ist partiell korrekt\n"
      + "und terminiert für jede Eingabe, d.h.<white/>liefert immer nach endlich\n"
      + "langer Zeit ein Ergebnis.</item>\n"
      + "</itemize>\n"
      + "Eine formale Verifikation ist notorisch schwierig und allgemein nicht\n"
      + "automatisch durchführbar. In der Praxis werden nur in ganz speziellen\n"
      + "kritischen Anwendungen formale Verifikationen durchgeführt, z.B.<white/>bei\n"
      + "Steu\\-er\\-un\\-gen gefahrenträchtiger Maschinen, so daß Menschenleben von\n"
      + "der Korrektheit eines Programms abhängen können. \n"
      + "\n"
      + "</item>\n"
      + "<item><b>Wartung/Pflege:</b> den größten Teil seiner Zeit verbringt\n"
      + "ein Programmierer nicht mit der Entwicklung neuer\n"
      + "<!-- Komma eingefügt hinter 1. \"Software\", \"mit\" eingefügt hinter \"sondern\"-->\n"
      + "Software, sondern mit der Wartung bestehender Software. Hierzu gehören\n"
      + "die Anpassung des Programms an neue Versionen benutzter Bibliotheken\n"
      + "<!-- Wiederholung von \"neue Versionen\" ganz rausgenommen-->\n"
      + "oder <!--neue Versionen--> des Betriebssystems, auf dem das Programm läuft, \n"
      + "sowie die Korrektur von Fehlern.</item>\n"
      + "\n"
      + "<item><b>Debuggen:</b> Bei einem  Programm ist immer damit\n"
      + "zu rechnen, daß es Fehler enthält. Diese Fehler werden im besten\n"
      + "Fall von der Qualitätssicherung entdeckt, im schlechteren Fall treten \n"
      + "sie beim Kunden auf. Um  Fehler im Programmtext zu finden,\n"
      + "gibt es Werkzeuge, die ein schrittweises Ausführen des Programms\n"
      + "ermöglichen <em>(debugger)</em>. Dabei lassen sich die Werte, die in\n"
      + "bestimmten Speicherzellen stehen, auslesen und auf diese Weise der Fehler\n"
      + "finden. \n"
      + " </item>\n"
      + "\n"
      + "<item><b>Internationalisieren (I18N)<footnote>I18N ist eine Abkürzung\n"
      + "für das Wort <em>internationalization</em>, das mit einem i beginnt, mit\n"
      + "einem n endet und dazwischen 18 Buchstaben hat.</footnote>:</b> Softwarefirmen\n"
      + "wollen möglichst\n"
      + "viel Geld mit ihrer Software verdienen und streben deshalb an, ihre\n"
      + "Programme möglichst weltweit zu vertreiben. Hierzu muß gewährleistet\n"
      + "sein, daß das Programm auf weltweit allen Plattformen läuft und\n"
      + "mit verschiedenen Schriften und Textcodierungen umgehen kann. Das\n"
      + "Programm sollte ebenso wie mit lateinischer Schrift auch mit Dokumenten\n"
      + "in anderen Schriften umgehen können. Fremdländische Akzente und  \n"
      + "deutsche Umlaute sollten bearbeitbar sein. Aber auch unterschiedliche\n"
      + "Tastaturbelegungen bis hin zu unterschiedlichen Schreibrichtungen sollten\n"
      + "unterstützt werden. \n"
      + "<p/>\n"
      + "Die Internationalisierung ist ein weites Feld, und wenn nicht am Anfang\n"
      + "der Programmerstellung hierauf Rücksicht genommen wird, so ist es schwer,\n"
      + "nachträglich das Programm zu internationalisieren.\n"
      + "</item>\n"
      + "\n"
      + "<item><b>Lokalisieren (L12N):</b> Ebenso wie die \n"
      + "Internationalisierung beschäftigt\n"
      + "sich die Lokalisierung damit, daß ein Programm in anderen Ländern\n"
      + "eingesetzt werden kann. Beschäftigt sich die Internationalisierung damit,\n"
      + "daß fremde Dokumente bearbeitet werden können, versucht die Lokalisierung,\n"
      + "das Programm komplett für die fremde Sprache zu übersetzen. Hierzu \n"
      + "gehören Menueinträge in der fremden Sprache, Beschriftungen der\n"
      + "Schaltflächen oder auch Fehlermeldungen in fremder Sprache und Schrift.\n"
      + "Insbesondere haben verschiedene Schriften unterschiedlichen\n"
      + "Platzbedarf; auch das ist beim Erstellen der Programmoberfläche\n"
      + "zu berücksichtigen.</item>\n"
      + "\n"
      + "\n"
      + "<item><b>Portieren:</b> Oft wird es nötig, ein Programm auf eine andere\n"
      + "Plattform zu portieren. Ein unter Windows erstelltes Programm soll\n"
      + "z.B.<white/>auch auf Unix-Systemen zur Verfügung stehen. </item>\n"
      + "\n"
      + "<item><b>Dokumentieren:</b> Der Programmtext allein reicht in der Regel\n"
      + "<!-- \"damit\" statt \"daß\", \"fremden\" mit großem 'F' -->\n"
      + "nicht aus, damit das Programm von Fremden oder \n"
      + "dem Programmierer selbst nach\n"
      + "geraumer Zeit gut verstanden werden kann. Um ein Programm näher\n"
      + "zu erklären, wird im Programmtext Kommentar eingefügt. Kommentare\n"
      + "erklären die benutzten Algorithmen, die Bedeutung bestimmter Datenfelder\n"
      + "oder die Schnittstellen und Benutzung \n"
      + "bestimmter Methoden<index>Methode</index>.\n"
      + "<p/>\n"
      + "Es ist zu empfehlen, sich anzugewöhnen, Quelltextdokumentation immer auf\n"
      + "Englisch zu schreiben. Es ist oft nicht abzusehen, wer einmal einen\n"
      + "Programmtext zu sehen bekommt. Vielleicht ein japanischer Kollege,\n"
      + "der das Programm für Japan lokalisiert, oder der irische Kollege, der,\n"
      + "nachdem die Firma mit einer anderen Firma fusionierte, das \n"
      + "Programm auf ein anderes Betriebssystem portiert, oder vielleicht\n"
      + "die englische Werksstudentin, die für ein Jahr in der Firma arbeitet.</item>\n"
      + "</itemize>\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Was ist ein Programm\">\n"
      + "Die Frage danach, was ein Programm eigentlich ist, läßt sich \n"
      + "aus verschiedenen Perspektiven recht unterschiedlich beantworten.\n"
      + "Wir haben schon eine ganze Reihe von Programmen geschrieben, so dass zumindest\n"
      + "schon ein erstes intuitives Gefühl dafür, was ein Programm eigentlich ist,\n"
      + "existieren sollte. Tatsächlich lassen sich Computerprogramme unter\n"
      + "unterschiedlichsten Aspekten betrachten. Was ist also eigenbtlich ein\n"
      + "Programm? \n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"pragmatische Antwort\">\n"
      + "Eine Textdatei, die durch ein anderes  Programm in einen \n"
      + "ausführbaren Maschinencode\n"
      + "übersetzt wird. Dieses andere Programm ist ein Übersetzer, \n"
      + "engl.<white></white><em>compiler</em>.\n"
      + "</subsubsection>\n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"mathematische Antwort\">\n"
      + "Eine Funktion, die deterministisch für Eingabewerte \n"
      + "einen Ausgabewert berechnet.\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"sprachwissenschaftliche Antwort\">\n"
      + "Ein Satz einer durch eine Grammatik beschriebenen Sprache. Für dieses\n"
      + "syntaktische Konstrukt existiert eine Bedeutung in Form einer\n"
      + "operationale Semantik.\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"operationale Antwort\">\n"
      + "Eine Folge von durch den Computer ausführbaren Befehlen, die den Speicher des\n"
      + "Computers manipulieren.\n"
      + "</subsubsection>\n"
      + "</subsection>\n"
      + "\n"
      + "\n"
      + "<subsection titel=\"Klassifizierung von Programmiersprachen\">\n"
      + "Es gibt mittlerweile mehr Programmiersprachen als \n"
      + "natürliche Sprachen. In <exlink\n"
      + "address=\"http://de.wikipedia.org/wiki/Liste_der_Programmiersprachen\"\n"
      + ">Wikipedia</exlink> existiert eine recht umfangreiche Liste von \n"
      + "Programmiersprachen. Die meisten Sprachen führen\n"
      + "entsprechend nur ein Schattendasein und die Mehrzahl der Programme\n"
      + "konzentriert sich auf einige wenige Sprachen. Programmiersprachen lassen\n"
      + "sich nach den unterschiedlichsten Kriterien klassifizieren.   \n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"Hauptklassen\">\n"
      + "Im folgenden eine hilfreiche Klassifizierung in fünf verschiedene \n"
      + "Hauptklassen.\n"
      + "\n"
      + "<itemize>\n"
      + "<item><b>imperativ</b> (C<cite label=\"KernighanRitchie\"/>, Pascal<cite label=\"pascal\"/>, Fortran, Cobol): das\n"
      + "Hauptkonstrukt dieser Sprachen sind Befehle, die den Speicher\n"
      + "manipulieren. Dieses äußert sich primär durch einen Zuweisungsbefehl, der es\n"
      + "erlaubt, Variablen neue Werte zuzuweisen.\n"
      + "</item>\n"
      + "<item><b>objektorientiert</b> (Java, C++, C\\#, Eiffel, Smalltalk):\n"
      + "Daten werden in Form von Objekten organisiert. Diese Objekte\n"
      + "bündeln mit den Daten auch die auf diesen Daten anwendbaren\n"
      + "Methoden<index entry=\"Methode\"/>.</item>\n"
      + "\n"
      + "<item><b>funktional</b> (Lisp, ML<cite label=\"milner:90\"/>, Haskell<cite\n"
      + "label=\"revisedHaskellReport\"/>, Scheme, Erlang, Clean, F\\#):\n"
      + "Programme werden als mathematische Funktionen verstanden und auch\n"
      + "Funktionen  können Daten sein. Dieses Programmierparadigma versucht,\n"
      + "sich möglichst weit von der Architektur des Computers zu lösen.\n"
      + "Veränderbare Speicherzellen gibt es in rein funktionalen Sprachen\n"
      + "nicht und erst recht keine Zuweisungsbefehle.</item>\n"
      + "\n"
      + "<item><b>Skriptsprachen</b> (Perl, AWK): solche Sprachen sind dazu\n"
      + "entworfen, einfache kleine Programme schnell zu erzeugen. Sie haben\n"
      + "meist kein Typsystem und nur eine begrenzte Zahl an \n"
      + "Strukturierungsmöglichkeiten, oft aber eine mächtige Bibliothek, um\n"
      + "Zeichenketten zu manipulieren.</item>\n"
      + "\n"
      + "<item><b>logisch</b> (Prolog): aus der KI (künstlichen Intelligenz)\n"
      + "stammen logische Programmiersprachen. Hier wird ein Programm als\n"
      + "logische Formel, für die ein Beweis gesucht wird, verstanden.</item>\n"
      + "</itemize>\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Ausführungsmodelle\">\n"
      + "Der Programmierer schreibt  den lesbaren Quelltext seines Programmes.\n"
      + "Um ein Programm auf einem Computer laufen zu lassen, muß es erst \n"
      + "in einen Programmcode übersetzt werden, den der Computer versteht.\n"
      + "Für diesen Schritt gibt es auch unterschiedliche Modelle:\n"
      + "\n"
      + "<itemize>\n"
      + "<item><b>kompiliert</b> (C, Cobol, Fortran): in einem Übersetzungsschritt\n"
      + "wird aus dem Quelltext direkt das ausführbare Programm erzeugt, das dann\n"
      + "unabhängig von irgendwelchen Hilfen der Programmiersprache ausgeführt werden\n"
      + "kann.\n"
      + "</item>\n"
      + "\n"
      + "<item><b>interpretiert</b> (Lisp, Scheme): der Programmtext wird nicht\n"
      + "in eine ausführbare Datei übersetzt, sondern durch einen Interpreter\n"
      + "Stück für Stück anhand des Quelltextes ausgeführt. Hierzu muß stets der\n"
      + "Interpreter zur Verfügung stehen, um das Programmm auszuführen. \n"
      + "Interpretierte Programme sind langsamer in der Ausführung als\n"
      + "übersetzte Programme.</item>\n"
      + "\n"
      + "<item><b>abstrakte Maschine über <em>byte code</em></b> (Java, ML):\n"
      + "dieses ist quasi eine Mischform aus den obigen zwei Ausführungsmodellen.\n"
      + "Der Quelltext wird übersetzt in Befehle nicht für einen konkreten\n"
      + "Computer, sondern für eine abstrakte Maschine. Für diese abstrakte Maschine\n"
      + "steht dann ein Interpreter zur Verfügung. Der Vorteil ist, daß durch\n"
      + "die zusätzliche Abstraktionsebene der Übersetzer unabhängig von einer konkreten\n"
      + "Maschine Code erzeugen kann und das Programm auf auf allen Systemen laufen\n"
      + "kann, für die es einen Interpreter der abstrakten Maschine gibt.\n"
      + "</item>\n"
      + "</itemize>\n"
      + "\n"
      + "\n"
      + "Es gibt Programmiersprachen, für die sowohl Interpreter als auch Übersetzer\n"
      + "zur Verfügung stehen. In diesem Fall wird der Interpreter gerne zur \n"
      + "Programmentwicklung benutzt und der Übersetzer erst, wenn das Programm\n"
      + "fertig entwickelt ist.\n"
      + "</subsubsection>\n"
      + "</subsection>\n"
      + "</section>\n"
      + "\n"
      + "<section titel=\"Präprozessor und Linker: hilfreiche Freunde des Compilers\">\n"
      + "Wenn wir bisher tatsächlich Programme übersetzt haben, um eine ausführbare\n"
      + "Datei zu erhalten, haben wir genaugenommen nicht nur den Compiler aktiviert,\n"
      + "sondern auch zwei gute kleine Helfer des Compilers: den Präprozessor und den\n"
      + "Linker. Der Präprozessor bereitet den Quelltext noch ein wenig auf, bevor er\n"
      + "ihn den Compiler gibt, der Linker fügt erst die einzelnen verschiedenen\n"
      + "übersetzten Programmteile, die der Compiler erzeugt hat, zu einer ausführbaren\n"
      + "Datei zusammen. In diesem Kapitel wollen wir ein wenig genaueres Augenmerk auf\n"
      + "diese beiden Freunden nehmen.\n"
      + "\n"
      + "<subsection titel=\"Funktionsprototypen\">\n"
      + "Betrachtet wir hierzu zunächst ein ganz simples C Programm, in dem gerade mal\n"
      + "eine einfache Funktion geschrieben und anschließend aufgerufen wird.\n"
      + "\n"
      + "<code class=\"Answer1\" lang=\"c\"\n"
      + "main=\"main\"\n"
      + ">#include &lt;stdio.h&gt;\n"
      + "\n"
      + "int <redv>getAnswer(){</redv>\n"
      + "  return 42;\n"
      + "};\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"Die Antwort lautet: %i\n\", <redv>getAnswer()</redv>);\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Wir definieren, die parameterlose Funktion <tt\n"
      + ">getAnswer</tt> und rufen sie in der Funktion <tt\n"
      + ">main</tt> auf.<p/>\n"
      + "\n"
      + "\n"
      + "In höheren Programmiersprachen spielt die Reihenfolge der Funktionen in einem\n"
      + "Programm keine Rolle. Der Kompilierer hat jeweils bereits die ganze\n"
      + "Quelldatei studiert, bevor er die Rümpfe der Methoden übersetzt. \n"
      + "Wir können versuchen, ob dieses für C auch gilt. Hierzu\n"
      + "vertauschen wir die\n"
      + "Reihenfolge der beiden Funktionen im letzten Programm.\n"
      + "\n"
      + "<code class=\"Answer2\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"Die Antwort lautet: %i\n\",getAnswer());\n"
      + "  return 0;\n"
      + "}\n"
      + "\n"
      + "int getAnswer(){\n"
      + "  return 42;\n"
      + "};]]></code>\n"
      + "\n"
      + "Der Versuch dieses Programm zu übersetzen führt zumindest zu einer Warnung:\n"
      + "\n"
      + "<scode><![CDATA[sep@swe10:~/fh/c> gcc -Wall -o ../obj/Answer2.o -c ./Answer2.c\n"
      + "Answer2.c: In function `main':\n"
      + "Answer2.c:4: warning: implicit declaration of function `getAnswer'\n"
      + "\n"
      + "sep@swe10:~/fh/c>]]></scode>\n"
      + "\n"
      + "Offensichtlich können in C Funktionen nur benutzt werden, nachdem sie\n"
      + "vorher im Programm definiert wurden. Diese Einschränkung hat\n"
      + "sicherlich mit den Stand der Compilerbautechnik am Anfang der 70er\n"
      + "Jahre zu tun. Ein Compiler, der nur einmal sequentiell  das Programm von\n"
      + "vorne nach hinten durchgeht, läßt sich leichter bauen, als\n"
      + "ein Compiler, der mehrmals über eine Quelldatei gehen muß, um\n"
      + "nacheinander verschiedene Informationen zu sammeln.<p/>\n"
      + "\n"
      + "Wollen wir die Reihenfolge der beiden Funktionen, wie wir sie in der\n"
      + "Datei <tt>Answer2.c</tt> geschrieben haben, beibehalten, so können\n"
      + "wir das in C, indem wir die Signatur der Funktion <tt\n"
      + ">getAnswer</tt> vorwegnehmen. Man kann in C in ein und derselben\n"
      + "Datei die Signatur einer Funktion deklarieren und später in der Datei\n"
      + "diese Funktion erst implementieren.\n"
      + "\n"
      + "<code class=\"Answer3\" lang=\"c\" main=\"main\"\n"
      + ">#include &lt;stdio.h&gt;\n"
      + "\n"
      + "<redv>int getAnswer()</redv>;\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"Die Antwort lautet: %i\n\", getAnswer());\n"
      + "  return 0;\n"
      + "}\n"
      + "\n"
      + "int getAnswer(){\n"
      + "  return 42;\n"
      + "}\n"
      + "</code>\n"
      + "\n"
      + "Jetzt übersetzt das Programm wieder fehlerfrei. Mit dieser Technik\n"
      + "simuliert man gewissermaßen, was ein moderner Compiler sieht, wenn er\n"
      + "mehrfach über einen Quelltext geht. Zunächst sieht er die Signaturen aller\n"
      + "Funktionen und erst dann betrachtet er ihre Rümpfe. Sobald die\n"
      + "Signatur einer Funktion bekannt ist, kann die Funktion benutzt werden.\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Header-Dateien\">\n"
      + "Nach dem geraden gelernten, scheint es sinnvoll in einem C Programm\n"
      + "zunächst die Signaturen aller Funktionen zu sammeln und dann die\n"
      + "einzelnen Funktionen zu implementieren. Die Sammlung der Signaturen\n"
      + "ergibt eine schöne Zusammenfassung aller von einem Programm\n"
      + "angebotener Funktionen. Es liegt nahe, diese in eine getrennte Datei\n"
      + "auszulagern. Hierzu bedient man sich in C der sogenannten <em\n"
      + ">header</em>-Dateien, die mit der Dateiendung <tt\n"
      + ">.h</tt> abgespeichert werden.<p/>\n"
      + "\n"
      + "Für unser letztes Beispiel können wir eine <em>header</em>-Datei \n"
      + "schreiben, in der die Signatur der Funktion <tt>getAnswer</tt> steht:\n"
      + "<code class=\"Answer4\" lang=\"h\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int getAnswer();]]></code>\n"
      + "\n"
      + "Statt jetzt in einem Programm diese Signatur am Anfang des Programms\n"
      + "zu schreiben, sagen wir dem Compiler, er soll \n"
      + "die <em>header</em>-Datei mit in das Programm einfügen. Hierzu\n"
      + "benutzen wir das <tt>#include</tt> Konstrukt. Unser Programm sieht\n"
      + "dann wie folgt aus:\n"
      + "\n"
      + "<code class=\"Answer4\" lang=\"c\" main=\"main\"><![CDATA[#include \"Answer4.h\"\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"Die Antwort lautet: %i\n\",getAnswer());\n"
      + "  return 0;\n"
      + "}\n"
      + "\n"
      + "int getAnswer(){\n"
      + "  return 42;\n"
      + "}]]></code>\n"
      + "\n"
      + "Wichtig ist hier zu verstehen, daß mit dem <tt>include</tt>, bevor der\n"
      + "Compiler anfängt das Programm zu übersetzen, die Datei <tt\n"
      + ">Answer4.h</tt> komplett wörtlich an der entsprechenden Stelle eingefügt\n"
      + "wird. Dieses Einfügen wird nicht vom eigentlichen Compiler gemacht,\n"
      + "sondern vom einem Programm, das vor dem Compiler den Quelltext\n"
      + "manipuliert, den sogenannten Präprozessor. Der Präprozessor liest die\n"
      + "Zeilen des Quelltext, die mit dem Zeichen <tt>#</tt> beginnen. Diese\n"
      + "nennt man Direktiven. Sie sind nicht Teil des eigentlichen Programms,\n"
      + "sondern erklären dem Präprozessor, wie das eigentliche Programm\n"
      + "zusammenzusetzen ist. \n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Objektdateien und Linker\">\n"
      + "Wer unsere bisherigen  Programme übersetzt hat, wird festgestellt\n"
      + "haben, daß Dateien mit der Endung <tt>.o</tt> ins Dateisystem\n"
      + "geschrieben wurden. Diese Dateien heißen Objektdateien.\n"
      + "Der eigentliche Compiler erzeugt nicht das ausführbare Programm,\n"
      + "sondern Objektdateien. Die Objektdateien werden dann erst durch den\n"
      + "sogenannten Linker zu ausführbaren Dateien zusammengefasst. <p/>\n"
      + "\n"
      + "Mit der Option <tt>-c</tt> kann man den Compiler dazu bringen, nur die\n"
      + "Objektdatei zu erzeugen und nicht anschließend noch das ausführbare\n"
      + "Programm zu erzeugen.<p/>\n"
      + "\n"
      + "Der Compiler kann Objektdateien erzeugen, in denen noch nicht jede\n"
      + "Funktion implementiert ist. Wir können das letzte Programm schreiben,\n"
      + "ohne die Funktion <tt>getAnswer</tt> implementiert zu haben:\n"
      + "\n"
      + "<code class=\"Answer5\" lang=\"c\" ><![CDATA[#include \"Answer4.h\"\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"Die Antwort lautet: %i\n\", getAnswer());\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Mit der Option <tt>-c</tt> kann der Compiler fehlerfrei die\n"
      + "Objektdatei erzeugen.\n"
      + "\n"
      + "<scode>sep@swe10:~/fh/prog3/examples> gcc -c Hello6.c\n"
      + "sep@swe10:~/fh/prog3/examples> ls -l Hello6.*\n"
      + "-rw-r--r--    1 sep      users          84 Sep  3 17:36 Hello6.c\n"
      + "-rw-r--r--    1 sep      users        8452 Sep  3 17:40 Hello6.o\n"
      + "sep@swe10:~/fh/prog3/examples></scode>\n"
      + "\n"
      + "Wollen wir hingegen ein ausführbares Programm erzeugen, so bekommen\n"
      + "wir einen Fehler, und zwar nicht vom Compiler sondern vom Linker. Der\n"
      + "Linker versucht jede deklarierte Funktion mit konkreten Programmcode\n"
      + "aufzulösen. Wenn er einen solchen Code nicht findet, so meldet er\n"
      + "einen Fehler:\n"
      + "\n"
      + "<scode><![CDATA[sep@swe10:~/fh/prog3/examples> gcc Hello6.c\n"
      + "/tmp/ccRKWUqK.o: In function `main':\n"
      + "/tmp/ccRKWUqK.o(.text+0xe): undefined reference to `getHallo(void)'\n"
      + "collect2: ld returned 1 exit status\n"
      + "sep@swe10:~/fh/prog3/examples>]]></scode>\n"
      + "\n"
      + "Um einen solchen Fehler zu produzieren, bedarf es \n"
      + "keiner <em>header</em>-Datei. Wir können in einem Programm eine\n"
      + "Funktion deklarieren ohne sie zu implementieren.\n"
      + "\n"
      + "\n"
      + "<code class=\"Answer6\" lang=\"c\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int getAnswer();\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"Die Antwort lautet: %i\n\", getAnswer());\n"
      + "  return 0;\n"
      + "}\n"
      + "]]></code>\n"
      + "\n"
      + "Wir bekommen wieder einen Fehler des Linkers:\n"
      + "\n"
      + "<scode><![CDATA[sep@swe10:~/fh/c> gcc Hello7.c\n"
      + "/tmp/ccdm3ngO.o: In function `main':\n"
      + "/tmp/ccdm3ngO.o(.text+0xe): undefined reference to `getHallo(void)'\n"
      + "collect2: ld returned 1 exit status\n"
      + "sep@swe10:~/fh/prog3/examples>]]></scode>\n"
      + "\n"
      + "\n"
      + "Der Linker hat  im Gegensatz zum Compiler meherere Dateien als\n"
      + "Eingabe, die er gemeinsam verarbeitet. \n"
      + "\n"
      + "</subsection>\n"
      + "\n"
      + "\n"
      + "<subsection titel=\"Mehrfach inkludieren\">\n"
      + "Genauso wie Funktionen können  auch Variablen in \n"
      + "Headerdateien deklariert sein. \n"
      + "\n"
      + "<code class=\"C1\" lang=\"h\">int x = 42;</code>\n"
      + "\n"
      + "Ebenso können Headerdateien weitere Headerdateien inkludieren:\n"
      + "\n"
      + "<code class=\"C2\" lang=\"h\">#include \"C1.h\"</code>\n"
      + "\n"
      + "Hier kann es zu einem Fehler kommen, wenn beide diese \n"
      + "Headerdateien auf die eine oder andere Art in eine Datei inkludiert wird. \n"
      + "\n"
      + "<code class=\"C3\" lang=\"c\" main=\"main\">#include \"C1.h\"\n"
      + "#include \"C2.h\"\n"
      + "\n"
      + "int main(){};</code>\n"
      + "\n"
      + "Der Versuch dieses Programm zu übersetzen, führt zu einem Fehler.\n"
      + "\n"
      + "<scode><![CDATA[sep@linux:~/fh/c> gcc -Wall -LDIR../obj -o ../bin/C3 ./C3.c\n"
      + "In file included from C2.h:1,\n"
      + "                 from C3.c:2:\n"
      + "C1.h:1: error: redefinition of `x'\n"
      + "C1.h:1: error: `x' previously defined here\n"
      + "strip: '../bin/C3': No such file\n"
      + "sep@linux:~/fh/c>\n"
      + "]]></scode>\n"
      + "\n"
      + "Um solche Fehler, die entstehen, wenn ein und dieselbe Datei mehrfach\n"
      + "inkludiert wird,  von vorneherein auszuschließen, bedient man sich\n"
      + "standardmäßig einer weiteren Direktive. Mit der \n"
      + "Direktive <tt>#define</tt> können Werte definiert werden.  Mit der \n"
      + "Direktive <tt>#ifndef</tt> kann abgefragt werden, ob ein Wert bereits\n"
      + "definiert wurde. Nun kann man in einer Headerdatei eine für diese Datei\n"
      + "spezifische Variable definieren. Üblicher Weise bildet man diese mit zwei\n"
      + "Unterstrichen, gefolgt vom komplett in Großbuchstaben geschriebenen Dateinamen\n"
      + "und der Endung <tt>_H</tt>. Den kompletten Inhalt der Headerdatei klammert man\n"
      + "nun in einer <tt>#ifndef</tt>-Direktive. So wird der Inhalt einer Headerdatei\n"
      + "nur dann eingefügt, wenn die spezifische Variable noch nicht definiert\n"
      + "wurde. Also höchstens einmal.<p/>\n"
      + "\n"
      + "Beherzigen wir diese Vorgehensweise, so erhalten wir statt der \n"
      + "Datei <tt>C1.h</tt> von oben, eine entsprechende Datei, die wir zur\n"
      + "Unterscheidung als <tt>D.h</tt> speichern.\n"
      + "\n"
      + "<code class=\"D1\" lang=\"h\">#ifndef __D1_H\n"
      + "\n"
      + "#define __D1_H ;\n"
      + "\n"
      + "int x = 42;\n"
      + "\n"
      + "#endif /* __D1_H */</code>\n"
      + "\n"
      + "Die Variable, die markiert, ob die Datei schon inkludiert wurde, heißt nach\n"
      + "unserer entsprechenden Konvention <tt>__D1_H</tt>.<p/>\n"
      + "\n"
      + "Diese Datei läßt sich jetzt woanders inkludieren.\n"
      + "<code class=\"D2\" lang=\"h\">#include \"D1.h\"</code>\n"
      + "\n"
      + "Eine mehrfache Inklusion führt jetzt nicht mehr zu einen Fehler.\n"
      + "<code class=\"D3\" lang=\"c\" main=\"main\">#include \"D1.h\"\n"
      + "#include \"D2.h\"\n"
      + "\n"
      + "int main(){\n"
      + "  return 0;\n"
      + "};</code>\n"
      + "\n"
      + "Das Programm läßt sich jetzt fehlerfrei übersetzen:\n"
      + "<scode><![CDATA[sep@linux:~/fh/prog3/examples/src> gcc -o D3 D3.c\n"
      + "sep@linux:~/fh/prog3/examples/src> ./D3]]></scode>\n"
      + "\n"
      + "In größeren C-Projekten kann man diese Vorgehensweise standardmäßig angewendet\n"
      + "sehen. \n"
      + "</subsection>\n"
      + "\n"
      + "\n"
      + "<subsection titel=\"Konstantendeklaration\">\n"
      + "Bisher haben wir die Direktiven des benutzt, um andere Dateien zu inkludieren\n"
      + "und um über die Bedingung <tt>ifndef</tt> zu verhindern, dass eine\n"
      + "header-datei mehrfach inkludiert wird. Eine sehr häufig verwendete Direktive,\n"
      + "erlaubt es konstante Werte zu definieren. Hierzu dient \n"
      + "das <tt>define</tt>, das bereits oben zu wehen war. Der Präprzessor ersetzt\n"
      + "jedesmal wenn ein Wort, das durch ein <tt>define</tt> einen Wrt erhalten hat,\n"
      + "dieses Wort durch den Wert. Der Compiler bekommt dieses Wort also gar nie zu\n"
      + "sehen, sondern nur nuch den Wert. Damit lassen sich nun die \n"
      + "Wörter <tt>true</tt> und <tt>false</tt> als Wahrheitswerte definieren.\n"
      + "\n"
      + "<code lang=\"h\" class=\"Boolean\">#ifndef __BOOLEAN_H\n"
      + "#define __BOOLEAN_H\n"
      + "#define true 1\n"
      + "#define false 0\n"
      + "#endif</code>\n"
      + "\n"
      + "Inkludieren wir diese header-Datei, so können wir die bool'schen Werte\n"
      + "benutzen. \n"
      + "\n"
      + "<code lang=\"c\" class=\"TestBoolean\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "#include \"Boolean.h\"\n"
      + "\n"
      + "int odd(int i){\n"
      + "  if (i%2==1)return true;\n"
      + "  return false;  \n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  if (odd(42)) printf(\"42 ist ungerade\n\");\n"
      + "  else  printf(\"42 ist gerade\n\");\n"
      + "  return 0;\n"
      + "}\n"
      + "]]></code>\n"
      + "\n"
      + "Tatsächlich in großen Projekten werden die Direktiven des Präprozessors\n"
      + "exzessiv genutzt. Das Programm sieht damit manchmal etwas seltsam aus und\n"
      + "erinnert wenig an C. Eigentlich ist der Präprozessor nur nötig, weil der C\n"
      + "Compiler viele Funktionalität nicht selbst anbietet.\n"
      + "</subsection>\n"
      + "</section>\n"
      + "\n"
      + "\n"
      + "\n"
      + "<section titel=\"Kompilierung: Mach mal!\">\n"
      + "Es gibt ein wunderbares kleines Programm mit Namen <tt>make</tt>. Starten wir\n"
      + "dieses Programm einmal mit einem Argument:\n"
      + "\n"
      + "<scode><![CDATA[panitz@fozzie(~)$ make love\n"
      + "make: *** No rule to make target `love'.  Stop.\n"
      + "panitz@fozzie(~)$]]></scode>\n"
      + "\n"
      + "Nun, etwas anderes hätten wir von einem Computer auch kaum erwartet.\n"
      + "Wenn er etwas machen soll, so müssen wir ihm in der Regel sagen, wie er das\n"
      + "machen kann. Hierzu liest das Programm <tt>make</tt> standardmäßig eine Datei\n"
      + "mit Namen <tt>Makefile</tt>. In dieser sind Ziele beschrieben und die\n"
      + "Operationen, die zum Erzeugen dieser Ziele notwendig sind.<p/>\n"
      + "\n"
      + "Ein Ziel ist in der Regel eine Datei, die zu erzeugen ist. Syntaktisch wird\n"
      + "ein Ziel so definiert, daß der Zielname in der ersten Spalte einer Zeile\n"
      + "steht. Ihm folgt ein Doppelpunkt, dem auf derselben Zeile Ziele aufgelistet\n"
      + "folgen, die zuerst erzeugt werden müssen, bevor dieses Ziel gebaut werden\n"
      + "kann. Dann folgt in den folgenden Zeilen durch einen Tabulatorschritt\n"
      + "eingerückt, welche Befehle zum Erreichen des Ziels ausgeführt werden müssen. \n"
      + "Eine einfache Makedatei zum Bauen des Programms <tt>HalloFreunde</tt> sieht\n"
      + "entsprechend wie folgt aus.\n"
      + "\n"
      + "<code class=\"makeHalloFreunde\" lang=\"\">HalloFreunde: HalloFreunde.o \n"
      + " gcc -o HalloFreunde HalloFreunde.o \n"
      + "\n"
      + "HalloFreunde.o: HalloFreunde.c\n"
      + " gcc -c HalloFreunde.c</code>\n"
      + "\n"
      + "Es gibt in dieser Makedatei zwei Ziele: die ausführbare \n"
      + "Datei <tt>HalloFreunde</tt> und die Objektdatei <tt>HalloFreunde.o</tt>. Zum\n"
      + "Erzeugen der Objektdatei, muß die Datei <tt>HalloFreunde.c</tt> vorhanden\n"
      + "sein, zum Erzeugen der ausführbaren Datei, muß erst die Objektdatei generiert\n"
      + "worden sein. Wir können jetzt <tt>make</tt> bitten, \n"
      + "unsere <tt>HalloFreunde</tt>-Applikation zu bauen. Die Makedatei \n"
      + "nicht <tt>Makefile</tt> heißt, welches die standardmäßig \n"
      + "von <tt>make</tt> als Steuerdatei gelesene Datei ist, müssen \n"
      + "wir <tt>make</tt> mit der Option <tt>-f</tt> als Argument mitgeben, in welcher\n"
      + "Datei die Ziele zum Machen definiert sind.<p/>\n"
      + "\n"
      + "Für die Erzeugung des Programms <tt>HalloFreunde</tt> reicht also folgender\n"
      + "Aufruf von <tt>make</tt>:\n"
      + "\n"
      + "\n"
      + "<scode><![CDATA[sep@pc216-5:~/fh/cpp/student/src> make -f makeHalloFreunde\n"
      + "gcc    -c -o HalloFreunde.o HalloFreunde.c\n"
      + "gcc -o HalloFreunde HalloFreunde.o\n"
      + "sep@pc216-5:~/fh/cpp/student/src> ./HalloFreunde\n"
      + "hello world\n"
      + "sep@pc216-5:~/fh/cpp/student/src> make -f makeHalloFreunde\n"
      + "make: »HalloFreunde« ist bereits aktualisiert.\n"
      + "sep@pc216-5:~/fh/cpp/student/src>]]></scode>\n"
      + "\n"
      + "Gibt man <tt>make</tt> nicht als zusätzliches Argument an, welches Ziel zu\n"
      + "bauen ist, so baut <tt>make</tt> das erste in der Makedatei definierte \n"
      + "Ziel.<p/>\n"
      + "\n"
      + "Die wahre Stärke von <tt>make</tt> ist aber, daß nicht stur alle Schritte zum\n"
      + "Erzeugen eines Ziels durchgeführt werden, sondern anhand der Zeitstempel der\n"
      + "Dateien geschaut wird, ob es denn überhaupt notwendig ist, bestimmte Ziele neu\n"
      + "zu bauen, oder ob sie schon aktuell im Dateisystem vorliegen. So kommt es, daß\n"
      + "beim zweiten Aufruf von <tt>make</tt> oben, nicht erneut kompiliert\n"
      + "wurde. <p/>\n"
      + "\n"
      + "Um gute und strukturierte Makedateien zu schreiben, kennt <tt>make</tt> eine\n"
      + "ganze Anzahl weiterer Konstrukte. Zuvorderst Kommentare. Kommantarzeilen\n"
      + "beginnen mit einem Gattersymbol <tt>#</tt>. Dann lassen sich Konstanten\n"
      + "definieren. Es empfiehlt sich in einer Makedatei alle Pfade und Werkzeuge, wie\n"
      + "z.B. der benutzte Compiler als Konstante zu definieren, damit diese leicht\n"
      + "global geändert werden können. Schließlich lassen sich noch allgemeine Regeln,\n"
      + "wie man von einem Dateitypen zu einem anderen Dateitypen gelangt,\n"
      + "definieren; z.B. das der Aufruf <tt>gcc -c</tt> zu benutzen ist, für eine \n"
      + "C-Datei eine Objektdatei zu generieren.<p/>\n"
      + "\n"
      + "Eine typische Makedatei, die all diese Eigenschaften ausnutzt,\n"
      + " sieht für ein C-Projekt dann wie folgt aus.\n"
      + "<code class=\"Makefile\" lang=\"\"><![CDATA[#der zu benutzende C++ Compiler\n"
      + "CC = gcc\n"
      + "EXE = TestReadRoman\n"
      + "\n"
      + "#das Hauptprogramm\n"
      + "TestReadRoman: TestReadRoman.o ReadRoman.o\n"
      + " $(CC) -o TestReadRoman TestReadRoman.o ReadRoman.o\n"
      + "\n"
      + "#allgemeine Regel zum Aufruf des Compilers zum generieren\n"
      + "#der Objektdatei aus der Quelltextdatei\n"
      + ".c.o:\n"
      + " $(CC) -c $<\n"
      + "\n"
      + "#alles wieder löschen\n"
      + "clean:\n"
      + " rm $(EXE)\n"
      + " rm *.o\n"
      + "\n"
      + "#just for fun\n"
      + "love:\n"
      + " @echo \"I do not know, how to make love.\";\n"
      + "]]></code>\n"
      + "\n"
      + "Für eine genaue Beschreibung der Möglichkeiten einer Makedatei konsultiere man\n"
      + "die Dokumentation von <tt>make</tt>. Nahezu alle C++-Projekte \n"
      + "benutzen <tt>make</tt> zum Bauen des Projektes. Für Javaprojekte\n"
      + "hat sich hingegen das\n"
      + "Programm <exlink address=\"http://ant.apache.org/\"\n"
      + "><tt>ant</tt></exlink> durchgesetzt.<p/>\n"
      + "\n"
      + "Auch die verschiedenen Versionen dieses Skripts werden mit Hilfe \n"
      + "von <tt>make</tt> erzeugt.\n"
      + "\n"
      + "<aufgabe blatt=\"4\">Kopieren Sie sich den Quelltextordner dieses Skripts und rufen Sie\n"
      + "die darin enthaltene obige Makefile-Datei auf. \n"
      + "Rufen Sie dann <tt>make</tt> direkt nocheinmal auf.\n"
      + "Ändern Sie anschließend die\n"
      + "Datei <tt>ReadRoman.c</tt> und starten Sie erneut <tt>make</tt>. Was\n"
      + "beobachten Sie in Hinblick auf <tt>TestReadRoman.o</tt>. Starten Sie \n"
      + "schließlich <tt>make</tt> mit dem Ziel <tt>love</tt>.\n"
      + "</aufgabe>\n"
      + "</section>\n"
      + "\n"
      + "\n"
      + "<section titel=\"Dokumentation\">\n"
      + "<subsection titel=\"Kommentare\">\n"
      + "Schön wäre es sicher, wenn ein Programmtext immer so klar und eindeutig wäre,\n"
      + "dass man sofort ohne weitere Hilfe erkennen könnte, was die einzelnen\n"
      + "Programmzeilen ausdrücken und bewirken. Davon ist in der Regel nicht\n"
      + "auszugehen. Daher ist es unerläßlich, dass man im Programmtext Kommentarzeilen\n"
      + "schreibt. Diese helfer Kollegen und einem selbst mit etwas zeitlichen Abstand\n"
      + "das Programm weiterhin zu verstehen.\n"
      + "\n"
      + "In C gibt es mitlerweile zwei Arten, Kommentare im Programmtext zu schreiben.\n"
      + "Für einzeilige Kommentare gibt es den doppelten Schrägstrich. Von diesem an\n"
      + "wird der Rest der Zeile als Kommentar betrachtet.\n"
      + "\n"
      + "Längere Kommentarblöcke werden mit den Zeichen <tt>/*</tt> begonnen und enden\n"
      + "mit den Zeichen <tt>*/</tt>. Hier zwischen können beliebig viele Zeichen in\n"
      + "mehreren Zeilen als Kommentar stehen.\n"
      + "\n"
      + "\n"
      + "Ein kleines Beispiel eines kommentierten Programms.\n"
      + "<code class=\"Comments\" main=\"main\" lang=\"c\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + " /*\n"
      + "  Berechnet die Fakultät vom Eingabeparameter.\n"
      + "  Der Eingabeparameter wird als nicht-negative Zahl erwartet.\n"
      + "  Ansonsten kann es zur Nichtterminierung der Funktion kommen.\n"
      + "  */\n"
      + "  int f(int n){\n"
      + "  // Lösung iterativ mit einer for-Schleife\n"
      + "\n"
      + "  int result=1; //akkumuliert das Ergebnis\n"
      + "  int i=n;      //Laufvariable für die Schleife\n"
      + "  for (;i>0;i++){\n"
      + "    result = result*i;  \n"
      + "  }\n"
      + "  return result;\n"
      + "}]]></code>\n"
      + "\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Benutzung von Doxygen\">\n"
      + "Heutzutage schreibt niemand mehr ein einzelnen Programm ganz allein. In der\n"
      + "Regel wird komplexere Software entwickelt. Die meiste Software wird damit\n"
      + "nicht einmal ein Programm sein, sondern eine  Bibliothek, die in anderen\n"
      + "Softwareprodukten verwendet wird.<p/>\n"
      + "Um die von einer Bibliothek bereitgestellte Funktionalität sinnvoll verwenden\n"
      + "zu können, ist diese auf einheitliche Weise zu dokumentieren. Zur\n"
      + "Dokumentation von C-Bibliotheken kann man das \n"
      + "Werkzeug <exlink address=\"http://www.stack.nl/~dimitri/doxygen/index.html\"\n"
      + ">Doxygen</exlink> einsetzen. Dieses Programm liest die C Kopfdateien und\n"
      + "generiert eine umfassende Dokumentation in verschiedenen Formaten. Am\n"
      + "häufigsten wird dabei wahrscheinlich die HTML-Dokumentation verwendet. \n"
      + "\n"
      + "Doxygen kommt mit einem Kommandozeilenprogramm <tt>doxygen</tt>. Dieses\n"
      + "erwartet als Eingabe eine Steuerdatei zur Konfiguration. In dieser\n"
      + "Konfigurationsdatei können eine große Menge von Parametern eingestellt werden,\n"
      + "wie die Sprache, in der die Dokumentation erstellt werden soll oder auch den\n"
      + "Projektnamen, des zu dokumentierenden Projekts. Zum Glück \n"
      + "ist <tt>doxygen</tt> in der Lage, sich selbst eine solche Konfigurationsdatei\n"
      + "zu generieren, die man dann manuell nacheditieren kann. Hierzu benutzt man das\n"
      + "Kommandozeilenargument <tt>-g</tt>  von <tt>doxygen</tt>.\n"
      + "<p />\n"
      + "\n"
      + "Ein kurzer Start mit <tt>doxygen</tt> sieht also wie folgt aus:\n"
      + "<itemize>\n"
      + "<item>Generierung einer Konfigurationsdatei mit:\n"
      + "<scode><![CDATA[sep@pc216-5:~/fh/c> doxygen -g MeinProjekt\n"
      + "\n"
      + "Configuration file `MeinProjekt' created.\n"
      + "\n"
      + "Now edit the configuration file and enter\n"
      + "\n"
      + "  doxygen MeinProjekt\n"
      + "\n"
      + "to generate the documentation for your project\n"
      + "\n"
      + "sep@pc216-5:~/fh/c>]]></scode></item>\n"
      + "<item>Anschließend editiert man die erzeugte Datei <tt>MeinProjekt</tt>. Für\n"
      + "den Anfang sei zu empfehlen <tt>EXTRACT_ALL = YES</tt> zu setzen. Selbst wenn\n"
      + "keine eigentlich für Doxygen gedachte Dokumentation im Quelltext steht, werden\n"
      + "alle Programmteile in der Dokumentation aufgelistet.</item>\n"
      + "<item>Die Eigentliche Generierung der Dokumentation.\n"
      + "<scode><![CDATA[sep@pc216-5:~/fh/c> doxygen  MeinProjekt\n"
      + "sep@pc216-5:~/fh/c>]]></scode></item>\n"
      + "</itemize> \n"
      + "\n"
      + "Jetzt befindet sich die generierte Dokumentation im in der Konfigurationsdatei\n"
      + "angegebenen Ausgabeordner.\n"
      + "</subsection> \n"
      + "\n"
      + "<aufgabe  blatt=\"4\">Laden Sie sich die kompletten Quelltextdateien dieses Skriptes von\n"
      + "der Webseite und generieren Sie mit <tt>Doxygen</tt> eine Dokumentation für\n"
      + "diese. </aufgabe>\n"
      + "\n"
      + "<subsection titel=\"Dokumentation des Quelltextes\">\n"
      + "Bisher konnte sich <em>Doxygen</em> lediglich auf den Quelltext beziehen, um\n"
      + "eine Dokumentation zu erzeugen. Natürlich reicht das nicht aus. Daher kann man\n"
      + "im Quelltext Kommentare anbringen, die <em>Doxygen</em> auswertet. Es gibt\n"
      + "verschiedene Syntax hierzu, z.B. die klassische aus C bekannte Art zu\n"
      + "kommentieren:\n"
      + "\n"
      + "<code lang=\"h\" class=\"DoxygenMe\">/**\n"
      + "  Dies ist eine einfache Funktion.\n"
      + "Sie ist in der Lage ganz tolle Dinge zu tun.\n"
      + " */\n"
      + "void f();</code>\n"
      + "\n"
      + "In diesen Kommentarblöcken, die über dem zu dokumentierenden Code stehen,\n"
      + "können mit dem Backslashsymbol bestimmte Attribute gesetzt werden. \n"
      + "So gibt es z.B. das Attribut <tt>\\param</tt> für einen Funktionsparameter oder\n"
      + "das Attribut <tt>\return</tt> für das Funktionsergebnis.\n"
      + "<code lang=\"h\" class=\"DoxygenMe\" sequel=\"true\">/**\n"
      + "  Die Additionsfunktion.\n"
      + "  Sie kann dazu benutzt werden, um einen Funktionszeiger \n"
      + "  auf die Addition\n"
      + "  zur Verfügung zu haben. Sie ruft in ihrem Rumpf lediglich den\n"
      + "  Additionsoperator auf.\n"
      + "\n"
      + "  \\param x der erste Operand.\n"
      + "  \\ param y der zweite (rechte) Operand.\n"
      + "  \\return die Summe der beiden Operanden.\n"
      + "*/\n"
      + "int add(int x, int y);</code>\n"
      + "\n"
      + "<aufgabe  blatt=\"4\">Betrachten Sie, die für die \n"
      + "Funktionen <tt>f</tt> und <tt>add</tt> in der letzten Aufgabe generierte\n"
      + "Dokumentation. </aufgabe>\n"
      + "\n"
      + "<em>Doxygen</em> kennt viele solcher Attribute und viele verschiedene mächtige\n"
      + "unterschiedliche Weisen der Dokumentation. Zum Glück \n"
      + "ist <em>Doxygen</em> selbst recht gut erklärt, so daß mit dem hier gegebenen\n"
      + "Einstieg es hoffentlich leicht möglich ist, sich mit dem Programm\n"
      + "auseinanderzusetzen. \n"
      + "\n"
      + "<aufgabe  blatt=\"4\">Beschäftigen Sie sich mit der Dokumentation \n"
      + "von <em>Doxygen</em> und testen einige der darin beschriebenen Möglichkeiten\n"
      + "der Dokumentation.</aufgabe>\n"
      + "</subsection>\n"
      + "\n"
      + "\n"
      + "\n"
      + "</section>\n"
      + "\n"
      + "<section titel=\"Debuggen\">\n"
      + "Wie Ernie in der Sesamstraße bereits gesungen hat: <em>Jeder macht mal Fehler\n"
      + "ich und du</em>; so müssen wir davon ausgehen, daß unsere Programme nicht auf\n"
      + "Anhieb die gewünschte Funktionalität bereitstellen. Insbesondere da C uns\n"
      + "relativ viel Möglichkeiten und Freiheiten in der Art der Programmierung\n"
      + "ermöglicht, läßt es uns auch die Freiheiten, viele Fehler zu machen.<p/>\n"
      + "\n"
      + "Um einen Fehler aufzuspüren können wir auf zwei Techniken zurückgreifen:\n"
      + "<itemize>\n"
      + "  <item>Logging: Während der Ausführung wird in bestimmten Programmzeilen eine\n"
      + "  Statusmeldung in eine Log-Datei geschrieben. Diese läßt sich hinterher\n"
      + "  analysieren. Die einfachste Form des Loggings ist, ab und zu eine Meldung\n"
      + "  auf die Konsole auszugeben.</item>\n"
      + "  <item>Debuggen: mit Hilfe eines Debuggers läßt sich schrittweise das\n"
      + "  Programm ausführen und dabei in den Speichern schauen.</item>\n"
      + "</itemize>\n"
      + "\n"
      + "Der Begriff <em>debuggen</em>, den man wörtlich \n"
      + "mit <em>Entwanzen</em> übersetzen könnte, bezieht sich auf die Benutzung des\n"
      + "Wortes <em>bug</em> für Macken in einem technischen System. Der Legende nach\n"
      + "stammt diese Benutzung des Wortes <em>bug</em> aus der Zeit der ersten\n"
      + "Rechner,\n"
      + "die noch nicht mit Halbleitern geschaltet haben, sondern mit Relais, ähnlich,\n"
      + "wie man sie von Flipperautomaten kennt. Es soll einmal zu einem Fehler im\n"
      + "Programmablauf gekommen sein, der sich schließlich darauf zurückführen ließ,\n"
      + "daß ein Käfer zwischen ein Relais geklettert war. Eine schöne Ankdote, die\n"
      + "leider falsch ist, denn aus schon früheren Dokumenten geht hervor, daß der\n"
      + "Begriff <em>bug</em> schon im 19. Jahrhundert für technische Fehler\n"
      + "gebräuchlich war.\n"
      + "<p/>\n"
      + "\n"
      + "\n"
      + "Um ein Programm mit einem Debugger zu durchlaufen, ist es notwenig, daß der\n"
      + "Debugger Informationen im ausführbaren Code findet, die sich auf den Quelltext\n"
      + "beziehen. Dieses sind umfangreiche Informationen.  Der <tt>gcc</tt> generiert\n"
      + "die notwendige Information in die Objektdateien, wenn man ihn mit der \n"
      + "Option <tt>-g</tt> startet.\n"
      + "\n"
      + "\n"
      + "<subsection titel=\"Debuggen auf der Kommandozeile\">\n"
      + "Die rudimentärste Art des Debuggens ist mit Hilfe des \n"
      + "Kommandozeilenprogramms  <tt>gdb</tt>. Wir wollen das einmal\n"
      + "ausprobieren. Hierzu brauchen wir natürlich ein entsprechendes Programm,\n"
      + "welches hier zunächst definiert sei. Es handelt sich dabei um ein Programm\n"
      + "zur Konvertierung von als Strings vorliegenden römischen Zahlen in die\n"
      + "entsprechende arabische Zahl als <tt>int</tt>. \n"
      + "\n"
      + "<code class=\"ReadRoman\" lang=\"h\" \n"
      + "><![CDATA[#ifndef READ_ROMAN__H\n"
      + "#define  READ_ROMAN__H ;\n"
      + "\n"
      + "int romanToInt(char* roman);\n"
      + "#endif]]></code>\n"
      + "\n"
      + "Eine rudimentäre Implementierung dieser Kopfdatei:\n"
      + "\n"
      + "<code class=\"ReadRoman\" lang=\"c\"\n"
      + " compileoptions=' echo -g '\n"
      + "><![CDATA[#include \"ReadRoman.h\"\n"
      + "\n"
      + "int romanCharToInt(char c){\n"
      + "  switch (c){\n"
      + "    case 'I': return 1;\n"
      + "    case 'V': return 5;\n"
      + "    case 'X': return 10;\n"
      + "    case 'L': return 50;\n"
      + "    case 'C': return 100;\n"
      + "    case 'D': return 500;\n"
      + "    case 'M': return 1000;\n"
      + "  }\n"
      + "  return -1;\n"
      + "}\n"
      + "\n"
      + "int romanToInt(char* roman){\n"
      + "  int result=0;\n"
      + "  int last=0;\n"
      + "  char* i;\n"
      + "  for (i=roman;*i != '\\0';i++){\n"
      + "    int current=romanCharToInt(*i); \n"
      + "    if (current>last) result = result-2*last;\n"
      + "    result=result+current;\n"
      + "    last=current;\n"
      + "  }  \n"
      + "  return result;\n"
      + "}]]></code>\n";
    String skript5 = 
        "\n"
      + "Wir benutzen hier schon ein paar wenige C Eigenschaften, die uns aber\n"
      + "vorerst nicht stören sollen und nicht weiter hinterfragt werden sollen. \n"
      + "Es folgt ein minimaler Test dieses Programms:\n"
      + "\n"
      + "<code class=\"TestReadRoman\" lang=\"c\" \n"
      + "  main=\"gcc -o TestReadRoman ../obj/TestReadRoman.o ../obj/ReadRoman.o\"\n"
      + " compileoptions=\" echo -g \"\n"
      + "><![CDATA[#include \"ReadRoman.h\"\n"
      + "#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"romanToInt(\\\"MMMCDXLIX\\\") = %i\n\",romanToInt(\"MMMCDXLIX\")); \n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "<aufgabe  blatt=\"4\">Übersetzen Sie das Programm mit der <tt>-g</tt>-Option\n"
      + "des <tt>gcc</tt> und lassen Sie das Programm ausführen.</aufgabe>\n"
      + "\n"
      + "Jetzt können sie den <tt>gnu debugger</tt> mit dem \n"
      + "Programm <tt>TestReadRoman</tt> aufrufen. Sie geraten in einen\n"
      + "Kommandozeileninterpreter des Debuggers. Der Debugger kennt eine Reihe\n"
      + "Kommandos, über die er mit dem Kommando <tt>help</tt> gerne informiert:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc216-5:~/fh/cpp/student/bin> gdb TestReadRoman\n"
      + "GNU gdb 6.1\n"
      + "Copyright 2004 Free Software Foundation, Inc.\n"
      + "GDB is free software, covered by the GNU General Public License, and you are\n"
      + "welcome to change it and/or distribute copies of it under certain conditions.\n"
      + "Type \"show copying\" to see the conditions.\n"
      + "There is absolutely no warranty for GDB.  Type \"show warranty\" for details.\n"
      + "This GDB was configured as \"i586-suse-linux\"...\n"
      + "  Using host libthread_db library \"/lib/tls/libthread_db.so.1\".\n"
      + "\n"
      + "(gdb) help\n"
      + "List of classes of commands:\n"
      + "\n"
      + "aliases -- Aliases of other commands\n"
      + "breakpoints -- Making program stop at certain points\n"
      + "data -- Examining data\n"
      + "files -- Specifying and examining files\n"
      + "internals -- Maintenance commands\n"
      + "obscure -- Obscure features\n"
      + "running -- Running the program\n"
      + "stack -- Examining the stack\n"
      + "status -- Status inquiries\n"
      + "support -- Support facilities\n"
      + "tracepoints -- Tracing of program execution without stopping the program\n"
      + "user-defined -- User-defined commands\n"
      + "\n"
      + "Type \"help\" followed by a class name for a list of commands in that class.\n"
      + "Type \"help\" followed by command name for full documentation.\n"
      + "Command name abbreviations are allowed if unambiguous.\n"
      + "(gdb)]]></scode>\n"
      + "\n"
      + "Das naheliegendste Kommando ist das Kommando <tt>run</tt>. Es führt dazu, daß\n"
      + "das Programm ausgeführt wird.\n"
      + "\n"
      + "<scode><![CDATA[(gdb) run\n"
      + "Starting program: /home/sep/fh/cpp/student/bin/TestReadRoman\n"
      + "3449\n"
      + "\n"
      + "Program exited normally.\n"
      + "(gdb)]]></scode>\n"
      + "\n"
      + "Wir wollen aber nicht, daß das Programm einmal komplett ausgeführt wird,\n"
      + "sondern schrittweise die Ausführung nachverfolgen. Hierzu müssen wir einen\n"
      + "sogenannten <em>breakpoint</em> setzen. Wir können diesen auf die erste Zeile\n"
      + "des Programms setzen:\n"
      + "<scode><![CDATA[(gdb) break 4\n"
      + "Breakpoint 1 at 0x804839c: file TestReadRoman.c, line 4.\n"
      + "(gdb)]]></scode>\n"
      + "\n"
      + "Wenn wir jetzt <tt>run</tt> sagen, stoppet der Debugger in der Zeile vier:\n"
      + "\n"
      + "<scode><![CDATA[(gdb) run\n"
      + "Starting program: /home/sep/fh/c/tutor/src/TestReadRoman\n"
      + "\n"
      + "Breakpoint 1, main () at TestReadRoman.c:4\n"
      + "4         printf(\"romanToInt(\\\"MMMCDXLIX\\\") = %i\n\",romanToInt(\"MMMCDXLIX\"));\n"
      + "(gdb)]]></scode>\n"
      + "\n"
      + "Jetzt können wir z.B. Zeile für Zeile das Programm vom Debugger ausführen\n"
      + "lassen. Hierzu gibt es den Befehl <tt>step</tt>:\n"
      + "\n"
      + "<scode><![CDATA[(gdb) step\n"
      + "romanToInt (roman=0x80485b8 \"MMMCDXLIX\") at ReadRoman.c:17\n"
      + "17        int result=0;\n"
      + "(gdb) step\n"
      + "18        int last=0;\n"
      + "(gdb) step\n"
      + "20        for (i=roman;*i != '\\0';i++){\n"
      + "(gdb)]]></scode>\n"
      + "Wie man sieht gibt der Debugger immer die aktuelle Zeile aus, und beim\n"
      + "Funktionsaufruf auch den Wert des Parameters. Wollen wir zusätzlich in den\n"
      + "Speicher schauen, so gibt es den Befehl <tt>print</tt>, der dazu da ist, sich\n"
      + "den Wert einer Variablen anzuschauen:\n"
      + "\n"
      + "<scode><![CDATA[(gdb) step\n"
      + "21          int current=romanCharToInt(*i);\n"
      + "(gdb) step\n"
      + "romanCharToInt (c=77 'M') at ReadRoman.c:4\n"
      + "4         switch (c){\n"
      + "(gdb) step\n"
      + "11          case 'M': return 1000;\n"
      + "(gdb) step\n"
      + "14      }\n"
      + "(gdb) step\n"
      + "romanToInt (roman=0x80485b8 \"MMMCDXLIX\") at ReadRoman.c:22\n"
      + "22          if (current>last) result = result-2*last;\n"
      + "(gdb) step\n"
      + "23          result=result+current;\n"
      + "(gdb) step\n"
      + "24          last=current;\n"
      + "(gdb) print result\n"
      + "$1 = 1000\n"
      + "(gdb)]]></scode>\n"
      + "\n"
      + "Wenn auch mühselig, so können wir so doch ganz genau verfolgen, wie das\n"
      + "Programm arbeitet. \n"
      + "\n"
      + "<aufgabe  blatt=\"4\">Spielen Sie die  Session des \n"
      + "Debuggers <tt>gdb</tt> aus dem Skript einmal nach und\n"
      + "experimentieren sie mit den verschiedenen Befehlen des Debuggers.</aufgabe>\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Graphische Debugging Werkzeuge\">\n"
      + "Aufbauend auf die Möglichkeiten des Debuggens über die\n"
      + "Kommandozeilenschnittstelle, lassen sich leicht konfortable graphische\n"
      + "Debugger implementieren. Ein recht schöner solcher Debugger ist das \n"
      + "Programm <tt>ddd</tt>. Hier können Breakpoints mit der Maus im Programmtext\n"
      + "gesetzt werden und die verschiedenen Speicherbelegungen betrachtet\n"
      + "werden. Abbildung <ref name=\"ddd\"/> zeigt das Programm in Aktion.\n"
      + "\n"
      + "<bild name=\"ddd\" pdfscale=\"0.6\" scale=\"0.6\"\n"
      + "caption=\"ddd in Aktion.\"\n"
      + "/> \n"
      + "\n"
      + "</subsection>\n"
      + "<aufgabe  blatt=\"4\">Üben Sie den Umgang mit dem  Debugger <tt>ddd</tt> anhand des\n"
      + "Programms <tt>TestReadRoman</tt>. \n"
      + "\n"
      + "</aufgabe>\n"
      + "</section>\n"
      + "\n"
      + "\n"
      + "\n"
      + "<section titel=\"Programmierumgebung: Arbeiten mit Eclipse\">\n"
      + "In großen Projekten existieren viele hundert Quelltextdateien und\n"
      + "Header-Dateien, die alle zum Gesamtprogramm beitragen. Viele Bibliotheken\n"
      + "werden benutzt. Es ist dann etwas mühseelig nur mit einem Editor und der\n"
      + "Kommandozeile zu arbeiten. Um hier die Arbeit zu erleichtern gibt es\n"
      + "Entwicklungsumgebungen. Entwicklungsumgebungen enthalten in der Regel \n"
      + "einen integrierten Editor, der eine gute Syntaxhervorhebung durchführt,\n"
      + "öffnende und schließende Klammern paart und Fehler direkt im Programmtext\n"
      + "markiert. Sie unterstützen den Build-Prozess und übersetzen in der Regel das\n"
      + "ganze Projekt bei einer neu abgespeicherten Änderung, so dass Fehler \n"
      + "sofort erkannt werden können.\n"
      + "\n"
      + "Eine recht mächtige Programmierumgebung ist <em>eclipse</em>. Sie \n"
      + "ist frei verfügbar und kann \n"
      + "unter <exlink address=\"http://download.eclipse.org/\"\n"
      + ">diesen Link</exlink> heruntergeladen werden. <em>eclipse</em> ist\n"
      + "ursprünglich eine von <em>IBM</em> zur Entwicklung von Javaprojekten gedachte\n"
      + "Entwicklungsplatform.  <em>eclipse</em> ist in Java entwickelt. \n"
      + "Daher braucht man, um mit <em>eclipse</em> arbeiten zu können auch \n"
      + "die <exlink address=\"http://java.sun.com/javase/downloads/index.jsp\"\n"
      + ">Java-Laufzeitumgebung</exlink>.\n"
      + " \n"
      + "\n"
      + "Durch den stark komponentenbasierten Aufbau \n"
      + "der Architektur von <em>eclipse</em> ist es möglich Zusätze zu Entwickeln, die\n"
      + "aus <em>eclipse</em> eine Entwicklungsumgebung für Projekte in anderen\n"
      + "Sprachen als Java zu benutzen. Ein solches sogenanntes Plugin ermöglicht die C\n"
      + "und C++-Entwicklung mit <em>eclipse</em>. Es ist \n"
      + "dies das Pugin <exlink address=\"http://www.eclipse.org/cdt/\">CDT</exlink>.\n"
      + "\n"
      + "Eclipse mit CDT ist auf unseren Übungsrechnern installiert. Wenn man eclipse\n"
      + "startet, wird zumeist nach einem Arbeitsordner gefragt. In diesem Ordner will \n"
      + "eclipse alle seine Projekte verwalten.\n"
      + "\n"
      + "Zum Start mit eclipse ist zunächst ein neues Projekt zu definieren. Hierzu\n"
      + "wähle man im Menu den Punkt: <em>new managed c project</em>. Einem solchem\n"
      + "Projekt können nnun neue <tt>.c</tt> und <tt>.h</tt> Quelltextdateien zugefügt\n"
      + "wreden, die in einem Editorfenster ediert werden können. In der Regel versucht\n"
      + "eclipse sobald eine Datei neu gespeichert wird, mit dem C compiler das Projekt\n"
      + "neu zu bauen und zeigt eventuelle Fehler direkt an.\n"
      + "\n"
      + "<aufgabe blatt=\"4\">Legen sie ein <em>eclipse</em> Projekt an und \n"
      + "Programmieren die nächste Aufgaben dieses Blattes \n"
      + "mit <em>eclipse</em>.</aufgabe>  \n"
      + "\n"
      + "</section>\n"
      + "</kapitel>\n"
      + "\n"
      + "<kapitel titel=\"Daten\"><label name=\"datachapter\"></label>\n"
      + "Bisher haben wir außer Zahlen und direkt ausgegebenen Zeichenketten noch keine\n"
      + "Daten in unseren Programmen verarbeitet. Daten sind natürlich das A und O der\n"
      + "Programmierung. Das spiegelt sich auch in der historischen Entwicklung \n"
      + "von Programmiersprachen wieder. Während die Grundkonzepte, wie Funktionen,\n"
      + "Ausdrücke und Schleifenbefehle sich schon vor mehreren Jahrzehnten in allen\n"
      + "Programmiersprachen auf ähnliche Weise befanden, sind sämtliche Fortschritte\n"
      + "in der Programmierung im Bezug auf Definition und Modifikation von Daten\n"
      + "bezogen. Objektorientierte Programmierung zeichnet sich als eine\n"
      + "datenzentrierte Programmierung aus. Aber auch in funktionalen\n"
      + "Programmiersprachen liegt der Fortschritt insbesondere in den sogenannten\n"
      + "algebraischen Datentypen, die es erlauben, strukturierte Daten einfach zu\n"
      + "definieren, zu erzeugen und zu bearbeiten. Nicht von ungefähr ist mit \n"
      + "XML <cite label=\"xml1.1\"/> eine \n"
      + "der jüngsten Sprachen, die in der Informatik  definiert wurde, eine\n"
      + "Sprache zum Beschreiben strukturierter Daten entstanden. \n"
      + "\n"
      + "In diesem Kapitel werden wir die Möglichkeiten der Definition und Verarbeitung\n"
      + "von Daten in C kennenlernen.\n"
      + "\n"
      + "<section titel=\"Basistypen\">\n"
      + "Bevor wir uns strukturierten Daten widmen können, betrachten wir noch einmal\n"
      + "die primitiven Basistypen zur Zahlendarstellung.\n"
      + "Bisher haben wir uns beim Rechnen auf einen Typen für ganze Zahlen beschränkt,\n"
      + "den Typ <tt>int</tt>. C stellt vielerlei Typen zur\n"
      + "Repräsentation von Zahlen zur Verfügung. \n"
      + "<p/>\n"
      + "Die im Folgenden vorgestellten Typen nennt man primitive Typen. Sie\n"
      + "sind fest von C vorgegeben.  \n"
      + "\n"
      + "<p/>\n"
      + "Um Daten der primitiven Typen aufschreiben zu können, gibt es jeweils\n"
      + "Literale für die Werte dieser Typen. Für den Typ <tt>int</tt> haben wir\n"
      + "einfach die Zahlen als Literale hinschreiben können.\n"
      + "\n"
      + "\n"
      + "<subsection titel=\"Zahlenmengen in der Mathematik\">\n"
      + "In der Mathematik sind wir gewohnt, mit verschiedenen Mengen von Zahlen zu\n"
      + "arbeiten:\n"
      + "\n"
      + "<itemize>\n"
      + "<item><b>natürliche Zahlen</b><w/> <setN/>: Eine induktiv definierbare Menge\n"
      + "mit einer kleinsten Zahl, so daß es für jede Zahl eine eindeutige\n"
      + "Nachfolgerzahl gibt.</item>\n"
      + "<item><b>ganze Zahlen</b><w/> <setZ/>: Die natürlichen Zahlen erweitert um die\n"
      + "mit einem negativen Vorzeichen behafteten Zahlen, die sich ergeben, wenn man\n"
      + "eine größere Zahl von einer natürlichen Zahl abzieht.</item>\n"
      + "<item><b>rationale Zahlen</b><w/> <setQ/>: Die ganzen Zahlen erweitert um\n"
      + "Brüche, die sich ergeben, wenn man eine Zahl durch eine Zahl teilt, von der\n"
      + "sie kein Vielfaches ist.</item>\n"
      + "<item><b>reelle Zahlen</b><w/> <setR/>: Die ganzen Zahlen erweitert um\n"
      + "irrationale Zahlen, die sich z.B.<w/>aus der Quadratwurzel von Zahlen \n"
      + "ergeben, die nicht das Quadrat einer rationalen Zahl sind. </item>\n"
      + "<item><b>komplexe Zahlen</b><w/> <setC/>: Die reellen Zahlen erweitert um\n"
      + "imaginäre Zahlen, wie sie benötigt werden, um einen Wurzelwert\n"
      + "für  negative Zahlen darzustellen.</item>\n"
      + "</itemize>\n"
      + "\n"
      + "Es gilt folgende Mengeninklusion zwischen diesen Mengen:<br/>\n"
      + "<center><setN/><subset/><setZ/><subset/><setQ/><subset/><setR/><subset/><setC/>\n"
      + "</center>\n"
      + "\n"
      + "Da bereits <setN/> nicht endlich ist, ist keine dieser Mengen endlich. \n"
      + "</subsection>\n"
      + "\n"
      + "\n"
      + "\n"
      + "<subsection titel=\"Zahlenmengen im Rechner\">\n"
      + "Da wir nur von einer endlich großen Speicherkapazität ausgehen können, lassen\n"
      + "sich für keine der aus der Mathematik bekannten Zahlenmengen alle Werte in\n"
      + "einem Rechner darstellen. Wir können also schon einmal nur Teilmengen der\n"
      + "Zahlenmengen darstellen.<p/>\n"
      + "\n"
      + "\n"
      + "Von der Hardwareseite stellt sich heute zumeist die folgende Situation dar: \n"
      + "Der Computer hat einen linearen Speicher, der   in Speicheradressen unterteilt\n"
      + "ist. Eine Speicheradresse\n"
      + "bezeichnet einen Bereich von 32 Bit. Wir bezeichnen diese als ein Wort. Die\n"
      + "Einheit von 8 Bit wird als Byte bezeichnet<footnote>ein anderes selten\n"
      + "gebrauchtes  Wort aus dem Französischen ist: Oktett</footnote>. Heutige\n"
      + "Rechner verwalten also in der Regel Dateneinheiten von 32 Bit. Hieraus ergibt\n"
      + "sich  die Kardinalität der Zahlenmengen, mit denen ein Rechner als primitive\n"
      + "Typen rechnen kann. Soll mit größeren Zahlenmengen gerechnet werden, so muß\n"
      + "hierzu eine Softwarelösung genutzt werden.<p/>\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"natürliche Zahlen\">\n"
      + "Natürliche Zahlen werden in der Regel durch Zeichenketten  von \n"
      + " Symbolen, den Ziffern, eines \n"
      + "endlichen Alphabets dargestellt. Die Größe dieser Symbolmenge\n"
      + " wird als die Basis <m>b</m> der Zahlendarstellung bezeichnet. \n"
      + "Für die Basis <m>b</m> gilt: <m>b &gt; 1</m>. Die Ziffern bezeichnen die\n"
      + " natürlichen Zahlen von <m>0</m> bis <m>b-1</m>. <p/>\n"
      + "\n"
      + "Der Wert der Zahl einer \n"
      + "Zeichenkette <m>a<subscript>n-1</subscript><dots/><w/>a<subscript\n"
      + ">0</subscript></m> berechnet sich für die Basis <m>b</m>  nach folgender\n"
      + "Formel: <p/>\n"
      + "\n"
      + "<displaymath\n"
      + "><sum><von>i=0</von><bis>n-1</bis></sum\n"
      + "> a<subscript>i</subscript>*b<superscript>i</superscript>\n"
      + "= a<subscript>0</subscript>*b<superscript\n"
      + ">0</superscript> + <dots/> + a<subscript\n"
      + ">n-1</subscript>*b <superscript>n-1</superscript>\n"
      + "</displaymath>\n"
      + "\n"
      + "Gebräuchliche Basen sind:\n"
      + "<itemize>\n"
      + "<item>2: Dualsystem</item>\n"
      + "<item>8: Oktalsystem</item>\n"
      + "<item>10: Dezimalsystem</item>\n"
      + "<item>16: Hexadezimalsystem<footnote>Eine etwas unglückliche Namensgebung aus\n"
      + "der Mischung eines griechischen mit einem lateinischen Wort.</footnote></item>\n"
      + "</itemize>\n"
      + "\n"
      + "Zur Unterscheidung wird im Zweifelsfalle die Basis einer Zahlendarstellung als\n"
      + "Index mit angegeben.\n"
      + "\n"
      + "<example>\n"
      + "Die Zahl 10 in Bezug auf unterschiedliche Basen dargestellt:\n"
      + "<displaymath>(10)<subscript>10</subscript>=\n"
      + "(A)<subscript>16</subscript>=\n"
      + "(12)<subscript>8</subscript>=\n"
      + "(1010)<subscript>2</subscript>\n"
      + "</displaymath>\n"
      + "</example>\n"
      + "\n"
      + "Darüberhinaus gibt es auch Zahlendarstellungen, die nicht in Bezug auf eine\n"
      + "Basis definiert sind, wie z.B.<w/>die römischen Zahlen.<p/>\n"
      + "\n"
      + "\n"
      + "Betrachten wir wieder unsere Hardware, die in Einheiten von 32 Bit agiert, so\n"
      + "lassen sich in einer Speicheradresse durch direkte Anwendung der Darstellung\n"
      + "im Dualsystem die natürlichen \n"
      + "Zahlen von <m>0</m> bis <m>2<superscript>32</superscript>-1</m\n"
      + "> darstellen.\n"
      + "\n"
      + "C kennt tatsächlich  Datentypen um natürliche Zahlen darzustellen. Ein solcher\n"
      + "Typ wird mit zwei Wörtern als <tt>unsigned int</tt> bezeichnet.\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"ganze Zahlen\">\n"
      + "Zur Darstellung ganzer Zahlen bedarf es einer\n"
      + "Darstellung vorzeichenbehafteter Zahlen in den Speicherzellen des Rechners. \n"
      + "Es gibt mehrere Verfahren, wie in einem dualen System vorzeichenbehaftete\n"
      + "Zahlen dargestellt werden können.\n"
      + "\n"
      + "<subsubsection titel=\"Vorzeichen und Betrag\">\n"
      + "Die einfachste Methode ist, von den <m>n</m> für die Zahlendarstellung zur\n"
      + "Verfügung stehenden Bit eines zur Darstellung des Vorzeichens und die\n"
      + "übrigen <m>n-1</m> Bit für eine Darstellung im Dualsystem zu nutzen.\n"
      + "\n"
      + "<example>In der Darstellung durch Vorzeichen und Betrag werden bei einer\n"
      + "Wortlänge von 8 Bit die Zahlen <m>10</m> und <m>-10</m> durch folgende \n"
      + "Bitmuster repräsentiert: <m>00001010</m> und <m>10001010</m>. \n"
      + "</example>\n"
      + "\n"
      + "Wenn das\n"
      + "linkeste Bit das Vorzeichen bezeichnet, ergibt sich daraus, daß es zwei\n"
      + "Bitmuster für die Darstellung der Zahl 0 \n"
      + "gibt: <m>10000000</m> und <m>00000000</m>. <p/>\n"
      + "\n"
      + "In dieser Darstellung lassen sich bei einer \n"
      + "Wortlänge <m>n</m> die Zahlen von <m\n"
      + ">-2<superscript>n-1</superscript>-1</m> bis <m\n"
      + ">2<superscript>n-1</superscript>-1</m> darstellen.\n"
      + "\n"
      + "<p/>\n"
      + "Die Lösung der Darstellung mit Vorzeichen und Betrag erschwert das Rechnen.\n"
      + "Wir müssen zwei Verfahren bereitstellen: eines zum Addieren und eines zum\n"
      + "Subtrahieren (so wie wir in der Schule schriftliches Addieren und Subtrahieren\n"
      + "getrennt gelernt haben). \n"
      + "\n"
      + "<example>Versuchen wir, das gängige Additionsverfahren \n"
      + "für <m>10</m> und <m>-10</m> in der Vorzeichendarstellung anzuwenden, so\n"
      + "erhalten wir:\n"
      + "\n"
      + "\n"
      + "<displaymath>\n"
      + "<array layout=\"cccccccc\">\n"
      + "<zeile>\n"
      + " <zelle>0</zelle><zelle>0</zelle>\n"
      + " <zelle>0</zelle><zelle>0</zelle>\n"
      + " <zelle>1</zelle><zelle>0</zelle>\n"
      + " <zelle>1</zelle><zelle>0</zelle>\n"
      + "</zeile>\n"
      + "<zeile>\n"
      + " <zelle>1</zelle><zelle>0</zelle>\n"
      + " <zelle>0</zelle><zelle>0</zelle>\n"
      + " <zelle>1</zelle><zelle>0</zelle>\n"
      + " <zelle>1</zelle><zelle>0</zelle>\n"
      + "</zeile><hline/>\n"
      + "<zeile>\n"
      + " <zelle>1</zelle><zelle>0</zelle>\n"
      + " <zelle>0</zelle><zelle>1</zelle>\n"
      + " <zelle>0</zelle><zelle>1</zelle>\n"
      + " <zelle>0</zelle><zelle>0</zelle>\n"
      + "</zeile>\n"
      + "</array>\n"
      + "</displaymath>\n"
      + "\n"
      + "\n"
      + "\n"
      + "Das Ergebnis stellt keinenfalls die \n"
      + "Zahl <m>0</m> dar, sondern die Zahl <m>-20</m>.\n"
      + "</example>\n"
      + "\n"
      + "Es läßt sich kein einheitlicher Algorithmus für die\n"
      + "Addition in dieser Darstellung finden.\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Einerkomplement\">\n"
      + "Ausgehend von der Idee, daß man eine Zahlendarstellung sucht, in der allein\n"
      + "durch das bekannte Additionsverfahren auch mit negativen Zahlen korrekt\n"
      + "gerechnet wird, kann man das Verfahren des Einerkomplements wählen.\n"
      + "Die Idee des Einerkomplements ist, daß für jede Zahl die entsprechende\n"
      + "negative Zahl so dargestellt wird, indem jedes Bit gerade andersherum gesetzt\n"
      + "ist. \n"
      + "\n"
      + "\n"
      + "\n"
      + "<example>Bei einer Wortlänge von 8 Bit werden die \n"
      + "Zahlen <m>10</m> und <m>-10</m> durch folgende Bitmuster \n"
      + "dargestellt: <m>00001010</m> und <m>11110101</m>.<p/>\n"
      + "\n"
      + "Jetzt können auch negative Zahlen mit dem gängigen Additionsverfahren addiert\n"
      + "werden, also kann die Subtraktion durch ein Additionsverfahren durchgeführt\n"
      + "werden. \n"
      + "\n"
      + "<displaymath>\n"
      + "<array layout=\"cccccccc\">\n"
      + "<zeile>\n"
      + " <zelle>0</zelle><zelle>0</zelle>\n"
      + " <zelle>0</zelle><zelle>0</zelle>\n"
      + " <zelle>1</zelle><zelle>0</zelle>\n"
      + " <zelle>1</zelle><zelle>0</zelle>\n"
      + "</zeile>\n"
      + "<zeile>\n"
      + " <zelle>1</zelle><zelle>1</zelle>\n"
      + " <zelle>1</zelle><zelle>1</zelle>\n"
      + " <zelle>0</zelle><zelle>1</zelle>\n"
      + " <zelle>0</zelle><zelle>1</zelle>\n"
      + "</zeile><hline/>\n"
      + "<zeile>\n"
      + " <zelle>1</zelle><zelle>1</zelle>\n"
      + " <zelle>1</zelle><zelle>1</zelle>\n"
      + " <zelle>1</zelle><zelle>1</zelle>\n"
      + " <zelle>1</zelle><zelle>1</zelle>\n"
      + "</zeile>\n"
      + "</array>\n"
      + "</displaymath>\n"
      + "\n"
      + "Das errechnete Bitmuster stellt die <em>negative</em> Null\n"
      + "dar.</example>\n"
      + "\n"
      + "In der Einerkomplementdarstellung läßt sich zwar fein rechnen, wir haben aber\n"
      + "immer noch zwei Bitmuster zur Darstellung der <m>0</m>. Für  eine \n"
      + "Wortlänge <m>n</m> lassen sich auch wieder die Zahlen von <m\n"
      + ">-2<superscript>n-1</superscript>-1</m> bis <m\n"
      + ">2<superscript>n-1</superscript>-1</m> darstellen..\n"
      + "\n"
      + "Ebenso wie in der Darstellung mit Vorzeichen und Betrag erkennt man in der\n"
      + "Einerkomplementdarstellung am linkesten Bit, ob es sich um eine negative oder\n"
      + "um eine positive Zahl handelt.\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Zweierkomplement\">\n"
      + "Die Zweierkomplementdarstellung verfeinert die Einerkomplementdarstellung, so\n"
      + "daß es nur noch ein Bitmuster für die Null gibt. Im Zweierkomplement wird für\n"
      + "eine Zahl die negative Zahl gebildet, indem zu ihrer\n"
      + "Einerkomplementdarstellung noch 1 hinzuaddiert wird.\n"
      + "\n"
      + "<example>Bei einer Wortlänge von 8 Bit werden die \n"
      + "Zahlen <m>10</m> und <m>-10</m> durch folgende Bitmuster \n"
      + "dargestellt: <m>00001010</m> und <m>11110110</m>.<p/>\n"
      + "\n"
      + "Jetzt können weiterhin auch negative Zahlen mit dem \n"
      + "gängigen Additionsverfahren addiert\n"
      + "werden, also kann die Subtraktion durch ein Additionsverfahren durchgeführt\n"
      + "werden. \n"
      + "\n"
      + "<displaymath>\n"
      + "<array layout=\"cccccccc\">\n"
      + "<zeile>\n"
      + " <zelle>0</zelle><zelle>0</zelle>\n"
      + " <zelle>0</zelle><zelle>0</zelle>\n"
      + " <zelle>1</zelle><zelle>0</zelle>\n"
      + " <zelle>1</zelle><zelle>0</zelle>\n"
      + "</zeile>\n"
      + "<zeile>\n"
      + " <zelle>1</zelle><zelle>1</zelle>\n"
      + " <zelle>1</zelle><zelle>1</zelle>\n"
      + " <zelle>0</zelle><zelle>1</zelle>\n"
      + " <zelle>1</zelle><zelle>0</zelle>\n"
      + "</zeile><hline/>\n"
      + "<zeile>\n"
      + " <zelle>0</zelle><zelle>0</zelle>\n"
      + " <zelle>0</zelle><zelle>0</zelle>\n"
      + " <zelle>0</zelle><zelle>0</zelle>\n"
      + " <zelle>0</zelle><zelle>0</zelle>\n"
      + "</zeile>\n"
      + "</array>\n"
      + "</displaymath>\n"
      + "\n"
      + "\n"
      + "Das errechnete Bitmuster stellt die  Null\n"
      + "dar.</example>\n"
      + "\n"
      + "Die <em>negative</em> Null aus dem Einerkomplement stellt im Zweierkomplement\n"
      + "keine Null dar, sondern die Zahl <m>-1</m>, wie man sich vergegenwärtigen\n"
      + "kann, wenn man von der 1 das Zweierkomplement bildet.\n"
      + "</subsubsection>\n"
      + "\n"
      + "Das Zweierkomplement ist die in heutigen Rechenanlagen gebräuchlichste Form\n"
      + "der Zahlendarstellung für ganze Zahlen. In modernen Programmiersprachen\n"
      + "spiegelt sich dieses in den Wertebereichen primitiver Zahlentypen wieder. \n"
      + "\n"
      + "\n"
      + "<center>\n"
      + "<table layout=\"|l|l|l|\"><hline/>\n"
      + "<zeile>\n"
      + "  <zelle><b>Typname</b></zelle>\n"
      + "  <zelle><b>Länge</b></zelle>\n"
      + "  <zelle><b>Wertebereich</b></zelle>\n"
      + "</zeile><hline/>\n"
      + "<zeile>\n"
      + "  <zelle><tt>byte</tt></zelle>\n"
      + "  <zelle>8 Bit </zelle>\n"
      + "  <zelle><m>-128=-2<superscript>7</superscript\n"
      + "    ></m> bis <m>127=2<superscript>7</superscript>-1</m>\n"
      + "  </zelle>\n"
      + "</zeile><hline/>\n"
      + "<zeile>\n"
      + "  <zelle><tt>short</tt></zelle>\n"
      + "  <zelle>16 Bit</zelle>\n"
      + "  <zelle><m>-32768=-2<superscript>15</superscript\n"
      + "    ></m> bis <m>32767=2<superscript>15</superscript>-1</m>\n"
      + "  </zelle>\n"
      + "</zeile><hline/>\n"
      + "<zeile>\n"
      + "  <zelle><tt>int</tt></zelle>\n"
      + "  <zelle>32 Bit</zelle>\n"
      + "  <zelle><m>-2147483648=-2<superscript>31</superscript\n"
      + "    ></m> bis <m>2147483647=2<superscript>32</superscript>-1</m>\n"
      + "  </zelle>\n"
      + "</zeile><hline/>\n"
      + "<zeile>\n"
      + "  <zelle><tt>long</tt></zelle>\n"
      + "  <zelle>64 Bit</zelle>\n"
      + "  <zelle><m>-9223372036854775808</m> bis <m\n"
      + "          >9223372036854775807</m>\n"
      + "  </zelle>\n"
      + "</zeile><hline/>\n"
      + "\n"
      + "</table>\n"
      + "</center>\n"
      + "\n"
      + "\n"
      + "In der Programmiersprache Java sind die konkreten Wertebereiche für die\n"
      + "einzelnen primitiven Typen in der Spezifikation festgelegt. In anderen\n"
      + "Programmiersprachen wie z.B.<w></w>C ist dies nicht der Fall. Hier hängt es\n"
      + "vom Compiler und dem konkreten Rechner ab, welchen Wertebereich die\n"
      + "entsprechenden Typen haben.<p/>\n"
      + "\n"
      + "Es gibt Programmiersprachen wie \n"
      + "z.B.<w/>Haskell<cite label=\"revisedHaskellReport\"/>, in denen es einen Typ\n"
      + "gibt, der potentiell ganze Zahlen von beliebiger Größe darstellen kann.\n"
      + " \n"
      + "\n"
      + "<subsubsection titel=\"Frage eines Softwaremenschen an die Hardwarebauer\">\n"
      + "Gängige Spezifikationen moderner Programmiersprachen sehen einen\n"
      + "ausgezeichneten Wert <em>nan</em> für <em>not a number</em> in \n"
      + "der Arithmetik vor, der ausdrücken soll,\n"
      + "dass es sich bei dem Wert nicht mehr um eine darstellbare Zahl handelt.  In der\n"
      + "Arithmetik moderne Prozessoren ist ein solcher zusätzlicher Wert nicht\n"
      + "vorgesehen. Warum eigentlich nicht?! Es sollte doch möglich sein, einen\n"
      + "Prozessor zu bauen, der beim Überlauf des Wertebereichs nicht stillschweigend\n"
      + "das durch den Überlauf entstandene Bitmuster wieder als Zahl interpretiert,\n"
      + "sondern den ausgezeichneten Wert <em>nan</em> als Ergebnis hat. Ein\n"
      + "Programmierer könnte dann entscheiden, wie er in diesem Fall verfahren\n"
      + "möchte. Eine  große Fehlerquelle wäre behoben. Warum ist eine solche\n"
      + "Arithmetik noch nicht in handelsüblichen Prozessoren verwirklicht?\n"
      + "\n"
      + "</subsubsection>\n"
      + "\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Kommazahlen\">\n"
      + "Wollen wir  Kommazahlen, also Zahlen aus den \n"
      + "Mengen <setQ></setQ> und <setR></setR>, im Rechner darstellen,\n"
      + "so stoßen wir auf ein zusätzliches Problem: es gilt dann nämlich nicht mehr,\n"
      + "daß ein Intervall nur endlich viele Werte enthält, wie es für ganze Zahlen\n"
      + "noch der Fall ist. Bei ganzen Zahlen konnten wir immerhin wenigstens alle\n"
      + "Zahlen eines bestimmten Intervalls darstellen. Wir können also nur endlich\n"
      + "viele \n"
      + "dieser unendlich vielen Werte in einem Intervall darstellen. Wir werden also\n"
      + "das Intervall <em>diskretisieren</em>.\n"
      + "\n"
      + "<subsubsection titel=\"Festkommazahlen\">\n"
      + "Vernachlässigen wir für einen Moment jetzt einmal wieder negative Zahlen. Eine\n"
      + "einfache und naheliegende Idee ist, bei einer Anzahl von <m>n</m> Bit, die\n"
      + "für die Darstellung der Kommazahlen zur Verfügung stehen, einen Teil\n"
      + "davon für den Anteil\n"
      + "vor dem Komma und den Rest für den Anteil nach dem Komma zu benutzen. Liegt\n"
      + "das Komma in der Mitte, so können wir eine Zahl aus <m>n</m> Ziffern durch\n"
      + "folgende Formel ausdrücken:\n"
      + "\n"
      + "Der Wert der Zahl einer \n"
      + "Zeichenkette <m>a<subscript>n-1</subscript><dots/><w/>a<subscript\n"
      + ">n/2</subscript>,a<subscript>n/2-1</subscript><dots/><w/>a<subscript\n"
      + ">0</subscript></m> berechnet sich für die Basis <m>b</m>  nach folgender\n"
      + "Formel: <p/>\n"
      + "\n"
      + "<displaymath\n"
      + "><sum><von>i=0</von><bis>n-1</bis></sum\n"
      + "> a<subscript>i</subscript><superscript>i-n/2</superscript>\n"
      + "= a<subscript>0</subscript>*b<superscript\n"
      + ">-n/2</superscript> + <dots/> + a<subscript\n"
      + ">n-1</subscript>*b<superscript>n-1-n/2</superscript>\n"
      + "</displaymath>\n"
      + "\n"
      + "\n"
      + "Wir kennen diese Darstellung aus dem im Alltag gebräuchlichen Zehnersystem.\n"
      + "Für Festkommazahlen ergibt sich ein überraschendes Phänomen. Zahlen, die sich\n"
      + "bezüglich einer Basis darstellen lassen, sind bezüglich einer anderen Basis\n"
      + "nicht darstellbar. So läßt sich schon die sehr einfach zur Basis 10\n"
      + "darstellbare Zahl <m>0,1</m> nicht zur Basis 2 als Festkommazahl darstellen,\n"
      + "und umgekehrt können Sie einfach zur Basis 2 als Festkommazahl darstellbare\n"
      + "Zahlen nicht zur Basis 10 darstellen.<p/>\n"
      + "\n"
      + "Dem Leser wird natürlich nicht entgangen sein, daß wir keine irrationale Zahl \n"
      + "über die Festkommadarstellung darstellen können.<p/>\n"
      + "\n"
      + "Festkommazahlen spielen in der Rechnerarchitektur kaum eine Rolle. Ein sehr\n"
      + "verbreitetes Anwendungsgebiet für Festkommazahlen sind Währungsbeträge. Hier\n"
      + "interessieren in der Regel nur die ersten zwei oder drei Dezimalstellen nach\n"
      + "dem Komma.\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Fließkommazahlen\">\n"
      + "Eine Alternative zu der Festkommadarstellung von Zahlen ist die\n"
      + "Fließkommadarstellung. Während die Festkommadarstellung einen Zahlenbereich\n"
      + "der rationalen Zahlen in einem festen Intervall durch diskrete, äquidistant\n"
      + "verteilte Werte darstellen kann, sind die diskreten Werte in der\n"
      + "Fließkommadarstellung nicht gleich verteilt.<p/>\n"
      + "\n"
      + "In der Fließkommadarstellung wird eine Zahl durch zwei Zahlen charakterisiert\n"
      + "und ist bezüglich einer Basis <m>b</m>: \n"
      + "<itemize>\n"
      + "<item>die Mantisse für die darstellbaren Ziffern. Die Mantisse\n"
      + "charakterisiert die Genauigkeit der Fließkommazahl.</item>\n"
      + "<item>der Exponent, der angibt, wie weit die Mantisse hinter bzw. vor dem\n"
      + "Komma liegt. </item>\n"
      + "</itemize>\n"
      + "\n"
      + "Aus Mantisse <m>m</m>, Basis <m>b</m> und Exponent <m>exp</m> ergibt sich\n"
      + "die dargestellte Zahl durch folgende Formel:\n"
      + "<displaymath\n"
      + ">z = m * b <superscript>exp</superscript>\n"
      + "</displaymath>\n"
      + "   \n"
      + "Damit lassen sich mit Fließkommazahlen sehr große und sehr kleine Zahlen\n"
      + "darstellen. Je größer jedoch die Zahlen werden, desto weiter liegen sie von der\n"
      + "nächsten Zahl entfernt.\n"
      + "\n"
      + "\n"
      + "Für die Fließkommadarstellung gibt es in Java zwei Zahlentypen, die nach der\n"
      + "Spezifikation des IEEE 754-1985 gebildet werden:\n"
      + "<itemize>\n"
      + "<item><b>float</b>: 32 Bit Fließkommazahl nach IEEE 754. Kleinste positive\n"
      + "Zahl: <m>2<superscript>-149</superscript></m>. \n"
      + "Größte positive \n"
      + "Zahl: <m>(2-2<superscript>-23</superscript>)*<superscript>127</superscript>\n"
      + "</m>\n"
      + "</item>\n"
      + "<item><b>double</b>: 64 Bit Fließkommazahl nach IEEE 754. Kleinste positive\n"
      + "Zahl: <m>2<superscript>-1074</superscript></m>. \n"
      + "Größte positive \n"
      + "Zahl: <m>(2-2<superscript>-52</superscript>)*<superscript>1023</superscript>\n"
      + "</m>\n"
      + "</item>\n"
      + "</itemize>\n"
      + "\n"
      + "Im Format für <tt>double</tt> steht das erste Bit für das Vorzeichen, die\n"
      + "nächsten 11 Bit markieren den Exponenten und die restlichen 52 Bit kodieren\n"
      + "die Mantisse. <p/>\n"
      + "\n"
      + "Im Format für <tt>float</tt> steht das erste Bit für das Vorzeichen, die\n"
      + "nächsten 8 Bit markieren den Exponenten und die restlichen 23 Bit kodieren\n"
      + "die Mantisse. <p/>\n"
      + "\n"
      + "\n"
      + "Bestimmte Bitmuster charakterisieren einen Wert für negative\n"
      + "und positive unbeschränkte Werte (unendlich) sowie Zahlen, Bitmuster, die\n"
      + "charakterisieren, daß es sich nicht mehr um eine Zahl handelt.\n"
      + "<delete>\n"
      + "<example>\n"
      + "Der folgende Test zeigt, daß bei einer Addition von zwei Fließkommazahlen die\n"
      + "kleinere Zahl das Nachsehen hat:  \n"
      + "\n"
      + "<code class=\"DoubleTest\" lang=\"java\"\n"
      + "><![CDATA[class DoubleTest{\n"
      + "  public static void main(String [] args){\n"
      + "    double x = 325e200;\n"
      + "    double y = 325e-200;\n"
      + "    System.out.println(x);\n"
      + "    System.out.println(y);\n"
      + "    System.out.println(x+y);\n"
      + "    System.out.println(x+100000);\n"
      + "  } \n"
      + "}]]></code>\n"
      + "\n"
      + "Wie man an der Ausgabe erkennen kann: selbst die Addition der \n"
      + "Zahl <tt>100000</tt> bewirkt keine Veränderung auf einer großen\n"
      + "Fließkommazahl: \n"
      + "\n"
      + "\n"
      + "<scode><![CDATA[sep@linux:~/fh/prog3/examples/src> java DoubleTest\n"
      + "3.25E202\n"
      + "3.25E-198\n"
      + "3.25E202\n"
      + "3.25E202\n"
      + "sep@linux:~/fh/prog3/examples/src>]]></scode>\n"
      + "</example>\n"
      + "\n"
      + "\n"
      + "<example>\n"
      + "Das folgende kleine Beispiel zeigt, inwieweit und für den Benutzer oft auf\n"
      + "überraschende Weise die Fließkommadarstellung zu Rundungen führt:\n"
      + "<code class=\"Rounded\" lang=\"java\"><![CDATA[class Rounded {\n"
      + "  public static void main(String [] args){\n"
      + "    System.out.println(8f);\n"
      + "    System.out.println(88f);\n"
      + "    System.out.println(8888f);\n"
      + "    System.out.println(88888f);\n"
      + "    System.out.println(888888f);\n"
      + "    System.out.println(8888888f);\n"
      + "    System.out.println(88888888f);\n"
      + "    System.out.println(888888888f);\n"
      + "    System.out.println(8888888888f);\n"
      + "    System.out.println(88888888888f);\n"
      + "    System.out.println(888888888888f);\n"
      + "    System.out.println(8888888888888f);\n"
      + "\n"
      + "    System.out.println(1f+1000000000000f-1000000000000f);\n"
      + "  } \n"
      + "}\n"
      + "]]></code>\n"
      + "Das Programm hat die folgende Ausgabe. Insbesondere in der letzten Zeile\n"
      + "  fällt auf, daß Addition und anschließende Subtraktion ein und derselben Zahl\n"
      + "  nicht die Identität ist. Für Fließkommazahlen gilt \n"
      + "nicht: <m>x + y - y = x</m>.\n"
      + "<scode><![CDATA[sep@linux:~/fh/prog3/examples/src> java Rounded\n"
      + "8.0\n"
      + "88.0\n"
      + "8888.0\n"
      + "88888.0\n"
      + "888888.0\n"
      + "8888888.0\n"
      + "8.8888888E7\n"
      + "8.888889E8\n"
      + "8.8888893E9\n"
      + "8.8888885E10\n"
      + "8.8888889E11\n"
      + "8.8888889E12\n"
      + "0.0\n"
      + "sep@linux:~/fh/prog3/examples/src>]]></scode>\n"
      + "</example>\n"
      + "</delete>\n"
      + "</subsubsection>\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Zahlentypen in C\">\n"
      + "C kennt  vier verschiedene Basistypen um Zahlen darzustellen. Zwei Typen\n"
      + "zur Darstellung ganzer Zahlen und zwei zur Darstellung von Fließkommazahlen.\n"
      + "Eine Übersicht findet sich auch in Anhang <ref name=\"primTyp\"></ref>.\n"
      + "\n"
      + " \n"
      + "<subsubsection titel=\"int und char\">\n"
      + "Ganze Zahlen werden mit dem \n"
      + "Typ <tt>int</tt> bezeichnet. Wieviel Byte im Speicher zur Darstellung einer\n"
      + "ganzen Zahl tatsächlich benutzt wird, ist im C-Standard nicht\n"
      + "spezifiziert. Es hängt von der benutzten Hardware und dem benutzten Compiler\n"
      + "ab. \n"
      + "\n"
      + "Der zweite Typ, der in der Lage ist, ganze Zahlen zu speichern, ist der \n"
      + "Typ <tt>char</tt>. Wie der Name (character, Zeichen) schon andeutet, wird\n"
      + "dieser Typ primär benutzt um alphabetische Zeichen zu speichern. Er kann aber\n"
      + "ebenso zum Rechnen mit Zahlen benutzt werden. \n"
      + "</subsubsection>\n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"float und double\">\n"
      + "C bietet zwei Typen zur Speicherung von Fließkommazahlen \n"
      + "an: <tt>float</tt> und <tt>double</tt>. Ihr Unterschied liegt in dem Platz,\n"
      + "der im Speicher benutzt wird. In der Regel wird für den \n"
      + "Typ <tt>float</tt> weniger Speicherplatz benutzt, es kann aber Compiler geben,\n"
      + "die für beide Typen die gleiche interne Darstellung benutzen.\n"
      + "\n"
      + "Beim Rechnen mit Fließkommazahlen sollte man  heutzutage immer den \n"
      + "Typ <tt>double</tt> verwenden\n"
      + "\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Literale\">\n"
      + "<paragraph titel=\"ganzzahlige Literale\">\n"
      + "Ganze Zahlen können in C auf drei verschiedene Weise notiert werden. Diese\n"
      + "drei Arten der Literale unterscheiden sich in der Basis zu der die Zahlen\n"
      + "notiert sind.\n"
      + "\n"
      + "<itemize>\n"
      + "<item>zur Basis 10 (dezimal): beginnt mit einer Ziffer ungleich 0 gefolgt\n"
      + " von einer\n"
      + "(möglicherweise leeren) Folge von Ziffern 0--9.\n"
      + "</item>\n"
      + "<item>zur Basis 16 (hexadecimal):beginnt \n"
      + "mit  <tt>0x</tt> oder <tt>0X</tt> gefolgt von einer nichtleeren Folge von\n"
      + "hexadezimalen  Ziffern 0--9,A,B,C,D,E,F. </item> \n"
      + "<item>zur Basis 16 (oktal): beginnt mit einer 0 gefolgt von einer\n"
      + "(möglicherweise leeren) Folge von Ziffern 0--7.</item>\n"
      + "</itemize>\n"
      + "\n"
      + "So kann die Zahl 63 in C \n"
      + "als <tt>63</tt>, <tt>0x3F</tt> und <tt>077</tt> notiert werden.\n"
      + "\n"
      + "\n"
      + "Den ganzzahligen Literalen kann ein Buchstaben angehänt sein, der den Datentyp\n"
      + "des Literals genauer spezifiziert. \n"
      + "<table layout=\"ll\">\n"
      + "<zeile><zelle><tt>u</tt> oder <tt>U</tt></zelle><zelle>markiert das Literal\n"
      + "als <em>unsigned</em></zelle></zeile>\n"
      + "<zeile><zelle><tt>l</tt> oder <tt>L</tt></zelle><zelle>markiert das Literal\n"
      + "als <tt>long</tt></zelle></zeile>\n"
      + "<zeile><zelle><tt>ll</tt> oder <tt>LL</tt></zelle><zelle>markiert das Literal\n"
      + "als <tt>long long</tt> (erst seit dem Standard C99)</zelle></zeile>\n"
      + "</table>\n"
      + "</paragraph>\n"
      + "\n"
      + "<paragraph titel=\"Fließkommaliterale\">\n"
      + "Fließkommaliterale benutzen den Punkt <tt>.</tt> als Dezimalkomma. Mit dem\n"
      + "Buchstaben <tt>e</tt> oder <tt>E</tt> kann ein ganzzahliger Exponent notiert\n"
      + "werden. So bezeichnen die folgenden Literale Fließkommazahlen vom \n"
      + "Typ <tt>double</tt>: <tt>3.1415926535897932</tt>, <tt>4.0</tt>, <tt>6.022e+23</tt>.\n"
      + "\n"
      + "Hängt an einem Fließkommaliteral noch der Buchstabe <tt>f</tt>, so wird das\n"
      + "Literal als Zahl vom Typ <tt>float</tt> gespeichert.\n"
      + "</paragraph>\n"
      + "\n"
      + "\n"
      + "<paragraph titel=\"Zeichenliterale\">\n"
      + "Einzelne Zeichen des Typs <tt>char</tt> können in einfachen Hochkommas\n"
      + "eingeschlossen notiert werden. Zeichen, für die es keine einfache sichtbare\n"
      + "Repräsentation gibt, wie z.B. das Zeilenendezeichen, werden mit einer\n"
      + "Fluchtsequenz beginnend mit dem rückwärtigen Schrägstrich bezeichnet.\n"
      + "</paragraph>\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Typ Modifizierer\">\n"
      + "Von den bisher vorgestellten primitiven Typen gibt es modifizierte\n"
      + "Versionen. Zum einen können sie modifiziert werden, in der Speichergröße, die\n"
      + "für sie verwendet wird, zum anderen ob sie Vorzeichen behaftete Zahlen\n"
      + "speichern können oder nicht.\n"
      + "\n"
      + "<paragraph titel=\"long und short\">\n"
      + "Der Typ <tt>int</tt> kann noch mit den Attribute <tt>long</tt> oder <tt\n"
      + ">short</tt> behaftet sein. Das Attribut <tt>long</tt> bewirkt dann, dass\n"
      + " auf bestimmten Systemen eventuell \n"
      + "mehr Byte zur Darstellung einer Zahl genutzt werden.\n"
      + "Garantiert doppelt so viel Byte wie ein <tt>int</tt> hat schließlich\n"
      + "der Typ <tt>long long int</tt>.\n"
      + "\n"
      + "Das Attribut <tt>short</tt> signalisiert, dass nur halb soviel Byte zu\n"
      + "Zahlendarstellung genutzt werden sollen, wie für normale <tt>int</tt> Zahlen.\n"
      + "Ebenso kann ein System einen  <tt>long double</tt> Typ zur Verfügung stellen,\n"
      + "der größer ist als der normale <tt>double</tt> Datentyp.\n"
      + "\n"
      + "\n"
      + "\n"
      + "</paragraph>\n"
      + "\n"
      + "<paragraph titel=\"unsigned und signed\">\n"
      + "Die Datentypen für ganze Zahlen können so modifiziert werden, dass in Ihnen\n"
      + "nur natürliche Zahlen (inklusive 0) gespeichert werden können. Dieses\n"
      + "geschieht durch das Attribut <tt>unsigned</tt>. Ebenso mit dem \n"
      + "Attribute <tt>signed</tt> signalisiert werden, dass z.B. beim \n"
      + "Datentyp <tt>char</tt> auch negative Zahlen darstellbar sein sollen.\n"
      + "Für die Typen <tt>float</tt> und <tt>double</tt> führt das \n"
      + "Attribut <tt>unsigned</tt> zu einem Fehler des Compilers.\n"
      + "\n"
      + "</paragraph>\n"
      + "\n"
      + "<paragraph titel=\"weitere Literalschreibweisen\">\n"
      + "Den ganzzahligen Literalen kann ein Buchstaben angehänt sein, der den Datentyp\n"
      + "des Literals genauer spezifiziert. \n"
      + "<table layout=\"ll\">\n"
      + "<zeile><zelle><tt>u</tt> oder <tt>U</tt></zelle><zelle>markiert das Literal\n"
      + "als <em>unsigned</em></zelle></zeile>\n"
      + "<zeile><zelle><tt>l</tt> oder <tt>L</tt></zelle><zelle>markiert das Literal\n"
      + "als <tt>long</tt></zelle></zeile>\n"
      + "<zeile><zelle><tt>ll</tt> oder <tt>LL</tt></zelle><zelle>markiert das Literal\n"
      + "als <tt>long long</tt> (erst seit dem Standard C99)</zelle></zeile>\n"
      + "</table>\n"
      + "</paragraph>\n"
      + "\n"
      + "<paragraph titel=\"der Operator sizeof\">\n"
      + "Wie zu sehen war, ist es gar nicht genau festgelegt, wie viel Byte zur\n"
      + "Darstellung der einzelnen primitiven Typen benutzt werden. Das kann von System\n"
      + "zu System variieren. Will man wissen, wieviel Speicherplatz für bestimmte\n"
      + "Datentypen tatsächlich bereit gehalten werden, so bietet C eine eingebaute\n"
      + "Funktion an, die dieses Information bereit hält: die Funktion <tt>sizeof</tt>.\n"
      + "Ihr kann als Parameter ein primitiver Typ übergeben werden. Als Rückgabe\n"
      + "erhält man die Anzahl der Byte, die für diesen Typ zur Darstellung verwendet\n"
      + "werden.  \n"
      + "</paragraph>\n"
      + "</subsubsection>\n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"printf\">\n"
      + "Zur Ausgabe von Zahlen benutzen wir die Funktion <tt>printf</tt>. Bisher\n"
      + "haben wir als Steuerzeichen für <tt>printf</tt> nur <tt>%i</tt> benutzt um\n"
      + "ganze Zahlen auszugeben. Die Prozedur <tt>printf</tt> ist eine sehr\n"
      + "ausgeklügelte Prozedur. In ihr kann sehr genau spezifiziert werden, auf welche\n"
      + "Weise Zahlen formattiert werden sollen. Zusätzlich zum angegebenen Zahlentypen\n"
      + "der dargestellt werden soll, kann auch angegeen werden, wieviel Platz zur\n"
      + "Darstellung der Zahl benutzt werden soll. Folgende Tabelle gibt einen kleinen Überblick:\n"
      + "\n"
      + "<table layout=\"|l|l|l|\">\n"
      + "<hline/>\n"
      + "<zeile>\n"
      + "  <zelle><b>Zeichen</b></zelle>\n"
      + "  <zelle><b>Argumenttyp</b></zelle>\n"
      + "  <zelle><b>darstellt als</b></zelle>\n"
      + "</zeile><hline/>\n"
      + "<zeile><zelle>\n"
      + "d,i</zelle><zelle>int</zelle><zelle> Dezimal mit Vorzeichen.</zelle>\n"
      + "</zeile><hline/>\n"
      + "<zeile><zelle>\n"
      + "o</zelle><zelle> int</zelle><zelle>Oktal ohne Vorzeichen (ohne führende Null).</zelle>\n"
      + "</zeile><hline/>\n"
      + "<zeile><zelle>\n"
      + "x,X</zelle><zelle> int</zelle><zelle><minipage dimension=\"0.7\textwidth\">\n"
      + "Hexadezimal ohne Vorzeichen (ohne führendes 0x oder 0X) mit abcdef bei 0x oder\n"
      + "  ABCDEF bei 0X.</minipage>\n"
      + "</zelle></zeile><hline/>\n"
      + "<zeile><zelle>\n"
      + "u</zelle><zelle> int</zelle><zelle>Dezimal ohne Vorzeichen.\n"
      + "</zelle></zeile><hline/>\n"
      + "<zeile><zelle>\n"
      + "c</zelle><zelle> int</zelle><zelle><minipage dimension=\"0.7\textwidth\"> einzelnes Zeichen, nach Umwandlung in unsigned char.</minipage>\n"
      + "</zelle></zeile><hline/>\n"
      + "<delete><zeile><zelle>\n"
      + "s</zelle><zelle> char*</zelle><zelle>aus einer Zeichenkette werden Zeichen ausgegeben bis vor '\\0' oder so viele Zeichen, wie die Genauigkeit verlangt.\n"
      + "</zelle></zeile><hline/></delete>\n"
      + "<zeile><zelle>\n"
      + "f</zelle><zelle> double</zelle><zelle><minipage\n"
      + "dimension=\"0.7\textwidth\">Dezimal als [-]mmm.ddd, wobei die Genauigkeit die\n"
      + "Anzahl der d festlegt. Voreinstellung ist 6; bei 0 entfällt der Dezimalpunkt.\n"
      + "</minipage>\n"
      + "</zelle></zeile><hline/>\n"
      + "<zeile><zelle>\n"
      + "e,E</zelle><zelle> double</zelle><zelle><minipage\n"
      + "  dimension=\"0.7\textwidth\"> Dezimal als [-]m.dddddde±xx oder [-]m.ddddddE±xx,\n"
      + "  wobei die Genauigkeit die Anzahl der d festlegt. Voreinstellung ist 6; bei 0\n"
      + "  entfällt der Dezimalpunkt.</minipage> \n"
      + "</zelle></zeile><hline/>\n"
      + "<zeile>\n"
      + "<zelle>g,G</zelle><zelle>double</zelle><zelle> \n"
      + "<minipage dimension=\"0.7\textwidth\">\\%e oder \\%E wird verwendet, wenn der\n"
      + "  Exponent kleiner als -4 oder nicht kleiner als die Genauigkeit ist; sonst\n"
      + "  wird \\%f benutzt. Null und Dezimalpunkt am Schluß werden nicht\n"
      + "  ausgegeben.</minipage> \n"
      + "</zelle></zeile><hline/>\n"
      + "</table>\n"
      + "\n"
      + "\n"
      + "Es ist an der Zeit, all das in diesem Kapitel angesprochene einmal\n"
      + "auszuprobieren. Im folgenden Programm werden von den unterschiedlichen\n"
      + "primitiven Typen einmal Variablen angelegt.\n"
      + "<code lang=\"c\" class=\"ArithTypes\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int main(){\n"
      + "  char c   = 'a';\n"
      + "  int  i   = 42;\n"
      + "  float f  = 42.0f;\n"
      + "  double d = 42.0;\n"
      + "\n"
      + "  long int  li   = 42;\n"
      + "  long long int  lli   = 42;\n"
      + "  long double ld = 42.0;\n"
      + "\n"
      + "  short int  si   = 42;\n"
      + "\n"
      + "  unsigned char uc   = 'a';\n"
      + "  unsigned int  ui   = 42;\n"
      + "\n"
      + "  signed char sic   = 'a';\n"
      + "  signed int  sii   = 42;\n"
      + "\n"
      + "  printf(\"sizeof(c): %3i value: %10c\n\",sizeof(c),c);\n"
      + "  printf(\"sizeof(i): %3i value: %10i\n\",sizeof(i),i);\n"
      + "  printf(\"sizeof(f): %3i value: %10f\n\",sizeof(f),f);\n"
      + "  printf(\"sizeof(d): %3i value: %10f\n\",sizeof(d),d);\n"
      + "  printf(\"\n\");\n"
      + "  printf(\"sizeof(li): %2i value: %10i\n\",sizeof(li),li);\n"
      + "  printf(\"sizeof(lli):%2i value: %10i\n\",sizeof(lli),lli);\n"
      + "  printf(\"sizeof(ld): %2i value: %10f\n\",sizeof(ld),ld);\n"
      + "  printf(\"\n\");\n"
      + "  printf(\"sizeof(si): %2i value: %10i\n\",sizeof(si),si);\n"
      + "  printf(\"\n\");\n"
      + "  printf(\"sizeof(uc): %2i value: %10u\n\",sizeof(uc),uc);\n"
      + "  printf(\"sizeof(ui): %2i value: %10u\n\",sizeof(ui),ui);\n"
      + "  printf(\"\n\");\n"
      + "  printf(\"sizeof(sic): %1i value: %10i\n\",sizeof(sic),sic);\n"
      + "  printf(\"sizeof(sii): %1i value: %10i\n\",sizeof(sii),sii);\n"
      + "\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Die Ausgabe des Programms gibt darüber Aufschluß, wie viel Byte für die\n"
      + "einzelnen unterschiedlichen Datentypen der <tt>gcc</tt> auf Linux belegt.\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/tutor> bin/ArithTypes\n"
      + "sizeof(c):   1 value:          a\n"
      + "sizeof(i):   4 value:         42\n"
      + "sizeof(f):   4 value:  42.000000\n"
      + "sizeof(d):   8 value:  42.000000\n"
      + "\n"
      + "sizeof(li):  4 value:         42\n"
      + "sizeof(lli): 8 value:         42\n"
      + "sizeof(ld): 12 value:  -0.000000\n"
      + "\n"
      + "sizeof(si):  2 value:         42\n"
      + "\n"
      + "sizeof(uc):  1 value:         97\n"
      + "sizeof(ui):  4 value:         42\n"
      + "\n"
      + "sizeof(sic): 1 value:         97\n"
      + "sizeof(sii): 4 value:         42\n"
      + "sep@pc305-3:~/fh/c/tutor>]]></scode>\n"
      + "\n"
      + "</subsubsection>\n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"Rechnen\">\n"
      + "<paragraph titel=\"ganze Zahlen\">\n"
      + "Auf dem Typen <tt>int</tt> haben wir bereits die bekannten arithmetischen\n"
      + "Operatoren kennengelernt. Diese existieren auch für die anderen Zahlentypen\n"
      + "und erstaunlicher Weise auch für den Typen <tt>char</tt>. So kann man eine\n"
      + "Variable sehr schön von A bis Z laufen lassen:\n"
      + "\n"
      + "<code class=\"ABisZ\" lang=\"c\" main=\"main\" compileoptions=\" echo -std=c99 \"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  char abstand='A'-'a';\n"
      + "  for (char c='A';c<='Z';c++) printf(\"%c\",c-abstand);\n"
      + "  printf(\"\n\");\n"
      + "  return 0;\n"
      + "}]]></code> \n"
      + "</paragraph>\n"
      + "\n"
      + "<paragraph titel=\"Typkonversion\">\n"
      + "Zahlen, die von einem Typ mit einem kleineren Zahlenbereich sind, können\n"
      + "problemlos als Zahlen eines Typs mit einem größeren Zahlenbereich betrachtet\n"
      + "werden. Umgekehrt ist das nicht so. Eine <tt>int</tt>-Zahl kann so zum\n"
      + "Beispiel zu groß sein, um als ein <tt>char</tt>-Wert gespeichert zu werden.\n"
      + "Es ist also Vorsicht walten zu lassen, wenn man zwischen den verschiedenen\n"
      + "Typen die Daten hin und her bewegt.\n"
      + "\n"
      + "Es gibt eine explizite Notation, um eine Zahl zu einem anderen Zahlentypen zu\n"
      + "konvertieren. Hierzu wird in runden Klammern der neue gewünschte Typ für einen\n"
      + "Ausdruck vor diesen geschrieben. Diese Operation wird \n"
      + "als <em>cast</em> bezeichnet. Man muß bei dieser expliziten Typkonvertierung\n"
      + "genau darauf acht geben, welchen Ausdruck man genau konvertieren \n"
      + "möchte.  So bedeutet <tt>(double)(3/2)</tt>, dass erst die ganzzahlige \n"
      + "Division durchzuführen ist und dieses Ergebnis dann als Fließkommazahl\n"
      + "betrachtet wird; dahingegen bedeutet <tt>(double)3/2)</tt>, dass zunächst \n"
      + "die <tt>3</tt> als Fließkommazahl zu betrachten ist und dann für\n"
      + "Fließkommazahlen die Division durchzuführen ist. \n"
      + "\n"
      + "Man überzeuge sich davon im folgenden textprogramm:\n"
      + "\n"
      + "<code class=\"Convert\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int main(){\n"
      + "  int x = 224;\n"
      + "  double d = x;\n"
      + "  char c = x;\n"
      + "\n"
      + "  printf(\"%i\n\",x);\n"
      + "  printf(\"%f\n\",d);\n"
      + "  printf(\"%i\n\",c);\n"
      + "\n"
      + "  printf(\"%f\n\",(double)(3/2));\n"
      + "  printf(\"%f\n\",(double)3/2);\n"
      + "  printf(\"%f\n\",3/2);\n"
      + "  printf(\"%i\n\",3/2);\n"
      + "  printf(\"%i\n\",(int)(3.0/2.0));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Die Ausgabe offenbahrt den fundamentalen unterschied.\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c> ./Convert\n"
      + "224\n"
      + "224.000000\n"
      + "-32\n"
      + "1.000000\n"
      + "1.500000\n"
      + "1.500000\n"
      + "1\n"
      + "sep@pc305-3:~/fh/c>]]></scode>\n"
      + "\n"
      + "Tatsächlich ist meine persönliche Erfahrung: bei einem <em>cast</em> lieber\n"
      + "eine Klammer zu viel setzen als zu wenig.\n"
      + "</paragraph>\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "<paragraph titel=\"Fließkommazahlen\">\n"
      + "Der folgende Test zeigt, daß bei einer Addition von zwei Fließkommazahlen die\n"
      + "kleinere Zahl das Nachsehen hat:  \n"
      + "\n"
      + "<code class=\"DoubleTest\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  double x = 325e200;\n"
      + "  double y = 325e-200;\n"
      + "  double z = -325e+200;\n"
      + "  printf(\"x: %6.20e\n\",x);\n"
      + "  printf(\"y: %6.20e\n\",y);\n"
      + "  printf(\"x+y: %6.20e\n\",(x+y));\n"
      + "  printf(\"x+z: %6.20e\n\",(x+z));\n"
      + "  printf(\"x+100000: %6.20e\n\",x+100000.0);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Wie man an der Ausgabe erkennen kann: selbst die Addition der \n"
      + "Zahl <tt>100000</tt> bewirkt keine Veränderung auf einer großen\n"
      + "Fließkommazahl: \n"
      + "\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> ./DoubleTest\n"
      + "x: 3.24999999999999978946e+202\n"
      + "y: 3.25000000000000017969e-198\n"
      + "x+y: 3.24999999999999978946e+202\n"
      + "x+z: 0.00000000000000000000e+00\n"
      + "x+100000: 3.24999999999999978946e+202\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "\n"
      + "Das folgende kleine Beispiel zeigt, inwieweit und für den Benutzer oft auf\n"
      + "überraschende Weise die Fließkommadarstellung zu Rundungen führt:\n"
      + "<code class=\"Rounded\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"8.0f =%20f \n\",8.0f);\n"
      + "  printf(\"88.0f =%20f \n\",88.0f);\n"
      + "  printf(\"888.0f =%20f \n\",888.0f);\n"
      + "  printf(\"8888.0f =%20f \n\",8888.0f);\n"
      + "  printf(\"88888.0f =%20f \n\",88888.0f);\n"
      + "  printf(\"888888.0f =%20f \n\",888888.0f);\n"
      + "  printf(\"8888888.0f =%20f \n\",8888888.0f);\n"
      + "  printf(\"88888888.0f =%20f \n\",88888888.0f);\n"
      + "  printf(\"888888888.0f =%20f \n\",888888888.0f);\n"
      + "  printf(\"8888888888.0f =%20f \n\",8888888888.0f);\n"
      + "  printf(\"88888888888.0f =%20f \n\",88888888888.0f);\n"
      + "  printf(\"888888888888.0f =%20f \n\",888888888888.0f);\n"
      + "\n"
      + "  printf(\"1.0f+1000000000000.0f-1000000000000.0f =%15f \n\"\n"
      + "        ,1.0f+1000000000000.0f-1000000000000.0f);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "Das Programm hat die folgende Ausgabe. Insbesondere in der letzten Zeile\n"
      + "  fällt auf, daß Addition und anschließende Subtraktion ein und derselben Zahl\n"
      + "  nicht die Identität ist. Für Fließkommazahlen gilt \n"
      + "nicht: <m>x + y - y = x</m>.\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> ./bin/Rounded\n"
      + "8.0f =            8.000000\n"
      + "88.0f =           88.000000\n"
      + "888.0f =          888.000000\n"
      + "8888.0f =         8888.000000\n"
      + "88888.0f =        88888.000000\n"
      + "888888.0f =       888888.000000\n"
      + "8888888.0f =      8888888.000000\n"
      + "88888888.0f =     88888888.000000\n"
      + "888888888.0f =    888888896.000000\n"
      + "8888888888.0f =   8888889344.000000\n"
      + "88888888888.0f =  88888885248.000000\n"
      + "888888888888.0f = 888888885248.000000\n"
      + "1.0f+1000000000000.0f-1000000000000.0f =       0.000000\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "\n"
      + "<paragraph titel=\"Bibliothek mathematischer Funktionen\">\n"
      + "Oft reichen die Grundrechenarten nicht aus. Insbesondere in der graphischen\n"
      + "Datenverarbeitung muß an in der Lage sein, die trigeometrischen Funktionen \n"
      + "wie <m>\\cos, \\sin, \\tan,\\dots</m> für Zahlen zu berechnen. Desweiteren werden\n"
      + "oft die Zahl <m>\\pi</m> benötigt. Hierzu gibt es in C eine Standardbibliothek,\n"
      + "in der eine Vielzahl von mathematischen Funktionen enthalten sind. Die\n"
      + "Bibliothek ist in der Kopfdatei <tt>math.h</tt> definiert.\n"
      + "\n"
      + "<code class=\"MathExample\" lang=\"c\" main=\"main\"  \n"
      + "compileoptions=' echo -lm '\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "#include <math.h>\n"
      + "int main(){\n"
      + "  printf(\"%f\n\",sin(M_PI));\n"
      + "  printf(\"%f\n\",sin(90));\n"
      + "  printf(\"%f\n\",sqrt(64));\n"
      + "  printf(\"%f\n\",pow(2,10));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Tatsächlich kann es zu Fehlern kommen, wenn der Linker ein Programm mit den\n"
      + "mathematischen Funktionen linken soll. \n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/tutor> gcc src/MathExample.c\n"
      + "/tmp/ccs63nup.o(.text+0x23): In function `main':\n"
      + ": undefined reference to `sin'\n"
      + "/tmp/ccs63nup.o(.text+0x51): In function `main':\n"
      + ": undefined reference to `sin'\n"
      + "/tmp/ccs63nup.o(.text+0x7f): In function `main':\n"
      + ": undefined reference to `sqrt'\n"
      + "/tmp/ccs63nup.o(.text+0xb9): In function `main':\n"
      + ": undefined reference to `pow'\n"
      + "collect2: ld returned 1 exit status\n"
      + "sep@pc305-3:~/fh/c/tutor>]]></scode>\n"
      + " \n"
      + "Hierzu ist dem Compiler für den Linker noch die Information mitzugeben, dass\n"
      + "die entsprechende mathematische Standardbibliothek mit einzulinken ist. Das\n"
      + "entsprechende <em>Flag</em> heisst: <tt>-lm</tt>.\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/tutor> gcc -lm src/MathExample.c\n"
      + "sep@pc305-3:~/fh/c/tutor>]]></scode>\n"
      + "</paragraph>\n"
      + "\n"
      + "\n"
      + "<aufgabe blatt=\"4\">Schreiben Sie eine Funktion<br /> \n"
      + "<tt>double kreisUmfang(double radius);</tt><br />\n"
      + "Sie soll für einen gegebenen Radius den Umfang eines Kreises berechnet.\n"
      + "<loesung><code class=\"Umfang\" lang=\"c\" main=\"main\"  \n"
      + "compileoptions=' echo -lm '\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "#include <math.h>\n"
      + "\n"
      + "double kreisUmfang(double radius){\n"
      + "  return 2*M_PI*radius;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"der Umfang bei einem radius 5 ist: %f\n\",kreisUmfang(5));\n"
      + "  return 0;\n"
      + "}]]></code></loesung>\n"
      + "</aufgabe>\n"
      + "\n"
      + "<aufgabe blatt=\"4\">Schreiben Sie eine Funktion<br /> \n"
      + "<tt>double kreisFlaeche(double radius);</tt><br />\n"
      + "Sie soll für einen gegebenen Radius den Flächeninhalt eines Kreises berechnet.\n"
      + "\n"
      + "<loesung><code class=\"Flaeche\" lang=\"c\" \n"
      + "main=\"gcc -lm -o Flaeche ../obj/Flaeche.o  \" compileoptions=' echo -lm '\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "#include <math.h>\n"
      + "\n"
      + "double kreisFlaeche(double radius){\n"
      + "  return M_PI* pow(radius,2.0);\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"die Flaeche bei einem radius 5 ist: %f\n\",kreisFlaeche(5));\n"
      + "  return 0;\n"
      + "}]]></code></loesung>\n"
      + "\n"
      + "</aufgabe>\n"
      + "\n"
      + "\n"
      + "<aufgabe blatt=\"4\"><b>(1 Punkt)</b>Schreiben Sie eine Prozedur<br /> \n"
      + "<tt>void printDual(int i);</tt><br />\n"
      + "Sie soll den Parameter <tt>i</tt> als Dualzahl auf der Konsole ausdrucken.<p\n"
      + "/>\n"
      + "\n"
      + "<b>Hinweis:</b> Leiten Sie Ihre Lösung aus der Lösung für die \n"
      + "Funktion <tt>alsText</tt> ab. Jetzt ist eine Funktion:<br/>\n"
      + "<tt>int hoechsteZweierPotenz(int i);</tt><br />\n"
      + "hilfreich.\n"
      + "\n"
      + "\n"
      + "<loesung>\n"
      + "<code class=\"AlsDual\" lang=\"c\" compileoptions=\" echo -std=c99 \"\n"
      + "main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int hoechsteZweierPotenz(int i){\n"
      + "  int result = 1;\n"
      + "  while (i>=2){\n"
      + "    result=result*2;\n"
      + "    i=i/2;\n"
      + "  }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "void printDual(int i){\n"
      + "  if (i<0){ \n"
      + "    printf(\"-\");\n"
      + "    i= -i;\n"
      + "  }\n"
      + "\n"
      + "  for (int hoechsteStelle = hoechsteZweierPotenz(i)\n"
      + "      ;hoechsteStelle>0\n"
      + "      ;hoechsteStelle=hoechsteStelle/2) {\n"
      + "    printf(\"%i\",i/hoechsteStelle);\n"
      + "    i=i%hoechsteStelle;\n"
      + "  }\n"
      + "  printf(\"\n\");\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printDual(-142);\n"
      + "  printDual(1024);\n"
      + "  printDual(0);\n"
      + "  printDual(-0);\n"
      + "  printDual((17+4)*2);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</loesung>\n"
      + "</aufgabe>\n"
      + "\n"
      + "</paragraph>\n"
      + "</subsubsection>\n"
      + "\n"
      + "\n"
      + "\n"
      + "</subsection>\n"
      + "</section>\n"
      + "\n"
      + "\n"
      + "<section titel=\"Neue Namen für Typen einführen\">\n"
      + "Wir schon im letzten Abschnitt zu sehen war, können in C Typennamen aus\n"
      + "mehreren Wörtern bestehen. Wie noch zu sehen wird, können in C Typnamen noch\n"
      + "weitgehend komplizierter zu notieren sein. Daher ist es eine schöne\n"
      + "Eigenschaft von C, dass man neue Namen für Typen definieren kann. Hierzu gibt\n"
      + "es das <tt>typedef</tt>-Konstrukt. Nach dem \n"
      + "Wort <tt>typedef</tt> ist der Typ zu schreiben, für den ein neuer Name\n"
      + "eingeführt wird. Schließlich ist der neue Typnme zu schreiben.\n"
      + "\n"
      + "Im folgenden kleinen Programm wird der neue Name <tt>nat</tt> für den\n"
      + "Typ <tt>unsigned int</tt> eingeführt. Von da an kann im Programm der neue \n"
      + "Name <tt>nat</tt> statt des komplizierteren \n"
      + "Namen <tt>unsigned int</tt> benutzt werden.\n"
      + "\n"
      + "<code lang=\"c\" class=\"Nat\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "typedef unsigned int nat;\n"
      + "\n"
      + "int main(){\n"
      + "  nat n=42;\n"
      + "  printf(\"n = %u\n\",n);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Das <tt>typedef</tt>-Konstrukt in C ist äußerst sinnvoll. der Vorteil liegt\n"
      + "nicht nur in einfacheren sprechenden Namen, die für Typen eingeführt werden\n"
      + "können. Es ist so auch möglich den physikalischen Typ flexibel zu halten. So\n"
      + "kann ein Name für \n"
      + "</section>\n"
      + "\n"
      + "<section titel=\"Strukturen\">\n"
      + "Bisher haben wir gänzlich auf den eingebauten primitiven Typen in C für Zahlen\n"
      + "aufgebaut. Bei der Programmierung von Anwendungen werden zumeist aber Daten\n"
      + "bearbeitet, die nicht nur aus einer Zahl bestehen, sondern oft ein Tupel aus\n"
      + "mehereren Zahlen sind. So könnte es z.B.~sein, dass wir als Aufgabe ein\n"
      + "Programm für eine Wetterstation schreiben sollen. Die Wetterstation ermittelt\n"
      + "dabei mehrere unterschiedliche Messwerte. Es wird z.B.~Temperatur, Luftdruck,\n"
      + "Luftfeuchtigkeit und die Windstärke gemessen. Die Wetterstation liefert zu\n"
      + "einem Zeitpunkt also vier Meßzahlen mit unterschiedlicher Bedeutung. Diese\n"
      + "vier Zahlen zusammen sind damit ein Datensatz der Wetterstation. Gerne wollen\n"
      + "wir diese vier Zahlen nun auch als ein einziges Datenobjekt betrachten\n"
      + "können. Hierzu bietet C die Möglichkeit über eine Struktur, den \n"
      + "sogenannten <em>structs</em> einen\n"
      + "neuen Typ zu definieren, der aus mehreren bereits bestehenden Typen\n"
      + "zusammengesetzt ist. \n"
      + "\n"
      + "\n"
      + "<subsection titel=\"Definition von Strukturen\">\n"
      + "Eine Struktur wird definiert mit dem Schlüsselwort <tt>struct</tt>, dann folgt\n"
      + "der frei wählbare Name, den die Struktur haben soll. Anschließend wird in\n"
      + "geschweiften Klammern der Inhalt der Struktur definiert. Der Inhalt sind im\n"
      + "Prinzip die Definition struktureigener Variablen.   \n"
      + "\n"
      + "So kann die Struktur definiert werden, die die vier verschiedenen Messwerte\n"
      + "einer Wetterstation zusammenfasst:\n"
      + "\n"
      + "<code lang=\"c\" class=\"Messwerte\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "struct Messwert{\n"
      + "  int temperatur;\n"
      + "  int luftfeuchtigkeit;\n"
      + "  int luftdruck;\n"
      + "  int windstaerke;\n"
      + "};]]></code>  \n";
    String skript2 =

        "\n"
      + "Die Definition einer Struktur endet immer noch mit einem abschließenden\n"
      + "Semikolon. Dieses wird häufig vergessen und führt mitunter zu verwirrenden\n"
      + "Fehlermeldungen.\n"
      + "\n"
      + "Strukturen werden in anderen Programmiersprachen üblicher Weise auch \n"
      + "als <tt>record</tt> bezeichnet.\n"
      + "\n"
      + "Die einzelnen Teile einer Struktur werden auch als ihre Attribute oder auch\n"
      + "als ihre Felder bezeichnet. In dieser Terminologie hat die \n"
      + "Struktur <tt>Messwert</tt> vier Felder, bzw. vier Attribute.\n"
      + "\n"
      + "Nachdem einmal eine Struktur  definiert wurde, steht sie als neuer\n"
      + "Typname zur Verfügung. Der neue Typname ist dann in unserem \n"
      + "Beispiel: <tt>struct Messwert</tt>, besteht also aus zwei Wörtern, so wie ja\n"
      + "auch schon der Typname für natürliche Zahlen aus zwei den \n"
      + "Wörtern <tt>unsigned int</tt> besteht. \n"
      + "\n"
      + "Dieser neue eigene Typ kann nun genauso verwendet werden, \n"
      + "wie z.B.~Typ <tt>int</tt> bisher: Variablen von diesem Typ können definiert\n"
      + "werden und Parameter von diesem Typ können definiert werden.  \n"
      + "\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Erzeugen von Strukturobjekten\"> \n"
      + "Wir haben uns angewöhnt, möglichst gleich bei der Delkaration einer Variablen,\n"
      + "dieser Variablen auch einen Wert zu geben. Das geht auch mit Variablen von\n"
      + "einem <tt>struct</tt>-Typ. Hierzu sind dann die Werte der einzelnen Attribute\n"
      + "aufzuzählen. Diese Aufzählung ist durch Komma getrennt innerhalb geschweifter\n"
      + "Klammern vorzunehmen. Die Reihenfolge der einzelnen Werte entspricht der\n"
      + "Reihenfolge, in der die Attribute in der Struktur definiert wurden.\n"
      + "\n"
      + "<code lang=\"c\" class=\"Messwerte\" sequel=\"true\" main=\"main\"><![CDATA[int main(){\n"
      + "  struct Messwert m1 = {22,41,997,8};]]></code>  \n"
      + "\n"
      + "Hiermit wurde ein Objekt der Struktur <tt>Messwert</tt> angelegt, das eine\n"
      + "Temperaturwert von <tt>22</tt>, Feuchtigkeitswert von <tt>41</tt>, einen\n"
      + "Luftdruck von <tt>997</tt> und eine Windstärke von <tt>8</tt> speichert.\n"
      + "\n"
      + "Ebenso wie bei einfachen Variablen vom Typ <tt>int</tt> können wir zunächst\n"
      + "aber auch erst einmal die Variable deklarieren und dann schrittweise die\n"
      + "einzelnen Werte zuweisen. Hierzu gibt es den Punkt-Operator, mit dem man auf\n"
      + "die einzelnen Attribute einer Struktur einzeln zugreifen und diese dann\n"
      + "einzeln auch mit Werten belegen  kann:\n"
      + "\n"
      + "\n"
      + "<code lang=\"c\" class=\"Messwerte\" sequel=\"true\" main=\"main\"><![CDATA[  struct Messwert m2;\n"
      + "  m2.temperatur=17;\n"
      + "  m2.luftfeuchtigkeit=57;\n"
      + "  m2.luftdruck=1004;\n"
      + "  m2.windstaerke=4;]]></code>  \n"
      + "\n"
      + "Hiermit wurde ein zweites Objekt der Struktur Messwert angelegt und die\n"
      + "einzelnen Felder mit Werten belegt.\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Zugriff auf Strukturkomponenten\"> \n"
      + "Die Punkt-Notation kann natürlich nicht nur genutzt werden, um den einzelnen\n"
      + "Felder einer Struktur Werte zuzuweisen, sondern auch um auf die darin\n"
      + "gespeicherten Werte zuzugreifen. So können wir die Werte einzelner Felder\n"
      + "unserer Strukturobjekte ausgeben:\n"
      + "\n"
      + "<code lang=\"c\" class=\"Messwerte\" sequel=\"true\" main=\"main\"><![CDATA[  printf(\"temperatur: %i\n\",m1.temperatur);\n"
      + "  printf(\"m1.luftdruck: %i\n\",m1.luftdruck);\n"
      + "  m1.temperatur = m1.temperatur-2; \n"
      + "  printf(\"m1.temperatur: %i\n\",m1.temperatur);\n"
      + "  printf(\"m2.temperatur: %i\n\",m2.temperatur);\n"
      + "  return 0;\n"
      + "};]]></code>  \n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Strukturen als Funktionsparameter\"> \n"
      + "Wir haben gelernt, dass C bei Funktionsaufrufen eine Parameterübergabe per\n"
      + "Wert vornimmt. Das ist für einfache Zahlen, also <tt>int</tt>-Parameter recht\n"
      + "einsichtig. Wie sieht dieses aber für Variablen eines Strukturtyps aus? Wir\n"
      + "können dies einmal mit einer simplen Struktur testen. Hierzu sei eine Struktur\n"
      + "definiert, in der die <tt>x</tt>- und <tt>y</tt>-Koordinate eines Punktes im\n"
      + "zweidimensionalen Raum gespeichert werden können:\n"
      + "\n"
      + "<code lang=\"c\" class=\"Punkt1\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "struct Punkt{\n"
      + "  int x;\n"
      + "  int y;\n"
      + "};]]></code>\n"
      + "\n"
      + "Für diese Struktur seien ein Paar Funktionen definiert. Zunächst eine schöne\n"
      + "Ausgabe eines Punktes auf der Kommandozeile:\n"
      + "\n"
      + "<code lang=\"c\" class=\"Punkt1\" sequel=\"true\" main=\"main\"\n"
      + "><![CDATA[void printPunkt(struct Punkt p){\n"
      + "  printf(\"(%i,%i)\n\",p.x,p.y);\n"
      + "}]]></code>\n"
      + "\n"
      + "Eine zweite Funktion soll einen Punkt um eins auf der x-Achse und um 2 auf der\n"
      + "y-Achse verschieben.\n"
      + "\n"
      + "<code lang=\"c\" class=\"Punkt1\" sequel=\"true\" main=\"main\"\n"
      + "><![CDATA[void verschiebe(struct Punkt p){\n"
      + "  p.x=p.x+1;\n"
      + "  p.y=p.y+2;\n"
      + "}]]></code>\n"
      + "Nun seien die beiden Funktionen einmal ausgetestet. Hierzu legen wir einen\n"
      + "Punkt an, geben diesen aus, verschieben ihn und geben ihn erneut aus:\n"
      + "\n"
      + "<code lang=\"c\" class=\"Punkt1\" sequel=\"true\" main=\"main\"\n"
      + "><![CDATA[int main(){\n"
      + "  struct Punkt p={17,4};\n"
      + "  printPunkt(p);\n"
      + "  verschiebe(p);\n"
      + "  printPunkt(p);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Tatsächlich wird zweimal der gleiche Punkt ausgegeben:\n"
      + "\n"
      + "<scode><![CDATA[]]></scode>\n"
      + "\n"
      + "Die Funktion <tt>verschiebe</tt> hat den Punkt <tt>p</tt> gar nicht\n"
      + "verändert. Was man hier sieht, ist, dass auch Strukturobjekte in C per Wert\n"
      + "übergeben werden. Da eine Struktur über ihre Felder mehrere Werte\n"
      + "repräsentiert, werden also tatsächlichen sämtliche Werte eines\n"
      + "Strukturobjektes übergeben. Anders ausgedrückt: es wird eine komplette Kopie\n"
      + "des Strukturobjektes vorgenommen.<footnote>Bei Javaprogrammierern, die\n"
      + "Neulinge in C \n"
      + "sind, führt in der Regel das obige Testprogramm zu einiger \n"
      + "Bestürzung.</footnote> Jeder Aufruf einer Funktion in C mit einer Struktur als\n"
      + "Parameter führt zur Erzeugung einer Kopie dieser Struktur. Die Kopie ist dann\n"
      + "vollkommen unabhängig zum Originalstrukturobjekt.\n"
      + "\n"
      + "\n"
      + "Da Parameter auch nur eine Form von Variable sind, gilt obiges in gleicher\n"
      + "Weise für die Zuweisung einer Variable. Auch dabei wird eine Kopie der Daten\n"
      + "vorgenommen.\n"
      + "\n"
      + "\n"
      + "Hierzu betrachte man folgendes Programm:\n"
      + "\n"
      + "<code lang=\"c\" class=\"Punkt2\" sequel=\"true\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "struct Punkt{\n"
      + "  int x;\n"
      + "  int y;\n"
      + "};\n"
      + "void printPunkt(struct Punkt p){\n"
      + "  printf(\"(%i,%i)\n\",p.x,p.y);\n"
      + "}\n"
      + "int main(){\n"
      + "  struct Punkt p1={17,4};\n"
      + "  struct Punkt p2=p1;\n"
      + "  printPunkt(p1);\n"
      + "  printPunkt(p2);\n"
      + "  p2.x=0;\n"
      + "  printPunkt(p1);\n"
      + "  printPunkt(p2);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Mit der Zuweisung <tt>p2=p1</tt> werden die Werte des \n"
      + "Strukturobjekts <tt>p1</tt> genommen um ein neues \n"
      + "Strukturobjekt <tt>p2</tt> zu erzeugen. Von da an, \n"
      + "haben <tt>p1</tt> und <tt>p2</tt> nichts mehr miteinander zu tun. Wird eine\n"
      + "der Variablen verändert, so bleibt die andere davon unberührt, wie an der\n"
      + "Ausgabe des Programms zu sehen ist:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/tutor> bin/Punkt2\n"
      + "(17,4)\n"
      + "(17,4)\n"
      + "(17,4)\n"
      + "(0,4)\n"
      + "sep@pc305-3:~/fh/c/tutor>]]></scode>\n"
      + "\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Einwortnamen für Strukturen\"> \n"
      + "Die Typnamen von Strukturen bestehen in C aus zwei Wörtern: dem \n"
      + "Wort <tt>struct</tt>  und dem eigentlichen Namen der Struktur. Das ist relativ\n"
      + "umständlich. Man kann sich hier das Leben durch einen Trick vereinfachen,\n"
      + "indem man gleichzeitig mit der Deklaration einer Struktur über \n"
      + "das <tt>typedef</tt>-Konstrukt einen Kurznamen für diese Struktur\n"
      + "erfindet. Hierzu betrachte man noch einmal das Beispiel der simplen Struktur\n"
      + "für zweidimensionale Punkte.\n"
      + "\n"
      + "<code lang=\"c\" class=\"Punkt3\" sequel=\"true\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "typedef struct {\n"
      + "  int x;\n"
      + "  int y;\n"
      + "} Punkt;\n"
      + "\n"
      + "void printPunkt( Punkt p){\n"
      + "  printf(\"(%i,%i)\n\",p.x,p.y);\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  Punkt p={17,4};\n"
      + "  printPunkt(p);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Hier konnte bei der Deklaration von Variablen des Typs <tt>Punkt</tt> auf \n"
      + "das Wort <tt>struct</tt> verzichtet werden.\n"
      + "</subsection>\n"
      + "\n"
      + "<aufgabe  blatt=\"5\"><b>(1 Punkt)</b><br/>\n"
      + "Auf diesen Übungsblatt sollen Sie eine kleine Bibliothek für komplexe Zahlen\n"
      + "  schreiben und austesten. Komplexe Zahlen werden meist in der \n"
      + "Form  <m>a+b * i</m>\n"
      + "dargestellt, wobei <m>a</m> und <m>b</m> reelle Zahlen sind und <m>i</m> die\n"
      + "  imaginäre Einheit ist. <m>a</m> wird dabei als Realteil \n"
      + "und <m>b</m> als Imaginärteil bezeichnet.\n"
      + "\n"
      + "<unteraufgaben>\n"
      + "<teil>Schreiben Sie eine Struktur, mit der komplexe Zahlen dargestellt werden\n"
      + "kann. Die Struktur soll unter den Typnamen <tt>Complex</tt> benutzbar \n"
      + "sein.</teil>\n"
      + "<teil>Schreiben Sie eine Funktion <tt>void printComplex(Complex c)</tt>, die\n"
      + "eine  komplexe Zahl auf der Kommandozeile ausgibt.</teil>\n"
      + "<teil>Für komplexe Zahlen sind Addition und Multiplikation wie folgt\n"
      + "definiert:\n"
      + "<itemize>\n"
      + "<item><m>(a+b\\,\\mathrm i)+(c+d\\,\\mathrm i)=(a+c)+(b+d)\\,\\mathrm i</m></item>\n"
      + "<item><m>(a + b \\, \\mathrm i) - (c + d \\, \\mathrm i) = (a - c) + (b - d) \\, \\mathrm i</m></item>\n"
      + "<item><m>(a+b\\,\\mathrm{i})\\cdot(c+d\\,\\mathrm{i})=(ac-bd) + (ad+bc)\\cdot\\mathrm i</m></item>\n"
      + "<item><m>\\frac{a+b\\,\\mathrm i}{c+d\\,\\mathrm i} = \\frac{(a+b\\,\\mathrm i)(c-d\\,\\mathrm i)}{(c+d\\,\\mathrm i)(c-d\\,\\mathrm i)} = \\frac{ac+bd}{c^2+d^2}+\\frac{bc-ad}{c^2+d^2}\\cdot\\mathrm i</m></item>\n"
      + "\n"
      + "</itemize>\n"
      + "\n"
      + "\n"
      + "Implementieren Sie die Funktionen <tt>add</tt>, <tt>sub</tt>, <tt\n"
      + ">mult</tt> und <tt>div</tt>, die zwei\n"
      + "komplexe Zahlen als Argument haben und eine komplexe Zahl \n"
      + "nach obigen Definitionen als Ergebnis zurückgeben.\n"
      + "\n"
      + "</teil>\n"
      + "<teil>Die Norm einer\n"
      + "    komplexen Zahl erhält man, wenn\n"
      + "    zum Quadrat des Realteils  das Quadrat des Imaginärteils\n"
      + "    addiert wird. Schreiben Sie eine Funktion <tt>norm</tt>, die für\n"
      + "eine komplexe Zahl ihre Norm berechnet.\n"
      + "</teil>\n"
      + "\n"
      + "<teil>Für die Erzeugung der als Apfelmännchen bekannten \n"
      + "Fraktale spielt die folgende Rekursionsgleichung auf komplexen Zahlen eine\n"
      + "entscheidene Rolle:  <m>z_{n+1} = z_n^2 + c</m>, wobei <m>z_0</m> die \n"
      + "komplexe Zahl <m>0+0i</m> mit dem Real-\n"
      + "und Imaginärteil <m>0</m> ist.<br/>\n"
      + "Schreiben Sie eine \n"
      + "Funktion<br /> \n"
      + "<tt>unsigned int schwelle(Complex c,double schwellwert)</tt><br/>\n"
      + "die das kleinste <m>n</m> berechnet, für das \n"
      + "gilt: <m>\\mathrm norm(z_n)&gt; \\mathrm schwellwert</m>.\n"
      + "</teil>\n"
      + "<teil>Schreiben Sie umfangreiche Tests in einer Funktion <tt>main</tt>.</teil>\n"
      + "</unteraufgaben>\n"
      + "\n"
      + "<loesung><code lang=\"h\" class=\"Complex\"><![CDATA[#ifndef COMPLEX_H__\n"
      + "#define COMPLEX_H__\n"
      + "\n"
      + "typedef struct{\n"
      + "  double real;\n"
      + "  double imag;\n"
      + "} Complex;\n"
      + "\n"
      + "void printComplex(Complex c);\n"
      + "\n"
      + "Complex add(Complex x,Complex y);\n"
      + "Complex sub(Complex x,Complex y);\n"
      + "Complex mult(Complex x,Complex y);\n"
      + "Complex divC(Complex x,Complex y);\n"
      + "double norm(Complex x);\n"
      + "unsigned int schwelle(Complex c,double schwellwert);\n"
      + "\n"
      + "\n"
      + "Complex mapComplex(Complex c,double f(double x));\n"
      + "#endif]]></code>\n"
      + "\n"
      + "<code lang=\"c\" class=\"Complex\"><![CDATA[#include \"Complex.h\"\n"
      + "#include <stdio.h>\n"
      + "\n"
      + "void printComplex(Complex c){\n"
      + "  printf(\"(%f,%f)\",c.real,c.imag);\n"
      + "}\n"
      + "\n"
      + "Complex add(Complex x,Complex y){\n"
      + "  Complex result = {x.real+y.real,x.imag+y.imag};\n"
      + "  return result;\n"
      + "}\n"
      + "Complex sub(Complex x,Complex y){\n"
      + "  Complex result = {x.real-y.real,x.imag-y.imag};\n"
      + "  return result;\n"
      + "}\n"
      + "Complex mult(Complex x,Complex y){\n"
      + "  Complex result = {x.real*y.real-x.imag*y.imag\n"
      + "                   ,x.real*y.imag+x.imag*y.real};\n"
      + "  return result;\n"
      + "}\n"
      + "Complex divC(Complex x,Complex y){\n"
      + "  Complex result = { (x.real*y.real+x.imag*y.imag)\n"
      + "                    /(y.imag*y.imag+y.real*y.real)\n"
      + "                   , (x.imag*y.real-x.real*y.imag)\n"
      + "                    /(y.imag*y.imag+y.real*y.real)};\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "double norm(Complex x){\n"
      + "  return x.real*x.real+x.imag*x.imag;\n"
      + "}\n"
      + "unsigned int schwelle(Complex c,double schwellwert){\n"
      + "  unsigned int result = 0;\n"
      + "  Complex z = {0,0};\n"
      + "  while(!(norm(z)> schwellwert) && result<50){\n"
      + "    z=add(mult(z,z),c);\n"
      + "    result=result+1;\n"
      + "  }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "Complex mapComplex(Complex c,double f(double x)){\n"
      + "  Complex result={f(c.real),f(c.imag)};\n"
      + "  return result;\n"
      + "}\n"
      + "]]></code>\n"
      + "\n"
      + "<code lang=\"c\" class=\"TestComplex\" \n"
      + "main=\"gcc -o TestComplex ../obj/TestComplex.o ../obj/Complex.o\"\n"
      + "><![CDATA[#include \"Complex.h\"\n"
      + "#include <stdio.h>\n"
      + "\n"
      + "void nl(){printf(\"\n\");}\n"
      + "\n"
      + "double doppel(double d){return 2*d;}\n"
      + "\n"
      + "int main(){\n"
      + "  Complex c1={-0.3,-0.76868};\n"
      + "  printComplex(c1);\n"
      + "  nl();\n"
      + "  printComplex(add(c1,c1));\n"
      + "  nl();\n"
      + "  printComplex(mult(c1,c1));\n"
      + "  nl();\n"
      + "  printComplex(divC(c1,c1));\n"
      + "  nl();\n"
      + "  printComplex(sub(c1,c1));\n"
      + "  nl();\n"
      + "  printf(\"Norm(c1) = %f\n\",norm(c1));\n"
      + "  printf(\"schwelle(c1,4): %i\n\",schwelle(c1,4));\n"
      + "  printComplex(mapComplex(c1,doppel));\n"
      + "  nl();\n"
      + "  return 0;\n"
      + "}\n"
      + "]]></code>\n"
      + "</loesung>\n"
      + "\n"
      + "</aufgabe>\n"
      + "</section>\n"
      + "\n"
      + "<section titel=\"Aufzählungen\">\n"
      + "Oft kommt es vor, dass man Daten hat, von denen es eine endliche Menge\n"
      + "unterschiedlicher Ausprägung gibt. Diese stehen dann oft auch in einer\n"
      + "bestimmten Reihenfolge. Ein typisches solches Beispiel sind die sieben\n"
      + "Wochentage. Ein Wochentag ist genau einer dieser sieben Werte, und die sieben\n"
      + "Werte stehen in einer festen Reihenfolge.\n"
      + "\n"
      + "Um solche Daten adequat auszudrücken, gibt\n"
      + "es in C die Möglichkeit Aufzählungen zu deklarieren.\n"
      + "\n"
      + "<subsection titel=\"Definition von Aufzählungen\">\n"
      + "Die Deklaration einer Aufzählung beginnt mit dem Wort <tt>enum</tt>, dann\n"
      + "folgt der Name, den der Aufzählungstyp haben soll. Schießlich kommen in\n"
      + "geschweiften Klammern per Komma getrennt die verschiedenen Namen der\n"
      + "Aufzählungselemente. So läßt sich eine Aufzählung für die sieben Wochentage\n"
      + "wie folgt definieren.\n"
      + "\n"
      + "<code class=\"Tage\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "enum Tag\n"
      + " {Montag,Dienstag,Mittwoch,Donnerstag,Freitag,Sonnabend,Sonntag};]]></code>\n"
      + "\n"
      + "Wie auch schon bei Strukturen sind Aufzählungstypen Typen, die aus zwei\n"
      + "Wörtern bestehen: erst das Wort <tt>enum</tt> und dann der eigentliche Name\n"
      + "des Typs. Es lassen sich nun die Namen der einzelnen Elemente als Werte \n"
      + "dieses neuen Typs benutzen. \n"
      + "\n"
      + "<code class=\"Tage\" lang=\"c\" main=\"main\" sequel=\"true\"><![CDATA[int main(){\n"
      + "  enum Tag heute = Montag;]]></code>\n"
      + "\n"
      + "Ein wenig Enttäuschung macht sich breit, wenn wir anfangen mit diesen Werten\n"
      + "zu rechnen. Tatsächlich sind die Werte einer Aufzählung nichts weiter als\n"
      + "einfache natürliche Zahlen. Wir können auf diesen Zahlen rechnen, können Werte\n"
      + "bekommen, die gar nicht in den Aufzählungsrahmen passen und können\n"
      + "Aufzählungsvariablen auch einfach mit willkürlichen Werten belegen, die gar\n"
      + "nichts mit der Aufzählung zu tun haben.\n"
      + "\n"
      + "\n"
      + "<code class=\"Tage\" lang=\"c\" main=\"main\" sequel=\"true\"><![CDATA[  printf(\"heute ist %i\n\",heute);\n"
      + "  heute=heute+1;\n"
      + "  printf(\"heute ist %i\n\",heute);\n"
      + "  heute=heute+6;\n"
      + "  printf(\"heute ist %i\n\",heute);\n"
      + "  heute = 42;\n"
      + "  printf(\"heute ist %i\n\",heute);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Die Ausgabe dieses Programms zeigt deutlich, dass wir es nur mit einfachen\n"
      + "Zahlen zu tun haben.\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/Tage\n"
      + "heute ist 0\n"
      + "heute ist 1\n"
      + "heute ist 7\n"
      + "heute ist 42\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Fallunterscheidung für Aufzählungen\">\n"
      + "Eine schöne Eigenschaft von Aufzählungen ist, dass sich für\n"
      + "Fallunterscheidungen sehr gut der <tt>switch</tt>-Befehl nutzen läßt. Hierzu\n"
      + "betrachte man folgendes Beispiel:\n"
      + "\n"
      + "<code class=\"Tage1\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "enum Tag\n"
      + "  {Montag,Dienstag,Mittwoch,Donnerstag,Freitag,Sonnabend,Sonntag};\n"
      + "\n"
      + "int istWerktag(enum Tag t){\n"
      + "  switch (t){\n"
      + "    case Sonnabend:\n"
      + "    case Sonntag: return 0;\n"
      + "    default:  return 1;\n"
      + "  } \n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"heute ist %i\n\",Montag);\n"
      + "  if (istWerktag(Montag)){\n"
      + "    printf(\"und das ist ein Werktag\n\");\n"
      + "  }\n"
      + "  if (!istWerktag(Sonntag)){\n"
      + "    printf(\"Sonntag ist kein Werktag\n\");\n"
      + "  }\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Einwortnamen für Aufzählungen\">\n"
      + "Die Zweiwortnamen eines Typen sind unpraktisch. Ebenso wie für Strukturen kann\n"
      + "man auch für Aufzählungen mit dem Trick über das <tt>typedef</tt>-Konstrukt\n"
      + "bei der Deklaration einer Aufzählung gleich den Einworttypnamen für die\n"
      + "Aufzählung einführen.\n"
      + "\n"
      + "Obiges Programm wird damit etwas kompakter zu:\n"
      + "\n"
      + "<code class=\"Tage2\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "typedef enum \n"
      + "  {Montag,Dienstag,Mittwoch,Donnerstag,Freitag,Sonnabend,Sonntag} \n"
      + "Tag;\n"
      + "int istWerktag(Tag t){\n"
      + "  switch (t){\n"
      + "    case Sonnabend:\n"
      + "    case Sonntag: return 0;\n"
      + "    default:  return 1;\n"
      + "  } \n"
      + "}\n"
      + "int main(){\n"
      + "  printf(\"heute ist %i\n\",Montag);\n"
      + "  if (istWerktag(Montag)){\n"
      + "    printf(\"und das ist ein Werktag\n\");\n"
      + "  }\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Bool'sche Werte als Aufzählung\">\n"
      + "Wir haben schon mehrfach über einen Typen gesprochen, der sich geradezu dazu\n"
      + "eignet, als Aufzählung dargestellt zu werden. Es ist der Typ für\n"
      + "Wahrheitswerte, von dem es genau zwei Werte gibt. Wir können, da es ja keinen\n"
      + "Typ <tt>bool</tt> in C gibt, diesen in einer winzigen Bibliothek als\n"
      + "Aufzählung definieren:\n"
      + "\n"
      + "<code class=\"Bool\" lang=\"h\"><![CDATA[#ifndef Bool__H_\n"
      + "#define BOOL__H_\n"
      + "typedef enum {false,true} bool;\n"
      + "\n"
      + "void printBool(bool b);\n"
      + "#endif\n"
      + "]]></code>\n"
      + "\n"
      + "Die Implementierung der Prozedur <tt>printBool</tt> ist entsprechend einfach:\n"
      + "\n"
      + "<code class=\"Bool\" lang=\"c\"><![CDATA[#include \"Bool.h\"\n"
      + "#include <stdio.h>\n"
      + "void printBool(bool b){\n"
      + "  if (b) {printf(\"true\n\");\n"
      + "  }else  {printf(\"false\n\");}\n"
      + "}]]></code>\n"
      + "\n"
      + "Inkludieren wir diese kleine Bibliothek so können wir endlich auch in C mit\n"
      + "den Wrten <tt>true</tt> und <tt>false</tt> arbeiten.\n"
      + "\n"
      + "<code class=\"TestBool\" lang=\"c\"\n"
      + "  main=\"gcc -o TestBool ../obj/Bool.o ../obj/TestBool.o \"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "#include \"Bool.h\"\n"
      + "int main(){\n"
      + "  bool b = 1>2;\n"
      + "  printBool(b);\n"
      + "  b=b||true;\n"
      + "  printBool(b);\n"
      + "  b=!b;\n"
      + "  printBool(b);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</subsection>\n"
      + "\n"
      + "</section>\n"
      + "\n"
      + "\n"
      + "<section titel=\"Funktionen als Daten\">\n"
      + "Wir befinden uns im Kapitel über Daten. Trotzdem sollten wir uns noch einmal\n"
      + "den Funktionen widmen. C hat eine wunderbare Eigenschaft, dass auch Funktionen\n"
      + "als Daten betrachtet werden können. Das ist auch gar nicht einmal so\n"
      + "verwunderlich, denn auch Funktionen liegen ja irgendwo im Speicher unseres\n"
      + "Computers. Damit sind auch Funktionen als Daten gespeichert. \n"
      + "In C gibt es nun die Möglichkeit, Funktionen als Parameter an andere\n"
      + "Funktionen zu übergeben. Leider ist die Typnotation für Funktionen dabei etwas\n"
      + "kompliziert. Betrachten wir das Konzept an einem Beispiel.\n"
      + "\n"
      + "\n"
      + "Wir können in C eine Funktion schreiben, die eine andere Funktion als\n"
      + "Parameter erhält. Wozu sollte das gut sein. Es ist z.B. vorstellbar, dass wir\n"
      + "die übergebene Funktion zweimal auf einen Parameter anwenden wollen. Hierzu\n"
      + "können wir die Funktion <tt>twice</tt> definieren.  Sie soll als ersten\n"
      + "Parameter eine Funktion <tt>f</tt> bekommen und als zweiten \n"
      + "Parameter eine Zahl <tt>x</tt>. Das\n"
      + "Ergebnis soll so berechnet werden, dass zunächst die \n"
      + "Funktion <tt>f</tt> auf die Zahl <tt>x</tt> angewendet wird. Anschließend wird\n"
      + "nocheinmal die Funktion <tt>f</tt> auf das Ergebnis der ersten Berechnung\n"
      + "angewendet. Mathematisch läßt sich die Funktion <tt>twice</tt> durch folgende\n"
      + "Gleichung spezifizieren:\n"
      + "\n"
      + "\\begin{displaymath}\n"
      + "\\textrm{twice}(f,x) = f(f(x))\n"
      + "\\end{displaymath}\n"
      + "\n"
      + "\n"
      + "Tatsächlich läßt sich obige Spezifikation ziemlich genau eins-zu-eins in C\n"
      + "umsetzen. Hierzu ist lediglich zu wissen, wie der Typ des Parameters eines\n"
      + "Funktionstyps zu deklarieren ist:\n"
      + "\n"
      + "Soll ein Paramter eine Funktion darstellen, so ist vor dem Parameternamen \n"
      + "der Rückgabetyp zu schreiben, danach in\n"
      + "runde Klammern eingeschlossen die Parametertypen. Damit ist z.B. ein\n"
      + "Parameter, der die Übergabe einer Funktion erwartet, die \n"
      + "einen <tt>int</tt> Parameter erwartet und auch ein <tt>int</tt> als Rückgabe\n"
      + "hat, zu deklarieren als <tt>int f(int)</tt>. Der Parametername ist \n"
      + "hierbei <tt>f</tt>. Wie man sieht, schreibt man einfach die Signatur der\n"
      + "erwarteten Funktion, die übergeben werden soll.\n"
      + "\n"
      + "\n"
      + "So läßt sich die Funktion <tt>twice</tt> direkt ausdrücken als:\n"
      + "\n"
      + "<code lang=\"c\" class=\"Twice\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int twice(int f(int),int x){\n"
      + "  return f(f(x));\n"
      + "}]]></code>\n"
      + "\n"
      + "Um diese Auszutesten, brauchen wir erst einmal eine Funktion, die wir für den\n"
      + "Parameter <tt>f</tt> übergeben können. Hierzu sei einfach die Funktion, die\n"
      + "den Parameter quadriert definiert:\n"
      + "\n"
      + "<code lang=\"c\" class=\"Twice\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[int quadrat(int x){return x*x;}]]></code>\n"
      + "\n"
      + "Wendet man diese Funktion zweimal hintereinander an, so wird hoch vier\n"
      + "gerechnet. Das läßt sich jetzt direkt mit der \n"
      + "Funktion <tt>twice</tt> ausdrücken:\n"
      + "\n"
      + "<code lang=\"c\" class=\"Twice\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[int hoch4(int x){return twice(quadrat,x);}]]></code>\n"
      + "\n"
      + "Und nun ist endlich Zeit, das alles einmal in einer Hauptfunktion\n"
      + "auszuprobieren: \n"
      + "\n"
      + "<code lang=\"c\" class=\"Twice\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[int add5(int x){return x+5;}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"twice(add5,32): %i\n\",twice(add5,32));\n"
      + "  printf(\"hoch4(2): %i\n\",hoch4(2));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Tatsächlich kompiliert das Programm nicht nur, sondern errechnet auch die\n"
      + "erwarteten Ausgaben.\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/Twice\n"
      + "twice(add5,32): 42\n"
      + "hoch4(2): 16\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Alle Arten von Funktionen können als Parameter übergeben werden. So auch \n"
      + "Prozeduren und Funktionen ohne Parameter. Wollen wir z.B. ausdrücken, dass\n"
      + "etwas endlich oft wiederholt werden soll, so läßt sich hierzu eine \n"
      + "Funktion <tt>repeat</tt> schreiben:\n"
      + "\n"
      + "<code lang=\"c\" class=\"Repeat\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "void repeat(int n, void f()){\n"
      + "  if (n>0) {\n"
      + "    f();\n"
      + "    repeat(n-1,f);\n"
      + "  }\n"
      + "}]]></code>\n"
      + "\n"
      + "Nun läßt sich über den Aufruf von <tt>repeat</tt> mehrfach dieselbe Prozedur\n"
      + "aufrufen. \n"
      + "\n"
      + "<code lang=\"c\" class=\"Repeat\" main=\"main\" squel=\"true\"\n"
      + "><![CDATA[void printHallo(){\n"
      + "  printf(\"Hallo\n\");\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  repeat(10,printHallo);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Was noch ein wenig esoterisch anmuten mag, Funktionen als Parameter zu\n"
      + "übergeben, ist in der Programmierung graphischer Benutzeroberflächen in C Gang\n"
      + "und Gebe. Dabei werden graphischen Komponenten, wie z.B. Knöpfen auf der\n"
      + "Oberfläche Funktionen übergeben, die diese Komponenten in bestimmten\n"
      + "Situationen ausführen sollen (z.B. wenn der Knopf gedrückt wird). Solche\n"
      + "Funktionen in der Programmierung graphischer Benutzeroberflächen in C werden\n"
      + "als <em>callback function</em>  bezeichnet.\n"
      + "\n"
      + "Allgemein werden Funktion, die wiederum Funktionen als Parameter haben, als\n"
      + "Funktionen höherer Ordnung bezeichnet. Die \n"
      + "Funktionen <tt>twice</tt> und <tt>repeat</tt> in den obigen Beispielen sind\n"
      + "Funktionen höherer Ordnung.\n"
      + "\n"
      + "\n"
      + "<subsection titel=\"typedef und Funktionstypen\">\n"
      + "Genauso wie für Strukturen und für Aufzählungen läßt sich \n"
      + "das <tt>typedef</tt>-Konstrukt nutzen, um einfachere oder sprechendere Namen\n"
      + "für Funktionstypen einzuführen. So läßt sich das letzte Beispiel\n"
      + "umformulieren, indem Prozeduren ohne Parameter auch als solche bezeichnet\n"
      + "werden:  \n"
      + "<code lang=\"c\" class=\"Repeat2\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "typedef void prozedur();\n"
      + "\n"
      + "void repeat(int n,prozedur f){\n"
      + "  if (n>0) {\n"
      + "    f();\n"
      + "    repeat(n-1,f);\n"
      + "  }\n"
      + "}\n"
      + "\n"
      + "void printHallo(){\n"
      + "  printf(\"Hallo\n\");\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  repeat(10,printHallo);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "<aufgabe blatt=\"5\">\n"
      + "Nehmen Sie Ihre Implementierung aus der letzten Aufgabe und schreiben Sie\n"
      + "jetzt eine Funktion höherer Ordnung:<br />\n"
      + "<tt>Complex mapComplex(Complex c,double f(double x))</tt>.<br/>\n"
      + "Sie soll die komplexe Zahl zurückgeben, die man erhält, wenn man die\n"
      + "übergebene Funktion sowohl auf Real- als auch auf den Imaginärteil\n"
      + "anwendet. Testen Sie auch die Funktion an einigen Beispielen. \n"
      + "</aufgabe>\n"
      + "</subsection> \n"
      + "\n"
      + "</section>\n"
      + "\n"
      + "<section titel=\"Dynamische Daten\">\n"
      + "<subsection titel=\"Adresstypen\">\n"
      + "Alle Daten stehen irgendwo im Hauptspeicher. Nicht nur Daten sondern, wie wir\n"
      + "gesehen haben, auch Funktionen, weshalb wir sie auch als Daten benutzen \n"
      + "können. Da der Speicher unseres Komputers in einzelne Speicherzellen\n"
      + "eingeteilt ist, und diese in Adressen durchnummeriert sind, liegt jedes\n"
      + "Datenobjekt im Speicher in einer Speicherzelle mit einer bestimmten Adresse. \n"
      + "\n"
      + "<subsubsection titel=\"Adressoperator\">\n"
      + "C ermöglicht es über den <tt>&amp;</tt>-Operator auf eben diese Adresse\n"
      + "zuzugreifen. Die Adressen sind dabei eigentlich nur Zahlen, die wir ausgeben\n"
      + "können. \n"
      + "\n"
      + "<code lang=\"c\" class=\"GetAddress\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int f(int x){return 2*x;}\n"
      + "\n"
      + "typedef struct {int x;int y;} Point; \n"
      + "\n"
      + "int main(){\n"
      + "  int x = 42;\n"
      + "  int y = 17;\n"
      + "  Point p ={x,y};\n"
      + "  double d=0.0;\n"
      + "  printf(\"&x: %u\n\",&x);\n"
      + "  printf(\"&y: %u\n\",&y);\n"
      + "  printf(\"&p: %u\n\",&p);\n"
      + "  printf(\"&d: %u\n\",&d);\n"
      + "  printf(\"&f: %u\n\",&f);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Starten wir das Programm, so gibt uns C ein wenig von seinem Innenleben\n"
      + "bekannt. Für die einzelnen Variablen wird die Adresse ausgegeben, an deren\n"
      + "Stelle im Speicher die einzelnen Variablen stehen.\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/GetAddress\n"
      + "&x: 3221219380\n"
      + "&y: 3221219376\n"
      + "&p: 3221219368\n"
      + "&d: 3221219360\n"
      + "&f: 134513548\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Wie man sieht, gibt es für fast alle Daten Adressen: für einfache Typen \n"
      + "wie <tt>int</tt> und <tt>double</tt>, für Strukturen aber auch für\n"
      + "Funktionen. Wie man der Ausgabe entnehmen kann liegen die lokalen Variablen\n"
      + "recht nah beieinander im Hauptspeicher. Die Funktion hingegen an einer\n"
      + "komplett anderen Stelle. Wo im Speicher die einzelnen Daten gespeichert\n"
      + "werden, darauf haben wir allerdings keinen Einfluss, das bestimmt der Compiler\n"
      + "automatisch. \n"
      + "\n"
      + "Adressen gibt es allerdings nur für Daten, die in Variablen gespeichert\n"
      + "sind. Konstanten und beliebige Ausdrücke sind davon ausgeschlossen. Versucht\n"
      + "man es trotzdem, die Adresse zu erfragen, \n"
      + "so kommt es zu einem Übersetzungsfehler:\n"
      + "\n"
      + "<code lang=\"c\" class=\"GetAddressError\"><![CDATA[#include <stdio.h>\n"
      + "int main(){\n"
      + "  printf(\"&42: %u\n\",&42);\n"
      + "  printf(\"&(17+4): %u\n\",&(17+4));\n"
      + "}]]></code>\n"
      + "\n"
      + "Der Compiler gibt folgende Fehlermeldung:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> gcc src/GetAddressError.c\n"
      + "src/GetAddressError.c: In function `main':\n"
      + "src/GetAddressError.c:3: error: invalid lvalue in unary `&'\n"
      + "src/GetAddressError.c:4: error: invalid lvalue in unary `&'\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "</subsubsection>\n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"Adresstype\">\n"
      + "Mit dem <tt>&amp;</tt>-Operator läßt sich für jede Variable die\n"
      + "Speicheradresse geben. Doch was für einen Typ hat dieser Operator als\n"
      + "Rückgabe? Im oberen Testprogramm haben wir die Rückgabe einfach als Zahl\n"
      + "interpretiert zurückgegeben. Wer das Programm aber mit allen Warnungen\n"
      + "übersetzt, ahnt bereits, dass da mehr hinter steckt. \n"
      + "Tatsächlich gibt es zu jedem\n"
      + "Typ in C einen passenden Adresstyp, auch als Zeigertyp oder \n"
      + "Pointertyp bezeichnet. Er wird mit einem Sternsymbol nach dem\n"
      + "Typnamen notiert. So gibt es also zum Typ <tt>int</tt> den \n"
      + "Zeigertyp <tt>int*</tt>. Der <tt>&amp;</tt>-Operator liefert zu einer\n"
      + "Variablen vom Typ <tt>x</tt> die Adresse des Typs <tt>x*</tt>, also für\n"
      + "Variablen des Typs <tt>int</tt> eine Adresse vom Typ <tt>int*</tt>.\n"
      + "\n"
      + "<code class=\"FirstPointer\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "typedef struct {int x;int y;} Point;\n"
      + "\n"
      + "int main(){\n"
      + "  int x = 42;\n"
      + "  int* xp = &x; \n"
      + "  int** xpp = &xp; \n"
      + "  Point p = {17,4};\n"
      + "  Point* pp = &p;\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Wie man an der Variablen <tt>xpp</tt> sieht kann man das Spielchen tatsächlich\n"
      + "mehrfach spielen. Man kann auch von einer Adressvariablen sich wiederum die\n"
      + "Adresse geben lassen. \n"
      + "\n"
      + "Betrachten wir das Programm noch einmal im Detail. In Zeile 5 wird eine\n"
      + "Variable deklariert. Hierzu bedarf es einem Speicherplatz im Hauptspeicher um\n"
      + "eine Zahl zu speichern. Dieser Speicherplatz hat eine Adresse. In Zeile 6 wird\n"
      + "mit <tt>&amp;x</tt> die Adresse des Speicherplatz für die \n"
      + "Variable <tt>x</tt> erfragt. Diese Adresse hat den Typ <tt>int*</tt>. Auch sie\n"
      + " soll in einer Variablen gespeichert werden. Deshalb wird die\n"
      + "Variable <tt>xp</tt> vom Typ <tt>int*</tt> deklariert. Auch die \n"
      + "Variable <tt>xp</tt> wird im Speicher in einer Speicherzelle mit einer \n"
      + "eigenen Adresse gespeichert. Diese Adresse läßt sich \n"
      + "mit <tt>&amp;xp</tt> erfragen. Sie ist vom Typ <tt>int**</tt> und wird in\n"
      + "Zeile 7 in der Variablen <tt>xpp</tt> gespeichert.\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Stern-Operator\">\n"
      + "Mit dem <tt>&amp;</tt>-Operator läßt sich die Speicheradresse einer Variablen\n"
      + "in Form eines Zeigertyps erfragen. Als inversen Operator gibt es in C den\n"
      + "Sternoperator <tt>*</tt>. Wird er auf einen Zeigertyp angewendet, dann werden\n"
      + "die Daten angesprochen, die an der entsprechenden Adresse gespeichert sind.\n"
      + "Er kehrt quasi die Operation des <tt>&amp;</tt>-Operators wieder um. Während\n"
      + "der <tt>&amp;</tt>-Operator für ein <tt>int</tt> eine Adresse auf \n"
      + "ein <tt>int</tt> berechnet, also ein <tt>int*</tt>, berechnet der *-Operator\n"
      + "für ein <tt>int*</tt> wieder ein <tt>int</tt>.\n"
      + "\n"
      + "Jetzt können wir das obige Programm erweitern, und mit Hilfe des\n"
      + "Sternoperators für die Zeigervariablen wieder die Werte erfragen, die in den\n"
      + "Speicherzellen gespeichert sind, auf den die Zeigervariablen verweisen.\n"
      + "\n"
      + "<code class=\"StarOperator\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "typedef struct {int x;int y;} Point;\n"
      + "\n"
      + "int main(){\n"
      + "  int x = 42;\n"
      + "  int* xp = &x; \n"
      + "  int y = *xp;\n"
      + "  printf(\"y = %i\n\",y);\n"
      + "\n"
      + "  int** xpp = &xp; \n"
      + "  int z = **xpp;\n"
      + "  printf(\"z = %i\n\",z);\n"
      + "  printf(\"**xpp = %i\n\",**xpp);\n"
      + "\n"
      + "  *xp = 17;\n"
      + "  printf(\"x = %i\n\",x);\n"
      + "\n"
      + "  Point p = {17,4};\n"
      + "  Point* pp = &p;\n"
      + "  printf(\"(*pp).x = %i\n\",(*pp).x);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/StarOperator\n"
      + "z = 42\n"
      + "**xpp = 42\n"
      + "x = 17\n"
      + "(*pp).x = 17\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Pfeiloperator\">\n"
      + "Beim Zugriff auf die Felder einer Struktur, die über einen Zeiger zugegriffen\n"
      + "wird, ist zunächst mit dem Sternoperator die Referenz aufzulösen, um dann mit\n"
      + "dem Punktoperator auf das Feld der Struktur zuzugreifen. Das gibt dann\n"
      + "Ausdrücke der Form <tt>(*pp).x</tt>, wie bereits im letzten Beispiel gesehen. \n"
      + "C bietet hierfür eine speziellen Operator an, der dieses etwas kürzer notieren\n"
      + "läßt, der Pfeiloperator <tt>-&gt;</tt>. <tt>(*pp).x</tt> kann mit ihm\n"
      + "als <tt>pp-&gt;x</tt> ausgedrückt werden.\n"
      + "\n"
      + "<code class=\"ArrowOperator\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "typedef struct {int x;int y;} Point;\n"
      + "\n"
      + "int main(){\n"
      + "  Point p = {17,4};\n"
      + "  Point* pp = &p;\n"
      + "  printf(\"(*pp).x = %i\n\",(*pp).x);\n"
      + "  printf(\"pp->x = %i\n\",pp->x);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Referenzübergabe\">\n"
      + "Was haben wir mit den Zeigern gewonnen (außer dass es etwas komplizierter wird\n"
      + "Programme zu verstehen)? Man erinnere sich daran, dass in C die Parameter an\n"
      + "eine Funktion immer per Wert übergeben werden. Das bedeutet, dass die\n"
      + "Parameterwerte kopiert werden. Man erinnere sich dazu an das \n"
      + "Beispielprogramm <tt>NoRefparam</tt>. Mit Zeigertypen gibt es nun eine \n"
      + "Möglichkeit, nicht den Wert, sondern die Speicheradresse einer Variablen an\n"
      + "eine Funktion zu übergeben. \n"
      + "Durch minimale Änderungen am Programm <tt>NoRefparam</tt>  erhalten wir ein\n"
      + "Programm, in dem die Funktion tatsächlich die übergebene Variable verändern\n"
      + "kann. \n"
      + "\n"
      + "<code class=\"RefParam\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int f1(int* x){\n"
      + "  *x = 2* (*x);\n"
      + "  return *x;\n"
      + "}\n"
      + "int main(){\n"
      + "  int y = 42;\n"
      + "  int z = f1(&y);\n"
      + "  printf(\"y = %i\n\",y);\n"
      + "  printf(\"z = %i\n\",z);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "Wie man an der Ausgabe sehen kann, ändert der Aufruf von <tt>f1</tt> jetzt\n"
      + "tatsächlich den Wert der Variablen <tt>y</tt>.\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c> ./student/bin/RefParam\n"
      + "y = 84\n"
      + "z = 84\n"
      + "sep@pc305-3:~/fh/c>]]></scode>\n"
      + "\n"
      + "Parameter per Zeiger zu übergeben statt per Wert kann insbesondere sinnvoll\n"
      + "sein, wenn es sich bei den Parametern um Strukturen handelt. Strukturobjekte\n"
      + "können mitunter sehr groß sein und viel Speicherplatz beanspruchen. Auch will\n"
      + "man gerade recht oft Strukturobjekte durch Prozeduraufrufe verändern.\n"
      + "\n"
      + "Betrachten wir hierzu ein weiteres Mal die Struktur <tt>Punkt</tt>. Wir haben\n"
      + "bereits festgestellt, dass bei einer Wertübergabe die \n"
      + "Funktion <tt>verschiebe</tt> das ursprünglichen Punktobjekt gar \n"
      + "nicht verändert. Jetzt per Übergabe des Punktobjets als Zeiger tritt der\n"
      + "gewünschte Effekt ein:\n"
      + "\n"
      +  "<code class=\"Punkt4\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "typedef struct {\n"
      + "  int x;\n"
      + "  int y;\n"
      + "} Punkt;\n"
      + "\n"
      + "void printPunkt(Punkt p){\n"
      + "  printf(\"(%i,%i)\n\",p.x,p.y);\n"
      + "}\n"
      + "\n"
      + "void verschiebe(Punkt* p){\n"
      + "  p->x=p->x+1;\n"
      + "  p->y=p->y+2;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  Punkt p={17,4};\n"
      + "  printPunkt(p);\n"
      + "  verschiebe(&p);\n"
      + "  printPunkt(p);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Zeiger auf lokale Variablen\">\n"
      + "Bisher vertrauen wir auf die automatische Speicherverwaltung lokaler Variablen\n"
      + "in C. Für eine lokale Variable einer Funktion ebenso wie für einen\n"
      + "Funktionsparameter, wird beim Aufruf einer Funktion Platz im Speicher\n"
      + "angelegt. An dieser Stelle werden die Daten der Variablen gespeichert. Sobald\n"
      + "die Funktion fertig ausgewertet ist und ihr Ergebnis berechnet hat, wird\n"
      + "dieser Speicherplatz nicht mehr benötigt. Die Speicherstelle wird wieder\n"
      + "freigegeben, um sie später für eventuelle andere Variablen zu benutzen.\n"
      + "\n"
      + "Da wir uns explizit mit dem <tt>&amp;</tt>-Operator die Adresse einer\n"
      + "Speicherzelle geben lassen können, so können wir eine solche Adresse auch als\n"
      + "Funktionsergebnis zurückgeben. Es läßt sich folgende Funktion definieren:\n"
      + "\n"
      + "<code class=\"DeadVariable\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int* f(int y){\n"
      + "  int x= y;\n"
      + "  return &x;\n"
      + "}]]></code>\n"
      + "\n"
      + "Bei einem Aufruf dieser Funktion erhalten wir einen Zeiger auf eine\n"
      + "Speicherzelle, in der während des Aufrufs eine lokale Variable gespeichert \n"
      + "war. Auf die Variable selbst läßt sich nicht mehr zugreifen. Sie existiert\n"
      + "quasi nicht mehr. Wir haben also einen Zeiger in einen Speicherbereich, der\n"
      + "einmal für eine lokale Variable genutzt wurde. Diese Variable gibt es aber gar\n"
      + "nicht mehr.\n"
      + "\n"
      + "\n"
      + "Der Compiler macht uns auch tatsächlich darauf aufmerksam, dass hier etwas\n"
      + "merkwürdig ist:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c> gcc DeadVariable.c\n"
      + "DeadVariable.c: In function `f':\n"
      + "DeadVariable.c:5: warning: function returns address of local variable\n"
      + "sep@pc305-3:~/fh/c>]]></scode>\n"
      + "\n"
      + "Da es sich aber nur um eine Warnung handelt, vielleicht wissen wir ja was wir\n"
      + "tun, können wir das Programm übersetzen. Wir vervollständigen es um eine\n"
      + "zweite Funktion und um eine Hauptfunktion.\n"
      + "\n"
      + "<code class=\"DeadVariable\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[void f2(int y){\n"
      + "  int z= y;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  int* xp = f(42);\n"
      + "  f2(17);\n"
      + "  printf(\"%i\n\",*xp);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Das Programm kann zu folgender Ausgabe führen:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c> ./DeadVariable\n"
      + "17\n"
      + "sep@pc305-3:~/fh/c>]]></scode>\n"
      + "\n"
      + "Hier läßt sich etwas über die interne Speicherverwaltung unseres Compilers\n"
      + "lernen. Wir lassen uns die Speicherzelle der lokalen \n"
      + "Variablen <tt>x</tt> aus der Funktion <tt>f</tt> zurückgeben. Anschließend\n"
      + "rufen wir die Funktion <tt>f2</tt> auf. Diese hat ihrerseits eine lokale\n"
      + "Variable. Nach Aufruf der Funktion <tt>f2</tt> befindet sich ein Wert in der\n"
      + "Speicherzelle die einstmals die lokale Variable <tt>x</tt> speicherte, der\n"
      + "zuletzt in der lokalen Variablen <tt>z</tt> der Funktion <tt>f2</tt> stand.\n"
      + "\n"
      + "Tatsächlich ist es ziemlicher Zufall, was sich am Speicherplatz einer nicht\n"
      + "mehr existierenden lokalen Variable befindet.\n"
      + "</subsubsection>\n"
      + "<subsubsection titel=\"der NULL-Zeiger\">\n"
      + "Wir haben uns bemüht Variablen immer gleich bei der Deklaration auch einen\n"
      + "initialen Wert zuzuweisen. Wird einer Variablen kein Wert zugewiesen, so hängt\n"
      + "es vom Zufall ab, was für einen Wert man bekommt, wenn auf eine solche noch\n"
      + "nicht initialisierte Variable zugegriffen wird. Dasselbe gilt auch für\n"
      + "Zeigervariablen. Es gibt aber Situationen, in denen man eine Zeigervariable\n"
      + "deklariert, ohne dass schon der zuzuweisende Adresswert vorhanden ist. Oder\n"
      + "umgekehrt: für eine Zeigervariable ist im Laufe des Programms keine gültige\n"
      + "Adresse mehr vorhanden. Um in einer Zeigervariablen nicht einen zufälligen\n"
      + "oder ungültigen Adresswert speichern zu müssen, gibt es in C die Möglichkeit\n"
      + "eines ausgezeichneten null-Zeigers. Er wird durch das \n"
      + "Wort <tt>NULL</tt> bezeichnet. Man kann mit der Gleichheit testen, ob ein\n"
      + "Zeiger mit <tt>NULL</tt> belegt ist.\n"
      + "\n"
      + "<code class=\"NullVar\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[#include <stdlib.h>\n"
      + "#include <stdio.h>\n"
      + "int* f(int* y){\n"
      + "  static int* x=NULL;\n"
      + "  if (NULL!=x) x=y;\n"
      + "  else *y=*x;\n"
      + "  return x;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  int x= 42;\n"
      + "  printf(\"*f(&x)%i\n\",*f(&x));\n"
      + "  x=17;\n"
      + "  printf(\"*f(&x)%i\n\",*f(&x));\n"
      + "  printf(\"x%i\n\",x);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Um den <tt>NULL</tt>-Zeiger verwenden zu können, ist es notwendig die\n"
      + "Bibliothek <tt>stdlib.h</tt> zu inkludieren.\n"
      + "</subsubsection>\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"der void-Zeiger\">\n"
      + "Wir haben gesehen, dass es für jeden Typ, einen entsprechenden Zeigertyp\n"
      + "gibt. So gibt es zu <tt>int</tt> den Zeigertyp <tt>int*</tt> und\n"
      + "für eine Struktur <tt>struct Punkt</tt> den \n"
      + "Zeigertyp <tt>struct Punkt*</tt>. Technisch gesehen sind alle diese\n"
      + "Zeigertypen eine Zahl, die eine Adresse in unserem Speicherbereich\n"
      + "bezeichnet. Also sind eigentlich alle Zeigertypen Daten von derselben Art. Die\n"
      + "Programmiersprache C bietet einen besonderen allgemeinen Zeigertyp an, der\n"
      + "ausdrückt, dass es sich um irgendeinen Zeiger handelt, der aber nicht angibt,\n"
      + "was in der Speicheradresse gespeichert ist, auf die der Zeiger\n"
      + "verweist. Dieser allgemeine Zeigertyp wird mit <tt>void*</tt> bezeichnet. Das\n"
      + "Wort <tt>void</tt> sollte hier so gelesen werden, dass nicht bekannt\n"
      + "ist, was für Daten an der Speicherstelle stehen, auf die verwiesen wird.\n"
      + "\n"
      + "\n"
      + "Zunächst definieren wir als Beispiel eine kleine Struktur:\n"
      + "<code class=\"VoidPointer\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "typedef struct {\n"
      + "  int x;\n"
      + "  int y;\n"
      + "} Punkt;]]></code>\n"
      + "\n"
      + "Wir wollen einmal einen <tt>void</tt>-Zeiger benutzen:\n"
      + "\n"
      + "<code class=\"VoidPointer\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[int main(){\n"
      + "  void* object;]]></code>\n"
      + "\n"
      + "In diesem <tt>void</tt>-Zeiger läßt sich jetzt z.B. die Adresse \n"
      + "einer <tt>int</tt>-Vatiablen speichern.\n"
      + "\n"
      + "<code class=\"VoidPointer\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[  int x = 17;\n"
      + "  object = &x;]]></code>\n"
      + "\n"
      + "Soll die Adresse über den <tt>void</tt>-Zeiger angesprochen werden und mit der\n"
      + "darin gespeicherte Zahl gerechnet werden, so müssen wir explizit den Zeiger zu\n"
      + "einem Zeiger auf eine <tt>int</tt>-Zahl umwandeln. Hierzu ist die Notation in\n"
      + "runden Klammern zu benutzen, wie wir sie schon vom Rechnen mit primitiven\n"
      + "Zahlen gewohnt sind. \n"
      + "\n"
      + "<code class=\"VoidPointer\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[  *(int*)object += 4; \n"
      + "  *(int*)object *= 2; \n"
      + "  printf(\"x = %i\\n\",x);]]></code>\n"
      + "\n"
      + "Wir können aber auf die gleiche Weise versuchen, in \n"
      + "der <tt>void</tt>-Zeigervariablen ein Objekt unserer Punktstruktur zu\n"
      + "speichern. Um wieder auf das Objekt zugreifen zu können, ist dann der Zeiger\n"
      + "wieder entsprechend umzuwandeln.\n"
      + "\n"
      + "\n"
      + "<code class=\"VoidPointer\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[  Punkt p = {2,6};\n"
      + "  object = &p;\n"
      + "\n"
      + "  printf(\"p.x: %i\\n\",p.x);\n"
      + "  printf(\"((Punkt*)object)->x: %i\\n\",((Punkt*)object)->x);\n"
      + "\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Im obigen Beispiel ist mit dem Namen <tt>object</tt> schon angedeutet, wofür\n"
      + "man den <tt>void</tt>-Zeiger verwenden kann: für die Möglichkeit, Zeiger auf\n"
      + "Daten belieber Art zu speiechern. In der objektorientierten Programmierung\n"
      + "wird dieses in dem Konzept eines allgemeinen Objektes münden. Am Ende dieses\n"
      + "Kapitels werden wir ein Beispiel sehen, in dem wir <tt>void</tt>-Pointer\n"
      + "sinnvoll nutzen.\n"
      + "\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Rechnen mit Zeigern\">\n"
      + "Zeiger sind technisch nur die Adressen bestimmter Speicherzellen, also\n"
      + "nichts weiteres als Zahlen. Und mit Zahlen können wir rechnen. So\n"
      + "können tatsächlich arithmetische Operationen auf Zeigern durchgeführt\n"
      + "werden. \n"
      + "\n"
      + "<example>\n"
      + "Wir erzeugen mehrere Zeiger auf ganze Zahlen und betrachten die\n"
      + "Nachbarschaft eines dieser Zeiger.\n"
      + "<code class=\"ZeigerArith\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int main(){\n"
      + "  int i = 5;\n"
      + "  int j = 42;\n"
      + "  int *pI = &i;\n"
      + "  int *pJ = &j;\n"
      + "  \n"
      + "  int *pK;\n"
      + "  printf\n"
      + "   (\"i:%i,pI:%u,pI+1:%u,*(pI+1):%i,pI-1:%u,*(pI-1):%i,pJ:%u,*pJ:%i\n\"\n"
      + "    ,i   ,pI   ,pI+1   ,*(pI+1)   ,pI-1   ,*(pI-1)   ,pJ   ,*pJ );\n"
      + "  *pK = 12;\n"
      + "  printf(\"pK: %i, *pK: %i\n\", pK,*pK); \n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Dieses Programm erzeugt z.B.<w></w>folgende interessante Ausgabe:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/ZeigerArith\n"
      + "i:5,pI:3221219380,pI+1:-1073747912,*(pI+1):-1073747816,pI-1:3221219376,*(pI-1):42,pJ:3221219376,*pJ:42\n"
      + "pK: 1075174352, *pK: 12\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "</example>\n"
      + "\n"
      + "Das Ergebnis einer Zeigerarithmetik hängt sehr davon ab, wie die\n"
      + "einzelnen Variablen im  Speicher abgelegt werden. In der Regel wird\n"
      + "man die Finger von ihr lassen und nur ganz bewußt auf sie\n"
      + "zurückgreifen, wenn man genau weiß, was man tut, um eventuell\n"
      + "Optimierungen durchführen zu können.\n"
      + "\n"
      + "Erstaunlicher Weise werden wir aber ein C-Konstrukt kennenlernen, das eines\n"
      + "der gebräuchlichsten Konzepte in C überhaupt ist, und tatsächlich auf der\n"
      + "Zeigerarithmetik basiert.\n"
      + "</subsection>\n"
      + "\n"
      + "\n"
      + "<subsection titel=\"Speicherverwaltung\">\n"
      + "Dieses Kapitel trägt den Titel dynamische Daten. Hiervon haben wir vorerst\n"
      + "aber noch nicht wirklich etwas gesehen. Bisher haben wir nur geschaut, in \n"
      + "welchen Speicherzellen die Daten unserer  Variablen gespeichert sind.\n"
      + "Damit ist in einem  Programm relativ statisch durch die Anzahl der Variablen\n"
      + "festgelegt, wieviel Daten das Programm \n"
      + "speichern kann. Normaler Weise wünscht man sich aber, dass ein Programm\n"
      + "während des Programmdurchlaufs dynamisch neuen Speicher nach Bedarf für\n"
      + "weitere Daten anlegen kann. Hierzu bietet C die Möglichkeit an über,\n"
      + "Speicherallokationsfunktionen neuen Speicher zu reservieren.\n"
      + " \n"
      + "<subsubsection titel=\"Allocation\">\n"
      + "In der C-Standardbibliothek gibt es zwei ein Funktionen, \n"
      + "mit der Speicher beliebiger\n"
      + "Größe vom Compiler angefordert werden kann. \n"
      + "\n"
      + "<paragraph titel=\"malloc\">\n"
      + "Die Funktion <tt>malloc</tt> hat einen Parameter. In diesem wird angegeben,\n"
      + "wieviel Speicherplatz bereitgestellt werden soll. Diese Angabe ist die Anzahl\n"
      + "der Byte.  \n"
      + "Das Ergebnis ist ein Zeiger\n"
      + "auf diesen neu bereitgestellten Speicher. Da die \n"
      + "Funktion <tt>malloc</tt> nicht wissen kann, was für Daten einmal in diesem\n"
      + "Speicherbereich gespeichert werden sollen, ist ihr Rückgabetyp der \n"
      + "allgemeine Zeiger <tt>void*</tt>.\n"
      + "\n"
      + "<code class=\"Malloc1\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "#include <stdlib.h>\n"
      + "\n"
      + "int main(){\n"
      + "  void* vp = malloc(7);\n"
      + "  int* ip=(int*)vp;\n"
      + "  *ip=42;\n"
      + "  printf(\"%i\n\",*ip);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Im obigen Beispiel haben wir willkürlich sieben Byte Speicher reservieren\n"
      + "lassen, um sie dann zur Speicherung von einer <tt>int</tt>-Zahl zu  benutzen.\n"
      + "Man sollte natürlich am Besten immer genau soviel Speicher anfordern, wie für\n"
      + "die geplanten Zwecke gebraucht wird. Wir kennen bereits die \n"
      + "Funktion <tt>sizeof</tt>, die Angaben darüber macht, wieviel Speicher ein\n"
      + "bestimmter Typ benötigt. Mit dieser läßt sich genau der erforderlicher\n"
      + "Speicherplatz anfordern:\n"
      + "\n"
      + "\n"
      + "<code class=\"Malloc2\" lang=\"c\" main=\"main\"\n"
      + ">#include &lt;stdio.h&gt;\n"
      + "#include &lt;stdlib.h&gt;\n"
      + "\n"
      + "int main(){\n"
      + "  void* vp = malloc(<redv>sizeof(int)</redv>);\n"
      + "  int* ip=(int*)vp;\n"
      + "  *ip=42;\n"
      + "  printf(\"%i\n\",*ip);\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "</paragraph>\n"
      + "\n"
      + "<paragraph titel=\"calloc\">\n"
      + "Es gibt in C eine Variante der Funktion <tt>malloc</tt>: die \n"
      + "Funktion <tt>calloc</tt>. \n"
      + "Nur, dass es bei der Funktion calloc() nicht einen, sondern zwei Parameter\n"
      + "gibt. Im Gegensatz zu <tt>malloc</tt> können wir mit <tt>calloc</tt> noch \n"
      + "die Anzahl von Speicherobjekten angeben, die reserviert werden soll. \n"
      + "Wird z.B. für 10\n"
      + "Zahlen vom Typ <tt>int</tt> Speicherplatz benötigt, so kann dies \n"
      + "mit <tt>calloc</tt> erledigt werden. Auf die mehreren Elemente dieses\n"
      + "Speicherbereichs kann dann mit der Zeigerarithmetik zugegriffen werden: \n"
      + "\n"
      + "\n"
      + "<code class=\"Calloc\" lang=\"c\" main=\"main\"\n"
      + ">#include &lt;stdio.h&gt;\n"
      + "#include &lt;stdlib.h&gt;\n"
      + "\n"
      + "int main(){\n"
      + "  int* xs = (int*)calloc(10,<redv>sizeof(int)</redv>);\n"
      + "  int i=0;\n"
      + "  for(i=0;i&lt;10;i++)  *(xs+i) = 2*i;\n"
      + "  for(i=0;i&lt;10;i++)  printf(\"%i, \",*(xs+i));\n"
      + "  printf(\"\n\");\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Wir haben somit ein kleines Programm geschrieben, in dem wir Speicher für 10\n"
      + "Zahlen angefordert haben und mit diesen 10 Speicherplätzen auch gearbeitet\n"
      + "haben:\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/Calloc\n"
      + "0, 2, 4, 6, 8, 10, 12, 14, 16, 18,\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Zusätzlich werden mit der Funktion <tt>calloc</tt> alle Werte des \n"
      + "angeforderten \n"
      + "Speichers automatisch mit binären 0-Werten initialisiert. \n"
      + "Bei <tt>malloc</tt> hat\n"
      + "der reservierte Speicherplatz zunächst einen undefinierten Wert. \n"
      + "Braucht man die zusätzliche Initialisierung des Speichers nicht, so kann \n"
      + "natürlich auch mit <tt>malloc</tt> Speicher für mehrere Elemente angefordert\n"
      + "werden. Der Aufruf <br/>\n"
      + "<tt>calloc(10,sizeof(int));</tt><br/>\n"
      + "ist hierzu zu Ersetzen durch:<br/>\n"
      + "<tt>malloc(10*sizeof(int));</tt><p/>\n"
      + "\n"
      + "\n"
      + "\n"
      + "</paragraph>\n"
      + "\n"
      + "<paragraph titel=\"realloc\">\n"
      + "to be done\n"
      + "</paragraph> \n"
      + "\n"
      + "\n"
      + "\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Speicher für ganze Datenreihungen\">\n"
      + "Wir haben oben schon gesehen, wie sich Speicher für ganze Reihen von Daten\n"
      + "eines Typs bequem allokieren läßt. Über die Zeigerarithmetik läßt sich dann\n"
      + "auf die einzelnen Elemente in einer solchen Reihung zugreifen.\n"
      + "\n"
      + "<paragraph titel=\"Zeichenketten\">\n"
      + "Bisher hatten wir noch keine Möglichkeit mit Zeichenketten, also Wörtern und\n"
      + "Sätzen zu arbeiten. Einzelne Buchstaben ließen sich durch Daten des \n"
      + "Typs <tt>char</tt> adequat<footnote>Nunja, zumindest wenn man sich auf die 26\n"
      + "Buchstaben des lateinischen Alpabets beschränkt.</footnote> darstellen. Ein\n"
      + "Wort oder längere Texte können nun als ein zusammen allokierten\n"
      + "Speicherbereich von <tt>char</tt>-Werten aufgefasst werden. Damit kann ein\n"
      + "Zeiger auf diesen Speicherbereich als Zeiger auf einen ganzen Text verstanden\n"
      + "werden. So können wir Speicher anfordern und darin Wörter speichern:\n"
      + "\n"
      + "\n"
      + "<code class=\"Word1\" lang=\"c\" main=\"main\"\n"
      + ">#include &lt;stdio.h&gt;\n"
      + "#include &lt;stdlib.h&gt;\n"
      + "\n"
      + "int main(){\n"
      + "  char* hallo = malloc(5*sizeof(char));\n"
      + "  *(hallo+0) = 'H';\n"
      + "  *(hallo+1) = 'A';\n"
      + "  *(hallo+2) = 'L';\n"
      + "  *(hallo+3) = 'L';\n"
      + "  *(hallo+4) = 'O';\n"
      + "  \n"
      + "  printf(\"%c\n\",*(hallo+3));\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Wir haben ein Problem: wir können der Variablen <tt>hallo</tt> vom \n"
      + "Typ <tt>char*</tt> im obigen Beispiel nich ansehen, für wieviel Buchstaben\n"
      + "dort Platz ist. Diese Information müssten wir seperat in einer Variablen\n"
      + "speichern. Also die eigentliche Wortlänge. Mit dieser Information läßt sich\n"
      + "dann auch ein Wort komplett ausdrucken:\n"
      + "\n"
      + "<code class=\"Word2\" lang=\"c\" main=\"main\"\n"
      + ">#include &lt;stdio.h&gt;\n"
      + "#include &lt;stdlib.h&gt;\n"
      + "\n"
      + "void printWord(unsigned int l, char* word){\n"
      + "  unsigned int i;\n"
      + "  for (i=0;i&lt;l;i++)\n"
      + "    printf(\"%c\",*(word+i));\n"
      + "\n"
      + "  printf(\"\n\");\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  unsigned int laenge = 5;\n"
      + "\n"
      + "  char* hallo = malloc(laenge*sizeof(char));\n"
      + "  *(hallo+0) = 'H';\n"
      + "  *(hallo+1) = 'A';\n"
      + "  *(hallo+2) = 'L';\n"
      + "  *(hallo+3) = 'L';\n"
      + "  *(hallo+4) = 'O';\n"
      + "  \n"
      + "  printWord(laenge,hallo);\n"
      + "\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Das ist etwas umständlich, wenn man immer die Länge als Zweitinformation mit\n"
      + "sich herumschleppen muß. Deshalb gibt es einen Standardtrick in C, wenn man\n"
      + "mit Reihungen von Zeichen arbeitet. Als letztes Zeichen schreibt man noch den \n"
      + "Nullbuchstaben, der als <tt>'\\0'</tt> notiert wird. Dann kann man auf eine\n"
      + "vorgegebene Länge verzichten und bei der Ausgabe abbrechen, wenn das\n"
      + "Nullzeichen erreicht wurde.\n"
      + "\n"
      + "<code class=\"Word3\" lang=\"c\" main=\"main\"\n"
      + ">#include &lt;stdio.h&gt;\n"
      + "#include &lt;stdlib.h&gt;\n"
      + "\n"
      + "void printWord( char* word){\n"
      + "  int i;\n"
      + "  for (i=0;*(word+i)!='\\0';i++)\n"
      + "    printf(\"%c\",*(word+i));\n"
      + "\n"
      + "  printf(\"\n\");\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  char* hallo = malloc(6*sizeof(char));\n"
      + "  *(hallo+0) = 'H';\n"
      + "  *(hallo+1) = 'A';\n"
      + "  *(hallo+2) = 'L';\n"
      + "  *(hallo+3) = 'L';\n"
      + "  *(hallo+4) = 'O';\n"
      + "  *(hallo+5) = '\\0';\n"
      + "  printWord(hallo);\n"
      + "\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Die oben dargestellte Form Texte zu verarbeiten ist der Standardweg in\n"
      + "C. Dieses ist in die Sprache eingebaut. Wenn ein Text in doppelten\n"
      + "Anführungszeichen steht, wie wir es ja schon oft in den Funktionsaufrufen \n"
      + "von <tt>printf</tt> gesehen haben, dann wird der Text auf eben diese Weise in\n"
      + "einen über den Typ <tt>char*</tt> beschriebenen Speicherbereich wie oben \n"
      + "von Hand durchgeführt gespeichert. Somit läßt sich die Erzeugung des obigen\n"
      + "Textes im Speicher viel einfacher schreiben:\n"
      + "\n"
      + "<code class=\"Word4\" lang=\"c\" main=\"main\"\n"
      + ">#include &lt;stdio.h&gt;\n"
      + "#include &lt;stdlib.h&gt;\n"
      + "\n"
      + "void printWord( char* word){\n"
      + "  int i;\n"
      + "  for (i=0;*(word+i)!='\\0';i++)\n"
      + "    printf(\"%c\",*(word+i));\n"
      + "\n"
      + "  printf(\"\n\");\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  char* hallo = \"HALLO\";\n"
      + "  printWord(hallo);\n"
      + "\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Ein weiterer Luxus ist, dass die Funktion <tt>printf</tt> auch darauf\n"
      + "vorbereitet ist, derartige Zeichenketten auszugeben, so dass wir auf ein\n"
      + "eigenes <tt>printWord</tt> verzichten können. Hierzu ist der \n"
      + "Funktion <tt>printf</tt> als Formatierungsanweisung <tt>%s</tt> mitzugeben:\n"
      + "\n"
      + "<code class=\"Word5\" lang=\"c\" main=\"main\"\n"
      + ">#include &lt;stdio.h&gt;\n"
      + "#include &lt;stdlib.h&gt;\n"
      + "\n"
      + "int main(){\n"
      + "  char* hallo = \"HALLO\";\n"
      + "  printf(\"%s\n\",hallo);\n"
      + "\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "<aufgabe blatt=\"6\">\n"
      + "Schreiben Sie eine Funktion <tt>int length(char* text)</tt>, die \n"
      + "angibt, wieviel Zeichen in dem Speicherbereich \n"
      + "von <tt>text</tt> gespeichert sind.\n"
      + "\n"
      + "<loesung>\n"
      + "<code class=\"B6A1\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int length(char* text){\n"
      + "  int i;\n"
      + "  for (i=0;*(text+i)!='\\0';i++){}\n"
      + "\n"
      + "  return i;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  printf(\"%i\n\",length(\"\"));\n"
      + "  printf(\"%i\n\",length(\"A\"));\n"
      + "  printf(\"%i\n\",length(\"Hallo\"));\n"
      + "  printf(\"%i\n\",length(\"ottos mops kotzt\"));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</loesung>\n"
      + "</aufgabe>\n"
      + "\n"
      + "<aufgabe blatt=\"6\">\n"
      + "Schreiben Sie eine Funktion <tt>bool isPallindrom(char* text)</tt>, \n"
      + "die testet, ob der übergebene Text vorwärts und rückwärts gelesen  identisch\n"
      + "ist.  \n"
      + "<loesung>\n"
      + "<code class=\"B6A2\" lang=\"c\" \n"
      + "  main=\"gcc -o B6A2 ../obj/Bool.o ../obj/B6A2.o \"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "#include \"Bool.h\"\n"
      + "int length(char* text){\n"
      + "  int i;\n"
      + "  for (i=0;*(text+i)!='\\0';i++){}\n"
      + "  return i;\n"
      + "}\n"
      + "\n"
      + "bool isPallindrom(char* text){\n"
      + "  int l = length(text);\n"
      + "  int i;\n"
      + "  for (i=0;i<l/2;i++)\n"
      + "    if ((*(text+i)) != (*(text+l-1-i))) return false;\n"
      + "  return true;\n"
      + "}\n"
      + "int main(){\n"
      + "  printBool(isPallindrom(\"otto\"));\n"
      + "  printBool(isPallindrom(\"hans\"));\n"
      + "  printBool(isPallindrom(\"koelbleok\"));\n"
      + "  printBool(isPallindrom(\"regallager\"));\n"
      + "  \n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</loesung>\n"
      + "</aufgabe>\n"
      + "\n"
      + "<aufgabe blatt=\"6\">\n"
      + "Schreiben Sie eine Funktion <tt>int leseAlsZahl(char* text)</tt>, die\n"
      + "Zeichenkette als Zahl interpretiert. Für die \n"
      + "Zeichenkette <tt>\"42\"</tt> soll also die Zahl <tt>42</tt> als Ergebnis\n"
      + "zurückgegeben werden:\n"
      + "<loesung>\n"
      + "<code class=\"B6A3\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "int leseAlsZahl(char* text){\n"
      + "  int result=0;\n"
      + "  int i;\n"
      + "  for (i=0;*(text+i)!='\\0';i++)\n"
      + "    result=result*10+(*(text+i)-'0');\n"
      + "  return result;\n"
      + "}\n"
      + "int main(){\n"
      + "  printf(\"%i\n\",leseAlsZahl(\"42\"));\n"
      + "  printf(\"%i\n\",leseAlsZahl(\"007\"));\n"
      + "  printf(\"%i\n\",leseAlsZahl(\"a\"));\n"
      + "  printf(\"%i\n\",leseAlsZahl(\"12\"));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</loesung>\n"
      + "</aufgabe>\n"
      + "\n"
      + "<aufgabe blatt=\"6\">\n"
      + "Schreiben Sie eine Funktion <tt>char* concat(char* text1,char* text2)</tt>, die\n"
      + "eine neue Zeichenkette erzeugt, die aus den beiden Zeichenketten der Parameter\n"
      + "aneinandergehängt besteht.\n";
    String skript6 =
       "<loesung>\n"
      + "<code class=\"B6A4\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "#include <stdlib.h>\n"
      + "\n"
      + "int length(char* text){\n"
      + "  int i;\n"
      + "  for (i=0;*(text+i)!='\\0';i++){}\n"
      + "  return i;\n"
      + "}\n"
      + "char* concat(char* text1,char* text2){\n"
      + "  char* result=malloc(sizeof(char)* (length(text1)+length(text2)+1));\n"
      + "  int i;\n"
      + "  for (i=0;*(text1+i)!='\\0';i++){\n"
      + "    *(result+i)=*(text1+i);\n"
      + "  }\n"
      + "  int j;\n"
      + "  for (j=0;*(text2+j)!='\\0';(i++,j++)){\n"
      + "    *(result+i)=*(text2+j);\n"
      + "  }\n"
      + "  *(result+i)='\\0';\n"
      + "  return result;  \n"
      + "}\n"
      + "int main(){\n"
      + "  printf(\"%s\n\",concat(\"otto\",\"reber\"));\n"
      + "  printf(\"%s\n\",concat(\"007\",\"008\"));\n"
      + "  printf(\"%s\n\",concat (\"john\",\"paul\"));\n"
      + "  printf(\"%s\n\",concat (\"george\",\"ringo\"));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</loesung>\n"
      + "</aufgabe>\n"
      + "\n"
      + "\n"
      + "\n"
      + "</paragraph>\n"
      + "\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Speicherfreigabe\">\n"
      + "Speicher anzufordern ist ein feine Sache, aber wenn wir auch viel davon in\n"
      + "heutugen Rechner haben, so ist der Speicher trotzdem endlich. Wenn wir sorglos\n"
      + "immer wieder neuen Speicher anfordern bekommen wir ein Müllproblem. Wie sich\n"
      + "ein solches auswirkt, läßt sich leicht ausprobieren. Man starte einmal das\n"
      + "folgende Progamm. \n"
      + "\n"
      + "<code main=\"main\" lang=\"c\" class=\"NoFree\">#include &lt;stdio.h&gt;\n"
      + "#include &lt;stdlib.h&gt;\n"
      + "int main(){\n"
      + "  int i=0;\n"
      + "  int* ip;\n"
      + "  for (;i&lt;10000000;i++){\n"
      + "    ip=(int*)<redv>malloc(sizeof(int))</redv>;\n"
      + "    *ip=i;\n"
      + "    printf(\"%i \",*ip);\n"
      + "  }\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Mit dem Betriebssystembefehl <tt>top</tt> läßt sich schön beobachten, wie\n"
      + "dieses Programm immer neuen Speicher benötigt und schließlich über 100\n"
      + "Megabyte Speicher reserviert hat (und damit den Rechner schon arg\n"
      + "belastet). Man spricht in einem solchen Fall von einem Speicherleck. Eine der\n"
      + "großen Schwierigkeiten der Programmiersprache C ist es, dass dynamisch\n"
      + "allokierter Speicher explizit wieder frei gegeben werden muß. Hierzu gibt es\n"
      + "die Funktion <tt>free</tt>. Sie erwartet einen Zeiger und gibt alles mit\n"
      + "diesem Zeiger allokierten Speicherbereich wieder frei zur neuen\n"
      + "Benutzung. Rufen wir nun im obigen Programm am Ende des Schleifenrumpfs die\n"
      + "Funktion <tt>free</tt> auf, so können wir beobachten, dass das Programm mit\n"
      + "konstanten Speicherbelegung läuft.\n"
      + "\n"
      + "<code main=\"main\" lang=\"c\" class=\"Free\">#include &lt;stdio.h&gt;\n"
      + "#include &lt;stdlib.h&gt;\n"
      + "int main(){\n"
      + "  int i=0;\n"
      + "  int* ip;\n"
      + "  for (;i&lt;10000000;i++){\n"
      + "    ip=(int*)malloc(sizeof(int));\n"
      + "    *ip=i;\n"
      + "    printf(\"%i \",*ip);\n"
      + "    <redv>free(ip)</redv>;\n"
      + "  }\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Schon seit Anfang der 60er Jahre gibt es mit <em>Lisp</em> eine \n"
      + "Programmiersprache, in der die dynamische Speicherverwaltung automatisch vom\n"
      + "Compiler durchgeführt wird. Dieses macht die sogenannte <em>garbage \n"
      + "collection</em>. Es ist erstaunlich und schwer erklärlich, dass sich eine\n"
      + "Programmiersprache ohne eine vollkommen automatische Speicherverwaltung wie C\n"
      + "derart durchsetzen und hartnäckig halten konnte. Erst mitte der 90er Jahre\n"
      + "setzte sich mit <em>Java</em> eine Mainstream Programmiersprache durch, die\n"
      + "eine automatische Speicherverwaltung per <em>garbage collection</em> hat.\n"
      + "\n"
      + "Reflexartig wiederholt für alle unangenehmen Eigenschaften von C wird stets\n"
      + "ein Performancevorteil. Allerdings spielt dieser wahrscheinlich für 99\\% der\n"
      + "Anwendungen keine signifikante Rolle.\n"
      + "\n"
      + "Warum hat man aber nicht irgendwann eine automatische Speicherverwaltung in C\n"
      + "integriert. Tatsächlich gibt es C-Compiler die dieses zumindest teilweise\n"
      + "anbieten; allerdings verhindern einige Konzepte von C, insbesondere die\n"
      + "Speicherarithmetik, dass eine <em>garbage collection</em> allgemein in C\n"
      + "eingeführt werden könnte.\n"
      + "\n"
      + "Doch genug des C <em>bashings</em>. Für uns ist sicherlich C eine \n"
      + "wunderbare Sprache, um etwas über den Speicher zu lernen und konfontiert damit\n"
      + "zu werden, dass angeforderter Speicher irgendwie auch wieder frei gesetzt\n"
      + "werden muss. Eine Erfahrung, die wir in Java nie gemacht hätten.  \n"
      + "\n"
      + "Ganz allein läßt uns C allerdings auch nicht mit der Speicherverwaltung. Zum\n"
      + "einen wird der Speicher lokaler Variablen nach Ablauf einer\n"
      + "Funktionsberechnung wieder frei gegeben, zum anderen müssen wir dem Compiler\n"
      + "in der Funktion <tt>free</tt> nicht mitteilen, wieviel Speicher denn wieder\n"
      + "frei gegeben werden soll. Die C-Laufzeit merkt sich für jede dynamisch\n"
      + "angeforderte Speicherzelle, wieviel Speicher angefordert wurde und gibt genau\n"
      + "diese Speichergröße dann auch wieder frei. \n"
      + "\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"objektorientiertes Arbeiten mit Strukturzeigern\">\n"
      + "Es ist Vorteilhaft auch in C schon einen weitgehendst objektorientierten\n"
      + "Programmierstil zu kultivieren. Objektarten werden durch Strukturen\n"
      + "definiert.  Objekte dieser Strukturen sollen nur über einen Zeiger benutzt\n"
      + "werden. Wir können eine weitgehendst objektorientiert angelegte Struktur gerne\n"
      + "auch schon als <em>Klasse</em> bezeichnen.\n"
      + "\n"
      + "Hierzu nocheinmal das Beispiel mit den Punkten im zweidimensionaloen\n"
      + "Raum: \n"
      + "\n"
      + "<code class=\"Punkt5\" lang=\"c\" main=\"main\" compileoptions=\"echo -lm \"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "#include <stdlib.h>\n"
      + "#include <math.h>\n"
      + "\n"
      + "typedef struct {\n"
      + "  int x;\n"
      + "  int y;\n"
      + "} PunktStrukt;\n"
      + "\n"
      + "typedef PunktStrukt* Punkt;]]></code>\n"
      + "\n"
      + "Es ist sinnvoll eine Funktion vorzusehen, die aus gegebenen Werte ein Objekt\n"
      + "einer Struktur erzeugt. Hierzu ist der entsprechende Speicher zu allokieren\n"
      + "und die einzelnen Felder des Strukturobjekts mit den Werten der Parameter zu\n"
      + "übergeben. Eine solche Funktion wird als Konstruktor bezeichnet. Eine\n"
      + "sinnvolle Namensgebung ist den Konstruktornamen mit <tt>new</tt> beginnen zu\n"
      + "lassen, gefolgt von dem Namen der Struktur:\n"
      + "\n"
      + "<code class=\"Punkt5\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[Punkt newPunkt(int x,int y){\n"
      + "  Punkt this = (Punkt)malloc(sizeof(PunktStrukt));\n"
      + "  this->x = x;\n"
      + "  this->y = y;\n"
      + "  return this;\n"
      + "}]]></code>\n"
      + "\n"
      + "Ebenso sollte man eine Funktion vorsehen, die es erlaubt ein Objekt wieder aus\n"
      + "dem Speicher zu entfernen. Man spricht dabei von einen Destruktor. Meistens\n"
      + "reicht es aus, hier einfach die Funktion <tt>free</tt> aufzurufen, wir werden\n"
      + "aber bald auch ein Beispiel sehen, in dem dies nicht ausreicht. Für dbie\n"
      + "Punkt-Klasse erhalten wir den einfachen Destruktor:\n"
      + "\n"
      + "<code class=\"Punkt5\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[void deletePunkt(Punkt this){\n"
      + "  free(this);\n"
      + "}]]></code>\n"
      + "\n"
      + "Nun können wir Punktobjekte erzeugen und löschen. Jetzt wollen wir mit diesen\n"
      + "Objekten auch gerne etwas vornehmen. Dazu schreiben wir Funktionen, die als\n"
      + "ersten Parameter ein entsprechendes Objekt erhalten. In Hinblick auf\n"
      + "objektorientierte Sprachen ist es sinnvoll diesen ersten Parameter dann mit\n"
      + "den Namen <tt>this</tt> zu bezeichnen. Funktionen, die als ersten Parameter\n"
      + "Objekte einer bestimmten Klasse erhalten, sollen \n"
      + "als <em>Objektmethode</em> kurz auch\n"
      + "nur <em>Mehtode</em>dieser\n"
      + "Klasse bezeichnet werden.\n"
      + "\n"
      + "So können wir eine einfache Methode schreiben, die ein Punktobjekt auf der\n"
      + "Kommandozeile ausgibt:\n"
      + "\n"
      + "<code class=\"Punkt5\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[void printPunkt(Punkt this){\n"
      + "  printf(\"(%i,%i)\n\",this->x,this->y);\n"
      + "}]]></code>\n"
      + "\n"
      + "Mehtoden können auch Rückgaben haben. Die folgende Mehtode errechnet als den\n"
      + "betrag eines Punktes seine Entfernung zum Ursprung. Hierzu wird die Formel von\n"
      + "Pythagoras verwendet:\n"
      + "\n"
      + "<code class=\"Punkt5\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[double betrag(Punkt this){\n"
      + "  return sqrt(this->x*this->x+this->y*this->y);\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "Methoden können nach dem ersten Parameter noch weitere Parameter enthalten.\n"
      + "Die folgende Methode kann ein Punktobjekt um die als weitere Werte angegebenen\n"
      + "Distanzen verschieben.\n"
      + "\n"
      + "<code class=\"Punkt5\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[void verschiebe(Punkt this,int deltaX,int deltaY){\n"
      + "  this->x += deltaX;\n"
      + "  this->y += deltaY;\n"
      + "}]]></code>\n"
      + "\n"
      + "Nun können wir tatsächlich schon fast wie in einer objektorientierten Sprache\n"
      + "mit der Punkt-Klasse arbeiten:\n"
      + "\n"
      + "<code class=\"Punkt5\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[int main(){\n"
      + "  Punkt p= newPunkt(17,4);\n"
      + "  printPunkt(p);\n"
      + "  printf(\"betrag: %f\n\",betrag(p));\n"
      + "  verschiebe(p,2,4);\n"
      + "  printPunkt(p);\n"
      + "  deletePunkt(p);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Das Programm führt zu folgender Ausgabe:\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/Punkt5\n"
      + "(17,4)\n"
      + "betrag: 17.464249\n"
      + "(19,8)\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "</subsubsection>\n"
      + "</subsection>\n"
      + "\n"
      + "\n"
      + "\n"
      + "</section>\n"
      + "\n"
      + "\n"
      + "<section titel=\"Reihungen (Arrays)\">\n"
      + "Eines der komplexesten Konstrukte der Programmiersprache C ist gleichzeitig\n"
      + "auch das wahrscheinlich am häufigsten benutzte. Es handelt sich dabei um\n"
      + "Arrays, auf Deutsch oft als Datenfelder bezeichnet. Innerhalb dieses Skripts\n"
      + "werden wir sie mit dem ebenfalls gebräuchlichen \n"
      + "Ausdruck <em>Reihungen</em>  bezeichnen, da wir als Feld auch schon die\n"
      + "Attribute von Strukturen bezeichnen. Bei Reihungen geht es darum, mehrere\n"
      + "Variablen eines uniformen Datentyps in einer Variablen zu speichern.\n"
      + "\n"
      + "Ähnlich wie schon bei Funktionstypen wird der Typ einer Reihung vor und hinter\n"
      + "dem Variablennamen bezeichnet. Vor dem Variablennamen steht der Typ, den die\n"
      + "einzelnen Elemente der Reihung haben und nach dem Variablennamen steht ein\n"
      + "eckiges Klammernpaar, um zu bezeichenen, dass es sich hier im eine\n"
      + "Reihungsvariablen handelt.  So bezeichnet <tt>int xs []</tt> eine Reihung von\n"
      + "ganzen Zahlen. Eine Reihung kann, ebenso wie wir es von Strukturen kennen,\n"
      + "durch die Aufzählung der Werte in geschweiften Klammern intialisiert werden. \n"
      + "\n"
      + "Zeit unseren ersten Array zu deklarieren. Statt vier einzelner \n"
      + "Variablen (noch einmal als Beispiel drüber) wird eine einzige Variable mit\n"
      + "vier Werten deklariert:\n"
      + "<code class=\"FirstArray\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int main(){\n"
      + "  int x0 = 1;\n"
      + "  int x1 = 2;\n"
      + "  int x2 = 3;\n"
      + "  int x3 = 4;\n"
      + "  int x [] = {1,2,3,4};]]></code>\n"
      + "\n"
      + "Normale Variablen können wir direkt benutzen, um an ihre Werte zu kommen:\n"
      + "\n"
      + "<code class=\"FirstArray\" lang=\"c\" main=\"main\" dequel=\"true\"\n"
      + "><![CDATA[  printf(\"x0  =%i, x1  =%i, x2  =%i, x3 =%i\n\",x0,x1,x2,x3);]]></code>\n"
      + "In Arrayvariablen verstecken sich mehrere einzelne Werte. Um auf diese einzeln\n"
      + "zugreifen zu können wird ein Index benutzt. Der Index ist in eckigen Klammern\n"
      + "der Variablen anzuhängen. Das erste Element wird über den Index 0\n"
      + "angesprochen. Die vier Werte unserer ersten Reihung sind also wie folgt\n"
      + "anzusprechen: \n"
      + "\n"
      + "<code class=\"FirstArray\" lang=\"c\" main=\"main\" dequel=\"true\"\n"
      + "><![CDATA[  printf(\"x[0]=%i, x[1]=%i, x[2]=%i, x[3]=%i\n\",x[0],x[1],x[2],x[3]);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "\n"
      + "Bei der Deklaration einer\n"
      + "Reihungsvariablen  muß die Anzahl der Elemente bekannt sein. Im ersten\n"
      + "Beispiel wurde die Anzahl aus der Elementanzahl in der Initialisierung\n"
      + "spezifiziert. Wird eine Reihung nicht direkt initialisiert, so beschwert sich\n"
      + "der Compiler darüber, dass er nicht bestimmen kann, wieviel Elemente die\n"
      + "Reihung benötigt:\n"
      + "\n"
      + "<code class=\"UnknownSize\" lang=\"c\">int main(){\n"
      + "  int xs [];\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "Die Übersetzung dieses Programms führt zu einem Fehler:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> gcc src/UnknownSize.c\n"
      + "src/UnknownSize.c: In function `main':\n"
      + "src/UnknownSize.c:2: error: array size missing in `xs'\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Der C-Übersetzer muß immer in der Lage sein, die Anzahl der Elemente einer\n"
      + "Reihung abzuleiten. Der Grund dafür ist, daß sobald eine Variable deklariert\n"
      + "wird, der C Compiler den Speicherplatz für die entsprechende Variable\n"
      + "anfordern muß. In C bedeutet das bei einer Reihung, daß der Speicher für eine\n"
      + "komplette Reihung angefordert wird. \n"
      + "Hierfür muß die Anzahl der Elemente bekannt sein.\n"
      + "\n"
      + "Man kann die Anzahl der Elemente in den eckigen Klammern bei einer\n"
      + "Arraydeklaration  angeben. Im folgenden Beispiel wird ein Array mit 15\n"
      + "Elementen angelegt.\n"
      + "\n"
      + "<code class=\"KnownSize\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "\n"
      + "int main(){\n"
      + "  int xs [15];\n"
      + "  printf(\"%i\n\",xs[2]);\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "\n"
      + "\n"
      + "Die Elementanzahl für eine Reihung muß nicht zur Übersetzungszeit bekannt\n"
      + "sein, sondern kann dynamisch errechnet werden und z.B.<w/>als Parameter einer\n"
      + "Funktion übergeben werden:\n"
      + "\n"
      + "<code class=\"LocalArray\" lang=\"c\" main=\"main\"\n"
      + ">#include &lt;stdio.h&gt;\n"
      + "\n"
      + "void f(int l){\n"
      + "  <redv>int xs [l]</redv>;\n"
      + "  int i;\n"
      + "  for (i= 0; i&lt;l;i=i+1){\n"
      + "    xs[i]=i;\n"
      + "    printf(\"%i,\", xs[i]);\n"
      + "  }\n"
      + "  printf(\"\n\");\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  f(7);\n"
      + "  f(2);\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Wie wir uns in der Ausgabe überzeugen können, werden in diesem Programm in der\n"
      + "Funktion <tt>f</tt> nacheinander zwei Reihungen unterschiedlicher Länge\n"
      + "erzeugt.<footnote>Angeblich sollen bestimmte \n"
      + "Compiler derartige Programme nicht übersetzen.</footnote>\n"
      + "<scode><![CDATA[\n"
      + "]]></scode>\n"
      + "\n"
      + "\n"
      + "<subsection titel=\"Die Größe einer Reihung\">\n"
      + "Einer Reihung kann man im allgemeinen nicht ansehen, wie viele Elemente sie\n"
      + "enthält. Das ist recht unangenehm, denn somit kann es z.B. passieren, das\n"
      + "versucht wird bei einer Reihung mit 10 Elementen, auf das 100.~Element\n"
      + "zuzugreifen. \n"
      + "<code class=\"WrongIndex\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "int main(){\n"
      + "  int xs [10];\n"
      + "  printf(\"%i\n\",xs[100]);\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Es gibt niemanden, der uns in diesem Programm auf die Finger haut. Wir können\n"
      + "es comilieren und laufen lassen. Es läuft sogar ohne Fehlermeldung und Programmabbruch:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/WrongIndex\n"
      + "-1073744294\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Allerdings wird hier irgendwo in den Speicher gegriffen und der zufällig dort\n"
      + "gespeicherte Wert gelesen.\n"
      + "\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Reihungen sind nur Zeiger\">\n"
      + "Wir können Funktionen schreiben, die Reihungen als Parameter übergeben\n"
      + "bekommen. Diese Reihungen lassen sich im Funktionsrumpf ganz normal als\n"
      + "Reihungen behandeln:\n"
      + "<code class=\"AddInts\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int add(int xs [],int argc){\n"
      + "  int result=0;\n"
      + "  int i=0;\n"
      + "  for (;i<argc;i++){\n"
      + "    result=result+xs[i];\n"
      + "  }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  int xs [] = {1,2,3,4};\n"
      + "  printf(\"%i\n\", add(xs,4));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "  \n"
      + "Wir können jetzt einmal in diesem Programm einen Fehler einbauen, um zu sehen,\n"
      + "als was für einen Typ der Compiler unseren Reihungsparameter betrachtet:\n"
      + "<code class=\"WrongArrayParameter\" lang=\"c\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int add(int xs [],int argc){\n"
      + "  int result=0;\n"
      + "  int i=0\n"
      + "  for (;i<argc;i++){\n"
      + "    result=result+xs[i];\n"
      + "  }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  int xs [] = {1,2,3,4};\n"
      + "  printf(\"%i\n\", add(xs,xs));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Auf diese Weise erzwingen wir eine Fehlermeldung des Compilers, in der die\n"
      + "erwarteten Parametertypen der Funktion <tt>add</tt> angegeben werden. Der\n"
      + "Kompilierversuch führt zu folgender Fehlermeldung:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> gcc -Wall src/WrongArrayParameter.c\n"
      + "src/WrongArrayParameter.c: In function `main':\n"
      + "src/WrongArrayParameter.c:14: warning: passing arg 2 of `add' makes integer from pointer without a cast\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Der Übersetzer ist der Meinung, der zweite Parameter, den wir der  Funktion <tt\n"
      + ">add</tt> übergeben, ist ein Zeiger. Der Übersetzer macht aus einem\n"
      + "Reihungsparameter implizit einen Zeiger. Und zwar einen Zeiger auf\n"
      + "das erste Element des Reihungsparameters. Ein Array <tt>int xs []</tt> ist\n"
      + "also nichts weiter als ein Zeiger des Typs <tt>int* xs</tt>.\n"
      + "\n"
      + "Die Schreibweise der eckigen\n"
      + "Klammern für Reihungen für den Elementzugriff, läßt sich somit als \n"
      + "eine versteckte Zeigerarithmetik\n"
      + "interpretieren. <tt>xs[i]</tt> bedeutet dann: <tt>*(xs+i)</tt>.\n"
      + "\n"
      + "Tatsächlich können wir ohne die Syntax der eckigen Klammern mit Reihungen\n"
      + "arbeiten. Obiges Programm läßt sich auch wie folgt formulieren:\n"
      + "\n"
      + "<code class=\"NoBrackets\" lang=\"c\" main=\"main\">#include &lt;stdio.h&gt;\n"
      + "\n"
      + "int add(int xs [],int argc){\n"
      + "  int result=0;\n"
      + "  int i=0;\n"
      + "  for (;i&lt;argc;i++){\n"
      + "    result=<redv>result + *(xs+i);</redv>\n"
      + "  }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  int xs [] = {1,2,3,4};\n"
      + "  printf(\"%i\n\", add(xs,4));\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Auch diese Version hat als Ergebnis die 10.\n"
      + "\n"
      + "<aufgabe  >Schreiben sie eine Funktion<br />\n"
      + " <tt>void reverse(int* xs,int length)</tt>,<br />\n"
      + "die die Reihenfolge der Elemente des Arrays gerade einmal umdreht.\n"
      + "</aufgabe>\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Reihungen als Rückgabewert\">\n"
      + "Im letzem Abschnitt haben wir bereits\n"
      + "gesehen, dass bei der Parameterübergabe von Reihungen diese implizit als Zeiger\n"
      + "auf das erste Element behandelt werden. Gleiches gilt auch für die\n"
      + "Rückgabewerte von Funktionen. Dadurch lassen sich einige Probleme\n"
      + "einhandeln. Versuchen wir einmal eine einfache Funktion zu schreiben, die eine\n"
      + "neue Reihungsvariable anlegt und diese als Ergebnis zurückgibt:\n"
      + "\n"
      + "<code class=\"WrongArrayReturn\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int*  newArray(int length){\n"
      + "  int result [length];\n"
      + "  int i=0;\n"
      + "  for (;i<5;i++)result[i]=i;\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "   int* xs = newArray(5);\n"
      + "   int i=0;\n"
      + "   for (;i<5;i++){\n"
      + "     printf(\"%i \",xs[i]);\n"
      + "   }\n"
      + "   printf(\"\n\");\n"
      + "   return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Die Übersetzung dieser Klasse glückt zwar, aber der Übersetzer gibt uns eine\n"
      + " ernst zu nehmende Warnung:\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> gcc -std=c99 src/WrongArrayReturn.c\n"
      + "src/WrongArrayReturn.c: In function `newArray':\n"
      + "src/WrongArrayReturn.c:7: warning: function returns address of local variable\n"
      + "sep@pc305-3:~/fh/c/student> .]]></scode>\n"
      + "\n"
      + "Die Warnung ist insofern ernst zu nehmen, als daß wir tatsächlich ein\n"
      + " undefiniertes Laufzeitverhalten bekommen:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> ./a.out\n"
      + "0 134518380 808989496 134513155 1074069176\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Den Grund hierfür kennen wir bereits aus unseren Kapitel über Zeiger. Implizit\n"
      + " behandelt der Übersetzer die Zeile <tt>return result</tt> als eine Rückgabe\n"
      + " des Zeigers auf die lokale Variable <tt>result</tt>. Eine lokale Variable\n"
      + " innerhalb einer Funktion, wird im Speicher nach Beendigung der Funktion\n"
      + " wieder freigegeben. Zeigen wir noch auf diese Variable, so werden wir an\n"
      + " ihrer Speicherzelle undefinierte Werte sehen.<p/>\n"
      + "\n"
      + "Die einzige vernünftigen Möglichkeiten der Rückgabe von Reihungen in C sind\n"
      + " die Rückgabe eines als Parameter überreichten Zeiger auf eine Reihung, oder\n"
      + " aber der Zeiger auf eine dynamisch neu erzeugte Reihung:\n"
      + "\n"
      + "<code class=\"ReturnArray\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "#include <stdlib.h>\n"
      + "\n"
      + "int* newArray(int length){\n"
      + "  int* result =  (int*)malloc(sizeof(int[length]));\n"
      + "  int i=0;\n"
      + "  for (;i<5;i++)result[i]=i;\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  int* xs = newArray(5);\n"
      + "  int i=0;\n"
      + "  for (;i<5;i++){\n"
      + "    printf(\"%i \",xs[i]);\n"
      + "  }\n"
      + "  printf(\"\n\");\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Dieses Programm übersetzt ohne Warnung und liefert die erwartete Ausgabe.\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> ./bin/ReturnArray\n"
      + "0 1 2 3 4\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Tatsächlich findet man es relativ selten in C Programmen, daß eine Funktion\n"
      + " eine Reihung als Rückgabewert hat. Zumeist bekommen Funktionen Reihungen als\n"
      + " Parameter übergeben und manipulieren diese.  \n"
      + " </subsection> \n"
      + "\n"
      + "\n"
      + "<subsection titel=\"Funktionen höherer Ordnung für Reihungen\">\n"
      + "Wir haben bereits gesehen, daß Funktionen über Funktionszeigern an andere\n"
      + "Funktionen als Parameter übergeben werden können. Im Zusammenhang mit\n"
      + "Reihungen eröffnet dieses ein mächtiges Programmierprinzip. Fast jede\n"
      + "Funktion, die sich mit Reihungen beschäftigt, wird einmal jedes Element der\n"
      + "Reihung durchgehen und dazu eine <tt>for</tt>-Schleife benutzen. Wie wäre es\n"
      + "denn, wenn man dieses Prinzip verallgemeinert und eine allgemeine Funktion\n"
      + "schreibt, die einmal jedes Element einer Reihung betrachtet und etwas mit ihm\n"
      + "macht. Was mit jedem Element zu tun ist, wird dieser Funktion als\n"
      + "Funktionszeiger übergeben. <p/>\n"
      + "\n"
      + "Funktionen, die als Parameter Funktionen übergeben bekommen, werden auch als\n"
      + "Funktionen höherer Ordnung bezeichnet.\n"
      + "\n"
      + "<example>\n"
      + "Wir schreiben für Reihungen ganzer Zahlen die Funktion <tt>map</tt>, die jedes\n"
      + "Element einer Reihung mit einer übergebenen Funktion umwandelt: \n"
      + "<code class=\"IntMap\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "void map(int xs [],int l,int (f) (int)){\n"
      + "  int i=0;\n"
      + "  for (;i<l;i++)  xs[i]=f(xs[i]);\n"
      + "}]]></code>\n"
      + "\n"
      + "Wir stellen drei Funktionen, die eine ganze Zahl als Parameter und Ergebnis\n"
      + "haben\n"
      + "zur Verfügung:\n"
      + "\n"
      + "<code class=\"IntMap\" lang=\"c\" sequel=\"true\"\n"
      + "><![CDATA[int add5(int x){return x+5;}\n"
      + "int square(int x){return x*x;}\n"
      + "int doubleX(int x){return 2*x;}]]></code>\n"
      + "\n"
      + "Jetzt können wir die Funktion <tt>map</tt> verwenden, um für jedes Element\n"
      + "einer Reihung, eine derartige Funktion anzuwenden. Zur Ausgabe von Reihungen\n"
      + "schreiben wir eine kleine Hilfsfunktion:\n"
      + "\n"
      + "<code class=\"IntMap\" lang=\"c\" sequel=\"true\"\n"
      + "><![CDATA[void printArray(int xs [],int l){\n"
      + "  printf(\"[\");\n"
      + "  int i=0;\n"
      + "  for (;i<l;i++){\n"
      + "    printf(\"%i\",xs[i]);\n"
      + "    if (i!=l-1) printf(\", \");\n"
      + "  }\n"
      + "  printf(\"]\n\");\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  int xs [] = {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};\n"
      + "  map(xs,15,add5);\n"
      + "  printArray(xs,15);\n"
      + "  map(xs,15,square);\n"
      + "  printArray(xs,15);\n"
      + "  map(xs,15,doubleX);\n"
      + "  printArray(xs,15);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "Und hier die Ausgabe des Programms:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/IntMap\n"
      + "[6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20]\n"
      + "[36, 49, 64, 81, 100, 121, 144, 169, 196, 225, 256, 289, 324, 361, 400]\n"
      + "[72, 98, 128, 162, 200, 242, 288, 338, 392, 450, 512, 578, 648, 722, 800]\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "Zunächst wird auf jedes Element der Reihung 5 aufaddiert. Dann werden die\n"
      + "Elemente quadriert und schließlich verdoppelt.\n"
      + "\n"
      + "</example>\n"
      + "<aufgabe>\n"
      + "Schreiben Sie eine Funktion <tt>fold</tt> mit folgender Signatur:<br/>\n"
      + "<code class=\"Fold\" lang=\"h\"><![CDATA[int fold(int xs [],int length,int op(int,int),int startV);]]></code>\n"
      + "\n"
      + "\n"
      + "\n"
      + "Die Spezifikation der Funktion sei durch folgende Gleichung gegeben:\n"
      + "\n"
      + "<quote>fold(xs,l,op,st) = op(<dots/> op(op(op(st,xs[0]),xs[1]),xs[2])<dots/>,xs[l-1])</quote>\n"
      + " \n"
      + "Oder bei Infixschreibweise der Funktion <tt>op</tt> gleichbedeutend über \n"
      + "folgende Gleichung:\n"
      + "\n"
      + "<quote>fold(<math><lpar/>x<subscript>0</subscript\n"
      + ">,x<subscript>1</subscript\n"
      + ">,</math>,<dots/>,<math>x<subscript>l-1</subscript><rpar/></math\n"
      + ">,l,op,st) = <math>st</math><w/>op<w/><math>x<subscript>0</subscript></math\n"
      + "><w/>op<w/><math>x<subscript>1</subscript></math><w/>op<w/>\n"
      + "<math>x<subscript>2</subscript></math><w/>op <dots/> op<w/><math>x<subscript>l-1</subscript></math></quote>\n"
      + "\n"
      + "Testen Sie Ihre Methode <tt>fold</tt> mit folgenden Programm:\n"
      + "\n"
      + "<code class=\"FoldTest\" lang=\"c\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "#include \"Fold.h\"\n"
      + "\n"
      + "int add(int x,int y){return x+y;}\n"
      + "int mult(int x,int y){return x*y;}\n"
      + "\n"
      + "int fold(int xs [],int length,int (*foldOp)(int,int),int startV);\n"
      + "\n"
      + "int main(){\n"
      + "  int xs [] = {1,2,3,4,5};\n"
      + "  printf(\"%i\n\",fold(xs,5,add,0));\n"
      + "  printf(\"%i\n\",fold(xs,5,mult,1));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "</aufgabe>\n"
      + "\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Sortieren von Reihungen mit bubblesort\">\n"
      + "Auf Reihungen läßt sich einer der populärsten Algorithmen der Infomatik\n"
      + "implementieren. Es der sogenannte <em>bubble sort</em> zum Sortieren der\n"
      + "Elemente einer Sammlung, in unserem Fall einer Reihung, nach einer bestimmten\n"
      + "Ordnung. \n"
      + "\n"
      + "Der Name <em>bubble sort</em> leitet sich davon\n"
      + "ab, daß Elemente wie die Luftblasen in einem Mineralwasserglass\n"
      + "innerhalb der Reihung aufsteigen, wenn sie laut der Ordnung an einen\n"
      + "höheren Platz gehören. Ein vielleicht phonetisch auch ähnlicher\n"
      + "klingender deutscher Name wäre <em>Blubbersortierung</em>. Dieser Name\n"
      + "ist jedoch nicht in der deutschen Terminologie etabliert und es wird\n"
      + "in der Regel der englische Name genommen.\n"
      + "<p/>\n"
      + "Die Idee des <em>bubble sort</em> ist, jeweils nur zwei benachbarte\n"
      + "Elemente einer Reihung zu betrachten und diese gegebenenfalls in ihrer\n"
      + "Reihenfolge zu vertauschen. Eine Reihung wird also von vorne bis hinten\n"
      + "durchlaufen, immer zwei benachbarte Elemente betrachtet und diese,\n"
      + "falls das vordere nicht kleiner ist als das hintere, getauscht. Wenn\n"
      + "die Liste in dieser Weise einmal durchgegangen wurde, ist sie entweder\n"
      + "fertig sortiert oder muß in gleicher Weise nocheinmal durchgegangen\n"
      + "werden, solange, bis keine Vertauschungen mehr vorzunehmen sind.\n"
      + "Allerdings braucht man bei einem weiteren Durchgang, das letzte Element nicht\n"
      + "mehr mit dem vorletzten zu vergleichen, da ein Blubberdurchgang sicherstellt,\n"
      + "dass das größte Element an die oberste Stelle kommt. \n"
      + "<p/>\n"
      + "\n"
      + "Betrachten wir ein Beispiel:<br />\n"
      + "Die Reihung <tt>(\"z\",\"b\",\"c\",\"a\")</tt> wird durch \n"
      + "den <em>bubble sort</em>-Algorithmus in folgender Weise sortiert:<p/>\n"
      + "\n"
      + "<b> 1. Bubble-Durchlauf</b><br/>\n"
      + "<tt>(\"z\",\"b\",\"c\",\"a\")</tt><br/>\n"
      + "<tt>(\"b\",\"z\",\"c\",\"a\")</tt><br/>\n"
      + "<tt>(\"b\",\"c\",\"z\",\"a\")</tt><br/>\n"
      + "<tt>(\"b\",\"c\",\"a\",\"z\")</tt><p/>\n"
      + "Das Element <tt>\"z\"</tt> ist in diesem Durchlauf an das Ende der Reihung\n"
      + "geblubbert. <p/>\n"
      + "\n"
      + "\n"
      + "<b> 2. Bubble-Durchlauf</b><br/>\n"
      + "<tt>(\"b\",\"c\",\"a\",\"z\")</tt><br/>\n"
      + "<tt>(\"b\",\"a\",\"c\",\"z\")</tt><p/>\n"
      + "\n"
      + "In diesem Durchlauf ist das Element <tt>\"c\"</tt> um einen Platz nach\n"
      + "hinten geblubbert.<p/>\n"
      + "\n"
      + "<b> 3. Bubble-Durchlauf</b><br/>\n"
      + "<tt>(\"b\",\"a\",\"c\",\"z\")</tt><br/>\n"
      + "<tt>(\"a\",\"b\",\"c\",\"z\")</tt><p/>\n"
      + "\n"
      + "Im letzten Schritt ist das Element <tt>\"b\"</tt> auf seine endgültige\n"
      + "Stelle geblubbert.<p/>\n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"Implementierung\">\n"
      + "Blubbersortierung läßt sich relativ leicht für Reihungen implementieren. Eine\n"
      + "Reihung ist dabei nur mehrfach zu durchlaufen und nebeneinanderstehende\n"
      + "Elemente sind eventuell in der Reihenfolge zu vertauschen. Dieses wird so\n"
      + "lange gemacht, bis keine Vertauschung mehr stattfindet, maximal aber um eines\n"
      + "weniger, als die Reihung Elemente hat.\n"
      + "\n"
      + "<code class=\"BubbleSort1\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "typedef enum {false,true} boolean;\n"
      + "\n"
      + "void bubble(int* xs, int i){\n"
      + "  boolean changed = true ;\n"
      + "  for (;changed && i>1;i--){\n"
      + "    changed=false;\n"
      + "    int j=0;\n"
      + "    for (;j<(i-1);j++){\n"
      + "      if (xs[j]>xs[j+1]){\n"
      + "        int tmp=xs[j];\n"
      + "        xs[j]=xs[j+1];\n"
      + "        xs[j+1]=tmp;\n"
      + "        changed=true;\n"
      + "      }\n"
      + "    }\n"
      + "  }\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  int xs [] = {321,43,43,5345,54,543,543,543,43,1,4,2};\n"
      + "  bubble(xs,12);\n"
      + "  int i=0;\n"
      + "  for (;i<12;i++)printf(\"%i,\",xs[i]);\n"
      + "  printf(\"\n\");\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</subsubsection>\n"
      + "<subsubsection titel=\"Implementierung mit Hilfsfunktionen\">\n"
      + "Wem die obige Implementierung zu komplex innerhalb einer Funktion ist, der\n"
      + "  kann sie sinnvoller Weise auf mehrere Funktionen splitten. Drei Aufgabe sind\n"
      + "  bei diesem Sotrierverfahren zu berwerkstelligen:\n"
      + "\n"
      + "<itemize>\n"
      + "<item>jeweils zwei Elemente eines Arrays sind zu vertauschen</item>\n"
      + "<item>ein Array ist einmal vom Anfang bis zu einem vorgegebenen Index zu\n"
      + "durchlaufen. Sind zwei benachbarte Elemente nicht in der richtigen\n"
      + "Reihenfolge, so sind diese zu vertauschen. </item>\n"
      + "<item>es ist so oft durch einen Array immer wieder zu durchlaufen, bis er\n"
      + "sortiert ist.</item>\n"
      + "</itemize>\n"
      + "\n"
      + "Entsprchend läßt sich die Sortierung mit drei kleinen Teilfunktionen\n"
      + "implementieren:\n"
      + "\n"
      + "Zunächst die kleine Hilfsmethode zum Vertauschen zweier Elemente eines\n"
      + "Arrays. Die Indizes dieser Elemente werden als weitere Parameter übergeben:\n"
      + "<code class=\"BubbleSort2\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "#include <stdlib.h>\n"
      + "typedef enum {false,true} boolean;\n"
      + "\n"
      + "void swap(int* xs,int i,int j){\n"
      + "  int tmp=xs[i];\n"
      + "  xs[i]=xs[j];\n"
      + "  xs[j]=tmp;\n"
      + "}]]></code>\n"
      + "\n"
      + "Als zweite Funktion kann das eigentliche <em>bubblen</em> realsiert werden:\n"
      + "\n"
      + "<code class=\"BubbleSort2\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[boolean bubble(int* xs,int i){\n"
      + "  boolean result = false;\n"
      + "  int j=0;\n"
      + "  for (;j<(i-1);j++){\n"
      + "    if (!xs[j]<xs[j+1]){\n"
      + "      swap(xs,j,j+1);\n"
      + "      result=true;\n"
      + "    }\n"
      + "  }\n"
      + "  return result;\n"
      + "}]]></code>\n"
      + "\n"
      + "Dieses wird nun so oft auf einem Array angewendet, bis dieser sortiert ist.\n"
      + "\n"
      + "<code class=\"BubbleSort2\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[void bubbleSort(int* xs, int length){\n"
      + "  boolean changed = true;\n"
      + "  for (;changed && length>1;length--) \n"
      + "    changed=bubble(xs,length);\n"
      + "}]]></code>\n"
      + "\n"
      + "Als kleine Demonstration noch einmal die Testfunktion:\n"
      + "\n"
      + "<code class=\"BubbleSort2\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[int main(){\n"
      + "  int xs [] = {321,43,43,5345,54,543,543,543,43,1,4,2};\n"
      + "  bubbleSort(xs,12);\n"
      + "  int i=0;\n"
      + "  for (;i<12;i++)printf(\"%i,\",xs[i]);\n"
      + "  printf(\"\n\");\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Sortierrelation übergeben\">\n"
      + "Ein Sortieralgorithmus ist vollkommen unabhängig davon, wonach sortiert werden\n"
      + "soll. Die obige Implementierung kann nur sortieren, dass erst die kleinen und\n"
      + "dann die großen Zahlen kommen. Wenn wir umgekehrt von groß nach klein\n"
      + "sortieren wollen, muß der ganze Algorithmus komplett neu implementiert werden,\n"
      + "nur um ein einziges Zeichen zu ändern, nämlich das Kleinerzeichen ins\n"
      + "Größerzeichen.  Das würde zu einer immensen Codeverdoppelung führen. Daher\n"
      + "wäre es doch schön, den <em>bubblesort</em> so zu implementieren, dass\n"
      + "flexibel gehalten ist, nach welcher Sotrierrelation sortiert werden soll. Da\n"
      + "wir in C Funktionen als Parameter übergeben können, können wir der\n"
      + "Sotrierfunktion als zusätzlichen Parameter eine Funktion übergeben, die für\n"
      + "zwei Elemente <em>true</em> zurückgibt, wenn das erste kleiner als das zweite\n"
      + "ist. \n"
      + "\n"
      + "So implementieren wir <em>bubblesort</em> als Funktion höherer Ordnung. Die\n"
      + "Funktion <tt>swap</tt> ist davon nicht betroffen:\n"
      + "\n"
      + "\n"
      + "<code class=\"BubbleSort3\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "typedef enum {false,true} boolean;\n"
      + "\n"
      + "void swap(int* xs,int i,int j){\n"
      + "  int tmp=xs[i];\n"
      + "  xs[i]=xs[j];\n"
      + "  xs[j]=tmp;\n"
      + "}]]></code>\n"
      + "\n"
      + "Die Funktion <tt>bubble</tt> bekommt einen zusätzliche Parameter. Eine\n"
      + "Funktion, die für zwei Zahlen entscheidet, ob die erste kleiner in einer\n"
      + "Relation ist. Diese wird dann verwendet, beim Vergleich der benachbarten zwei\n"
      + "Arrayelemente: \n"
      + "\n"
      + "<code class=\"BubbleSort3\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + ">boolean bubble(int* xs,int i,<redv>boolean smaller(int,int)</redv>){\n"
      + "  boolean result = false;\n"
      + "  int j=0;\n"
      + "  for (;j&lt;(i-1);j++)\n"
      + "    if (!<redv>smaller(xs[j],xs[j+1])</redv>){\n"
      + "      swap(xs,j,j+1);\n"
      + "      result=true;\n"
      + "    }\n"
      + "  return result;\n"
      + "}</code>\n"
      + "\n"
      + "Ebenso braucht die Funktion <tt>bubbleSort</tt> diesen Funktionsparameter, um\n"
      + "ihn an die Funktion <tt>bubble</tt> weiterzureichen:\n"
      + "\n"
      + "<code class=\"BubbleSort3\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + ">void bubbleSort(int* xs, int length,<redv>boolean smaller(int,int)</redv>){\n"
      + "  boolean changed = true;\n"
      + "  for (;changed &amp;&amp; length&gt;1;length--) \n"
      + "    changed=bubble(xs,length,<redv>smaller</redv>);\n"
      + "}</code>\n"
      + "\n"
      + "Soweit der Bubblesort mit der Sortierrelation als Parameter. Jetzt seien\n"
      + "einmal drei verschiedene Sortierrelationen zu schreiben. Einmal sollen kleine\n"
      + "vor großen Zahlen kommen, einmal umgekehrt, und in der dritten Sortierrelation\n"
      + "seien ungerade Zahlen prinzipiell kleiner als gerade Zahlen:\n"
      + "\n"
      + "<code class=\"BubbleSort3\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[boolean le(int x,int y){return x<y;}\n"
      + "boolean ge(int x,int y){return x>y;}\n"
      + "boolean oddFirst(int x,int y){return x%2>y%2 || (x%2==y%2 && x<y);}]]></code>\n"
      + "\n"
      + "Für die nun folgenden Test, sei wieder eine kleine Ausgabefunktion für\n"
      + "Reihungen geschrieben:\n"
      + "\n"
      + "<code class=\"BubbleSort3\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[\n"
      + "void printArray(int* xs,int length){\n"
      + "  int i=0;\n"
      + "  printf(\"[\");\n"
      + "  for (;i<length;i++){\n"
      + "    printf(\"%i\",xs[i]);\n"
      + "    if (i<length-1) printf(\", \");\n"
      + "  }\n"
      + "  printf(\"]\n\");\n"
      + "}]]></code>\n"
      + "\n"
      + "Und jetzt können wir ein und dieselbe Sortierfunktion benutzen, um nach ganz\n"
      + "unterschiedlichen Relationen zu sortieren:\n"
      + "\n"
      + "<code class=\"BubbleSort3\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[int main(){\n"
      + "  int xs [] = {321,43,43,5345,54,543,543,543,43,1,4,2};\n"
      + "  bubbleSort(xs,12,le);\n"
      + "  printArray(xs,12);\n"
      + "  bubbleSort(xs,12,ge);\n"
      + "  printArray(xs,12);\n"
      + "  bubbleSort(xs,12,oddFirst);\n"
      + "  printArray(xs,12);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Und tatsächlich wird die Reihung dreifach unterschiedlich sortiert:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/BubbleSort3\n"
      + "[1, 2, 4, 43, 43, 43, 54, 321, 543, 543, 543, 5345]\n"
      + "[5345, 543, 543, 543, 321, 54, 43, 43, 43, 4, 2, 1]\n"
      + "[1, 43, 43, 43, 321, 543, 543, 543, 5345, 2, 4, 54]\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Beliebige Zeigerelemente sortieren\">\n"
      + "Im letzten Abschnitt haben wir die Sortierrelation, über die sortietr werden\n"
      + "variabel gehalten und als Parameter übergeben.  Wir haben aber stets nur\n"
      + "Reihungen, die ganze Zahlen als Elemente enthalten haben, sortiert. Im Prinzip\n"
      + "ist einem Sortieralgorithmus auch gleichgültig, um was für Elemente es sich in\n"
      + "einer Reihung handelt, solange eine Sotrierrelation auf diesen Elementen\n"
      + "bekannt ist. \n"
      + "\n"
      + "So soll jetzt der Bubblesort so modifiziert werden, dass er beliebige\n"
      + "Datenobjekte sortieren kann. Die einziege Möglichkeit, die es in C gibt über\n"
      + "beliebige Daten zu sprechen, ist über den <tt>void</tt>-Zeiger. Um unser\n"
      + "vorgehen noch ein wenig plastischer zu machen, sei der \n"
      + "Typ <tt>void*</tt> als <tt>Object</tt> bezeichnet:\n"
      + "\n"
      + "\n"
      + "<code class=\"BubbleSort4\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "#include <stdlib.h>\n"
      + "\n"
      + "typedef void* Object;]]></code>\n"
      + "\n"
      + "Die Funktion <tt>swap</tt> ändert sich im Prinzip nicht. Wir müssen nur\n"
      + "berücksichtigen, dass nun nicht in einer Reihung mit <tt>int</tt>-Zahlen zwei\n"
      + "Elemente vertauscht werden, sondern in einer Reihung von Objekten:\n"
      + "\n"
      + "<code class=\"BubbleSort4\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + ">typedef enum {false,true} boolean;\n"
      + "\n"
      + "void swap(<redv>Object</redv>* xs,int i,int j){\n"
      + "  Object tmp=xs[i];\n"
      + "  xs[i]=xs[j];\n"
      + "  xs[j]=tmp;\n"
      + "}</code>\n"
      + "\n"
      + "Tatsächlich ändert sich auch nichts in der Funktion <tt>bubble</tt>, bis auf\n"
      + "dass der Typ <tt>int</tt> durch den Typ <tt>Object</tt> ersetzt wurde:\n"
      + "<code class=\"BubbleSort4\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[boolean bubble(Object* xs,int i,boolean smaller(Object,Object)){\n"
      + "  boolean result = false;\n"
      + "  int j=0;\n"
      + "  for (;j<(i-1);j++)\n"
      + "    if (!smaller(xs[j],xs[j+1])){\n"
      + "      swap(xs,j,j+1);\n"
      + "      result=true;\n"
      + "    }\n"
      + "  return result;\n"
      + "}]]></code>\n"
      + "\n"
      + "Das gleiche gilt für die Funktion <tt>bubbleSort</tt>:\n"
      + "\n"
      + "<code class=\"BubbleSort4\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[void bubbleSort(Object* xs, int length,boolean smaller(Object,Object)){\n"
      + "  boolean changed = true;\n"
      + "  for (;changed && length>1;length--) \n"
      + "    changed=bubble(xs,length,smaller);\n"
      + "}]]></code>\n"
      + "\n"
      + "In der Funktion <tt>printArray</tt> bekommen wir ein kleines Problem. Wir\n"
      + "wissen nicht, um was für Objekte es sich in der Reihung handelt, somit können\n"
      + "wir auch nicht wissen, wie diese Objekte auszugeben sind. Daher benötigen wir\n"
      + "noch eine weitere Funktion als Parameter übergeben. Diese soll ein Objekt auf\n"
      + "der KOmmandozeile ausgeben:\n"
      + "\n"
      + "<code class=\"BubbleSort4\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[void printArray(Object* xs,int length,void printer(Object)){\n"
      + "  int i=0;\n"
      + "  printf(\"[\");\n"
      + "  for (;i<length;i++){\n"
      + "    printer(xs[i]);\n"
      + "    if (i<length-1) printf(\", \");\n"
      + "  }\n"
      + "  printf(\"]\n\");\n"
      + "}]]></code>\n"
      + "\n"
      + "Soweit die Implementierung der allgemeinen Sortierung. Wir haben nun zum einen\n"
      + "die Art der Daten, die sortiert werden sollen, zum anderen die Sortierrelation\n"
      + "offen gelassen. Um die Sortierung zu testen, seien ein paar Klassen\n"
      + "definiert. Zunächst einmal mehr die schon bekannte Punktklasse für Punkte im\n"
      + "zweidimensionalen Raum:\n"
      + "\n"
      + "<code class=\"BubbleSort4\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[typedef struct {\n"
      + "  int x;\n"
      + "  int y;\n"
      + "} PunktStrukt;\n"
      + "\n"
      + "typedef PunktStrukt* Punkt;]]></code>\n"
      + "\n"
      + "Es seien wieder entsprechend Konstruktor und Destruktor definiert, sowie eine\n"
      + "einfache Funktion für das Quadrat der Entfernung zum Nullpunkt:\n"
      + "\n"
      + "<code class=\"BubbleSort4\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[Punkt newPunkt(int x,int y){\n"
      + "  Punkt this = (Punkt)malloc(sizeof(PunktStrukt));\n"
      + "  this->x=x; \n"
      + "  this->y=y;\n"
      + "  return this;\n"
      + "} \n"
      + "\n"
      + "void deletePunkt(Punkt this){\n"
      + "  free(this);\n"
      + "}\n"
      + "\n"
      + "int square(int x){return x*x;}\n"
      + "int betragQuadrat(Punkt p){return square(p->x)+square(p->y);}\n"
      + "]]></code>\n"
      + "\n"
      + "Um Punktobjekte zu sortieren, brauchen wir auf Punktobjekten eine \n"
      + "Sortieerrelation. Punkte, die näher am Nullpunkt liegen, seien kleiner als\n"
      + "weiter entfernte in dieser Relation:\n"
      + "\n"
      + "<code class=\"BubbleSort4\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[boolean lePunkt(Object o1,Object o2){\n"
      + "  Punkt p1=(Punkt)o1;\n"
      + "  Punkt p2=(Punkt)o2;\n"
      + "  return betragQuadrat(p1)<betragQuadrat(p2);\n"
      + "}]]></code>\n"
      + "\n"
      + "Wir müssen auch eine Methode zur Ausgabe eines Punktobjektes definieren:\n"
      + "\n"
      + "<code class=\"BubbleSort4\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[void printPunkt(Object p){\n"
      + "  printf(\"(%i,%i)\",((Punkt)p)->x,((Punkt)p)->y);\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "Als zweites wollen wir auch wieder ganze Zahlen sortieren, allerdings können\n"
      + "wir nur verzeigerte Objekte sortieren. Somit sei aich eine Klasse \n"
      + "die <tt>int</tt>-Zahlen repräsentiert, definiert. Auch diese Klasse sei gleich\n"
      + "mit Konstruktor, destruktor, der <tt>print</tt>-Methode und schließlich einer\n"
      + "Kleinerrelation  definiert:\n"
      + "\n"
      + "<code class=\"BubbleSort4\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[typedef int* Integer;\n"
      + "\n"
      + "Integer newInt(int x){\n"
      + "  Integer result =(void*)malloc(sizeof(int));\n"
      + "  *result=x;\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "void deleteInt(Integer this){free(this);}\n"
      + "\n"
      + "void printInt(Object p){printf(\"%i\",*((Integer)p));}\n"
      + "\n"
      + "boolean leInt(Object o1,Object o2){\n"
      + "  Integer i1=(Integer)o1;\n"
      + "  Integer i2=(Integer)o2;\n"
      + "  return *i1<*i2;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "Als dritte Klasse von Elemente, die sortiert werden sollen, sei nun noch eine\n"
      + "Klasse für Wahrheitswerte definiert. Auch diese wieder mit Konstruktor,\n"
      + "Destruktor, <tt>print</tt>-Methode und schließlich einer\n"
      + "Kleinerrelation:\n"
      + "<code class=\"BubbleSort4\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[typedef boolean* Boolean;\n"
      + "\n"
      + "Boolean newBoolean(boolean x){\n"
      + "  Boolean result =(Boolean)malloc(sizeof(boolean));\n"
      + "  *result = x;\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "void printBoolean(Object p){\n"
      + "  if (*((Boolean)p)) printf(\"true\");\n"
      + "  else printf(\"false\");\n"
      + "}\n"
      + "\n"
      + "boolean leBoolean(Object o1,Object o2){return *(Boolean)o1;}]]></code>\n"
      + "\n"
      + "Nun kann es losgehen. Zunächst sei eine Reihung von Punkten definiert:\n"
      + "\n"
      + "<code class=\"BubbleSort4\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[int main(){\n"
      + "  Punkt xs [] = {newPunkt(321,43)\n"
      + "                ,newPunkt(43,5345)\n"
      + "                ,newPunkt(54,543)\n"
      + "                ,newPunkt(543,543)\n"
      + "                ,newPunkt(43,1)\n"
      + "                ,newPunkt(4,2)};\n"
      + "  bubbleSort((Object*)xs,6,lePunkt);\n"
      + "  printArray((Object*)xs,6,printPunkt);\n"
      + "  int i=0;\n"
      + "  for (;i<6;i++) deletePunkt(xs[i]);]]></code>\n"
      + "\n"
      + "Jetzt können wir dieselbe Sortierfunktion benutzen, um eine Reihung von Zahlen\n"
      + "zu sortieren:\n"
      + "\n"
      + "<code class=\"BubbleSort4\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[  Object ys [6];\n"
      + "  for (i=0;i<6;i++)ys[i]=newInt(42-i);\n"
      + "  \n"
      + "  bubbleSort(ys,6,leInt);\n"
      + "  printArray(ys,6,printInt);\n"
      + "  for (i=0;i<6;i++) deleteInt(ys[i]);]]></code>\n"
      + "\n"
      + "Und auf die gleiche Weise können wir auch eine Reihung von Wahrheitswerten\n"
      + "sortieren: \n"
      + "\n"
      + "<code class=\"BubbleSort4\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[  for (i=0;i<6;i++) ys[i]=((Object)newBoolean(i%3==0));\n"
      + "  bubbleSort(ys,6,leBoolean);\n"
      + "  printArray(ys,6,printBoolean);\n"
      + "\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Und tatsächlich werden die drei Reihungen mit ihren ganz unterschiedlichen\n"
      + "Daten alle korrekt sortiert:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/BubbleSort4\n"
      + "[(4,2), (43,1), (321,43), (54,543), (543,543), (43,5345)]\n"
      + "[37, 38, 39, 40, 41, 42]\n"
      + "[true, true, false, false, false, false]\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "</subsubsection>\n"
      + "\n"
      + "</subsection>\n"
      + "</section>\n"
      + "\n"
      + "<section titel=\"Arbeiten mit Texten\">\n"
      + "Wahrscheinlich die am häufigsten benötigten Daten sind Texte. Texte\n"
      + "unbestimmter Länge, die Wachsen und Schrumpfen können. Texte die editiert\n"
      + "werden sollen und modifiziert. Unglücklicher Weise stellt C für Texte keinen\n"
      + "eigenen Typ zur Verfügung. Damit steht C als Programmiersprache ziemlich\n"
      + "allein dar, denn fast alle neueren Programmiersprachen bieten komfortable\n"
      + "Mittel an, um Texte in Form von Zeichenketten zu bearbeiten.\n"
      + "\n"
      + "Dabei haben wir bereits gesehen, dass auch C nicht gänzlich blind für\n"
      + "Zeichenketten ist, denn es wird ja ein entsprechendes Literal angeboten.\n"
      + "Zeichenketten können in dopppelten Hochkommas eingeschlossen als Literale in C\n"
      + "ausgedrückt werden. Es fragt sich, wenn es nicht wie in anderen\n"
      + "Programmiersprachen einen Typ <tt>string</tt> für Zeichenketten gibt, als was\n"
      + "für einen Typ werden die <tt>string</tt>-Literale dann gespeichert? \n"
      + "\n"
      + "Die Antwort liegt in den geraden kennengelernten Reihungen. \n"
      + "Ein <tt>string</tt> ist eine Reichung vom einzelnen Werten des \n"
      + "Typs <tt>char</tt>, und da es sich bei Reihungen lediglich um einen Zeiger auf\n"
      + "das erste Reihungselement handelt, sind tatsächlich Zeichenketten als Werte\n"
      + "des Typs <tt>char*</tt> gespeichert.\n"
      + "\n"
      + "\n"
      + "Intern hat jeder C-String ein Element mehr als Zeichen. In diesem letzten\n"
      + "Element ist mit einer <tt>0</tt> markiert, daß der String jetzt zu Ende\n"
      + "ist. Zeichenketten werden also intern durch ein Nullelement beendet. Dieses\n"
      + "ist unabhängig von der eigentlichen technischen Länge der Reihung. \n"
      + "\n"
      + "Initialisiert man eine Reihung von Zeichen mit der Mengenklammeraufzählung ist\n"
      + "der beendende Nullwert unbedingt zu berücksichtigen. \n"
      + "<code class=\"CString2\" lang=\"c\" main=\"main\"\n"
      + ">#include &lt;stdio.h&gt;\n"
      + "\n"
      + "int main(){\n"
      + "  char hello[] = \n"
      + "   { 'H', 'e', 'l', 'l', 'o', <redv>'\\0'</redv> };\n"
      + "  printf(\"%s\n\",hello);\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Wird die Endemarkierung bei der Initialisierung vergessen, so blickt C\n"
      + "unkontrolliert weiter in den Speicher und betrachtet alles nachfolgende als\n"
      + "Zeichen der Zeichenkette, bis zufällig ein Nullwert kommt. Das folgende\n"
      + "Programm erzeugt auch eine indeterministische Ausgabe:\n"
      + "\n"
      + "<code class=\"CString3\" lang=\"c\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "int main(){\n"
      + "  char hello[] = \n"
      + "   { 'H', 'e', 'l', 'l', 'o'};\n"
      + "  printf(\"%s\n\",hello);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> ./bin/CString3\n"
      + "Hello¿½@@0Gï¿½@\n"
      + "         sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "Für C ist eine Zeichenkette immer genau dann beendet, wenn der abschließende\n"
      + "Nullwert auftritt. Dieses gilt auch, wenn er inmitten der Reihung auftritt. \n"
      + "\n"
      + "Im folgenden Programm ist nach der Zuweisung des Nullwerts für das Element am\n"
      + "Index 6 für C der String nach dem Wort <tt>hello</tt> beendet, obwohl die\n"
      + "Reihung länger ist und noch weitere sinnvolle Zeichen in der Reihung\n"
      + "gespeichert sind.\n"
      + "<code class=\"CString4\" lang=\"c\" main=\"main\"\n"
      + ">#include &lt;stdio.h&gt;\n"
      + "\n"
      + "int main(){\n"
      + "  char hello [] = \"hello world!\";\n"
      + "  <redv>hello[5] ='\\0'</redv>;\n"
      + "\n"
      + "  printf(\"%s\n\",hello);\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "\n"
      + "<scode><![CDATA[ sep@pc305-3:~/fh/c/student> ./bin/CString4\n"
      + "hello\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "In traditioneller C-Programmierung gibt es typischer Weise Reihungen einer\n"
      + "maximalen Länge, in denen unterschiedlich lange Strings gespeichert sind. Für\n"
      + "das Programm bedeutet das, daß die Stringwerte an diesen Stellen eine\n"
      + "bestimmte Maximallänge nicht überschreiten dürfen. Daher kommt in vielen\n"
      + "älteren Programmen wahrscheinlich die Restriktion, daß bestimmte Namen, Pfade\n"
      + "oder Optionen nur\n"
      + "eine bestimmte Länge haben dürfen.<p/>\n"
      + "\n"
      + "<code class=\"StringLength\" lang=\"h\" main=\"main\"\n"
      + "><![CDATA[#ifndef STRING_LENGTH__H_\n"
      + "#define STRING_LENGTH__H_\n"
      + "\n"
      + "unsigned int stringLaenge(char* xs);\n"
      + "#endif]]></code>\n"
      + "\n"
      + "<code class=\"StringLength\" lang=\"c\"><![CDATA[#include \"StringLength.h\"\n"
      + "unsigned int stringLaenge(char* xs){\n"
      + "  int result=0;\n"
      + "  int i = 0;\n"
      + "  for (;xs[i]!='\\0';i++){\n"
      + "    result++;\n"
      + "  }\n"
      + "  return result;\n"
      + "}]]></code>\n"
      + "\n"
      + "<code class=\"TestStringLength\" lang=\"c\" \n"
      + "  main=\"gcc -o TestStringLength ../obj/TestStringLength.o ../obj/StringLength.o \"\n"
      + "><![CDATA[#include \"StringLength.h\"\n"
      + "#include <stdio.h>\n"
      + "int main(){\n"
      + "  char* str = \"hallo\";\n"
      + "  printf(\"der String \\\"%s\\\" hat %i Zeichen\n\",str,stringLaenge(str));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "<code class=\"StringToUpper\" lang=\"h\" main=\"main\"><![CDATA[#ifndef STRING_TO_UPPER__H_\n"
      + "#define STRING_TO_UPPER__H_\n"
      + "\n"
      + "void toUpper(char* source,char* target);\n"
      + "#endif]]></code>\n"
      + "\n"
      + "<code class=\"StringToUpper\" lang=\"c\"><![CDATA[#include \"StringToUpper.h\"\n"
      + "#define LOWER_TO_UPPER  'A'-'a';\n"
      + "\n"
      + "char charToUpper(char c){\n"
      + "  if (c>='a' && c <= 'z'){\n"
      + "    return c+LOWER_TO_UPPER;\n"
      + "  }\n"
      + "  return c;\n"
      + "} \n"
      + "\n"
      + "void toUpper(char* source,char* target){\n"
      + "  int i=0;\n"
      + "  for (;source[i]!='\\0';i++){\n"
      + "    target[i] = charToUpper(source[i]);\n"
      + "  }\n"
      + "  target[i]='\\0';\n"
      + "}]]></code>\n"
      + "\n"
      + "<code class=\"TestToUpper\" lang=\"c\" \n"
      + " main=\"gcc -o TestToUpper ../obj/TestToUpper.o ../obj/StringToUpper.o ../obj/StringLength.o \"\n"
      + "><![CDATA[#include \"StringToUpper.h\"\n"
      + "#include \"StringLength.h\"\n"
      + "#include <stdio.h>\n"
      + "int main(){\n"
      + "  char* str = \"hallo Du da!\";\n"
      + "  char erg [stringLaenge(str)+1]; \n"
      + "  toUpper(str,erg);\n"
      + "  printf(\"der String \\\"%s\\\" in Grossbuchstaben: \\\"%s\\\"\n\",str,erg);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"Kommandozeilenparameter\">\n"
      + "Auch für die\n"
      + "Hauptmethode hat es Auswirkungen, daß C Reihungen ihre Elementanzahl nicht\n"
      + "kennen. Unsere bisherigen Hauptmethoden\n"
      + "hatten keine Argumente. Man kann zur Kommandozeilenübergabe in C aber auch\n"
      + "eine Hauptmethode schreiben, der in einer Reihung die Kommandozeilenoptionen\n"
      + "übergeben werden. Hierzu braucht man dann aber auch ein weiteres Argument, das\n"
      + "die Länge der übergebenen Reihung mit angibt.\n"
      + "\n"
      + "<code class=\"CommandLineOption\" lang=\"c\" main=\"main\"\n"
      + ">#include &lt;stdio.h&gt;\n"
      + "\n"
      + "int main(<redv>int argc, char* argv []</redv>){  \n"
      + "  int i;\n"
      + "  for (i=0;i&lt;argc;i++){\n"
      + "    char* arg = argv[i];\n"
      + "    printf(\"%s\n\",arg);\n"
      + "  }\n"
      + "  return 0;\n"
      + "}</code>\n"
      + "\n"
      + "Wie man an dem folgenden Testlauf sieht, wird als erstes Reihungselement der\n"
      + "Name des Programms übergeben.  \n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> ./bin/CommandLineOption hallo C -v gruss\n"
      + "./bin/CommandLineOption\n"
      + "hallo\n"
      + "C\n"
      + "-v\n"
      + "gruss\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "\n"
      + "\n"
      + "</subsubsection>\n"
      + "</section>\n"
      + "\n"
      + "\n"
      + "<section titel=\"Typsumme mit Unions\">\n"
      + "Als Summentyp wird in der Informatik ein Typ bezeichnet, der die Vereinigung\n"
      + "einer oder mehrerer Typen darstellt.\n"
      + "Auch hierfür stellt C ein eigenes\n"
      + "Konstrukt zur Verfügung: die Vereinigung von Typen, die <tt>union</tt>. <p/>\n"
      + "\n"
      + "Syntaktisch sieht eine Typvereinigung einer Struktur sehr ähnlich. Lediglich\n"
      + "das Schlüsselwort <tt>struct</tt> ist durch das Schlüsselwort <tt\n"
      + ">union</tt> zu ersetzen. Somit läßt sich eine Vereinigung der \n"
      + "Typen <tt>int</tt> und <tt>char*</tt> definieren \n"
      + "als:<br/>\n"
      + "<tt>union stringOrInt {int i;char *s;};</tt>.<p/>\n"
      + "\n"
      + "Daten des Typs <tt>union stringOrInt</tt> sind nun entweder eine Zahl, die\n"
      + "über das Attribut <tt>i</tt> angesprochen werden kann, oder der Zeiger auf das\n"
      + "erstes Element einer Zeichenkette, der über das \n"
      + "Attribut <tt>s</tt> angesprochen werden kann.\n"
      + "\n"
      + "<example>\n"
      + "Im folgenden kleinem Programm  wird eine Typsumme definiert und beispielhaft\n"
      + "in einer Hauptmethode benutzt. \n"
      + "<code class =\"Union1\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "union stringOrInt {int i;char *s;};\n"
      + "\n"
      + "int main(){\n"
      + "  union stringOrInt sOrI;\n"
      + "  sOrI.s=\"hallo da draussen\";\n"
      + "  printf(\"%s\n\", sOrI.s);\n"
      + "\n"
      + "  sOrI.i=42;\n"
      + "  printf(\"%i\n\", sOrI.i);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "Wie man der Ausgabe entnehmen kann, wird in der Variablen des Typs <tt\n"
      + ">stringOrInt</tt> entweder ein <tt>int</tt> oder eine Zeichenkettenreferenz gespeichert:\n"
      + "<scode><![CDATA[sep@linux:~/fh/prog3/examples/src> gcc -o Union1 Union1.c\n"
      + "sep@linux:~/fh/prog3/examples/src> ./Union1\n"
      + "hallo da draussen\n"
      + "42\n"
      + "sep@linux:~/fh/prog3/examples/src>]]></scode>\n"
      + "</example>\n"
      + "\n"
      + "\n"
      + "\n"
      + "Im letzten Beispiel haben wir die Typsumme gutartig benutzt.  Die Typsumme\n"
      + "drückt aus, daß die Daten entweder von einem oder vom anderen Typ sind. Im\n"
      + "Beispiel haben wir uns gemerkt, welchen Typ wir als letztes in der\n"
      + "entsprechenden Variablen gespeichert haben und nur auf diesen Typ\n"
      + "zugegriffen. C bewahrt uns aber nicht davor, dieses immer korrekt zu tun. \n"
      + "\n"
      + "<example>\n"
      + "In diesem Beispiel benutzen wir den selben Summentypen wie im vorhergehenden\n"
      + "Beispiel. Jetzt interpretieren wir aber jeweils die Daten auch als die andere\n"
      + "Typalternative. \n"
      + "<code class =\"Union2\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "union stringOrInt {int i;char *s;};\n"
      + "\n"
      + "int main(){\n"
      + "  union stringOrInt sOrI;\n"
      + "  sOrI.s=\"hallo da draussen\";\n"
      + "  printf(\"%s\n\", sOrI.s);\n"
      + "  printf(\"%i\n\", sOrI.i);\n"
      + "\n"
      + "  sOrI.i=42;\n"
      + "  printf(\"%s\n\", sOrI.s);\n"
      + "  printf(\"%i\n\", sOrI.i);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Wenn wir jetzt einen Adresse auf einen Zeichenkette in der Variablen <tt\n"
      + ">sOrI</tt> gespeichert haben und auf die Variable mit \n"
      + "ihrem <tt>int</tt>-Attribut <tt>i</tt> zugreifen, so bekommen wir die\n"
      + "gespeicherte Adresse als Zahl geliefert.<p/>\n"
      + "\n"
      + "Wenn wir umgekehrt eine Zahl gespeichert haben und diese nun als Adresse einer\n"
      + "Zeichenkette lesen wollen, so kommt es in der Regel zu einem Fehler, weil wir\n"
      + "höchstwahrscheinlich versuchen eine Adresse im Speicher zu lesen, auf die wir\n"
      + "nicht zugreifen können.\n"
      + "<scode><![CDATA[sep@linux:~/fh/prog3/examples/src> ./Union2\n"
      + "hallo da draussen\n"
      + "134514920\n"
      + "42\n"
      + "Speicherzugriffsfehler\n"
      + "sep@linux:~/fh/prog3/examples/src>]]></scode>\n"
      + "</example>\n"
      + "\n"
      + "Um Fehler, wie im letzem Beispiel zu vermeiden, ist es ratsam Strukturen,\n"
      + "Aufzählungen  und\n"
      + "Typsummen geschachtelt zu verwenden. Hierzu kapselt man die Typsumme in eine\n"
      + "Struktur. In dieser Struktur gibt ein zweites Attribut an, um welchen Typ es\n"
      + "sich gerade in der Typsumme handelt. Für das Attribut, das den Typ\n"
      + "kennzeichnet, bietet sich an, einen Aufzählungstypen zu verwenden.\n"
      + "\n"
      + "<example>\n"
      + "In diesem Beispiel definieren wir eine Typsumme, die in einer Struktur\n"
      + "eingebettet ist. Dazu definieren wir drei Typen: eine Aufzählung, eine\n"
      + "Typsumme und eine Struktur.\n"
      + "<code class =\"Union3\" lang=\"c\" main=\"main\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "typedef enum   {INT,STRING} TypeMarker;\n"
      + "typedef union  {int i;char * s;} stringOrInt;\n"
      + "\n"
      + "typedef struct {TypeMarker type;stringOrInt v;} strOrInt;]]></code>\n"
      + "\n"
      + "Jetzt können wir uns zwei Funktionen schreiben, die jeweils eine der beiden\n"
      + "Varianten unseres Summentypens konstruieren:\n"
      + "\n"
      + "<code class =\"Union3\" lang=\"c\" sequel=\"true\"\n"
      + "><![CDATA[strOrInt forInt(int i){\n"
      + "  strOrInt result;\n"
      + "  result.type=INT;\n"
      + "  result.v.i=i;\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "strOrInt forString(char * s){\n"
      + "  strOrInt result;\n"
      + "  result.type=STRING;\n"
      + "  result.v.s=s;\n"
      + "  return result;\n"
      + "}]]></code>\n"
      + "Schließlich ein Beispiel für eine Funktion, die den neuen Typen\n"
      + "  benutzt. Hierzu ist zunächst zu fragen, von was für einen Typ denn die\n"
      + "  gespeichert sind, um dann entsprechend mit den Daten zu verfahren:\n"
      + "<code class =\"Union3\" lang=\"c\" sequel=\"true\"\n"
      + "><![CDATA[char * toString(strOrInt si){\n"
      + "  char* result;\n"
      + "  if (si.type==INT){\n"
      + "    sprintf(result,\"%d\",si.v.i);\n"
      + "  }else if (si.type==STRING){\n"
      + "    result=si.v.s;\n"
      + "  }\n"
      + "  return result;\n"
      + "}]]></code>\n"
      + "Abschließend ein kleiner Test in einer Hauptmethode:\n"
      + "<code class =\"Union3\" lang=\"c\" sequel=\"true\"\n"
      + "><![CDATA[int main(){\n"
      + "  strOrInt test = forString(\"hallo da draussen\");\n"
      + "  printf(\"%s\n\", toString(test));\n"
      + "  test = forInt(42);\n"
      + "  printf(\"%s\n\", toString(test));\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "In der Ausgabe können wir uns davon überzeugen, daß tatsächlich immer die\n"
      + "Daten der Typsumme korrekt interpretiert werden:\n"
      + "\n"
      + "<scode><![CDATA[sep@linux:~/fh/prog3/examples/src> gcc -o Union3 Union3.c\n"
      + "sep@linux:~/fh/prog3/examples/src> ./Union3\n"
      + "hallo da draussen\n"
      + "42\n"
      + "sep@linux:~/fh/prog3/examples/src>]]></scode>\n"
      + "</example>\n"
      + "\n"
      + "\n"
      + "Schließlich ist noch interessant, wieviel Speicher C für eine Typsumme\n"
      + "reserviert. Auch dieses können wir experimentel erfragen:\n"
      + "<code class=\"Union4\" lang=\"cpp\" main=\"main\"\n"
      + "><![CDATA[#include <iostream>\n"
      + "\n"
      + "typedef union {char a1 [15]; char a2 [200];}  U1;\n"
      + "typedef union {int a1; char a2 [16];}  U2;\n"
      + "\n"
      + "int main(){\n"
      + "  U1 u1;\n"
      + "  U2 u2;\n"
      + "  std::cout << sizeof(u1) << std::endl;\n"
      + "  std::cout << sizeof(u2) << std::endl;\n"
      + " }]]></code>\n"
      + "An der Ausgabe ist zu erkennen, daß der maximal notwendige Speicher für einen\n"
      + "  der  Typen in der Summe angefordert wird. \n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/Union4\n"
      + "200\n"
      + "16\n"
      + "sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "</section>\n"
      + "\n"
      + "\n"
      + "<section titel=\"Rekursive Daten\">\n"
      + "Als ein fundamentales Grundkonzept der Informatik haben wir die Rekursion\n"
      + "kennengelernt. Wir haben rekursive Funktionen definiert. Eine rekursive\n"
      + "Funktion ruft sich selbst in ihrem Rumpf wieder auf. Nicht nur Funktionen,\n"
      + "auch Daten können rekursiv definiert werden. Rekursive Daten sind Daten, die\n"
      + "sich selbst wieder enthalten. \n"
      + "\n"
      + "<subsection titel=\"Listen\"> \n"
      + "Eine der häufigsten Datenstrukturen in der Programmierung sind\n"
      + "Sammlungstypen. In fast jedem nichttrivialen Programm wird es Punkte\n"
      + "geben, an denen eine Sammlung mehrerer Daten gleichen Typs anzulegen\n"
      + "sind. Eine der einfachsten Strukturen, um Sammlungen anzulegen, sind\n"
      + "Listen. Das Wesen einer Liste ist, dass ihre maximale Länge nicht in\n"
      + "vornherein bekannt ist. Es kannt also nicht statisch zuvor ein Array im\n"
      + "Speicher angelegt werden, in dem nach einander die Elemente gespeichert\n"
      + "werden. Eine Liste soll die Möglichkeit haben, ohne vorgesetztes Limit\n"
      + "beliebig wachsen zu können.\n"
      + "\n"
      + "<subsubsection titel=\"Formale Spezifikation\">\n"
      + "Wir werden Listen als abstrakten Datentyp formal spezifizieren. Ein abstrakter\n"
      + "Datentyp (ADT) wird spezifiziert über eine endliche Menge von Funktionen. \n"
      + "Hierzu wird\n"
      + "spezifiziert, auf welche Weise Daten eines ADT konstruiert werden\n"
      + "können. Dazu werden entsprechende Konstruktorfunktionen spezifiziert. Dann\n"
      + "wird eine Menge von Funktionen definiert, die wieder Teile aus den\n"
      + "konstruierten Daten selektieren können. Schließlich werden noch Testfunktionen\n"
      + "spezifiziert, die angeben, mit welchem Konstruktor ein Datum erzeugt\n"
      + "wurde.<p/>\n"
      + "\n"
      + "Der Zusammenhang zwischen Konstruktoren und Selektoren sowie zwischen den\n"
      + "Konstruktoren und den Testfunktionen wird in Form von Gleichungen spezifiziert.\n"
      + "\n"
      + "\n"
      + "\n"
      + "<p/>\n";
    String skript7 =
       "Der Trick, der angewendet wird, um abstrakte Datentypen wie Listen zu\n"
      + "spezifizieren, ist  die Rekursion. Das Hinzufügen eines weiteren\n"
      + "Elements zu einer Liste wird dabei als das Konstruieren einer neuen\n"
      + "Liste aus der Ursprungsliste und einem weiteren Element\n"
      + "betrachtet. Mit dieser Betrachtungsweise haben Listen eine rekursive\n"
      + "Struktur: eine Liste besteht aus dem zuletzt vorne angehängten neuen\n"
      + "Element, dem sogenannten Kopf der Liste, und aus der alten Teilliste,\n"
      + "an die dieses Element angehängt wurde, dem sogenannten Schwanz der\n"
      + "Liste. Wie bei jeder rekursiven Struktur bedarf es eines Anfangs der\n"
      + "Definition. Im Falle von Listen wird dieses durch die Konstruktion\n"
      + "einer leeren Liste spezifiziert.<footnote>Man vergleiche es mit der\n"
      + "Definition der natürlichen Zahlen: die <m>0</m>  entspricht der leeren\n"
      + "Liste, der Schritt von <m>n</m> nach <m>n+1</m> dem Hinzufügen eines neuen\n"
      + "Elements zu einer Liste.</footnote>\n"
      + "\n"
      + "<paragraph titel=\"Konstruktoren\">\n"
      + "Abstrakte Datentypen wie Listen lassen sich  durch\n"
      + "ihre Konstruktoren spezifizieren. Die\n"
      + "Konstruktoren geben an, wie Daten des entsprechenden Typs konstruiert\n"
      + "werden können.\n"
      + "In dem Fall von Listen bedarf es nach\n"
      + "den obigen Überlegungen zweier Konstruktoren:\n"
      + "\n"
      + "<itemize>\n"
      + "\n"
      + "<item> einem Konstruktor für neue Listen, die noch leer sind.</item>\n"
      + "<item> einem Konstruktor, der aus einem Element und einer bereits\n"
      + "bestehenden Liste eine neue Liste konstruiert, indem an  die\n"
      + "Ursprungsliste das Element vorne angehängt wird.</item>\n"
      + "</itemize>\n"
      + "\n"
      + "Wir benutzen in der Spezifikation eine mathematische Notation der\n"
      + "Typen von Konstruktoren.<footnote>Entgegen der Notation in C, in der\n"
      + "der Rückgabetyp kurioser Weise vor den Namen der Funktionen geschrieben\n"
      + "wird.</footnote> Dem Namen des Konstruktors folgt dabei mit einem\n"
      + "Doppelpunkt abgetrennt der Typ. Der Ergebnistyp wird von den\n"
      + "Parametertypen mit einem Pfeil getrennt.\n"
      + "\n"
      + "Somit lassen sich die Typen der zwei Konstruktoren für Listen wie\n"
      + "folgt spezifizieren:\n"
      + "\n"
      + "<itemize>\n"
      + "<item>Empty: () <rightarrow/> <b>List</b></item>\n"
      + "<item>Cons: (<b>int</b>,<b>List</b>) <rightarrow/><b>List</b></item>\n"
      + "</itemize>\n"
      + "\n"
      + "Der Konstruktor für leere Listen hat keinen Parameter. Der \n"
      + "Konstruktor  <b>Cons</b> hat ein neues Listenelement und eine bestehende Liste\n"
      + "als Parameter. Hier versteckt sich die Rekursion. Um eine neue Liste \n"
      + "mit <b>Cons</b> zu erzeugen, bedient man sich einer bereits bestehenden Liste.\n"
      + "</paragraph>\n"
      + "\n"
      + "<paragraph titel=\"Selektoren\">\n"
      + "\n"
      + "Die Selektoren können wieder auf die einzelnen\n"
      + "Bestandteile der Konstruktion zurückgreifen. \n"
      + "Der Konstruktor <bf>Cons</bf> hat zwei Parameter. Für <bf\n"
      + ">Cons</bf>-Listen \n"
      + "werden zwei\n"
      + "Selektoren spezifiziert, die jeweils einen dieser beiden Parameter\n"
      + "wieder aus der Liste selektieren. Die Namen dieser beiden Selektoren\n"
      + "sind traditioneller Weise <em>head</em> und <em>tail</em>.\n"
      + "\n"
      + "<itemize>\n"
      + "<item>head: <b>(List)</b> <rightarrow/><b>int</b></item>\n"
      + "<item>tail: <b>(List)</b> <rightarrow/><b>List</b></item>\n"
      + "</itemize>\n"
      + "\n"
      + "Der funktionale Zusammenhang von  Selektoren und Konstruktoren läßt\n"
      + "sich durch folgende Gleichungen spezifizieren:\n"
      + "<p/>\n"
      + "\n"
      + "<eqnarray>\n"
      + "head(Cons(x,xs)) <eq/>x<br/>\n"
      + "tail(Cons(x,xs)) <eq/>xs\n"
      + "</eqnarray>\n"
      + "\n"
      + "Die erste Gleichung ist zu lesen:<br/> \n"
      + "wenn nach dem <em>head</em> einer Liste\n"
      + "gefragt wird, und diese durch den <b>Cons</b>-Konstruktor mit einem neuen \n"
      + "Element <em>x</em> und einer bestehenden Liste <em>xs</em> erzeugt wurde, dann\n"
      + "ist das Ergebnis das Element <em>x</em>.\n"
      + "\n"
      + "Analog ist die zweite Gleichung  zu lesen: <br/>\n"
      + "wenn nach dem <em>tail</em> einer Liste\n"
      + "gefragt wird, und diese durch den <b>Cons</b>-Konstruktor mit einem neuen \n"
      + "Element <em>x</em> und einer bestehenden Liste <em>xs</em> erzeugt wurde, dann\n"
      + "ist das Ergebnis die Restliste <em>xs</em>.\n"
      + "\n"
      + "\n"
      + "Wie man sieht gibt es keine Spezifikation \n"
      + "von <em>head</em> und <em>tail</em> für den Fall, dass die fragliche Liste\n"
      + "eine leere Liste ist, also eine Liste, die durch <b>Empty</b> erzeugt wurde. \n"
      + "</paragraph>\n"
      + "\n"
      + "<paragraph titel=\"Testmethoden\">\n"
      + "Um für  Listen Algorithmen umzusetzen, ist es notwendig, unterscheiden\n"
      + "zu können, welche Art der beiden Listen vorliegt: die leere Liste oder\n"
      + "eine <bf>Cons</bf>-Liste. Hierzu bedarf es noch einer Testfunktion, die\n"
      + "mit einem bool'schen Wert als Ergebnis angibt, ob es sich bei der\n"
      + "Eingabeliste um die leere Liste handelte oder nicht. Wir wollen diese\n"
      + "Testfunktion <em>isEmpty</em> nennen. Sie hat folgenden Typ:\n"
      + "\n"
      + "<itemize>\n"
      + "<item>isEmpty: <b>List</b><rightarrow/> <b>boolean</b></item>\n"
      + "</itemize>\n"
      + "\n"
      + "\n"
      + "Das funktionale Verhalten der Testfunktion läßt sich durch folgende\n"
      + "zwei Gleichungen spezifizieren:\n"
      + "\n"
      + "<eqnarray>\n"
      + "isEmpty(Empty()) <eq/> true<br/>\n"
      + "isEmpty(Cons(x,xs)) <eq/> false\n"
      + "</eqnarray>\n"
      + "\n"
      + "Somit ist alles spezifiziert, was eine Listenstruktur ausmacht. Listen\n"
      + "können konstruiert werden, die Bestandteile einer Liste wieder einzeln\n"
      + "selektiert und Listen können nach der Art ihrer Konstruktion\n"
      + "unterschieden werden. \n"
      + "</paragraph>\n"
      + "\n"
      + "<paragraph titel=\"Listenalgorithmen\">\n"
      + "Allein diese fünf Funktionen beschreiben den ADT der\n"
      + "Listen. Wir können aufgrund dieser Spezifikation Algorithmen für Listen\n"
      + "schreiben.\n"
      + "\n"
      + "<paragraph titel=\"Länge\">\n"
      + "Es läßt sich durch zwei Gleichungen spezifizieren, was die Länge einer\n"
      + "Liste ist:\n"
      + "\n"
      + "<eqnarray>\n"
      + "length(Empty())<eq/>0<br/>\n"
      + "length(Cons(x,xs))<eq/>1+length(xs)\n"
      + "</eqnarray>\n"
      + "\n"
      + "\n"
      + "Mit Hilfe dieser Gleichungen läßt sich jetzt schrittweise die Berechnung einer\n"
      + "Listenlänge auf Listen durchführen. Hierzu benutzen wir die Gleichungen als\n"
      + "Ersetzungsregeln. Wenn ein Unterausdruck in der Form der linken Seite \n"
      + "einer Gleichung gefunden wird, so kann diese durch die entsprechende rechte\n"
      + "Seite ersetzt werden. Man spricht bei so einem Ersetzungsschritt von einem\n"
      + "Reduktionsschritt.\n"
      + "\n"
      + "<example>\n"
      + "Wir errechnen in diesem Beispiel die Länge einer Liste, indem wir die obigen\n"
      + "Gleichungen zum Reduzieren auf die Liste anwenden:\n"
      + "\n"
      + "<eqnarray>\n"
      + "<amp/><amp/><red>length(<mb>Cons</mb>(a,<mb>Cons</mb>(b,<mb>Cons</mb>(c,<mb>Empty</mb>()))))</red><br/>\n"
      + "<reduce/>1+<red>length(<mb>Cons</mb>(b,<mb>Cons</mb>(c,<mb>Empty</mb>())))</red>\n"
      + "<br/>\n"
      + "<reduce/>1+(1+<red>length(<mb>Cons</mb>(c,<mb>Empty</mb>()))</red>)\n"
      + "<br/>\n"
      + "<reduce/>1+(1+(1+<red>length(<mb>Empty</mb>())</red>))\n"
      + "<br/>\n"
      + "<reduce/>1+(1+(<red>1+0</red>))\n"
      + "<br/>\n"
      + "<reduce/>1+(<red>1+1</red>)\n"
      + "<br/>\n"
      + "<reduce/><red>1+2</red><br/>\n"
      + "<reduce/>3\n"
      + "\n"
      + "</eqnarray> \n"
      + "</example> \n"
      + "</paragraph>\n"
      + "\n"
      + "\n"
      + "<paragraph titel=\"Letztes Listenelement\">\n"
      + "Wir können mit einfachen Gleichungen spezifizieren, was wir unter dem letzten\n"
      + "Element einer Liste verstehen.\n"
      + "\n"
      + "<eqnarray>\n"
      + "last(Cons(x,Empty())))<eq/> x<br/>\n"
      + "last(Cons(x,xs)))<eq/>last(xs)\n"
      + "</eqnarray>\n"
      + "\n"
      + "Auch die Funktion <tt>last</tt> können wir von Hand auf einer Beispielliste\n"
      + "einmal per Reduktion ausprobieren:\n"
      + "<eqnarray>\n"
      + "<amp/><amp/><red>last(<mb>Cons</mb>(a,<mb>Cons</mb>(b,<mb>Cons</mb>(c,<mb>Empty</mb>()))))</red><br/>\n"
      + "<reduce/><red>last(<mb>Cons</mb>(b,<mb>Cons</mb>(c,<mb>Empty</mb>())))</red>\n"
      + "<br/>\n"
      + "<reduce/><red>last(<mb>Cons</mb>(c,<mb>Empty</mb>()))</red>\n"
      + "<br/>\n"
      + "<reduce/>c\n"
      + "</eqnarray> \n"
      + "\n"
      + "</paragraph>\n"
      + "\n"
      + "\n"
      + "<paragraph titel=\"Listenkonkatenation\">\n"
      + "Die folgenden Gleichungen spezifizieren, wie zwei Listen aneinandergehängt\n"
      + "werden: \n"
      + "\n"
      + "<eqnarray>\n"
      + "concat(Empty(),ys)<eq/>ys<br/>\n"
      + "concat(Cons(x,xs),ys)<eq/>Cons(x,concat(xs,ys))\n"
      + "</eqnarray>\n"
      + "\n"
      + "Auch diese Funktion läßt sich beispielhaft mit der Reduktion einmal\n"
      + "durchrechnen: \n"
      + "\n"
      + "<eqnarray>\n"
      + "<amp/><amp/><red>concat(<mb>Cons</mb>(i,<mb>Cons</mb>(j,<mb>Empty</mb>())),<mb>Cons</mb>(a,<mb>Cons</mb>(b,<mb>Cons</mb>(c,<mb>Empty</mb>()))))</red>\n"
      + "<br/>\n"
      + "<reduce/><mb>Cons</mb>(i,<red>concat(<mb>Cons</mb>(j,<mb>Empty</mb>()),<mb>Cons</mb>(a,<mb>Cons</mb>(b,<mb>Cons</mb>(c,<mb>Empty</mb>()))))</red>)\n"
      + "<br/>\n"
      + "<reduce/><mb>Cons</mb>(i,<mb>Cons</mb>(j,<red>concat(<mb>Empty</mb>(),<mb>Cons</mb>(a,<mb>Cons</mb>(b,<mb>Cons</mb>(c,<mb>Empty</mb>()))))</red>))\n"
      + "<br/>\n"
      + "<reduce/><mb>Cons</mb>(i,<mb>Cons</mb>(j,<mb>Cons</mb>(a,<mb>Cons</mb>(b,<mb>Cons</mb>(c,<mb>Empty</mb>())))))\n"
      + "</eqnarray> \n"
      + "\n"
      + "</paragraph>\n"
      + "\n"
      + "\n"
      + "</paragraph>\n"
      + "\n"
      + "<paragraph titel=\"Schachtel- und Zeiger-Darstellung\">\n"
      + "Listen lassen sich auch sehr schön graphisch visualisieren. Hierzu wird jede\n"
      + "Liste durch eine Schachtel mit zwei Feldern dargestellt. Von diesen beiden\n"
      + "Feldern gehen Pfeile aus. Der erste Pfeil zeigt auf das erste Element der\n"
      + "Liste, dem <tt>head</tt>, der zweite Pfeil zeigt auf die Schachtel, die für\n"
      + "den Restliste steht dem <em>tail</em>. Wenn eine Liste leer ist, so gehen\n"
      + "keine Pfeile von der Schachtel aus, die sie repräsentiert. <p/>\n"
      + "\n"
      + "Die Liste <em>Cons(a,Cons(b,Cons(c,Empty())))</em> hat somit die\n"
      + "Schachtel- und Zeiger- Darstellung aus Abbildung <ref name=\"List1\"/>.\n"
      + "\n"
      + "<bild name=\"List1\" pdfscale=\"0.5\" psscale=\"0.6\"\n"
      + "caption=\"Schachtel Zeiger Darstellung einer dreielementigen Liste.\"\n"
      + "/> \n"
      + "\n"
      + "\n"
      + "\n"
      + "In der Schachtel- und Zeiger-Darstellung läßt sich sehr gut nachverfolgen, wie\n"
      + "bestimmte Algorithmen auf Listen dynamisch arbeiten.\n"
      + "Wir können die schrittweise Reduktion der Methode <tt>concat</tt> in der \n"
      + "Schachtel- und Zeiger-Darstellung gut nachvollziehen:\n"
      + "\n"
      + "<bild name=\"Concat1\" pdfscale=\"0.5\" psscale=\"0.6\"\n"
      + "caption=\"Schachtel Zeiger Darstellung der Funktionsanwendung von concat auf\n"
      + "zwei Listen.\"\n"
      + "/> \n"
      + "\n"
      + "\n"
      + "Abbildung <ref name=\"Concat1\"/> zeigt die Ausgangssituation. Zwei Listen sind\n"
      + "dargestellt. Von einer Schachtel, die wir als die Schachtel der \n"
      + "Funktionsanwendung\n"
      + "von <tt>concat</tt> markiert haben, gehen zwei Zeiger aus. Der erste auf das\n"
      + "erste Argument, der zweite auf das zweite Argument der Funktionsanwendung.\n"
      + "\n"
      + "\n"
      + "<bild name=\"Concat2\" pdfscale=\"0.5\" psscale=\"0.6\"\n"
      + "caption=\"Schachtel-Zeiger-Darstellung nach dem zweiten Reduktionsschritt.\"\n"
      + "/> \n"
      + "\n"
      + "\n"
      + "Abbildung <ref name=\"Concat2\"/> zeigt die Situation, nachdem die \n"
      + "Funktion <tt>concat</tt> einmal reduziert wurde. Ein neuer Listenknoten wurde\n"
      + "erzeugt. Dieser zeigt auf das erste Element der ursprünglich \n"
      + "ersten Argumentliste. Der zweite zeigt auf den rekursiven Aufruf der \n"
      + "Funktion <tt>concat</tt>, diesmal mit der Schwanzliste des ursprünglich ersten Arguments.\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "<bild name=\"Concat3\" pdfscale=\"0.5\" psscale=\"0.6\"\n"
      + "caption=\"Schachtel-Zeiger-Darstellung nach dem zweiten Reduktionsschritt.\"\n"
      + "/> \n"
      + "\n"
      + "Abbildung <ref name=\"Concat3\"/> zeigt die Situation nach dem zweiten\n"
      + "Reduktionsschritt. Ein weiterer neuer Listenknoten ist entstanden und ein\n"
      + "neuer Knoten für den rekursiven Aufruf ist entstanden.\n"
      + "\n"
      + "\n"
      + "<bild name=\"Concat4\" pdfscale=\"0.5\" psscale=\"0.5\"\n"
      + "caption=\"Schachtel Zeiger Darstellung des Ergebnisses nach der Reduktion.\"\n"
      + "/> \n"
      + "\n"
      + "Abbildung <ref name=\"Concat4\"/> zeigt die endgültige Situation. Der letzte\n"
      + "rekursive Aufruf von <tt>concat</tt> hatte als erstes Argument eine leere\n"
      + "Liste. Deshalb wurde kein neuer Listenknoten erzeugt, sondern lediglich der\n"
      + "Knoten für die Funktionsanwendung gelöscht. Man beachte, daß die beiden\n"
      + "ursprünglichen Listen noch vollständig erhalten sind. Sie wurden nicht\n"
      + "gelöscht. Die erste Argumentliste wurde quasi kopiert. Die zweite\n"
      + "Argumentliste teilen sich gewisser Maßen die neue Ergebnisliste der\n"
      + "Funktionsanwendung und die zweite ursprüngliche Argumentliste.\n"
      + "</paragraph>\n"
      + "</subsubsection>\n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"Implementierung\">\n"
      + "Es ist nun endlich an der Zeit die Spezifikation der Liste auch in C-Code zu\n"
      + "gießen. Tatsächlich ist diese Recht einfach und die Gleichungen lassen sich\n"
      + "ziemlich eins-zu-eins in entsprechende Zeile C-Code umsetzen.\n"
      + "\n"
      + "\n"
      + "Wir werden zwei Implementierungen vornehmen. Zunächst werden wir nur Listen\n"
      + "implementieren, in denen als Elemente <tt>int</tt>-Zahlen gespeichert werden\n"
      + "können.  Anschließend werden wir daraus eine generische Implementierung\n"
      + "ableiten, in der beliebige Elementtypen gespeichert werden können.\n"
      + "\n"
      + "Beginnen wir damit, in der Kopfdatei zu definieren, als welchen Datentypen\n"
      + "unsere liste gespeichert werden sollen.\n"
      + "\n"
      + "Zunächst definieren wir uns einen Typ für Wahrheitswerte: \n"
      + "<code class=\"List\" lang=\"h\"><![CDATA[#ifndef LIST_\n"
      + "#define LIST_\n"
      + "\n"
      + "typedef enum {false,true} bool;]]></code>\n"
      + "\n"
      + "Für Listen wird eine Struktur definiert. Nach unserer Spezifikation muß eine\n"
      + "Liste zwei Bestandteile speichern können. \n"
      + "\n"
      + "Zusätzlich sehen wir noch ein Attribut vor, das kennzeichnet, ob die Liste\n"
      + "eine leere Liste ist.\n"
      + "<code class=\"List\" lang=\"h\" sequel=\"true\"><![CDATA[struct Liste{\n"
      + "  int head;\n"
      + "  struct Liste* tail;\n"
      + "};]]></code>\n"
      + "\n"
      + "Um ein wenig lesbarer über Listen sprechen zu können, führen wir ein\n"
      + "Typsynonym für die Struktur ein. Damit umgehen wir, dass wir \n"
      + "immer das Wort <tt>struct</tt> vor dem Typnamen schreiben müssen:\n"
      + "\n"
      + "<code class=\"List\" lang=\"h\" sequel=\"true\"><![CDATA[typedef struct Liste* List;]]></code>\n"
      + "\n"
      + "Die Selektoren der Listen haben wir bereits durch die Felder der \n"
      + "Struktur  <tt>Liste</tt> ausgedrückt. Ebenso dient das \n"
      + "Feld <tt>isEmpty</tt> als Test.\n"
      + "\n"
      + "Wir müssen nach unserer Spezifikation\n"
      + "noch zwei Konstruktorfunktionen vorsehen. Hierzu definieren wir die \n"
      + "Funktionen <tt>cons</tt> und <tt>nil</tt>, wobei <tt>nil</tt> für die\n"
      + "Konstruktion leerer Liste stehen soll.\n"
      + "\n"
      + "<code class=\"List\" lang=\"h\" sequel=\"true\"><![CDATA[List nil();\n"
      + "List cons(int x,List xs);\n"
      + "\n"
      + "bool isEmpty(List xs);\n"
      + "]]></code>\n"
      + "\n"
      + "Wir hantieren eifrig mit dynamischen daten. Daher ist es notwendig eine\n"
      + "Funktion zum Löschen der Listen aus dem Speicher vorzusehen. Diese tauchte in\n"
      + "der Spezifikation nicht auf. Sie hat nichts mit der Funktionalität von Listen\n"
      + "zu tun, sondern ist eine technisches Funktion für die explizite\n"
      + "Speicherfreigabe. \n"
      + "\n"
      + "<code class=\"List\" lang=\"h\" sequel=\"true\"><![CDATA[void delete(List xs);]]></code>\n"
      + "Soweit die Kopfdatei.\n"
      + "\n"
      + "<code class=\"List\" lang=\"h\" sequel=\"true\"><![CDATA[#endif /*LIST_*/\n"
      + "]]></code>\n"
      + "\n"
      + "\n"
      + "Zur Implementierung der Kopfdatei sind drei Funktionen umzusetzen. zunächst\n"
      + "die beiden Konstruktoren. Beide müssen zunächst Speicher allokieren, in dem\n"
      + "das neue Listenobjekt gespeichert werden kann. Daher sei zunächst eine eigene\n"
      + "kleine Funktion definiert, die diesen Speicherplatz allokiert:\n"
      + " \n"
      + "<code class=\"List\" lang=\"c\"><![CDATA[#include \"List.h\"\n"
      + "#include <stdlib.h>\n"
      + "#include <stdio.h>\n"
      + "\n"
      + "List newList(){return (List)malloc(sizeof (struct Liste));}]]></code>\n"
      + "\n"
      + "Im Konstruktor für leere Listen ist ein neues Listenobjekt zu erzeugen, und\n"
      + "dann darin zu vermerken, dass es sich um eine leere Liste handelt: \n"
      + "\n"
      + "<code class=\"List\" lang=\"c\"><![CDATA[List nil(){\n"
      + "  List result=newList();\n"
      + "  result->tail=NULL;\n"
      + "  return result;\n"
      + "};]]></code>\n"
      + "\n"
      + "Der Konstruktor <tt>cons</tt> hat zwei Parameter, die in den entsprechenden\n"
      + "Feldern des neu erzeugten Listenobjekts abzuspeichern sind:\n"
      + "\n"
      + "<code class=\"List\" lang=\"c\"><![CDATA[List cons(int x, List xs){\n"
      + "  List result=newList();\n"
      + "  result->head=x;\n"
      + "  result->tail=xs;\n"
      + "  return result;\n"
      + "};]]></code>\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "<code class=\"List\" lang=\"c\"><![CDATA[bool isEmpty(List xs){\n"
      + "  return xs->tail==NULL;\n"
      + "};]]></code>\n"
      + "\n"
      + "\n"
      + "\n"
      + "Verbleibt nur noch das Löschen einer Liste. Hierzu ist nicht nur das aktuelle\n"
      + "Listenobjekt zu löschen, sondern, sofern es einen <tt>tail</tt> gibt, also für\n"
      + "nichtleere Liste, ist zunächst der <tt>tail</tt> im Speicher wieder\n"
      + "freizugeben. Erst anschließend kann das Listenobjekt selbst im Speicher wieder\n"
      + "freigegeben werden. Es ergibt sich folgende rekursive Funktion.\n"
      + "\n"
      + "<code class=\"List\" lang=\"c\"><![CDATA[void delete(List xs){\n"
      + "  if (!isEmpty(xs)) delete(xs->tail);\n"
      + "  free(xs);\n"
      + "}\n"
      + "]]></code>\n"
      + "\n"
      + "Zeit, ein paar erste Tests mit unserer listenimplementierung\n"
      + "durchzuführen. Hierzu sei eine Liste aus vier Zahlen erzeugt und drei dieser\n"
      + "Zahlen aus der Liste wieder zugegriffen:\n"
      + "\n"
      + "<code class=\"TestList\" lang=\"c\" main=\"gcc -o TestList ../obj/List.o \n"
      + " TestList.c\"\n"
      + "><![CDATA[#include \"List.h\"\n"
      + "#include <stdio.h>\n"
      + "\n"
      + "int main(){\n"
      + "  List xs=cons(1,cons(2,cons(3,cons(4,nil()))));\n"
      + "  printf(\"Das erste Element: %i\n\",xs->head);\n"
      + "  printf(\"Das zweite Element: %i\n\",xs->tail->head);\n"
      + "  printf(\"Das dritte Element: %i\n\",xs->tail->tail->head);\n"
      + "  delete(xs);\n"
      + "  return 0;\n"
      + "}\n"
      + "]]></code>\n"
      + "\n"
      + "\n"
      + "Nun können wir Algorithmen für Listen implementieren. Es sollen vorerst sechs\n"
      + "Algorithmen implementiert werden, darunter die beiden Funktionen, die wir im\n"
      + "vorangegangenen Abschnitt bereits implementiert haben: der Algorithmus zur\n"
      + "Berechnung der Länge einer Liste und der zum Aneinanderhängen zweier \n"
      + "Liste<footnote>Die in der Spezifikation <ttt>concat</ttt> hieß, hier aber unter\n"
      + "den Namen <ttt>append</ttt> implementiert ist.</footnote>.\n"
      + "\n"
      + "Hier nun die Kopfdatei, in der die Signaturen der sechs zu implementierenden\n"
      + "Algorithmen definiert sind: \n"
      + "\n"
      + "<code class=\"ListUtil\" lang=\"h\"><![CDATA[#ifndef LIST_UTIL_\n"
      + "#define LIST_UTIL_\n"
      + "#include \"List.h\"\n"
      + "\n"
      + "int length(List xs);\n"
      + "int sum(List xs);\n"
      + "double avg(List xs);\n"
      + "\n"
      + "int last(List xs);\n"
      + "\n"
      + "List reverse(List xs);\n"
      + "\n"
      + "List copy(List xs);\n"
      + "List append(List xs,List ys);\n"
      + "\n"
      + "List map(int f(int),List xs);\n"
      + "\n"
      + "#endif /*LIST_UTIL_*/\n"
      + "]]></code>\n"
      + "\n"
      + "Beginnen wir mit der Implementierung der Längenfunktion. Sie war durch zwei\n"
      + "Gleichungen spezifiziert. Leere Listen haben die Länge 0, nichtleere Listen\n"
      + "sind um eins Länger als der Listentail. Dieses mündet direkt in folgende\n"
      + "Implementierung: \n"
      + "\n"
      + "<code class=\"ListUtil\" lang=\"c\"><![CDATA[#include \"ListUtil.h\"\n"
      + "\n"
      + "int length(List xs){\n"
      + "  if (isEmpty(xs)) return 0;\n"
      + "  return 1+length(xs->tail);\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "Die Implementierung bedient sich der Rekursion. Da unsere Listen eine rekursiv\n"
      + "definierte Datenstruktur sind, lassen sich die meisten Algorithmen sehr schön\n"
      + "rekursiv implementieren. Allerdings sind iterative Lösungen zumindest leichter\n"
      + "zu effizienten Code kompilierbar. \n"
      + "\n"
      + "<code class=\"ListUtil\" lang=\"c\"><![CDATA[int lengthIteration(List xs){\n"
      + "  int result=0;\n"
      + "  while (!isEmpty(xs)){\n"
      + "    result=result+1;\n"
      + "    xs=xs->tail;\n"
      + "  }\n"
      + "  return result;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "\n"
      + "Da wir bisher nur Zahlen als Listenelemente Speichern können wir diese\n"
      + "natürlich auch auch aufsummieren. Auch die Summenfunktion läßt sich in zwei\n"
      + "Gleichungen spezifizieren: \n"
      + "\n"
      + "<eqnarray>\n"
      + "sum(Empty())<eq/>0<br/>\n"
      + "sum(Cons(x,xs))<eq/>x+sum(xs)\n"
      + "</eqnarray>\n"
      + "\n"
      + "Diese Gleichungen münden wieder direkt in die entsprechende Implementierung,\n"
      + "in der für jede der beiden Gleichungen genau eine Zeile benötigt wird:\n"
      + "\n"
      + "<code class=\"ListUtil\" lang=\"c\"><![CDATA[int sumRecursion(List xs){\n"
      + "  if (isEmpty(xs)) return 0;\n"
      + "  return xs->head+length(xs->tail);\n"
      + "}]]></code>\n"
      + "\n"
      + "Oder aber wir können die Spezifikation auch  iterativ implementieren. \n"
      + "\n"
      + "<code class=\"ListUtil\" lang=\"c\" sequel=\"true\"\n"
      + "><![CDATA[int sum(List xs){\n"
      + "  int result=0;\n"
      + "  while (!isEmpty(xs)){\n"
      + "    result=result+xs->head;\n"
      + "    xs=xs->tail;\n"
      + "  }\n"
      + "  return result;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "Wenn die Summe der einzelnen Elemente bekannt ist und die Länge der Liste,\n"
      + "dann läßt sich aus beiden direkt der Durchschnittswert der Elemente\n"
      + "berechnen. \n"
      + "\n"
      + "<code class=\"ListUtil\" lang=\"c\" sequel=\"true\"\n"
      + "><![CDATA[double avg(List xs){\n"
      + "  if (isEmpty(xs)) return 0;\n"
      + "  double su = sum(xs);\n"
      + "  double le = length(xs);\n"
      + "  return su/le;\n"
      + "}]]></code>\n"
      + "\n"
      + "Auch die Funktion zur Selektion des letzten Elements einer Liste haben wir\n"
      + "bereits in zwei Gleichungen spezifiziert. Auch diese zwei Gleichungen lassen\n"
      + "sich direkt in entsprechenden Code umsetzen. Allerdings fügen wir als dritten\n"
      + "Fall hinzu, dass für leere Listen die Zahl 0 als letztes Element zurcükgegeben\n"
      + "wird. \n"
      + "\n"
      + "<code class=\"ListUtil\" lang=\"c\" sequel=\"true\"\n"
      + "><![CDATA[int last(List xs){\n"
      + "  if (isEmpty(xs)) return 0;\n"
      + "  if (isEmpty(xs->tail)) return xs->head;\n"
      + "  return last(xs->tail);\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "Eine naheliegende Funktion für Listen, ist ihre Reihenfolge umzudrehen.\n"
      + "Hierzu wird das erste Element zum letzen gemacht. Auch diese Funktion läßt\n"
      + "sich in zwei Gleichungen spezifizieren. In der Spezifikation wird die bereits\n"
      + "spezifizierte Funktion <tt>concat</tt>.\n"
      + "\n"
      + "<eqnarray>\n"
      + "reverse(Empty())<eq/>Empty()<br/>\n"
      + "reverse(Cons(x,xs))<eq/>concat(reverse(xs),Cons(x,Empty()))\n"
      + "</eqnarray>\n"
      + "\n"
      + "Wenn wir einmal davon ausgehen, dass die Funktion <tt>concat</tt> unter\n"
      + "den Namen <tt>append</tt> weiter unten implementiert wird, so lassen sich auch\n"
      + "diese Gleichungen direkt in zwei Zeilen umsetzen:\n"
      + "\n"
      + "<code class=\"ListUtil\" lang=\"c\" sequel=\"true\"\n"
      + "><![CDATA[List reverseRecursive(List xs){\n"
      + "  if (isEmpty(xs)) return nil();\n"
      + "  return append(reverse(xs->tail),cons(xs->head,nil()));\n"
      + "}]]></code>\n"
      + "\n"
      + "Diese Implementierung ist allerdings hoffnungslos ineffizient. Im jeden\n"
      + "rekursiven Aufruf wirds die Funktion <tt>append</tt> aufgerufen, die\n"
      + "ihrerseits wieder rekursiv ist. Damit haben wir eine ineinander \n"
      + "geschachtelte  Rekursion. Der Aufwand hierfür wird quadratisch.\n"
      + "\n"
      + "Die Funktion <tt>reverse</tt> läßt sich zum vergleich recht einfach und\n"
      + "effizient iterative implementieren. Es wird eine Ergebnisliste in einer \n"
      + "Schleife stückweise zusammengesetzt, indem immer das erste Element der\n"
      + "durchlaufenden Liste vorn an die Ergebnisliste angehängt wird.\n"
      + "\n"
      + "<code class=\"ListUtil\" lang=\"c\" sequel=\"true\"\n"
      + "><![CDATA[List reverse(List xs){\n"
      + "  List result=nil();\n"
      + "  while (!isEmpty(xs)){\n"
      + "    result=cons(xs->head,result);\n"
      + "    xs=xs->tail;\n"
      + "  }\n"
      + "  return result;\n"
      + "}]]></code>\n"
      + "\n"
      + "Diese Implementierung ist wesentlich effizienter. Sie durchläuft genau einmal\n"
      + "die Liste, die umzudrehen ist. Nur ist streng genommen noch formal zu\n"
      + "beweisen, dass die Funktion <tt>reverse</tt> das gleiche Ergebnis hat, wie die\n"
      + "Funktion <tt>reverseRecursive</tt>. Ein solcher Beweis ist allerdings formal\n"
      + "sehr schwierig. In der Praxis beschränkt man sich daher zumeist darauf, sich\n"
      + "durch ein paar Testbeispiele zu versichern, dass die Implementierung das\n"
      + "gewünschte leistet. \n"
      + "\n"
      + "\n"
      + "\n"
      + "Als nächstes sei eine Funktion implementiert, die eigentlich keine wirkliche\n"
      + "neue Berechnung vornimmt, sondern eine eins-zu-eins Kopie einer Liste \n"
      + "erstellt. Hierzu wird für eine leere Liste eine neue <tt>nil</tt>-Liste\n"
      + "erzeugt und für nichtleere Liste eine neue <tt>cons</tt>-Liste.\n"
      + "\n"
      + "<code class=\"ListUtil\" lang=\"c\" sequel=\"true\"\n"
      + "><![CDATA[List copy(List xs){\n"
      + "  if (isEmpty(xs)) return nil();\n"
      + "  return cons(xs->head,copy(xs->tail));\n"
      + "}]]></code>\n"
      + "\n"
      + "Nun endlich soll die Implementierung der Funktion folgen, \n"
      + "die aus zwei Listen eine neue Liste erzeugt. Die neue  Liste besteht erst aus\n"
      + "den Elementen des ersten Parameters, dann aus den Elementen des zweiten\n"
      + "Parameters: \n"
      + "\n"
      + "<code class=\"ListUtil\" lang=\"c\" sequel=\"true\"\n"
      + "><![CDATA[List append(List xs,List ys){\n"
      + "  if (isEmpty(xs)) return copy(ys);\n"
      + "  return cons(xs->head,append(xs->tail,ys));\n"
      + "}]]></code>\n"
      + "\n"
      + "Im Falle einer leeren Liste als ersten Parameter begnügen wir uns nicht damit,\n"
      + "die Liste des zweiten Parameters zurückzugeben, sondern erzeugen eine Kopie\n"
      + "von diesem. Die Entscheidung hierfür liegt in der Tatsache, dass es sonst sehr\n"
      + "schwer wird darüber Buch zu führen, welche Listen noch Bestandteil von\n"
      + "Teillisten sind, und welche im Speicher nach Gebrauch wieder frei gegeben\n"
      + "werden können. \n"
      + "\n"
      + "\n"
      + "Zu guter letzt soll noch eine Funktion höherer Ordnung folgen. Die\n"
      + "Funktion <tt>map</tt> soll eine neue liste erzeugen, in dem auf jedes\n"
      + "Listenelement eine Funktion übergeben wird. Auch die \n"
      + "Funktion <tt>map</tt> ist schnell durch zwei Gleichungen spezifiziert:\n"
      + "\n"
      + "<eqnarray>\n"
      + "map(f,Empty())<eq/>Empty()<br/>\n"
      + "map(f,Cons(x,xs))<eq/>Cons(f(x),map(f,xs))\n"
      + "</eqnarray>\n"
      + "\n"
      + "Und diese zwei Gleichungen lassen sich wieder direkt in entsprechenden Coe\n"
      + "umsetzen: \n"
      + "\n"
      + "<code class=\"ListUtil\" lang=\"c\" sequel=\"true\"\n"
      + "><![CDATA[List map(int f (int),List xs){\n"
      + "  if (isEmpty(xs)) return nil();\n"
      + "  return cons(f(xs->head),map(f,xs->tail));\n"
      + "}\n"
      + "]]></code>\n"
      + "\n"
      + "Nun sollen die Funktionen endlich auch einmal ausgetestet werden:\n"
      + "\n"
      + "<code class=\"TestListUtil\" lang=\"c\" main=\"gcc -o TestListUtil ../obj/List.o ../obj/ListUtil.o \n"
      + " TestListUtil.c\"\n"
      + "><![CDATA[#include \"ListUtil.h\"\n"
      + "#include <stdio.h>\n"
      + "\n"
      + "int addFive(int x){return x+5;}\n"
      + "\n"
      + "int main(){\n"
      + "  List xs=cons(1,cons(2,cons(3,cons(4,nil()))));\n"
      + "  printf(\"Das letzte Element von xs ist: %i\n\",last(xs));\n"
      + "  printf(\"Die Laenge von xs ist: %i\n\",length(xs));\n"
      + "  printf(\"Die Summe von xs ist: %i\n\",sum(xs));\n"
      + "  printf(\"Der Durchschnitt von xs ist: %f\n\",avg(xs));\n"
      + "\n"
      + "  List xsxs=append(xs,xs);\n"
      + "  printf(\"Die Laenge von xsxs ist: %i\n\",length(xsxs));\n"
      + "  printf(\"Die Summe von xsxs ist: %i\n\",sum(xsxs));\n"
      + "  printf(\"Der Durchschnitt von xsxs ist: %f\n\",avg(xsxs));\n"
      + "\n"
      + "  delete(xsxs);\n"
      + "\n"
      + "  List sx=reverse(xs);\n"
      + "  printf(\"Das erste Element von sx: %i\n\",sx->head);\n"
      + "  delete(sx);\n"
      + "\n"
      + "  List xs5=map(addFive,xs);\n"
      + "  printf(\"Die Summe von xs5 ist: %i\n\",sum(xs5));\n"
      + "\n"
      + "  delete(xs5);\n"
      + "  delete(xs);\n"
      + "\n"
      + "  return 0;\n"
      + "}\n"
      + "]]></code>\n"
      + "\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"generischer Zeigerliste\">\n"
      + "Die Listen im letzen Abschnitt haben als Listenelemente ganze Zahlen\n"
      + "enthalten. Wollen wir andere Daten in Listen speichern, so wird eine neue\n"
      + "Listenimplementierung notwendig. Das ist etwas schade, denn die meisten\n"
      + "Algorithmen für listen sind unabhängig von den Elementtypen der Listen. Zur\n"
      + "Berechnung der Länge einer Liste, ist ziemlich egal, was für Elemente in den\n"
      + "einzelnen Listenzellen im Feld <tt>head</tt> gespeichert sind. Es wäre schön,\n"
      + "wenn wir eine Listenstruktur implementieren könnten, die in der Lage ist\n"
      + "unterschiedlichste Daten als Elemente anzuspeichern. Hierzu haben wir schon\n"
      + "früher einen Trick kennengelernt: die Void-Zeiger. Statt jetzt eine Liste von\n"
      + "ganzen Zahlen zu definieren, können wir eine Liste von Void-Zeigern\n"
      + "definieren. Ein Void-Zeiger kann dann auf beliebige Arten von daten zeigen.\n"
      + "\n"
      + "\n"
      + "Wir können die Headerdatei für unsere Listen von ganzen Zahlen weitgehendst\n"
      + "übernehmen, indem wir einfach überall wo der Typ <tt>int</tt> eingesetzt war,\n"
      + "den Typ <tt>void*</tt> schreiben. Da wir den Typ <tt>void*</tt> benutzen\n"
      + "wollen um beliebige Objekte darin speichern zu können, führen wir wie bereits\n"
      + "früher dazu das Typsynonym <tt>Object</tt> ein.\n"
      + "\n"
      + "Damit erhalten wir die folgende Header-Datei:\n"
      + "\n"
      + "<code class=\"PList\" lang=\"h\"><![CDATA[#ifndef PLIST_\n"
      + "#define PLIST_\n"
      + "\n"
      + "typedef enum {false,true} bool;\n"
      + "typedef void* Object;\n"
      + "\n"
      + "struct PListe{\n"
      + "  Object head;\n"
      + "  struct PListe* tail;\n"
      + "};\n"
      + "\n"
      + "typedef struct PListe* PList;\n"
      + "\n"
      + "PList nil();\n"
      + "PList cons(Object x,PList xs);\n"
      + "\n"
      + "bool isEmpty(PList xs);\n"
      + "\n"
      + "void delete(PList xs);\n"
      + "#endif /*PLIST_*/\n"
      + "]]></code>\n"
      + "\n"
      + "\n"
      + "Es stellt sich heraus, dass wir die Implementierung der Listen von ganzen\n"
      + "Zahlen fast wörtlich übernehmen können, um unsere allgemeinere\n"
      + "Listenimplementierung zu bekommen:\n"
      + "\n"
      + "<code class=\"PList\" lang=\"c\"  compileoptions=\" echo -fPIC \"\n"
      + "><![CDATA[#include \"PList.h\"\n"
      + "#include <stdlib.h>\n"
      + "#include <stdio.h>\n"
      + "\n"
      + "PList nil(){\n"
      + "  PList result=malloc (sizeof (struct PListe));\n"
      + "  result->tail=NULL;\n"
      + "  result->head=NULL;\n"
      + "  return result;\n"
      + "};\n"
      + "\n"
      + "PList cons(Object x, PList xs){\n"
      + "  PList result=malloc (sizeof (struct PListe));\n"
      + "  result->head=x;\n"
      + "  result->tail=xs;\n"
      + "  return result;\n"
      + "};\n"
      + "\n"
      + "bool isEmpty(PList xs){\n"
      + "  return xs->tail==NULL;\n"
      + "};\n"
      + "\n"
      + "void delete(PList xs){\n"
      + "  if (!isEmpty(xs)) delete(xs->tail);\n"
      + "  free(xs);\n"
      + "}\n"
      + "]]></code>\n"
      + "\n"
      + "Bevor wir jetzt die einzelnen Algorithmen für Listen implementieren, soll ein\n"
      + "kleiner Test uns davon, dass  wir mit ihr tatsächlich in der Lage sind,\n"
      + "beliebige Objekttypen zu speichern.\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "Es  sollen zunächst Objekte eines Punkttypens gespeichert\n"
      + "werden. Hierzu sei  die entsprechende Struktur zur Darstellung von\n"
      + "Punkten im zweidimensionalen Raum definiert. \n"
      + "Mit einer kleinen Hilfsfunktion sollen solche Punktobjekte auf der\n"
      + "Kummandozeile ausgegeben werden:\n"
      + "\n"
      + "<code class=\"Punkt\" lang=\"h\"><![CDATA[#ifndef PUNKT__H_\n"
      + "#define PUNKT__H_\n"
      + "typedef struct {\n"
      + "  int x;\n"
      + "  int y;\n"
      + "} Punkt;\n"
      + "\n"
      + "void printPunkt(Punkt* p);\n"
      + "#endif]]></code>\n"
      + "\n"
      + "<code class=\"Punkt\" lang=\"c\"><![CDATA[#include \"Punkt.h\"\n"
      + "#include <stdio.h>\n"
      + "void printPunkt(Punkt* p){\n"
      + "  printf(\"(%i,%i)\",p->x,p->y);\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "In der Testfunktion legen wir ein paar Punkte an, und bauen aus diesen eine Liste.\n"
      + "\n"
      + "<code class=\"TestPList\" lang=\"c\" main=\"gcc -o TestPList ../obj/PList.o   ../obj/Punkt.o \n"
      + " TestPList.c\" sequel=\"true\"\n"
      + "><![CDATA[#include \"PList.h\"\n"
      + "#include \"Punkt.h\"\n"
      + "\n"
      + "#include <stdio.h>\n"
      + "\n"
      + "int main(){\n"
      + "  Punkt p1 = {0,0};\n"
      + "  Punkt p2 = {0,2};\n"
      + "  Punkt p3 = {2,2};\n"
      + "  Punkt p4 = {2,0};\n"
      + "\n"
      + "  PList polygon=cons(&p1,cons(&p2,cons(&p3,cons(&p4,nil()))));]]></code>\n"
      + "\n"
      + "In gewohnter Weise lässt sich auf diese Liste \n"
      + "mit <tt>head</tt> und <tt>tail</tt> zugreifen:\n"
      + "\n"
      + "<code class=\"TestPList\" lang=\"c\" main=\"gcc -o TestPList ../obj/PList.o  ../obj/Punkt.o \n"
      + " TestPList.c\" sequel=\"true\"\n"
      + "><![CDATA[  printPunkt((Punkt*)polygon->tail->tail->head);\n"
      + "\n"
      + "  delete(polygon);\n"
      + "]]></code>\n"
      + "\n"
      + "Nun wollen wir die\n"
      + "Listenimplementierung benutzen, um auch weiterhin ganze Zahlen zu\n"
      + "speichern. Jetzt allerdings können wir nur Zeiger auf ganze Zahlen\n"
      + "speichern. \n"
      + "\n"
      + "\n"
      + "<code class=\"TestPList\" lang=\"c\" main=\"gcc -o TestPList ../obj/PList.o  ../obj/Punkt.o \n"
      + " TestPList.c\" sequel=\"true\"\n"
      + "><![CDATA[\n"
      + "\n"
      + "  int x1=1;\n"
      + "  int x2=2;\n"
      + "  int x3=3;\n"
      + "  int x4=4;\n"
      + "  PList xs=cons(&x1,cons(&x2,cons(&x3,cons(&x4,nil()))));\n"
      + "\n"
      + "  printf(\"Das erste Element: %i\n\",*(int*)xs->head);\n"
      + "  printf(\"Das zweite Element: %i\n\",*(int*)xs->tail->head);\n"
      + "  printf(\"Das dritte Element: %i\n\",*(int*)xs->tail->tail->head);\n"
      + "  delete(xs);\n"
      + "  return 0;\n"
      + "}\n"
      + "]]></code>\n"
      + "\n"
      + "\n"
      + "Damit ließen sich also mit einer Listenimplementierung Listen ganz\n"
      + "unterschiedlichen Inhalts erzeugen.\n"
      + "\n"
      + "\n"
      + "Nun wollen wir auch die unterschiedlichen Algorithmen auf Listen implementieren:\n"
      + "\n"
      + "<code class=\"PListUtil\" lang=\"h\"><![CDATA[#ifndef PLIST_UTIL_\n"
      + "#define PLIST_UTIL_\n"
      + "#include \"PList.h\"\n"
      + "\n"
      + "int length(PList xs);\n"
      + "PList copy(PList xs);\n"
      + "PList append(PList xs,PList ys);\n"
      + "PList reverse(PList xs);\n"
      + "PList map(Object f(Object),PList xs);\n"
      + "void forEach(void f(Object),PList xs);\n"
      + "\n"
      + "#endif /*LIST_UTIL_*/\n"
      + "]]></code>\n"
      + "\n"
      + "Tatsächlich ist für die meisten dieser Funktionen gegenüber der bisherigen\n"
      + "Implementierung nichts zu ändern. \n"
      + "\n"
      + "<code class=\"PListUtil\" lang=\"c\"  compileoptions=\" echo -fPIC \"><![CDATA[#include \"PListUtil.h\"\n"
      + "\n"
      + "int length(PList xs){\n"
      + "  if (isEmpty(xs)) return 0;\n"
      + "  return 1+length(xs->tail);\n"
      + "}\n"
      + "\n"
      + "PList copy(PList xs){\n"
      + "  if (isEmpty(xs)) return nil();\n"
      + "  return cons(xs->head,copy(xs->tail));\n"
      + "}\n"
      + "\n"
      + "PList append(PList xs,PList ys){\n"
      + "  if (isEmpty(xs)) return copy(ys);\n"
      + "  return cons(xs->head,append(xs->tail,ys));\n"
      + "}\n"
      + "\n"
      + "PList reverse(PList xs){\n"
      + "  PList result=nil();\n"
      + "  while (!isEmpty(xs)){\n"
      + "    result=cons(xs->head,result);\n"
      + "    xs=xs->tail;\n"
      + "  }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "PList map(Object f (Object),PList xs){\n"
      + "  if (isEmpty(xs)) return nil();\n"
      + "  return cons(f(xs->head),map(f,xs->tail));\n"
      + "}\n"
      + "\n"
      + "void forEach(void f (Object),PList xs){\n"
      + "  for (;!isEmpty(xs);xs=xs->tail) f(xs->head);\n"
      + "}\n"
      + "]]></code>\n"
      + "\n"
      + "\n"
      + "Wir bedienen uns den Punkten im zweidimensionalen Raum, um ein paar Tests mit\n"
      + "diesen Funktionen durchzuführen\n"
      + "\n"
      + "<code class=\"TestPListUtil\" lang=\"c\" main=\"gcc -o TestPListUtil ../obj/PList.o ../obj/PListUtil.o  ../obj/Punkt.o  TestPListUtil.c\"\n"
      + "><![CDATA[#include \"PListUtil.h\"\n"
      + "#include \"Punkt.h\"\n"
      + "\n"
      + "#include <stdio.h>\n"
      + "\n"
      + "void move(Punkt* this){\n"
      + "  this->x=2*this->x;\n"
      + "  this->y=2*this->y;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  Punkt p1 = {0,0};\n"
      + "  Punkt p2 = {0,2};\n"
      + "  Punkt p3 = {2,2};\n"
      + "  Punkt p4 = {2,0};\n"
      + "\n"
      + "  PList polygon=cons(&p1,cons(&p2,cons(&p3,cons(&p4,nil()))));\n"
      + "\n"
      + "  printf(\"length(polygon)=$i\n\",length(polygon));\n"
      + "  printf(\"polygon: [\");  \n"
      + "  forEach(printPunkt,polygon);\n"
      + "  printf(\"]\n\");\n"
      + "\n"
      + "  PList pol2 = append(polygon,polygon);\n"
      + "  printf(\"append(polygon,polygon): [\");    \n"
      + "  forEach(printPunkt,pol2);\n"
      + "  printf(\"]\n\");\n"
      + "\n"
      + "  PList pol3 = reverse(pol2);\n"
      + "  printf(\"reverse(pol2): [\");  \n"
      + "  forEach(printPunkt,pol3);\n"
      + "  printf(\"]\n\");\n"
      + "\n"
      + "  map(move,pol3);\n"
      + "  printf(\"map(move,pol3): [\");  \n"
      + "  forEach(printPunkt,pol3);\n"
      + "  printf(\"]\n\");\n"
      + "\n"
      + "  delete(polygon);\n"
      + "  delete(pol2);\n"
      + "  delete(pol3);\n"
      + "\n"
      + "  return 0;\n"
      + "}\n"
      + "\n"
      + "]]></code>\n"
      + "\n"
      + "<aufgabe blatt=\"blatt8\"><b>(3 Punkte)</b> \n"
      + "Erweitern Sie das Bibliothek <tt>PList</tt> um folgende weitere Funktionen und\n"
      + "testen Sie Ihre Implementierungen an ein paar Beispielen aus:\n"
      + "\n"
      + "<unteraufgaben>\n"
      + "<teil><tt>Object last(PList this );</tt><br/>\n"
      + "Die Funktion sei spezifiziert durch folgende Gleichung:\n"
      + "<eqnarray>\n"
      + "last(Cons(x,Nil())))<eq/> x<br/>\n"
      + "last(Cons(x,xs)))<eq/>last(xs)\n"
      + "</eqnarray>\n"
      + "</teil>\n"
      + "<teil><tt>Object get(PList this,unsigned int i );</tt><br/>\n"
      + "Die Funktion sei spezifiziert durch folgende Gleichung:\n"
      + "<eqnarray>\n"
      + "get(Cons(x,xs),0)<eq/> x<br/>\n"
      + "get(Cons(x,xs)),i)<eq/>get(xs,i-1)\n"
      + "</eqnarray>\n"
      + "\n"
      + "\n"
      + "</teil>\n"
      + "<teil><tt>PList take(PList this,unsigned int i);</tt><br/>\n"
      + "Die Funktion sei spezifiziert durch folgende Gleichung:\n"
      + "<eqnarray>\n"
      + "take(xs,0)<eq/> Nil()<br/>\n"
      + "take(Nil(),i)<eq/> Nil()<br/>\n"
      + "take(Cons(x,xs),i))<eq/>Cons(x,take(xs,i-1))\n"
      + "</eqnarray>\n"
      + "\n"
      + "\n"
      + "</teil>\n"
      + "\n"
      + "\n"
      + "<teil><tt>PList drop(PList this,unsigned int i);</tt><br/>\n"
      + "Die Funktion sei spezifiziert durch folgende Gleichung:\n"
      + "<eqnarray>\n"
      + "drop(Nil(),i)<eq/> Nil()<br/>\n"
      + "drop(xs,0)<eq/> xs<br/>\n"
      + "drop(Cons(x,xs),i)<eq/> drop(xs,i-1)\n"
      + "</eqnarray>\n"
      + "</teil>\n"
      + "<teil><tt>PList oddElements(PList this);</tt><br/>\n"
      + "Die Funktion sei spezifiziert durch folgende Gleichung:\n"
      + "<eqnarray>\n"
      + "oddElements(Nil())<eq/> Nil()<br/>\n"
      + "oddElements(Cons(x,Nil()))<eq/> Cons(x,Nil())<br/>\n"
      + "oddElements(Cons(x,Cons(y,ys)))<eq/> Cons(x,oddElements(ys))\n"
      + "</eqnarray></teil>\n"
      + "<teil><tt>PList filter(PList this,bool predicate(Object));</tt><br />\n"
      + "Die Funktion sei spezifiziert durch folgende Gleichung:\n"
      + "<eqnarray>\n"
      + "filter(Nil(),pred)<eq/> Nil()<br/>\n"
      + "filter(Cons(x,xs),pred)<eq/><![CDATA[ \\left\\{ \\begin{array}{ll}\n"
      + "Cons(x,filter(xs,p)) & \\textrm{für pred$(x)$}\\\n"
      + "filter(xs,p) & \\textrm{für $\\neg$pred$(x)$}\n"
      + "\\end{array}\\right.]]>\n"
      + "</eqnarray>\n"
      + "</teil>\n"
      + "</unteraufgaben>\n"
      + "<!--\n"
      + "<loesung>\n"
      + "\n"
      + "<code class=\"PListUtil2\" lang=\"h\"><![CDATA[#ifndef PLIST_UTIL2_\n"
      + "#define PLIST_UTIL2_\n"
      + "#include \"PList.h\"\n"
      + "\n"
      + "Object last(PList this );\n"
      + "Object get(PList this,unsigned int i);\n"
      + "PList take(PList this,unsigned int i);\n"
      + "PList drop(PList this,unsigned int i);\n"
      + "PList oddElements(PList this);\n"
      + "PList filter(PList this,bool predicate(Object));\n"
      + "\n"
      + "#endif /*LIST_UTIL2_*/\n"
      + "]]></code>\n"
      + "\n"
      + "\n"
      + "<code class=\"PListUtil2\" lang=\"c\"  compileoptions=\" echo -fPIC \"\n"
      + "\n"
      + "><![CDATA[#include \"PList.h\"\n"
      + "#include \"PListUtil.h\"\n"
      + "#include \"PListUtil2.h\"\n"
      + "\n"
      + "#include <stdio.h>\n"
      + "\n"
      + "Object last(PList this ){\n"
      + " if (isEmpty(this->tail)) return this->head;\n"
      + " return last(this->tail);\n"
      + "}\n"
      + "\n"
      + "Object get(PList this,unsigned int i){\n"
      + "  if (i==0) return this->head;\n"
      + "  return get(this->tail,i-1);\n"
      + "}\n"
      + "\n"
      + "PList take(PList this,unsigned int i){\n"
      + "  if (isEmpty(this)||i==0) return nil();\n"
      + "  return cons(this->head,take(this->tail,i-1));\n"
      + "}\n"
      + "\n"
      + "PList drop(PList this,unsigned int i){\n"
      + "  if (isEmpty(this)) return copy(this);\n"
      + "  if (i==0) return copy(this);\n"
      + "  return drop(this->tail,i-1);\n"
      + "}\n"
      + "\n"
      + "PList oddElements(PList this){\n"
      + "  if (isEmpty(this)) return nil();\n"
      + "  if (isEmpty(this->tail)) return cons(this->head,nil());\n"
      + "  return cons(this->head,oddElements(this->tail->tail));\n"
      + "}\n"
      + "\n"
      + "PList filter(PList this,bool predicate(Object)){\n"
      + "  if (isEmpty(this)) return nil();\n"
      + "  if (predicate(this->head)) \n"
      + "     return cons(this->head,filter(this->tail,predicate));\n"
      + "  return filter(this->tail,predicate);\n"
      + "}\n"
      + "]]></code>\n"
      + "\n"
      + "\n"
      + "<code class=\"PListUtil2Test\" lang=\"c\"\n"
      + "main=\"gcc -o PListUtil2Test ../obj/PList.o ../obj/PListUtil2.o ../obj/PListUtil2Test.o ../obj/PListUtil.o ../obj/Punkt.o  \"\n"
      + "\n"
      + "><![CDATA[#include \"PList.h\"\n"
      + "#include \"Punkt.h\"\n"
      + "#include \"PListUtil.h\"\n"
      + "#include \"PListUtil2.h\"\n"
      + "\n"
      + "#include <stdio.h>\n"
      + "\n"
      + "bool nichtUrsprung(Punkt* p){\n"
      + "  return p-> x != 0 || p ->y !=0;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "  Punkt p1 = {0,0};\n"
      + "  Punkt p2 = {0,2};\n"
      + "  Punkt p3 = {2,2};\n"
      + "  Punkt p4 = {2,0};\n"
      + "\n"
      + "  PList polygon=cons(&p1,cons(&p2,cons(&p3,cons(&p4,nil()))));\n"
      + "\n"
      + "  printf(\"polygon: [\");\n"
      + "  forEach(printPunkt,polygon);\n"
      + "  printf(\"]\n\");\n"
      + "\n"
      + "  printf(\"last(polygon)=\");\n"
      + "  printPunkt((Punkt*) last(polygon));\n"
      + "  printf(\"\n\");\n"
      + "  printf(\"get(polygon,2)=\");\n"
      + "  printPunkt((Punkt*)get(polygon,2));\n"
      + "  printf(\"\n\");\n"
      + "  PList xs = drop(polygon,2);\n"
      + "\n"
      + "  printf(\"drop(polygon,2): [\");\n"
      + "  forEach(printPunkt,xs);\n"
      + "  printf(\"]\n\");\n"
      + "\n"
      + "  delete(xs);\n"
      + "  \n"
      + "  xs = take(polygon,2);\n"
      + "\n"
      + "  printf(\"take(polygon,2): [\");  \n"
      + "  forEach(printPunkt,xs);\n"
      + "  printf(\"]\n\");\n"
      + "\n"
      + "  delete(xs);\n"
      + "  \n"
      + "  xs = oddElements(polygon);\n"
      + "\n"
      + "  printf(\"oddElements(polygon): [\");  \n"
      + "  forEach(printPunkt,xs);\n"
      + "  printf(\"]\n\");\n"
      + "\n"
      + "  delete(xs);\n"
      + "  \n"
      + "  xs = filter(polygon,nichtUrsprung);\n"
      + "\n"
      + "  printf(\"filter(polygon,nichtUrsprung): [\");  \n"
      + "  forEach(printPunkt,xs);\n"
      + "  printf(\"]\n\");\n"
      + "  delete(xs);\n"
      + "  delete(polygon);\n"
      + "\n"
      + "  return 0;\n"
      + "}\n"
      + "]]></code></loesung>\n"
      + "-->\n"
      + "</aufgabe>\n"
      + "</subsubsection>\n"
      + "\n"
      + "</subsection>\n"
      + "</section>\n"
      + "\n"
      + "\n"
      + "<section titel=\"Binäre Suchbäume\">\n"
      + "Im letzten Abschnitt haben wir als erste rekursive Datenstruktur Listen\n"
      + "ausgiebig behandelt. Exemplarisch soll in diesem Abschnitt eine weitere häufig\n"
      + "gebrauchte Datenstruktur aus der Informatik implementiert werden. Es sollen\n"
      + "Bäume realisiert werden. Dabei wollen wir uns auf  eine bestimmte Art von\n"
      + "Bäumen beschränken: den Binärbäumen. Allgemein sind Bäume so aufgebaut, dass\n"
      + "ein Baumknoten Teilbäume als Kinder hat. Bei Binärbäumen hat jeder Baumknoten\n"
      + "maximal 2 Kinder: einen linken und einen rechten Teilbaum als Kind. \n"
      + "\n"
      + "Die Knoten eines Baumes sollen mit Daten markiert sein. In unserem Fall wollen\n"
      + "wir uns auf Strings als Knotenmarkierungen beschränken. Mit diesen Vorgaben\n"
      + "lassen sich Bäume kurz und knapp in C umsetzen:\n"
      + "\n"
      + "<code class=\"BinTree\" lang=\"c\" main=\"main\"><![CDATA[#include <string.h>\n"
      + "#include <stdio.h>\n"
      + "#include <stdlib.h>\n"
      + "\n"
      + "struct B {\n"
      + "  char* name;\n"
      + "  struct B* links;\n"
      + "  struct B* rechts;\n"
      + "};\n"
      + "\n"
      + "typedef struct B* Baum;]]></code>\n"
      + "\n"
      + "Ein genauer Blick auf diese Datenstruktur zeigt, dass sie in \n"
      + "ihrer  Art unserer Listenstruktur sehr ähnelt. Das Feld, dass hier den \n"
      + "Namen <tt>name</tt> trägt, entspricht den Feld <tt>head</tt> der Listen,\n"
      + "das Feld mit dem Name <tt>links</tt> entspricht dem \n"
      + "Feld <tt>tail</tt> unserer Listen. Zusätzlich gibt es ein weiteres Feld, das\n"
      + "Feld <tt>rechts</tt>, das man quasi als zweiten <tt>tail</tt> verstehen\n"
      + "kann. Im Grunde genommen waren Listen auch eine Art von Bäumen, man könnte sie\n"
      + "als Unärbäume bezeichnen, weil jeder Listenknoten maximal ein Kind hat, \n"
      + "seinen <tt>tail</tt>.\n"
      + "\n"
      + "Als nächstes soll eine Konstruktorfunktion geschrieben werden, die die\n"
      + "einfachste Form binärer Bäume konstruiert, nämlich Blätter. Blätter sind\n"
      + "Bäume, die kein Kind haben, was in unserer Implementierung bedeutet, dass\n"
      + "rechtes und linkes Kind beide mit <tt>NULL</tt> belegt werden.\n"
      + "\n"
      + "<code class=\"BinTree\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[Baum newBlatt(char* n){\n"
      + "  Baum this = (Baum)malloc(sizeof(struct B));\n"
      + "  this->name=n;\n"
      + "  this->links=NULL;\n"
      + "  this->rechts=NULL;\n"
      + "  return this;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "Binärbäume können dazu genutzt werden, um Objekte effizient gemäß\n"
      + "einer Ordnung zu speichern und effizient nach ihnen unter Benutzung\n"
      + "dieser Ordnung wieder zu suchen. \n"
      + "Die Knotenmarkierungen unserer Bäume sind Strings, für die sich die\n"
      + "lexikographische Ordnung anbietet.\n"
      + "\n"
      + "Binäre Bäume heißen binäre Suchbäume, wenn für jeden\n"
      + "Baumknoten gilt:\n"
      + "<itemize>\n"
      + "<item>die Knotenmarkierung seines linken Teilbaums ist kleiner oder\n"
      + "gleich als die eigene Knotenmarkierung.</item>\n"
      + "<item>die Knotenmarkierung des rechten Teilbaums ist größer als die\n"
      + "eigene Knotenmarkierung.</item>\n"
      + "</itemize>\n"
      + "\n"
      + "Um einen binären Suchbaum zu erhalten, müssen \n"
      + "Bäume mit mehr als einen Knoten kontrolliert\n"
      + "konstruiert werden. Hierzu ist es sinnvoll eine Funktion anzubieten, die eine\n"
      + "neue Markierung in einen bestehenden Baum einfügt. Diese Einfügefunktion muß\n"
      + "sicherstellen, dass, wenn der ursprüngliche Baum ein binärer Suhbaum war, dann\n"
      + "der geänderte Baum auch wieder ein binärer Suchbaum ist. \n"
      + "\n"
      + "Algorithmisch kann das wie folgt erreicht werden:\n"
      + "\n"
      + "Gegeben seien ein Baum <tt>t</tt> und ein Element <tt>o</tt>.\n"
      + "<itemize>\n"
      + "<item>Ist <tt>o</tt> kleiner oder gleich der Markierung von <tt>t</tt>, so \n"
      + "muß <tt>o</tt> ins linke Kind von <tt>t</tt> eingefügt werden.</item>\n"
      + "<item>Ansonsten muß <tt>o</tt> ins rechte Kind von <tt>t</tt> eingefügt \n"
      + "werden.</item>\n"
      + "</itemize>\n"
      + "Hat <tt>t</tt> kein linkes (bzw. rechtes) Kind, in das eingefügt weden kann,\n"
      + "so ist eine neues Blatt mit <tt>o</tt> zu erzeugen, welches das \n"
      + "linke (bzw. rechte) Kind von <tt>t</tt> wird.\n"
      + "\n"
      + "Es bietet sich an, diesen Algorithmus in zwei C Funktionen umzusetzen, die\n"
      + "sich gegenseitig verschränkt rekursiv aufrufen. Eine \n"
      + "Funktion <tt>insert</tt>, die ein neues Element in einen Baum einfügt, und\n"
      + "eine Funktion <tt>insertOrNewChild</tt>, die eine Referenz auf ein Kind\n"
      + "hat. Sollte es dieses Kind nicht geben, die Referenz also \n"
      + "auf <tt>NULL</tt> zeigt, so ist ein neues Blatt auf dieser Referenz\n"
      + "einzutragen, ansonsten ist das Element in dem referenzierten Baum einzufügen.\n"
      + "\n"
      + "Zunächst die zwei Sinaturen der benötigten Funktionen.\n"
      + "\n"
      + "<code class=\"BinTree\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[void insertOrNewChild(Baum* insertHere,char* n);\n"
      + "void insert(Baum this,char* n);]]></code>\n"
      + "\n"
      + "Die Umsetzung beider Funktionen ist erschreckend einfach. Beginnen wir mit der\n"
      + "eigentlichen Einfügefunktion <tt>insert</tt>. Es wird mit der \n"
      + "Standardfunktion <tt>strcmp</tt> der einzufügende String mit der\n"
      + "Wurzelmarkierung verglichen. Je nach dem ist links oder rechts das Element \n"
      + "einzufügen.\n"
      + "\n"
      + "<code class=\"BinTree\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[void insert(Baum this,char* n){\n"
      + "  if (strcmp(n,this->name)>0) insertOrNewChild(&this->rechts,n);\n"
      + "  else insertOrNewChild(&this->links,n);\n"
      + "}]]></code> \n"
      + "\n"
      + "Ebenso nur mit zwei Zeilen Funktionsrumpf lässt sich die zweite Funktion\n"
      + "umsetzen. Hier wird unterschieden, ob es noch einen Baum gibt, in dem\n"
      + "einzufügen ist, oder ob ein Blatt erzeugt und eingehängt werden soll:\n"
      + "\n"
      + "<code class=\"BinTree\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[void insertOrNewChild(Baum* insertHere,char* n){\n"
      + "  if (*insertHere==NULL) *insertHere=newBlatt(n);\n"
      + "  else insert(*insertHere,n);\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "Das war es schon. Zum Testen brauchen wir Funktionen, die einen Baum ausgeben\n"
      + "können, so dass man sich ein Bild von seiner Struktur machen kann. Hierzu die\n"
      + "folgende Funktion, die einen Binärbaum ausgibt.\n"
      + "\n"
      + "<code class=\"BinTree\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[void nl(int i){printf(\"\n\");for (;i>0;i--) printf(\" \");}\n"
      + "\n"
      + "int isLeaf(Baum this){return this->links==NULL&&this->rechts==NULL;}\n"
      + "\n"
      + "void printTree(Baum this,int indent){\n"
      + "  if (this!=NULL){\n"
      + "    printf(\"%s\",this->name);\n"
      + "    if (!isLeaf(this)){\n"
      + "      nl(indent);\n"
      + "      printf(\"[\");\n"
      + "      printTree(this->links,indent+1);\n"
      + "      nl(indent);\n"
      + "      printf(\",\");\n"
      + "      printTree(this->rechts,indent+1);\n"
      + "      nl(indent);\n"
      + "      printf(\"]\");\n"
      + "    }\n"
      + "  }else\n"
      + "    printf(\"NULL\");\n"
      + "}]]></code>\n"
      + "\n"
      + "Eine der interessanten Eigenschaften eines binären Suchbaums ist es, dass wenn\n"
      + "zunächst die Elemente des linken Kindes, dann die Wurzelmakierung und\n"
      + "schließlich die Elemente des rechten Kindes ausgegeben werden, die Elemente in\n"
      + "sortierter Reihenfolge ausgegeben werden. \n"
      + "\n"
      + "<code class=\"BinTree\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[void printSorted(Baum this){\n"
      + "  if (this==NULL) return;\n"
      + "  printSorted(this->links);\n"
      + "  printf(\" %s \",this->name);\n"
      + "  printSorted(this->rechts);\n"
      + "}]]></code>\n"
      + "\n"
      + "Ein minimaler test soll uns von der Arbeitsweise obiger Funktionen überzeugen:\n"
      + "\n"
      + "\n"
      + "<code class=\"BinTree\" lang=\"c\" main=\"main\" sequel=\"true\"\n"
      + "><![CDATA[int main(){\n"
      + "  Baum b = newBlatt(\"Sven Eric\");\n"
      + "  insert(b,\"Sebastian\");\n"
      + "  insert(b,\"Tristan\");\n"
      + "  insert(b,\"Jan\");\n"
      + "  insert(b,\"Andreas\");\n"
      + "  insert(b,\"Michael\");\n"
      + "  insert(b,\"Thorsten\");\n"
      + "  insert(b,\"Robert\");\n"
      + "  insert(b,\"Thobias\");\n"
      + "  insert(b,\"Daniel\");\n"
      + "  printTree(b,1);\n"
      + "  printSorted(b);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "das Programm erzeugt folgende kleine Ausgabe:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/student> bin/BinTree\n"
      + "Sven Eric\n"
      + " [Sebastian\n"
      + "  [Jan\n"
      + "   [Andreas\n"
      + "    [NULL\n"
      + "    ,Daniel\n"
      + "    ]\n"
      + "   ,Michael\n"
      + "    [NULL\n"
      + "    ,Robert\n"
      + "    ]\n"
      + "   ]\n"
      + "  ,NULL\n"
      + "  ]\n"
      + " ,Tristan\n"
      + "  [Thorsten\n"
      + "   [Thobias\n"
      + "   ,NULL\n"
      + "   ]\n"
      + "  ,NULL\n"
      + "  ]\n"
      + " ] Andreas  Daniel  Jan  Michael  Robert  Sebastian  Sven Eric  Thobias  Thorsten  Tristan sep@pc305-3:~/fh/c/student>]]></scode>\n"
      + "</section>\n"
      + "\n"
      + "<section titel=\"Praktikumsaufgabe\">\n"
      + "In dieser Projektaufgabe sollen Programme geschrieben werden, die farbige\n"
      + "Bilddateien erzeugen.  Als einfachstes Bildformat benutzen wir das \n"
      + "Format <tt>bmp</tt>, das Bilder als einfache Bitmapdateien speichert.\n"
      + "\n"
      + "Hierzu sei die folgende Header-Datei einer kleinen Bibliothek zum Erzeugen von\n"
      + "Bitmapdateien gegeben. Darin werden zwei einfache Strukturen definiert. Eine\n"
      + "um Farben zu speichern:\n"
      + "<code class=\"BMP\" lang=\"h\" ><![CDATA[#ifndef BMP__H_\n"
      + "#define BMP__H_\n"
      + "\n"
      + "#include <stdlib.h>\n"
      + "#include <stdio.h>\n"
      + "\n"
      + "typedef struct {\n"
      + "  unsigned char red;\n"
      + "  unsigned char green;\n"
      + "  unsigned char blue;\n"
      + "} Color;\n"
      + "\n"
      + "const static Color BLACK = {0,0,0};\n"
      + "const static Color WHITE = {255,255,255};\n"
      + "const static Color RED   = {255,0,0};\n"
      + "const static Color GREEN = {0,255,0};\n"
      + "const static Color BLUE  = {0,0,255};\n"
      + "const static Color YELLOW= {255,255,0};]]></code>\n"
      + "\n"
      + "Und eine für die eigentlichen Bitmapdaten. \n"
      + "\n"
      + "<code class=\"BMP\" lang=\"h\" sequel=\"true\" ><![CDATA[typedef struct {\n"
      + "  int width;\n"
      + "  int height;\n"
      + "  Color* imagedata ;\n"
      + "} Bmp;]]></code>\n"
      + "\n"
      + "Die Bibliothek sieht vier Funktionen vor:\n"
      + "<itemize>\n"
      + "<item><tt>newBmp</tt>: zum Erzeugen eines neuen Bitmapobjektes im \n"
      + "Speicher. </item>\n"
      + "<item><tt>deleteBmp</tt>: um ein Bitmapobjekt wieder aus dem Speicher zu\n"
      + "löschen.</item>\n"
      + "<item><tt>writeBmpToFile</tt>: um ein \n"
      + "Bitmapobjekt in eine Datei zu schreiben.</item>\n"
      + "<item><tt>setBmpPoint</tt>: um einen Punkt mit einer Farbe zu \n"
      + "beschreiben.</item>\n"
      + "</itemize>\n"
      + "\n"
      + "\n"
      + "<code class=\"BMP\" lang=\"h\" sequel=\"true\" \n"
      + "><![CDATA[Bmp* newBmp(int width,int  height);\n"
      + "void deleteBmp(Bmp* this);\n"
      + "void writeBmpToFile(Bmp* this,char* fileName);\n"
      + "void setBmpPoint(Bmp* b,Color c,int x, int y);\n"
      + "\n"
      + "#endif\n"
      + "]]></code>\n"
      + "\n"
      + "Es folgt die Implementierung dieser Bibliothek:\n"
      + "\n"
      + "<code class=\"BMP\" lang=\"c\"\n"
      + " compileoptions=\" echo -std=c99 \"\n"
      + " ><![CDATA[#include \"BMP.h\"\n"
      + "#include <stdlib.h>\n"
      + "#include <stdio.h>\n"
      + "\n"
      + "Bmp* newBmp(int width,int height){\n"
      + "  Bmp* result = (Bmp*)malloc(sizeof(Bmp));\n"
      + "  result->imagedata =(Color*)malloc(sizeof(Color)*width*height);\n"
      + "  result->width=width;\n"
      + "  result->height=height;\n"
      + "  return result;\n"
      + "}\n"
      + "void deleteBmp(Bmp* this){\n"
      + "  free(this->imagedata);\n"
      + "  free(this);\n"
      + "}\n"
      + "\n"
      + "void setBmpPoint(Bmp* this,Color c,int x, int y){\n"
      + "  if (!(x<0||x>=this->width||y<0||y>=this->height)){\n"
      + "    this->imagedata[y*this->width+x]=c;\n"
      + "  }\n"
      + "}\n"
      + "\n"
      + "void putByte(FILE* out,unsigned char ch) {fputc(ch,out);}\n"
      + "\n"
      + "void putShort(FILE* out, unsigned short w) {\n"
      + "  putByte(out, w & 0xff);\n"
      + "  putByte(out, (w>>8) & 0xff);\n"
      + "}\n"
      + "void putLong(FILE* out, unsigned int l) {\n"
      + "  putByte(out, l & 0xff);\n"
      + "  putByte(out, (l>>8) & 0xff);\n"
      + "  putByte(out, (l>>16) & 0xff);\n"
      + "  putByte(out, (l>>24) & 0xff);\n"
      + "}\n"
      + "void putColor(FILE* out, Color c) {\n"
      + "  putByte(out,c.blue);\n"
      + "  putByte(out,c.green);\n"
      + "  putByte(out,c.red);\n"
      + "}\n"
      + "int getBytesPerLines(Bmp* this){\n"
      + "  long bytesPerLine = this->width * 3l;  /* (for 24 bit images) */\n"
      + "  bytesPerLine=bytesPerLine+(4-bytesPerLine%4)%4;\n"
      + "  return bytesPerLine;\n"
      + "}\n"
      + "void writeBmpToFile(Bmp* this,char* fileName) {\n"
      + "  FILE* out = fopen(fileName, \"wb\");\n"
      + "  if (out == NULL){\n"
      + "    printf(\"Error opening output file\n\");\n"
      + "    exit(1);\n"
      + "  }\n"
      + "  putByte(out,'B'); // \"BM\"-ID schreiben\n"
      + "  putByte(out,'M');\n"
      + "\n"
      + "  int headersize = 54L;\n"
      + "  int bytesPerLine = getBytesPerLines(this);\n"
      + "  int filesize  = headersize+bytesPerLine*this->height;\n"
      + "  putLong(out,filesize);\n"
      + "\n"
      + "  putShort(out,0);\n"
      + "  putShort(out,0);\n"
      + "  putLong(out, headersize);  \n"
      + "  putLong(out, 0x28L);       //infoSize\n"
      + "  putLong(out,this-> width);\n"
      + "  putLong(out,this-> height);\n"
      + "  putShort(out, 1);          //biPlanes\n"
      + "  putShort(out, 24);         //bits\n"
      + "  putLong(out,0);            //(no compression)\n"
      + "  putLong(out,0);\n"
      + "  putLong(out,0);\n"
      + "  putLong(out,0);\n"
      + "  putLong(out,0);\n"
      + "  putLong(out,0);\n"
      + "  \n"
      + "  int line, colum;\n"
      + "  for (line=0;line < this->height;line++){\n"
      + "    for (colum=0;colum < this->width;colum++){\n"
      + "      putColor(out,this->imagedata[line*this->width+colum]);\n"
      + "    }\n"
      + "    int missingBytes=bytesPerLine-3*this->width;\n"
      + "    for (;missingBytes>0;missingBytes--)\n"
      + "      putByte(out,0);\n"
      + "  }\n"
      + "  fclose(out);\n"
      + "}]]></code>\n"
      + "\n"
      + "Es folgt eine kleine Beispielanwendung, in der eine erste Bilddatei erzeugt\n"
      + "wird. \n"
      + "\n"
      + "<code class=\"FirstBitmap\" lang=\"c\" \n"
      + " compileoptions=\" echo -std=c99 \"\n"
      + "main=\"gcc -o FirstBitmap ../obj/BMP.o  FirstBitmap.c\"><![CDATA[#include \"BMP.h\"\n"
      + "int main(){\n"
      + "  Bmp* bh = newBmp(850,400);\n"
      + "  int y,x;\n"
      + "  for (y=0;y<bh->height;y++){\n"
      + "    for (x=0;x<bh->width;x++){\n"
      + "      Color c={0,x,0};\n"
      + "      setBmpPoint(bh,c,x,y);\n"
      + "    }\n"
      + "  }\n"
      + "  writeBmpToFile(bh,\"test.bmp\");\n"
      + "  deleteBmp(bh);\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Nun sind Sie dran, Programme zu schreiben, mit denen Bilder generiert\n"
      + "werden können.\n"
      + "<aufgabe blatt=\"Projektaufgabe\"> \n"
      + "Schreiben Sie eine kleine Bibliothek, mit deren Hilfe Sie geometrische Figuren \n"
      + "in  Bitmapdateien scheiben können.\n"
      + "<unteraufgaben>\n"
      + "\n"
      + "<teil>Schreiben Sie eine Prozedur<br />\n"
      + "<tt>void background(Bmp* this,Color c)</tt><br />\n"
      + "Sie soll das ganze Bild mit einer Hintergrundfarbe ausfüllen.\n"
      + "</teil>\n"
      + "\n"
      + "<teil>\n"
      + "Schreiben Sie eine Prozedur\n"
      + "<br/><tt>void fillRect(Bmp* this,Color c,int x,int y,int w,int h)</tt><br/>\n"
      + "Sie soll ein farbiges Rechteck mit der linken unteren \n"
      + "Ecke <tt>(x,y)</tt>, der Weite <tt>w</tt> und der Höhe <tt>h</tt> in die\n"
      + "Bitmapdatei zeichnen.\n"
      + "</teil>\n"
      + "\n"
      + "<teil>\n"
      + "Schreiben Sie eine Prozedur\n"
      + "<br/><tt>void drawLine(Bmp* this,Color c,int fromX,int fromY,int toX,int toY)</tt><br/>\n"
      + "Sie soll eine farbiges Linie mit dem \n"
      + "Startpunkt  <tt>(fromX,fromY)</tt> und dem Endpunkt <tt>(toX,toY)</tt> in \n"
      + "die Bitmapdatei zeichnen.\n"
      + "</teil>\n"
      + "\n"
      + "\n"
      + "<teil>\n"
      + "Schreiben Sie eine Prozedur\n"
      + "<br/><tt>void drawRect(Bmp* this,Color c,int x,int y,int w,int h)</tt><br/>\n"
      + "Sie soll die  farbige Umrandung eines Rechtecks mit der linken unteren \n"
      + "Ecke <tt>(x,y)</tt>, der Weite <tt>w</tt> und der Höhe <tt>h</tt> in die\n"
      + "Bitmapdatei zeichnen.\n"
      + "</teil>\n"
      + "\n"
      + "<teil>\n"
      + "Schreiben Sie eine Prozedur\n"
      + "<br/><tt>void drawCircle(Bmp* this,Color c,int x,int y,int radius)</tt><br/>\n"
      + "Sie soll die  farbige Umrandung eines Kreises mit dem \n"
      + "Mittelpunkt  <tt>(x,y)</tt> und dem  Radius <tt>radius</tt> in die\n"
      + "Bitmapdatei zeichnen.\n"
      + "</teil>\n"
      + "\n"
      + "<teil>\n"
      + "Schreiben Sie eine Prozedur\n"
      + "<br/><tt>void fillCircle(Bmp* this,Color c,int x,int y,int radius)</tt><br/>\n"
      + "Sie soll einen  farbigen Kreises mit dem \n"
      + "Mittelpunkt  <tt>(x,y)</tt> und dem  Radius <tt>radius</tt> in die\n"
      + "Bitmapdatei zeichnen.\n"
      + "\n"
      + "</teil>\n"
      + "\n"
      + "<teil>Schreiben Sie ein Programm, das Ihre Bibliothek nutzt und verschiedene\n"
      + "interessante Bilder erzeugt.</teil>\n"
      + "</unteraufgaben>\n"
      + "\n"
      + "\n";
    String skript8 =
        "<loesung>\n"
      + "<code lang=\"h\" class=\"geo\"><![CDATA[#ifndef GEO__H_H\n"
      + "#define GEO__H_H\n"
      + "\n"
      + "#include \"BMP.h\"\n"
      + "void background(Bmp* this,Color c);\n"
      + "void fillRect(Bmp* this,Color c,int x,int y,int w,int h);\n"
      + "void drawLine(Bmp* this,Color c,int fromX,int fromY,int toX,int toY);\n"
      + "void drawRect(Bmp* this,Color c,int x,int y,int w,int h);\n"
      + "void drawCircle(Bmp* this,Color c,int x,int y,int radius);\n"
      + "void fillCircle(Bmp* this,Color c,int x,int y, int radius);\n"
      + "#endif\n"
      + "]]></code>\n"
      + "<code lang=\"c\" class=\"geo\"\n"
      + " compileoptions=\" echo -std=c99 \"\n"
      + "><![CDATA[#include \"BMP.h\"\n"
      + "#include <math.h>\n"
      + "\n"
      + "#ifndef M_PI\n"
      + "#define M_PI  3.14159265358979323846  \n"
      + "#endif\n"
      + "\n"
      + "void background(Bmp* this,Color c){\n"
      + "  for (int y=0;y<this->height;y++){\n"
      + "    for (int x=0;x<this->width;x++)\n"
      + "      setBmpPoint(this,c,x,y);\n"
      + "  }\n"
      + "}\n"
      + "\n"
      + "void fillRect(Bmp* this,Color c,int x,int y,int w,int h){    \n"
      + "  for (int i=y;i<y+h;i++){\n"
      + "    for (int j=x;j<x+w;j++)\n"
      + "      setBmpPoint(this,c,j,i);\n"
      + "  }\n"
      + "}\n"
      + "\n"
      + "void swapValues(int* x,int* y){\n"
      + "  int z= *x;\n"
      + "  *x= *y;\n"
      + "  *y = z;\n"
      + "}\n"
      + "\n"
      + "void drawLine(Bmp* this,Color c,int fromX,int fromY,int toX,int toY){    \n"
      + "  int xDiv = abs(toX-fromX);\n"
      + "  int yDiv = abs(toY-fromY);\n"
      + "\n"
      + "  if (fromX==toX && fromY==toY){\n"
      + "    setBmpPoint(this,c,fromX,fromY);\n"
      + "  }else if (xDiv>yDiv){\n"
      + "    if (fromX>toX){\n"
      + "      swapValues(&fromY,&toY);\n"
      + "      swapValues(&fromX,&toX);\n"
      + "    }\n"
      + "    double steigung= ((double)toY-fromY)/(toX-fromX);\n"
      + "    for(int x=fromX;x<=toX;x++){\n"
      + "      setBmpPoint(this,c,x,fromY+(int)(x-fromX)*steigung);\n"
      + "    }\n"
      + "  }else{\n"
      + "    if (fromY>toY){\n"
      + "      swapValues(&fromY,&toY);\n"
      + "      swapValues(&fromX,&toX);\n"
      + "    }\n"
      + "    double steigung= ((double)toX-fromX)/(toY-fromY);\n"
      + "    for(int y=fromY;y<=toY;y++){\n"
      + "      setBmpPoint(this,c,fromX+(int)(y-fromY)*steigung,y);\n"
      + "    }\n"
      + "  }\n"
      + "}\n"
      + "\n"
      + "void drawRect(Bmp* this,Color c,int x,int y,int w,int h){\n"
      + "  drawLine(this,c,x,y,x+w,y);\n"
      + "  drawLine(this,c,x+w,y,x+w,y+h);\n"
      + "  drawLine(this,c,x+w,y+h,x,y+h);\n"
      + "  drawLine(this,c,x,y+h,x,y);\n"
      + "}\n"
      + "\n"
      + "void drawCircle(Bmp* this,Color c,int x,int y,int radius){\n"
      + "  if (radius<0) radius= -radius;\n"
      + "  const int maxAlpha=360*(1+radius/100);\n"
      + "  for (int alpha=0;alpha<maxAlpha;alpha++){\n"
      + "    setBmpPoint(this,c\n"
      + "               ,x+(int)(radius*sin(2*M_PI*alpha/maxAlpha))\n"
      + "               ,y+(int)(radius*cos(2*M_PI*alpha/maxAlpha)));\n"
      + "  }\n"
      + "}\n"
      + "\n"
      + "void fillCircle(Bmp* this,Color c,int x,int y, int radius){\n"
      + "  if (radius<0) radius= -radius;\n"
      + "  for (int i=y-radius;i<y+radius;i++)\n"
      + "    for (int j=x-radius;j<x+radius;j++)\n"
      + "      if ((i-y)*(i-y)+(j-x)*(j-x)<radius*radius)\n"
      + "   setBmpPoint(this,c,j,i);\n"
      + "}]]></code>\n"
      + "\n"
      + "<code class=\"testGeo\" lang=\"c\"\n"
      + " compileoptions=\" echo -std=c99 \"\n"
      + "main=\"gcc -std=c99 -lm -o testGeo ../obj/geo.o ../obj/BMP.o testGeo.c\"\n"
      + "><![CDATA[#include \"BMP.h\"\n"
      + "#include <math.h>\n"
      + "#include \"geo.h\"\n"
      + "\n"
      + "int main(){\n"
      + "  Bmp* bmp=newBmp(200,100);\n"
      + "  background(bmp, BLACK);\n"
      + "  fillRect(bmp,RED,20,20,80,30);\n"
      + "  fillRect(bmp,BLUE,80,40,80,50);\n"
      + "  writeBmpToFile(bmp,\"b1.bmp\");\n"
      + "  deleteBmp(bmp);\n"
      + "  \n"
      + "  bmp=newBmp(200,200);\n"
      + "  background(bmp, RED);\n"
      + "  drawRect(bmp,BLUE,80,40,80,50);\n"
      + "  drawLine(bmp,GREEN,10,10,50,90);\n"
      + "  drawLine(bmp,GREEN,10,10,50,190);\n"
      + "  drawLine(bmp,GREEN,10,10,90,50);\n"
      + "  drawLine(bmp,GREEN,10,10,190,50);\n"
      + "  drawLine(bmp,GREEN,10,10,10,150);\n"
      + "  drawLine(bmp,GREEN,10,10,150,10);\n"
      + "\n"
      + "\n"
      + "  drawLine(bmp,GREEN,50,90,10,10);\n"
      + "  drawLine(bmp,GREEN,50,190,10,10);\n"
      + "  drawLine(bmp,GREEN,90,50,10,10);\n"
      + "  drawLine(bmp,GREEN,190,50,10,10);\n"
      + "  drawLine(bmp,GREEN,10,150,10,10);\n"
      + "  drawLine(bmp,GREEN,150,10,10,10);\n"
      + "\n"
      + "  drawCircle(bmp,BLACK,100,100,100);\n"
      + "  drawCircle(bmp,BLACK,100,100,90);\n"
      + "  drawCircle(bmp,BLACK,100,100,80);\n"
      + "  drawCircle(bmp,BLACK,100,100,70);\n"
      + "  drawCircle(bmp,BLACK,100,100,60);\n"
      + "  drawCircle(bmp,BLACK,100,100,50);\n"
      + "  drawCircle(bmp,BLACK,-900,-900,1500);\n"
      + "\n"
      + "  writeBmpToFile(bmp,\"b2.bmp\");\n"
      + "  deleteBmp(bmp);\n"
      + "\n"
      + "  bmp=newBmp(200,200);\n"
      + "  background(bmp, BLUE);\n"
      + "  fillCircle(bmp,YELLOW,100,100,80);\n"
      + "  fillCircle(bmp,GREEN,1,1,70);\n"
      + "  writeBmpToFile(bmp,\"b3.bmp\");\n"
      + "\n"
      + "  deleteBmp(bmp);\n"
      + "  return 0;\n"
      + "}\n"
      + "]]></code>\n"
      + "</loesung>\n"
      + "\n"
      + "</aufgabe>\n"
      + "\n"
      + "<aufgabe blatt=\"Projektaufgabe\"> \n"
      + "In dieser Aufgabe sollen Sie mit Polynomen rechnen. Polynome bestehen aus der\n"
      + "Summe von Monomen. Ein Monom ist der Form <m>c*x^e</m>, \n"
      + "wobei <m>c</m> der Koeffizient eine reelle Zahl ist und <m>e</m> der Exponent,\n"
      + "eine natürliche Zahl inklusive <m>0</m> ist.\n"
      + "<unteraufgaben>\n"
      + "<teil>Definieren Sie eine Datenstruktur, mit der Sie Polynome adequat\n"
      + "darstellen können. <b>Tipp</b>: Betrachten Sie hierzu ein Polynom als eine Art\n"
      + "Liste von Monomen. Definieren Sie sich also zunächst ein <tt>struct</tt>, mit\n"
      + "dem Sie Monome darstellen können. Dann definieren Sie sich \n"
      + "ein <tt>struct</tt>, mit dem Sie eine Verkettung von Monomen darstellen können.</teil>\n"
      + "<teil>Schreiben Sie eine Funktion:<br/>\n"
      + "<tt>double eval(Polynomial this,double x)</tt><br/>\n"
      + "die für einen Eingabewert das Polynom ausrechnet.</teil>\n"
      + "<teil>Schreiben Sie eine Funktion:<br/>\n"
      + "<tt>Polynomial derivation(Polynomial this);</tt><br/>\n"
      + "die für ein Polynom die erste Ableitung erzeugt. </teil>\n"
      + "<teil>Schreiben Sie eine Prozedur:<br />\n"
      + "<tt>void drawPolynomial(Bmp* this,Color c,Polynomial poly</tt><br/>\n"
      + "<tt>                   ,int minX,int maxX, int minY);</tt>\n"
      + "Sie soll den Graphen des Polynoms in einer Bitmapdatei \n"
      + "zeichnen. <tt>minX</tt> und <tt>maxX</tt> geben den gewünschten Wertebereich\n"
      + "auf der <em>x</em>-Achse an. <tt>minY</tt> den <em>y</em>-Wert in der\n"
      + "untersten Bildzeile an.  \n"
      + "</teil>\n"
      + "\n"
      + "</unteraufgaben>\n"
      + "<loesung>\n"
      + "<code lang=\"h\" class=\"poly\"><![CDATA[#ifndef POLY__H_H\n"
      + "#define POLY__H_H\n"
      + "\n"
      + "#include \"BMP.h\"\n"
      + "\n"
      + "typedef struct{\n"
      + "  double coefficient;\n"
      + "  int exponent ;\n"
      + "} Monomial;\n"
      + "\n"
      + "struct PolyStruct{\n"
      + "  Monomial mono;\n"
      + "  struct PolyStruct* next;  \n"
      + "};\n"
      + "\n"
      + "typedef  struct PolyStruct* Polynomial;\n"
      + "\n"
      + "Polynomial newMonoPolynomial(Monomial m);\n"
      + "Polynomial newPolynomial(Monomial m,Polynomial p);\n"
      + "void deletePolynomial(Polynomial this);\n"
      + "\n"
      + "double eval(Polynomial this,double x);\n"
      + "Polynomial derivation(Polynomial this);\n"
      + "void drawPolynomial(Bmp* this,Color c,Polynomial poly\n"
      + "                   ,int minX,int maxX, int minY);\n"
      + "\n"
      + "#endif]]></code>\n"
      + "\n"
      + "<code class=\"poly\" lang=\"c\"\n"
      + " compileoptions=\" echo -std=c99 \"\n"
      + "><![CDATA[#include \"poly.h\"\n"
      + "#include \"geo.h\"\n"
      + "#include <stdlib.h>\n"
      + "#include <math.h>\n"
      + "\n"
      + "Polynomial newMonoPolynomial(Monomial m){\n"
      + "  Polynomial this=(Polynomial)malloc(sizeof(struct PolyStruct));\n"
      + "  this->mono=m;\n"
      + "  this->next=NULL;\n"
      + "  return this;\n"
      + "}\n"
      + "Polynomial newPolynomial(Monomial m,Polynomial p){\n"
      + "  Polynomial this=(Polynomial)malloc(sizeof(struct PolyStruct));\n"
      + "  this->mono=m;\n"
      + "  this->next=p;\n"
      + "  return this;\n"
      + "}\n"
      + "void deletePolynomial(Polynomial this){\n"
      + "  if (this->next!=NULL) deletePolynomial(this->next);\n"
      + "  free(this);\n"
      + "}\n"
      + "double evalMonomial(Monomial m,double x){\n"
      + "  return m.coefficient*pow(x,m.exponent);\n"
      + "}\n"
      + "double eval(Polynomial this,double x){\n"
      + "  double result=evalMonomial(this->mono,x);\n"
      + "  if (this->next!=NULL)result=result+eval(this->next,x);\n"
      + "  return result;\n"
      + "}\n"
      + "Monomial derivationMonomial(Monomial m){\n"
      + "  Monomial result;\n"
      + "  if (m.exponent==0){\n"
      + "    result.exponent=0;\n"
      + "    result.coefficient=0;\n"
      + "  }else {\n"
      + "    result.exponent=m.exponent-1;\n"
      + "    result.coefficient=m.coefficient*m.exponent;\n"
      + "  }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "Polynomial derivation(Polynomial this){\n"
      + "  Monomial mono = derivationMonomial(this->mono);\n"
      + "  if (this->next==NULL) return  newMonoPolynomial(mono);\n"
      + "  return  newPolynomial(mono,derivation(this->next));\n"
      + "}\n"
      + "\n"
      + "void drawPolynomial(Bmp* this,Color c,Polynomial poly\n"
      + "                   ,int minX,int maxX, int minY){\n"
      + "  double valuePerPixel = ((double)maxX-minX)/this->width;\n"
      + "  for (int x=0;x<this->width;x++){\n"
      + "    int y1\n"
      + "     =(int)((eval(poly,minX+valuePerPixel*x)-minY)/valuePerPixel);\n"
      + "    int y2=(int)((eval(poly,minX+valuePerPixel*(x+1))-minY)\n"
      + "                 /valuePerPixel);\n"
      + "    drawLine(this,c,x,y1,x+1,y2);\n"
      + "  } \n"
      + "}]]></code>\n"
      + "\n"
      + "<code lang=\"c\" class=\"testPoly\"\n"
      + " compileoptions=\" echo -std=c99 \"\n"
      + "main=\"gcc -std=c99 -lm -o testPoly  ../obj/geo.o ../obj/BMP.o ../obj/poly.o testPoly.c\"\n"
      + "><![CDATA[#include \"BMP.h\"\n"
      + "#include \"poly.h\"\n"
      + "#include \"geo.h\"\n"
      + "\n"
      + "int main(){\n"
      + "  Bmp* bmp=newBmp(200,400);\n"
      + "  background(bmp, WHITE);\n"
      + "\n"
      + "  Monomial m = {0.02,3};\n"
      + "  Polynomial p=newMonoPolynomial(m);\n"
      + "\n"
      + "  drawPolynomial(bmp,RED,p,-20,20,-20);\n"
      + "  Polynomial p1=derivation(p);\n"
      + "  drawPolynomial(bmp,BLUE,p1,-20,20,-20);\n"
      + "  Polynomial p2=derivation(p1);\n"
      + "  drawPolynomial(bmp,GREEN,p2,-20,20,-20);\n"
      + "  Polynomial p3=derivation(p2);\n"
      + "  drawPolynomial(bmp,BLACK,p3,-20,20,-20);\n"
      + "  writeBmpToFile(bmp,\"b4.bmp\");\n"
      + "\n"
      + "  deletePolynomial(p);\n"
      + "  deletePolynomial(p1);\n"
      + "  deletePolynomial(p2);\n"
      + "  deletePolynomial(p3);\n"
      + "  deleteBmp(bmp);\n"
      + "  return 0;\n"
      + "}\n"
      + "]]></code>\n"
      + "</loesung>\n"
      + "\n"
      + "</aufgabe>\n"
      + "\n"
      + "<aufgabe blatt=\"Projektaufgabe\"> \n"
      + "In dieser Aufgabe sollen Sie die Mandelbrotmenge in einer Bitmapdatei\n"
      + "zeichnen. Hierzu brauchen Sie die Bibliothek für komplexe Zahlen aus\n"
      + "Übungsblatt Nummer 5. \n"
      + "<unteraufgaben>\n"
      + "<teil>Erzeugen Sie eine Bitmapdatei mit der \n"
      + "Weite <tt>480</tt> und der Höhe <tt>430</tt>. Pro Pixel soll dabei ein\n"
      + "reeller Abstand von <m>0.00625</m> dargestellt werden. \n"
      + "Die linke untere Ecke soll \n"
      + "der Punkt <m>(x,y)=(-2,-1,35)</m> sein.<br/>\n"
      + "Berechnen Sie für jeden \n"
      + "Punkt <m>(x,y)</m> nun die Schwelle der komplexen \n"
      + "Zahl <m>x + y i</m> mit dem Schwellwert <m>4</m>. Sie dürfen die \n"
      + "Funktion <tt>schwelle</tt> aus Ihrer Bibliothek \n"
      + "für komplexe Zahlen so abändern, dass sie\n"
      + "maximal 50 als Schwelle berechnet. Ansonsten könnte es passieren, dass die\n"
      + "Funktion <tt>schwelle</tt> nicht terminiert.<br/>\n"
      + "Färben Sie nun die Punkte für unterschiedlichen Schwellwerte\n"
      + "unterschiedlich ein, so dass Sie eine interessante farbige Darstellung der\n"
      + "Mandelbrotmenge erhalten.\n"
      + "\n"
      + "<loesung><code lang=\"c\" class=\"apfel\"\n"
      + " compileoptions=\" echo -std=c99 \"\n"
      + "main=\"gcc -std=c99 -lm -o apfel apfel.c ../obj/BMP.o ../obj/Complex.o \"\n"
      + "><![CDATA[#include \"Complex.h\"\n"
      + "#include \"BMP.h\"\n"
      + "\n"
      + "Bmp* newApfel(){\n"
      + "  Bmp* result = newBmp(480,430);\n"
      + "  for (int y=0;y<result->height;y++)\n"
      + "    for (int x=0;x<result->width;x++){\n"
      + " Complex c={-2+x*0.00625,-1.35+y*0.00625};\n"
      + " unsigned int s=schwelle(c,4)%50;\n"
      + " Color col={5*s%255,s%5*30,s%5*50};\n"
      + " setBmpPoint(result,col,x,y);\n"
      + "    }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "    Bmp* apfel=newApfel();\n"
      + "    writeBmpToFile(apfel,\"apfel.bmp\");\n"
      + "    deleteBmp(apfel);\n"
      + "    return 0;\n"
      + "}\n"
      + "\n"
      + "]]></code></loesung>\n"
      + "\n"
      + "</teil>\n"
      + "<teil>Erzeugen Sie mehrere Bilder, in denen Sie in die in Aufgabe a)\n"
      + "dargestellte Figur hineinzoomen.</teil>\n"
      + "</unteraufgaben>\n"
      + "</aufgabe>\n"
      + "</section>\n"
      + "</kapitel>\n"
      + "\n"
      + "<kapitel titel=\"Programmiersprachen\">\n"
      + "Nachdem wir nun schon sehr tief in die Programmiersprache C eingetaucht sind,\n"
      + "und bereits Programme mit einer komplexen Funktionalität schreiben können, ist\n"
      + "vielleicht Zeit einmal innezuhalten und sich zu überlegen, was eine\n"
      + "Programmiersprache eigentlich genau ist, wie eine Programmiersprache definiert\n"
      + "und beschrieben wird und wie im Endeffekt ein Compiler arbeitet.\n"
      + "\n"
      + "<section titel=\"Syntax und Semantik\">\n"
      + "Programmiersprachen stellen formale Systeme dar. In einem  formalen System\n"
      + "gilt  zu unterscheiden:\n"
      + "<itemize>\n"
      + "<item>\n"
      + " die äußere Struktur, in dem Sätze des Systems\n"
      + "notiert werden, der sogenannten Syntax,</item>\n"
      + "<item> und der Bedeutung dieser Sätze, der\n"
      + "sogenannten Semantik.</item>  \n"
      + "</itemize>\n"
      + "\n"
      + "\n"
      + "<subsection titel=\"Syntax\">\n"
      + "Sprachen sind ein fundamentales Konzept nicht nur der Informatik. In\n"
      + "der Informatik begegnen uns als auffälligste Form der Sprache\n"
      + "<em>Programmiersprachen</em>. Es gibt gewisse Regeln, nach denen die Sätze\n"
      + "einen Sprache aus einer Menge von Wörtern geformt werden können. \n"
      + "Die Regeln nennen wir im \n"
      + "allgemeinen eine <em>Grammatik</em>. Ein Satz einer\n"
      + "Programmiersprache nennen wir Programm. Die Wörter sind,\n"
      + "Schlüsselwörter, Bezeichner, Konstanten und Sonderzeichen.\n"
      + "<p/> \n"
      + "Ausführlich beschäftigt sich die Vorlesung Informatik 2 mit\n"
      + "formalen Sprachen. Die praktische Umsetzung der Theorie in Form eines\n"
      + "Compilers wird in der Vorlesung <em>Compilerbau</em><cite\n"
      + "label=\"webercomp\"/><cite label=\"sepcomp\"/> behandelt. Wir werden in diesem Kapitel die wichtigsten\n"
      + "Grundkenntnisse hierzu betrachten, wie sie zum Handwerkszeug eines\n"
      + "jeden Informatikers gehören.\n"
      + "\n"
      + "Eine der bahnbrechenden Erfindungen des 20.<white></white>Jahrhunderts\n"
      + "geht auf den Sprachwissenschaftler Noam \n"
      + "Chomsky<cite label=\"chomsky56\"/><footnote>Chomsky gilt\n"
      + "als der am häufigsten zitierte Wissenschaftler \n"
      + "des 20.<white></white>Jahrhunderts. Heutzutage tritt Chomsky weniger durch\n"
      + "seine wissenschaftlichen Arbeiten als vielmehr durch seinen Einsatz\n"
      + "für Menschenrechte und bedrohte Völker in Erscheinung.</footnote> zurück. Er\n"
      + "präsentierte als erster ein formales Regelsystem, mit dem die\n"
      + "Grammatik einer Sprache beschrieben werden kann. Dieses Regelsystem\n"
      + "ist in seiner Idee verblüffend einfach. Es bietet Regeln an, \n"
      + "mit denen mechanisch die Sätze einer Sprache generiert werden können.\n"
      + "<p/>\n"
      + "Systematisch wurden Chomsky Ideen zum erstenmal für die Beschreibung\n"
      + "der Syntax der Programmiersprache Algol angewendet<cite\n"
      + "label=\"naur60\"/>. \n"
      + "</subsection>\n"
      + "<subsection titel=\"kontextfreie Grammatik\">  \n"
      + "Eine kontextfreie Grammatik besteht aus\n"
      + "<itemize>\n"
      + "<item>einer Menge <cal>T</cal> von Wörteren,\n"
      + " den <em>Terminalsymbole</em>.</item>\n"
      + "<item>einer Menge <cal>N</cal> von Nichtterminalsymbolen.</item>\n"
      + "<item>ein ausgezeichnetes Startsymbol $S\\in$<cal>N</cal>.</item>\n"
      + "<item>einer endlichen Menge <cal>R</cal> von Regeln der Form:<br></br>\n"
      + "<em>nt</em> <tt>::=</tt> $t_1<dots></dots> t_n$, \n"
      + "wobei <em>nt</em>$\\in$<cal>N</cal>, $t_i\\in$<cal>N</cal>$\\cup$<cal>T</cal>. \n"
      + "</item>\n"
      + "</itemize>\n"
      + "\n"
      + "Mit den Regeln einer kontextfreien Grammatik werden Sätze gebildet,\n"
      + "indem ausgehend vom Startsymbol Regel angewendet werden. Bei einer\n"
      + "Regelanwendung wird ein Nichtterminalzeichen $t$ durch die Rechte Seite\n"
      + "einer Regel, die $t$ auf der linken Seite hat, ersetzt.\n"
      + "\n"
      + "<example>Wir geben eine Grammatik an, die einfache Sätze über unser\n"
      + "Sonnensystem auf Englisch\n"
      + "bilden kann:\n"
      + "<itemize>\n"
      + "<item><cal>T</cal>$=\\{$mars,mercury,deimos,phoebus,orbits,is,a,moon,planet$\\}$</item>\n"
      + "<item><cal>N</cal>$=\\{$<em>start,noun-phrase,verb-phrase,noun,verb,article</em>$\\}$</item>\n"
      + "<item>$S=$<em>start</em></item>\n"
      + "<item><em>start</em> ::= <em>noun-phrase verb-phrase</em><p/>\n"
      + "\n"
      + "<em>noun-phrase</em> ::= <em>noun</em><br/>\n"
      + "<em>noun-phrase</em> ::= <em>article noun</em><p/>\n"
      + "\n"
      + "<em>verb-phrase</em> ::= <em>verb noun-phrase</em><p/>\n"
      + "\n"
      + "<em>noun</em> ::= planet<br/>\n"
      + "<em>noun</em> ::= moon<br/>\n"
      + "<em>noun</em> ::= mars<br/>\n"
      + "<em>noun</em> ::= deimos<br/>\n"
      + "<em>noun</em> ::= phoebus<p/>\n"
      + "\n"
      + "<em>verb</em> ::= orbits<br/>\n"
      + "<em>verb</em> ::= is<p/>\n"
      + "\n"
      + "<em>article</em> ::= a\n"
      + "</item>\n"
      + "</itemize>\n"
      + "Wir können mit dieser Grammatik Sätze in der folgenden Art bilden:\n"
      + "<itemize>\n"
      + "<item><em>start</em><br/>\n"
      + "<rightarrow/> <em>noun-phrase verb-phrase</em><br/>\n"
      + "<rightarrow/> <em>article noun verb-phrase</em><br/>\n"
      + "<rightarrow/> <em>article noun verb noun-phrase</em><br/>\n"
      + "<rightarrow/> a <em>noun verb noun-phrase</em><br/>\n"
      + "<rightarrow/> a moon <em>verb noun-phrase</em><br/>\n"
      + "<rightarrow/> a moon orbits <em>noun-phrase</em><br/>\n"
      + "<rightarrow/> a moon orbits <em>noun</em><br/>\n"
      + "<rightarrow/> a moon orbits mars<br/>\n"
      + "</item>\n"
      + "<item><em>start</em><br/>\n"
      + "<rightarrow/> <em>noun-phrase verb-phrase</em><br/>\n"
      + "<rightarrow/> <em>noun verb-phrase</em><br/>\n"
      + "<rightarrow/> mercury <em>verb-phrase</em><br/>\n"
      + "<rightarrow/> mercury <em>verb noun-phrase</em><br/>\n"
      + "<rightarrow/> mercury is <em>noun-phrase</em><br/>\n"
      + "<rightarrow/> mercury is <em>article noun</em><br/>\n"
      + "<rightarrow/> mercury is a <em>noun</em><br/>\n"
      + "<rightarrow/> mercury is a planet<br/>\n"
      + "</item>\n"
      + "<item>Mit dieser einfachen Grammatik lassen sich auch Sätze bilden,\n"
      + "die weder korrektes Englisch sind, noch eine vernünftige inhaltliche\n"
      + "Aussage machen:<p/>\n"
      + "<em>start</em><br/>\n"
      + "<rightarrow/> <em> noun-phrase verb-phrase</em><br/>\n"
      + "<rightarrow/> <em>noun verb-phrase</em><br/>\n"
      + "<rightarrow/> planet <em>verb-phrase</em><br/>\n"
      + "<rightarrow/> planet <em>verb noun-phrase</em><br/>\n"
      + "<rightarrow/> planet orbits <em>noun-phrase</em><br/>\n"
      + "<rightarrow/> planet orbits <em>article noun</em><br/>\n"
      + "<rightarrow/> planet orbits a <em> noun</em><br/>\n"
      + "<rightarrow/> planet orbits a phoebus<br/>\n"
      + "</item>\n"
      + "</itemize>\n"
      + "</example>\n"
      + "\n"
      + "Eine Grammatik beschreibt die Syntax einer Sprache im Gegensatz zur\n"
      + "Semantik, der Bedeutung, einer Sprache. \n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"Rekursive Grammatiken\">\n"
      + "Die Grammatik aus dem letzen Beispiel kann nur endlich viele Sätze\n"
      + "generieren. Will man mit einer Grammatik unendlich viele Sätze\n"
      + "beschreiben, so wie eine Programmiersprache unendlich viele Programme\n"
      + "hat, so kann man sich dem Trick der Rekursion bedienen. Eine Grammatik\n"
      + "kann rekursive Regeln enthalten; das sind Regeln, in denen auf der\n"
      + "rechten Seite das Nichtterminalsymbol der linken Seite wieder\n"
      + "auftaucht. \n"
      + "<example>Die folgende Grammatik erlaubt es arithmetische Ausdrücke zu\n"
      + "generieren: \n"
      + "<itemize>\n"
      + "<item><cal>T</cal>$=\\{0,1,2,3,4,5,6,7,8,9,+,-,*,/\\}$</item>\n"
      + "<item><cal>N</cal>$=\\{$<em>start,expr,op,integer,digit,</em>$\\}$</item>\n"
      + "<item>$S=$<em>start</em></item>\n"
      + "<item><em>start</em> ::= <em>expr</em><p/>\n"
      + "\n"
      + "<em>expr</em> ::= <em>integer</em><br/>\n"
      + "<em>expr</em> ::= <em>integer op expr</em><p/>\n"
      + "\n"
      + "<em>integer</em> ::= <em>digit</em><p/>\n"
      + "<em>integer</em> ::= <em>digit integer</em><p/>\n"
      + "\n"
      + "<em>op</em> ::= +<br/>\n"
      + "<em>op</em> ::= -<br/>\n"
      + "<em>op</em> ::= *<br/>\n"
      + "<em>op</em> ::= /<p/>\n"
      + "\n"
      + "<em>digit</em> ::= 0<br/>\n"
      + "<em>digit</em> ::= 1<br/>\n"
      + "<em>digit</em> ::= 2<br/>\n"
      + "<em>digit</em> ::= 3<br/>\n"
      + "<em>digit</em> ::= 4<br/>\n"
      + "<em>digit</em> ::= 5<br/>\n"
      + "<em>digit</em> ::= 6<br/>\n"
      + "<em>digit</em> ::= 7<br/>\n"
      + "<em>digit</em> ::= 8<br/>\n"
      + "<em>digit</em> ::= 9\n"
      + "</item>\n"
      + "</itemize>\n"
      + "Diese Grammatik hat zwei rekursive Regeln: eine für das \n"
      + "Nichtterminal <em>expr</em> und eines für das \n"
      + "Nichtterminal <em>integer</em>. <p/>\n"
      + "\n"
      + "Folgende Abeleitung generiert einen arithmetischen Ausdrucke mit dieser\n"
      + "Grammatik:\n"
      + "<itemize>\n"
      + "<item><em>start</em><br/>\n"
      + "<rightarrow/> <em>expr</em><br/>\n"
      + "<rightarrow/> <em>integer op expr</em><br/>\n"
      + "<rightarrow/> <em>integer op integer op expr</em><br/>\n"
      + "<rightarrow/> <em>integer op integer op integer op expr</em><br/>\n"
      + "<rightarrow/> <em>integer op integer op integer op integer</em><br/>\n"
      + "<rightarrow/> <em>integer</em> + <em>integer op integer op integer</em><br/>\n"
      + "<rightarrow/> <em>integer</em> + <em>integer</em> $*$ <em>integer op integer</em><br/>\n"
      + "<rightarrow/> <em>integer</em> + <em>integer</em> $*$ <em>integer</em> $-$\n"
      + "<em>integer</em><br/>\n"
      + "<rightarrow/> <em>digit integer</em> + <em>integer</em> $*$ <em>integer</em> $-$ <em>integer</em><br/>\n"
      + "<rightarrow/> $1$ <em>integer</em> + <em>integer</em> $*$ <em>integer</em>\n"
      + "$-$ <em>integer</em><br/>\n"
      + "<rightarrow/> $1$ <em>digit integer</em> + <em>integer</em> $*$\n"
      + "<em>integer</em> $-$ <em>integer</em><br/>\n"
      + "<rightarrow/> $12$ <em>integer</em> + <em>integer</em> $*$\n"
      + "<em>integer</em> $-$ <em>integer</em><br/>\n"
      + "<rightarrow/> $12$ <em>digit</em> + <em>integer</em> $*$ <em>integer</em>\n"
      + "$-$ <em>integer</em><br/>\n"
      + "<rightarrow/> $129+$ <em>integer</em> $*$ <em>integer</em> $-$\n"
      + "<em>integer</em><br/>\n"
      + "<rightarrow/> $129+$ <em>digit</em> $*$ <em>integer</em> $-$\n"
      + "<em>integer</em><br/>\n"
      + "<rightarrow/> $129+4*$ <em>integer</em> $-$ <em>integer</em><br/>\n"
      + "<rightarrow/> $129+4*$ <em>digit integer</em> $-$ <em>integer</em><br/>\n"
      + "<rightarrow/> $129+4*5$<em>integer</em> $-$ <em>integer</em><br/>\n"
      + "<rightarrow/> $129+4*5$<em>digit</em> $-$ <em>integer</em><br/>\n"
      + "<rightarrow/> $129+4*53-$ <em>integer</em><br/>\n"
      + "<rightarrow/> $129+4*53-$ <em>digit integer</em><br/>\n"
      + "<rightarrow/> $129+4*53-8$ <em>integer</em><br/>\n"
      + "<rightarrow/> $129+4*53-8$ <em>digit</em><br/>\n"
      + "<rightarrow/> $129+4*53-87$<br/>\n"
      + "</item>\n"
      + "</itemize>\n"
      + "</example>\n"
      + "\n"
      + "<aufgabe>Erweitern Sie die obige Grammatik so, dass sie mit ihr auch\n"
      + "geklammerte arithmetische Ausdrücke ableiten können. Hierfür gibt es\n"
      + "zwei neue Terminalsymbolde: <tt>(</tt> und <tt>)</tt>. <p/>\n"
      + "Schreiben Sie\n"
      + "eine Ableitung für den Ausdruck: <tt>1+(2*20)+1</tt></aufgabe>\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Grenzen kontextfreier Grammatiken\">\n"
      + "Kontextfreie Grammatiken sind ein einfaches und dennoch mächtiges \n"
      + "Beschreibungsmittel für Sprachen. Dennoch gibt es viele Sprachen, die\n"
      + "nicht durch eine kontextfreie Grammatik beschrieben werden können. \n"
      + "\n"
      + "<paragraph titel=\"syntaktische Grenzen\">\n"
      + "Es gibt syntaktisch recht einfache Sprachen, die sich nicht durch eine\n"
      + "kontextfreie Grammatik beschreiben lassen. Eine sehr einfache solche\n"
      + "Sprache besteht aus drei Wörtern: <cal>T</cal>$=\\{$a,b,c$\\}$. Die\n"
      + "Sätze dieser Sprache sollen so gebildet sein, daß für eine Zahl $n$\n"
      + "eine Folge von $n$ mal dem Zeichen a, $n$ mal das Zeichen b und\n"
      + "schließlich $n$ mal das Zeichen c folgt, \n"
      + "also \n"
      + "<quote>$\\{a^nb^nc^n|n\\in I\\!\\!N\\}$. </quote>\n"
      + "\n"
      + "Die Sätze dieser Sprache lassen sich aufzählen:\n"
      + "<quote>\n"
      + "abc<br/> \n"
      + "aabbcc<br/> \n"
      + "aaabbbccc<br/> \n"
      + "aaaabbbbcccc<br/> \n"
      + "aaaaabbbbbccccc<br/> \n"
      + "aaaaaabbbbbbcccccc<br/> \n"
      + "<dots/></quote>\n"
      + "Es gibt formale Beweise, daß derartige Sprachen sich nicht mit\n"
      + "kontextfreie Grammatiken bilden lassen. Versuchen Sie einmal das\n"
      + "Unmögliche: eine Grammatik aufzustellen, die diese Sprache erzeugt.\n"
      + "<p/>\n"
      + "Eine weitere einfache Sprache, die nicht durch eine kontextfreie auszudrücken\n"
      + "ist, hat zwei Terminalsymbole und verlangt, daß in jedem Satz die\n"
      + "beiden Symbole gleich oft vorkommen, die Reihenfolge jedoch beliebig\n"
      + "sein kann.</paragraph>\n"
      + "\n"
      + "<paragraph titel=\"semantische Grenzen\">\n"
      + "Über die Syntax hinaus, haben Sprachen noch weitere Einschränkungen,\n"
      + "die sich nicht in der Grammatik ausdrücken lassen. Die meisten\n"
      + "syntaktisch korrekten C-Programme werden trotzdem vom C-Übersetzer\n"
      + "als inkorrekt zurückgewiesen. Diese Programme verstoßen gegen\n"
      + "semantische Beschränkungen, wie z.B.<white></white>gegen die\n"
      + "Zuweisungskompatibilität. Das Programm:\n"
      + "<code>int i = \"1\";</code>\n"
      + "ist syntaktisch nach den Regeln der C-Grammatik korrekt gebildet,\n"
      + "verletzt aber die Beschränkung, daß einem Feld vom \n"
      + "Typ <tt>int</tt> kein Objekt des Typs <tt>String</tt> zugewiesen\n"
      + "werden darf.<p/>\n"
      + "\n"
      + "Aus diesen Grund besteht ein Übersetzer aus zwei großen Teilen. Der\n"
      + "syntaktischen Analyse, die prüft, ob der Satz mit den Regeln der\n"
      + "Grammatik erzeugt werden kann und der semantischen Analyse, die\n"
      + "anschließend zusätzliche semantische Bedingungen prüft.\n"
      + "</paragraph>\n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Das leere Wort\">\n"
      + "Manchmal will man in einer Grammatik ausdrücken, dass in\n"
      + "Nichtterminalsymbol auch zu einem leeren Folge von Symbolen reduzieren\n"
      + "soll. Hierzu könnte man die Regel<br/>\n"
      + "<quote>$t$::=</quote>\n"
      + "mit leerer rechter Seite schreiben. Es ist eine Konvention ein\n"
      + "spezielles Zeichen für das leere Wort zu benutzen. Hierzu bedient man\n"
      + "sich des griechischen Buchtstabens $\\epsilon$. Obige Regel würde man\n"
      + "also schreiben als:\n"
      + "<quote>$t$::=$\\epsilon$</quote>\n"
      + "</subsubsection>\n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"Lexikalische Struktur\">\n"
      + "Bisher haben wir uns keine Gedanken gemacht, woher die  Wörter unserer\n"
      + "Sprache kommen. Wir haben bisher immer eine gegebene Menge\n"
      + "angenommen. Die Wörter einer Sprache bestimmen ihre lexikalische\n"
      + "Struktur. In unseren obigen Beispielen haben wir sehr unterschiedliche\n"
      + "Arten von Wörtern: einmal Wörter der englischen Sprache und einmal\n"
      + "Ziffernsymbole und arithmetische Operatorsymbole. Im Kontext von\n"
      + "Programmiersprachen spricht man von Token. <p/>\n"
      + "\n"
      + "Bevor wir testen können, ob ein Satz mit einer Grammatik erzeugt\n"
      + "werden kann, sind die einzelnen Wörter in diesem Satz zu\n"
      + "identifizieren. Dieses geschieht in einer lexikalischen Analyse. Man\n"
      + "spricht auch vom <em>Lexer</em> und <em>Tokenizer</em>. Um zu\n"
      + "beschreiben, wie die einzelnen lexikalischen Einheiten einer Sprache\n"
      + "aussehen, bedient man sich eines weiteren Formalismus, den regulären\n"
      + "Ausdrücken. \n"
      + "</subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Andere Grammatiken\">\n"
      + "Die in diesem Kapitel vorgestellten Grammatiken \n"
      + "heißen <em>kontextfrei</em>, weil eine Regel für ein\n"
      + "Nichtterminalzeichen angewendet wird, ohne dabei zu betrachten, was\n"
      + "vor oder nach dem Zeichen für ein weiteres Zeichen steht, der Kontext\n"
      + "also nicht betrachtet wird. Läßt man auch Regeln zu, die auf der\n"
      + "linken Seite nicht ein Nichtterminalzeichen stehen haben, so kann man\n"
      + "mächtigere Sprachen beschreiben, als mit einer kontextfreien\n"
      + "Grammatik.\n"
      + "<example>Wir können mit der folgenden nicht-kontextfreien Grammatik\n"
      + "die Sprache beschreiben, in der jeder Satz gleich oft die beiden\n"
      + "Terminalsymbole, eber in beliebiger Reihenfolge enthält.\n"
      + "<itemize>\n"
      + "<item><cal>T</cal>$=\\{$a,b$\\}$</item>\n"
      + "<item><cal>N</cal>$=\\{$<em>start,A,B</em>$\\}$</item>\n"
      + "<item>$S=$<em>start</em></item>\n"
      + "<item><em>start</em> ::= <em>ABstart</em><br/>\n"
      + "<em></em>start ::= $\\epsilon$<p/>\n"
      + "\n"
      + "<em>AB</em> ::= <em>BA</em><p/>\n"
      + "<em>BA</em> ::= <em>AB</em><p/>\n"
      + "\n"
      + "<em>A</em> ::= a<p/>\n"
      + "\n"
      + "<em>B</em> ::= b\n"
      + "</item>\n"
      + "</itemize>\n"
      + "\n"
      + "<quote><em>start</em><br/>\n"
      + "<rightarrow/> <em>ABstart</em><br/>\n"
      + "<rightarrow/> <em>ABABstart</em><br/>\n"
      + "<rightarrow/> <em>ABABABstart</em><br/>\n"
      + "<rightarrow/> <em>ABABABABstart</em><br/>\n"
      + "<rightarrow/> <em>ABABABABABstart</em><br/>\n"
      + "<rightarrow/> <em>ABABABABAB</em><br/>\n"
      + "<rightarrow/> <em>AABBABABAB</em><br/>\n"
      + "<rightarrow/> <em>AABBBAABAB</em><br/>\n"
      + "<rightarrow/> <em>AABBBABAAB</em><br/>\n"
      + "<rightarrow/> <em>AABBBABABA</em><br/>\n"
      + "<rightarrow/> <em>AABBBABBAA</em><br/>\n"
      + "<rightarrow/> <em>AABBBBABAA</em><br/>\n"
      + "<rightarrow/> <em>AABBBBBAAA</em><br/>\n"
      + "<rightarrow/> a<em>ABBBBBAAA</em><br/>\n"
      + "<rightarrow/> aa<em>BBBBBAAA</em><br/>\n"
      + "<rightarrow/> aab<em>BBBBAAA</em><br/>\n"
      + "<rightarrow/> aabb<em>BBBAAA</em><br/>\n"
      + "<rightarrow/> aabbb<em>BBAAA</em><br/>\n"
      + "<rightarrow/> aabbbb<em>BAAA</em><br/>\n"
      + "<rightarrow/> aabbbbb<em>AAA</em><br/>\n"
      + "<rightarrow/> aabbbbba<em>AA</em><br/>\n"
      + "<rightarrow/> aabbbbbaa<em>A</em><br/>\n"
      + "<rightarrow/> aabbbbbaaa\n"
      + "</quote></example> \n"
      + "\n"
      + "\n"
      + "<example>\n"
      + "Auch die nicht durch eine kontextfreie Grammatik darstellbare Sprache:\n"
      + "<quote>$\\{a^nb^nc^n|n\\in I\\!\\!N\\}$. </quote>\n"
      + "läßt sich mit einer solchen Grammatik generieren:\n"
      + "<quote>\n"
      + "<em>S</em>::=ab<em>T</em>c<br/>\n"
      + "<em>T</em>::=Ab<em>T</em>c<bar/>$\\epsilon$<br/>\n"
      + "b<em>A</em>::=<em>A</em>b<br/>\n"
      + "a<em>A</em>::=aa<br/>\n"
      + "</quote>\n"
      + "Eine Ableitung mit dieser Grammatik sieht wie folgt aus:\n"
      + "<quote><em>S</em><br/>\n"
      + "<rightarrow/> ab<em>T</em>c<br/>\n"
      + "<rightarrow/> ab<em>A</em>b<em>T</em>cc<br/>\n"
      + "<rightarrow/> ab<em>A</em>b<em>A</em>b<em>T</em>ccc<br/>\n"
      + "<rightarrow/> ab<em>A</em>b<em>A</em>b<em>A</em>b<em>T</em>cccc<br/>\n"
      + "<rightarrow/> ab<em>A</em>b<em>A</em>b<em>A</em>b<em>A</em>b<em>T</em>ccccc<br/>\n"
      + "<rightarrow/> ab<em>A</em>b<em>A</em>b<em>A</em>b<em>A</em>bccccc<br/>\n"
      + "<rightarrow/> ab<em>AA</em>bb<em>A</em>b<em>A</em>bccccc<br/>\n"
      + "<rightarrow/> ab<em>AA</em>b<em>A</em>bb<em>A</em>bccccc<br/>\n"
      + "<rightarrow/> ab<em>AAA</em>bbb<em>A</em>bccccc<br/>\n"
      + "<rightarrow/> ab<em>AAA</em>bb<em>A</em>bbccccc<br/>\n"
      + "<rightarrow/> ab<em>AAA</em>b<em>A</em>bbbccccc<br/>\n"
      + "<rightarrow/> ab<em>AAAA</em>bbbbccccc<br/>\n"
      + "<rightarrow/> a<em>A</em>b<em>AAA</em>bbbbccccc<br/>\n"
      + "<rightarrow/> a<em>AA</em>b<em>AA</em>bbbbccccc<br/>\n"
      + "<rightarrow/> a<em>AAA</em>b<em>A</em>bbbbccccc<br/>\n"
      + "<rightarrow/> a<em>AAAA</em>bbbbbccccc<br/>\n"
      + "<rightarrow/> aa<em>AAA</em>bbbbbccccc<br/>\n"
      + "<rightarrow/> aaa<em>AA</em>bbbbbccccc<br/>\n"
      + "<rightarrow/> aaaa<em>A</em>bbbbbccccc<br/>\n"
      + "<rightarrow/> aaaaabbbbbccccc\n"
      + "</quote>\n"
      + "</example>\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "Als Preis dafür, daß man sich nicht auf kontextfreie Grammatiken\n"
      + "beschränkt, kann nicht immer leicht und eindeutig erkannt werden, ob\n"
      + "ein bestimmter vorgegebener Satz mit dieser Grammatik erzeugt werden\n"
      + "kann. </subsubsection>\n"
      + "\n"
      + "<subsubsection titel=\"Grammatiken und Bäume\">\n"
      + "Im letzten Kapitel haben wir uns ausführlich mit Bäumen\n"
      + "beschäftigt. Eine Grammatik stellt in naheliegender Weise nicht nur\n"
      + "ein Beschreibung einer Sprache dar, sondern jede Generierung eines\n"
      + "Satzes dieser Sprache entspricht einem Baum, dem Ableitungsbaum. \n"
      + "Die Knoten des Baumes\n"
      + "sind mit Terminal- und Nichtterminalzeichen markiert, wobei Blätter\n"
      + "mit Terminalzeichen markiert sind. Die Kinder eines Knotens sind die\n"
      + "Knoten, die mit der rechten Seite einer Regelanwendung markiert sind.\n"
      + "<p/>\n"
      + "Liest man die Blätter eines solchen Baumes von links nach rechts, so\n"
      + "ergibt sich der generierte Satz.\n"
      + "<example>Die Ableitungen der Sätze unserer ersten Grammatik haben\n"
      + "folgende Baumdarstellung:<br/>\n"
      + "<bild name=\"mars1\"  pdfscale=\"0.9\" psscale=\"0.8\"\n"
      + "caption=\"Ableitungsbaum für a moon orbits mars.\"\n"
      + "/><p/> \n"
      + "\n"
      + "<bild name=\"mars2\"  pdfscale=\"0.9\" psscale=\"0.8\"\n"
      + "caption=\"Ableitungsbaum für mercury is a planet.\"\n"
      + "/><p/>\n"
      + "\n"
      + "<bild name=\"mars3\"  pdfscale=\"0.9\" psscale=\"0.8\"\n"
      + "caption=\"Ableitungsbaum für planet orbits a phoebus.\"\n"
      + "/>\n"
      + "</example>\n"
      + "\n"
      + "Gegenüber unserer bisherigen Darstellung der Ableitung eines Wortes\n"
      + "mit den Regeln einer Grammatik, ist die Reihenfolge, in der die Regeln\n"
      + "angewendet werden in der Baumdarstellung nicht mehr ersichtlich. Daher\n"
      + "spricht man häufiger auch vom Syntaxbaum des Satzes.\n"
      + "\n"
      + "<aufgabe>Betrachten Sie die einfache Grammatik für arithmetische\n"
      + "Ausdrücke aus dem letzen Abschnitt. Zeichnen Sie einen Syntaxbaum für den \n"
      + "Audruck <tt>1+1+2*20</tt>.</aufgabe>\n"
      + "</subsubsection>\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Erweiterte Backus-Naur-Form\">\n"
      + "Die Ausdrucksmöglichkeit einer kontextfreien Grammatik ist auf wenige\n"
      + "Konstrukte beschränkt. Das macht das Konzept einfach. Im Kontext von\n"
      + "Programmiersprachen gibt es häufig sprachliche Konstrukte, wie die\n"
      + "mehrfache Wiederholung oder eine Liste von bestimmten Teilen, die zwar\n"
      + "mit einer kontextfreien Grammatik darstellbar ist, für die aber\n"
      + "spezielles zusätzliche Ausdrucksmittel in der Grammatik eingeführt\n"
      + "werden.  In den nächsten Abschnitten werden wir diese Erweiterungen\n"
      + "kennenlernen, allerdings werden wir in unseren Algorithmen für Sprachen\n"
      + "und Grammatiken diese Erweiterungen nicht berücksichtigen. \n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"Alternativen\">\n"
      + "Wenn es für ein Nichtterminalzeichen mehrere Regeln gibt, so werden\n"
      + "diese Regeln zu einer Regel umgestaltet. Die unterschiedlichen rechten\n"
      + "Seiten werden dann durch einen vertikalen \n"
      + "Strich <bar></bar> gestrennt.\n"
      + "<p/>\n"
      + "Durch diese Darstellung verliert man leider den direkten Zusammenhang\n"
      + "zwischen den Regeln und einen Ableitungsbaum. \n"
      + "<example>\n"
      + "Die Regeln unserer ersten Grammatik können damit wie folgt geschrieben\n"
      + "werden:\n"
      + "\n"
      + "<quote><em>start</em> ::= <em>noun-phrase verb-phrase</em><p/>\n"
      + "\n"
      + "<em>noun-phrase</em> ::= <em>noun</em><bar></bar><em>article noun</em><p/>\n"
      + "\n"
      + "<em>verb-phrase</em> ::= <em>verb noun-phrase</em><p/>\n"
      + "\n"
      + "<em>noun</em> ::= planet<bar/>moon<bar/>mars<bar/>deimos<bar/>phoebus<p/>\n"
      + "\n"
      + "<em>verb</em> ::= orbits<bar/>is<p/>\n"
      + "\n"
      + "<em>article</em> ::= a\n"
      + "</quote>\n"
      + "</example> \n"
      + "</subsubsection>\n"
      + "<subsubsection titel=\"Gruppierung\">\n"
      + "Bestimmte Teile der rechten Seite einer Grammatik können durch\n"
      + "Klammern gruppiert werden. In diesen Klammern können wieder durch\n"
      + "einen vertikalen Strich getrennte \n"
      + "Alternativen stehen.\n"
      + "<example>\n"
      + "Die einfache Grammatik für arithmetische Ausdrücke läßt sich damit\n"
      + "ohne das Nichtterminalzeichen <em>op</em> schreiben:\n"
      + "<quote>\n"
      + "<em>start</em> ::= <em>expr</em><p/>\n"
      + "\n"
      + "<em>expr</em> ::= <em>integer</em><bar/><em>integer</em>\n"
      + "$(+$<bar/>$-$<bar/>$*$<bar/>$/)$ <em> expr</em><p/>\n"
      + "\n"
      + "<em>integer</em> ::= <em>digit</em><bar/><em>digit integer</em><p/>\n"
      + "\n"
      + "<em>digit</em> ::=\n"
      + "0<bar/>1<bar/>2<bar/>3<bar/>4<bar/>5<bar/>6<bar/>7<bar/>8<bar/>9\n"
      + "</quote>\n"
      + "</example>\n"
      + "</subsubsection>\n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"Wiederholungen\">\n"
      + "Ein typische Konstrukt in Programmiersprachen ist, daß bestimmte\n"
      + "Kontrukte wiederholt werden können. So stehen \n"
      + "z.B.<white></white> in C im Rumpf einer\n"
      + "Funktion mehrere Anweisungen. Solche Sprachkonstrukte lassen sich mit einer\n"
      + "kontextfreien Grammatik ausdrücken.\n"
      + "\n"
      + "<example>Eine Zahl besteht aus einer Folge von $n$ Ziffern\n"
      + "($n>0$). Dieses läßt sich durch folgende Regel ausdrücken:\n"
      + "<quote>\n"
      + "<em>Zahl</em> ::= <em>Ziffer Zahl</em><white/><bar/><white/><em>Ziffer</em>\n"
      + "</quote>\n"
      + "</example>\n"
      + "\n"
      + "<paragraph titel=\"1 bis n-fach\">\n"
      + "Im obigen Beispiel handelt es sich um eine 1 bis $n$-fache\n"
      + "Wiederholung des Zeichens <em>Ziffer</em>. Hierzu gibt es eine\n"
      + "abkürzende Schreibweise. Dem zu wiederholenden Teil wird das \n"
      + "Zeichen <tt>+</tt> nachgestellt.\n"
      + "<example>\n"
      + "Obige Regel für das Nichtterminal <em>Zahl</em> läßt sich mit dieser\n"
      + "abkürzenden Schreibweise schreiben als:\n"
      + "<quote><em>Zahl</em> ::= <em>Ziffer</em><tt>+</tt></quote>\n"
      + "</example>\n"
      + "</paragraph>\n"
      + "\n"
      + "<paragraph titel=\"0 bis n-fach\">\n"
      + "Soll ein Teil in einer Wiederholung auch keinmal vorkommen, so wird\n"
      + "statt des Zeichens <tt>+</tt> das Zeichen <tt>*</tt> genommen.\n"
      + "\n"
      + "<example>\n"
      + "Folgende Regel drückt aus, daß ein Ausdruck eine durch Operatoren\n"
      + "getrennte Liste von Zahlen ist.\n"
      + "<quote>\n"
      + "<em>expr</em> ::= <em>Zahl</em><white/><bar/>\n"
      + "<white/> (<em>Op</em><white/><em>Zahl</em>)* \n"
      + "</quote>\n"
      + "</example> \n"
      + "</paragraph>\n"
      + "\n"
      + "<paragraph titel=\"Option\">\n"
      + "Ein weiterer Spezialfall der Wiederholung ist die, in der der\n"
      + "entsprechende Teil keinmal oder einmal vorkommen darf, d.h.~der Teil\n"
      + "ist optional. Optionale Teile werden in der erweiterten Form in eckige\n"
      + "Klammern gesetzt.\n"
      + "\n"
      + "\n"
      + "</paragraph>\n"
      + "\n"
      + "</subsubsection>\n"
      + "\n"
      + "</subsection>\n"
      + "\n"
      + "\n"
      + "\n"
      + "<subsection titel=\"Parser\">\n"
      + "Grammatiken geben an, wie Sätze einer Sprache gebildet werden\n"
      + "können. In der Informatik interessiert der umgekehrte Fall. Ein Satz\n"
      + "ist vorgegeben und es soll geprüft werden, ob dieser Satz mit einer\n"
      + "bestimmten Grammatik erzeugt werden kann. Ein C-Übersetzer \n"
      + "prüft z.B.<white/>ob ein vorgegebenes Programm syntaktisch zur durch\n"
      + "die Javagrammatik beschriebenen Sprache gehört.\n"
      + "Hierzu ist ein Prüfalgorithmus anzugeben, der testet, ob die Grammatik\n"
      + "einen bestimmten Satz generieren kann. Ein solches Programm \n"
      + "wird <em>Parser</em> genannt. Ein Parser<footnote>Lateinisch Pars\n"
      + "bedeutet Teil.</footnote> zerteilt einen Satz in seine syntaktischen\n"
      + "Bestandteile.  \n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Parsstrategien\">\n"
      + "Man kann unterschiedliche Algorithmen benutzen, um zu testen, daß ein\n"
      + "zu der Sprache einer Grammatik gehört. Eine Strategie geht primär von\n"
      + "der Grammatik aus, die andere betrachten eher den zu prüfenden Satz.\n"
      + "\n"
      + "<subsubsection titel=\"Rekursiv absteigend\">\n"
      + "Eine einfache Idee zum Schreiben eines Parsers ist es, einfach\n"
      + "nacheinander auszuprobieren, ob die Regelanwendung nach und nach einen\n"
      + "Satz bilden kann. Hierzu startet man mit dem Startsymbol und wendet\n"
      + "nacheinander die Regeln an. Dabei wendet man immer eine Regel auf das\n"
      + "linkeste Nichtterminalzeichen an, so lange, bis der Satzanfang\n"
      + "abgelitten wurde, oder aber ein falscher Satzanfang abgelitten\n"
      + "wurde. Im letzteren Fall hat man offensichtlich bei einer Regel die\n"
      + "falsche Alternative gewählt. Man ist in eine Sackgasse geraten. \n"
      + "Nun geht man in seiner Ableitung zurück bis\n"
      + "zu der letzten Regelanwendung, an der eine andere Alternative hätte\n"
      + "gewählt werden können. Man spricht dann von <em>backtracking</em>; auf\n"
      + "deutsch kann man treffend von Zurückverfolgen sprechen.<p/>\n"
      + "\n"
      + "Auf diese Weise gelangt man entweder zu einer Ableitung des Satzes,\n"
      + "oder stellt irgendwann fest, daß man alle Alternativen ausprobiert hat\n"
      + "und immer in eine Sackgasse geraten ist. Dann ist der Satz nicht in\n"
      + "der Sprache.\n"
      + "<p/>\n"
      + "Diese Strategie ist eine Suche. Es wird systematisch aus allen\n"
      + "möglichen Ableitungen in der Grammatik nach der Ableitung gesucht, die\n"
      + "den gewünschten Satz findet.\n"
      + "<example>\n"
      + "Wir suchen mit dieser Strategie die Ableitung des \n"
      + "Satzes <em>a moon orbits mars</em> in dem\n"
      + "Sonnensystembeispiel. Sackgassen sind durch einen Punkt $\\bullet$\n"
      + "markiert. \n"
      + "<table layout=\"lllr\">\n"
      + "<zeile><zelle>(0)</zelle><zelle></zelle><zelle><em>start</em></zelle></zeile> \n"
      + "<zeile><zelle>(1) aus 0</zelle><zelle><rightarrow/></zelle><zelle><em>noun-phrase verb-phrase</em></zelle></zeile>\n"
      + "<zeile><zelle>(2a) aus 1</zelle><zelle><rightarrow/></zelle><zelle><em>noun verb-phrase</em></zelle></zeile>   <br/>\n"
      + "\n"
      + "<zeile><zelle>(2a3a) aus 2a</zelle><zelle><rightarrow/></zelle><zelle>planet <em> verb-phrase</em></zelle><zelle>$\\bullet$</zelle></zeile> \n"
      + "<zeile><zelle>(2a3b) aus 2a</zelle><zelle><rightarrow/></zelle><zelle>moon <em> verb-phrase</em></zelle><zelle>$\\bullet$</zelle></zeile> \n"
      + "<zeile><zelle>(2a3c) aus 2a</zelle><zelle><rightarrow/></zelle><zelle>mars <em> verb-phrase</em></zelle><zelle>$\\bullet$</zelle></zeile> \n"
      + "<zeile><zelle>(2a3d) aus 2a</zelle><zelle><rightarrow/></zelle><zelle>deimos <em> verb-phrase</em></zelle><zelle>$\\bullet$</zelle></zeile>\n"
      + "<zeile><zelle>(2a3e) aus 2a</zelle><zelle><rightarrow/></zelle><zelle>phobus <em> verb-phrase</em></zelle><zelle>$\\bullet$</zelle></zeile>  <br/>\n"
      + "\n"
      + "<zeile><zelle>(2b)  aus 1</zelle><zelle><rightarrow/></zelle><zelle><em>article noun verb-phrase</em></zelle></zeile>  \n"
      + "<zeile><zelle>(3) aus 2b</zelle><zelle><rightarrow/></zelle><zelle>a <em> noun verb-phrase</em></zelle></zeile>   <br/>\n"
      + "\n"
      + "<zeile><zelle>(4a) aus 3</zelle><zelle><rightarrow/></zelle><zelle>a planet <em> verb-phrase</em></zelle><zelle>$\\bullet$</zelle></zeile>\n"
      + "<zeile><zelle>(4b) aus 3</zelle><zelle><rightarrow/></zelle><zelle>a moon <em> verb-phrase</em></zelle></zeile>   <br/>\n"
      + "\n"
      + "<zeile><zelle>(5) aus 4b</zelle><zelle><rightarrow/></zelle><zelle>a moon <em> verb noun-phrase</em></zelle></zeile>   <br/>\n"
      + "\n"
      + "<zeile><zelle>(6) aus 5</zelle><zelle><rightarrow/></zelle><zelle>a moon orbits <em> noun-phrase</em></zelle></zeile>   <br/>\n"
      + "\n"
      + "<zeile><zelle>(7) aus 6</zelle><zelle><rightarrow/></zelle><zelle>a moon orbits <em> noun</em></zelle></zeile>   <br/>\n"
      + "\n"
      + "<zeile><zelle>(8a) aus 7</zelle><zelle><rightarrow/></zelle><zelle>a moon orbits planet</zelle><zelle>$\\bullet$</zelle></zeile>   \n"
      + "<zeile><zelle>(8b) aus 7</zelle><zelle><rightarrow/></zelle><zelle>a moon orbits moon</zelle><zelle>$\\bullet$ </zelle></zeile>  \n"
      + "<zeile><zelle>(8c) aus 7</zelle><zelle><rightarrow/></zelle><zelle>a moon orbits mars</zelle></zeile> \n"
      + "</table>\n"
      + "</example>\n"
      + "\n"
      + "Alternativ könnte man diese Strategie auch symetrisch nicht von links\n"
      + "sondern von der rechten Seite an ausführen, also immer eine Regel für\n"
      + "das rechtestes Nichtterminalsymbol anwenden.\n"
      + "\n"
      + "<paragraph titel=\"Linksrekursion\">\n"
      + "Die Strategie des rekursiven Abstiegs auf der linken Seite\n"
      + "funktioniert für eine bestimmte Art von Regeln nicht. Dieses sind\n"
      + "Regeln, die in einer Alternative als erstes Symbol wieder das\n"
      + "Nichtterminalsymbol stehen haben, das auch auf der linken Seite\n"
      + "steht. Solche Regeln heißen linksrekursiv. Unsere Strategie terminiert\n"
      + "in diesen Fall nicht.\n"
      + "\n"
      + "<example>\n"
      + "Gegeben sei eine Grammatik mit einer linksrekursiven Regel:\n"
      + "<quote><em>expr</em>::=<em>expr</em>+<em>zahl</em><bar/><em>zahl</em>\n"
      + "</quote>\n"
      + "Der Versuch den Satz\n"
      + "<quote>zahl+zahl</quote>\n"
      + "mit einem links rekursiv absteigenden Parser abzuleiten, führt zu\n"
      + "einem nicht terminierenden rekursiven Abstieg. Wir gelangen nie in\n"
      + "eine Sackgasse:<p/>\n"
      + "\n"
      + "<table layout=\"ll\">\n"
      + "<zeile><zelle></zelle><zelle><em>expr</em></zelle></zeile>\n"
      + "<zeile><zelle><rightarrow/></zelle><zelle><em>expr</em>+<em>zahl</em></zelle></zeile>\n"
      + "<zeile><zelle><rightarrow/></zelle><zelle><em>expr</em>+<em>zahl</em>+<em>zahl</em></zelle></zeile>\n"
      + "<zeile><zelle><rightarrow/></zelle><zelle><em>expr</em>+<em>zahl</em>+<em>zahl</em>+<em>zahl</em></zelle></zeile>\n"
      + "<zeile><zelle><rightarrow/></zelle><zelle><em>expr</em>+<em>zahl</em>+<em>zahl</em>+<em>zahl</em>+<em>zahl</em></zelle></zeile>\n"
      + "<zeile><zelle></zelle><zelle><dots/></zelle></zeile>\n"
      + "</table>\n"
      + "</example>\n"
      + "\n"
      + "Es läßt sich also nicht für alle Grammatiken mit dem Verfahren des\n"
      + "rekursiven Abstiegs entscheiden, ob ein Satz mit der Grammatik erzeugt\n"
      + "werden kann; aber es ist möglich, eine Grammatik mit linksrekursiven\n"
      + "Regeln so umzuschreiben, daß sie die gleiche Sprache generiert, jedoch\n"
      + "nicht mehr linksrekursiv ist. Hierzu gibt es ein einfaches Schema:\n"
      + "\n"
      + "<quote>\n"
      + "Eine Regel nach dem Schema:\n"
      + "<quote><em>A</em> ::= <em>A</em><white/><em>rest</em><bar/><em>alt2</em></quote>\n"
      + "ist zu ersetzen durch die zwei Regeln:\n"
      + "\n"
      + "<quote><em>A</em>::= <em>alt2</em><white/><em>R</em><br/>\n"
      + "<em>R</em>::= <em>rest</em><white/><em>R</em><bar/>$\\epsilon$</quote>\n"
      + "wobei <em>R</em> ein neues Nichtterminalsymbol ist.\n"
      + "</quote>\n"
      + "\n"
      + "</paragraph>\n"
      + "\n"
      + "<paragraph titel=\"Linkseindeutigkeit\">\n"
      + "Die rekursiv absteigende Strategie hat einen weiteren Nachteil. Wenn\n"
      + "sie streng schematisch angewendet wird, führt sie dazu, daß bestimmte\n"
      + "Prüfungen mehrfach durchgeführt werden. Diese mehrfache Ausführung\n"
      + "kann sich bei wiederholter Regelanwendung multipizieren und zu einem\n"
      + "sehr ineffizienten Parser führen. Grund dafür sind Regeln, die zwei\n"
      + "Alternativen mit gleichem Anfang haben:\n"
      + "<quote>\n"
      + "  <em>S</em> ::= <em>AB</em><bar/><em>A</em>\n"
      + "</quote>\n"
      + "Beide Alternativen für das Nichtterminalzeichen <em>S</em> starten mit\n"
      + "dem Zeichen <em>A</em>. Für unseren Parser bedeutet das soweit:\n"
      + "versuche nach der ersten Alternative zu parsen. Hierzu parse erst nach\n"
      + "dem Symbol <em>A</em>. Das kann eine sehr komplexe Berechnung\n"
      + "sein. Wenn sie gelingt, dann versuche anschließend weiter nach dem\n"
      + "Symbol <em>B</em> zu parsen. Wenn das fehlschlägt, dann verwerfe die\n"
      + "Regelalternative und versuche nach der zweiten Regelalternative zu\n"
      + "parsen. Jetzt ist wieder nach dem Symbol <em>A</em> zu parsen, was wir\n"
      + "bereits gemacht haben.<p/>\n"
      + "Regeln der obigen Art wirken sich auf unsere Parsstrategie ungünstig\n"
      + "aus. Wir können aber ein Schema angegeben, wie man solche Regeln aus\n"
      + "der Grammatik eleminiert, ohne die erzeugte Sprache zu ändern:\n"
      + "<quote>\n"
      + "Regeln der Form\n"
      + "  <quote><em>S</em> ::= <em>AB</em><bar/><em>A</em></quote>\n"
      + "sind zu ersetzen durch\n"
      + "  <quote>\n"
      + "      <em>S</em> ::= <em>AT</em><br/>\n"
      + "      <em>T</em> ::= <em>B</em><bar/>$\\epsilon$\n"
      + "  </quote>\n"
      + "wobei <em>T</em> ein neues Nichtterminalzeichen ist.\n"
      + "</quote>\n"
      + "</paragraph>\n"
      + "\n"
      + "<paragraph titel=\"Vorausschau\">\n"
      + "Im letzten Abschnitt haben wir gesehen, wie wir die Grammatik\n"
      + "umschreiben können, so daß nach dem Zurücksetzen in unserem\n"
      + "Algorithmus es nicht vorkommt, bereits ausgeführte Regeln ein weiteres\n"
      + "Mal zu durchlaufen. Schöner noch wäre es, wenn wir auf das\n"
      + "Zurücksetzen ganz verzichten könnten. Dieses läßt sich allgemein nicht\n"
      + "erreichen, aber es gibt Grammatiken, in denen man durch Betrachtung\n"
      + "des nächsten zu parsenden Zeichens erkennen kann, welche der\n"
      + "Regelalternativen als einzige Alternative in betracht kommt. Hierzu\n"
      + "kann man für eine  Grammatik für jedes Nichtterminalzeichen in jeder\n"
      + "Regelalternative berechnen, welche Terminalzeichen als linkestes\n"
      + "Zeichen in einem mit dieser Regel abgelittenen Satz auftreten\n"
      + "kann. Wenn die Regelalternativen disjunkte solche Menge des ersten\n"
      + "Zeichens haben, so ist eindeutig bei Betrachtung des ersten Zeichens\n"
      + "eines zu parsenden Satzes erkennbar, ob und mit welcher Alternative\n"
      + "dieser Satz nur parsbar sein kann.<p/>\n"
      + "Die gängigsten Parser benutzen diese Entscheidung, nach dem erstem\n"
      + "Zeichen. Diese Parser sind darauf angewiesen, daß die Menge der ersten\n"
      + "Zeichen der verschiedenen Regelalternativen disjunkt sind.<p/>\n"
      + "Der Vorteil an diesem Verfahren ist, daß die Token nach und nach von\n"
      + "links nach rechts stückweise konsumiert werden. Sie können durch einen\n"
      + "Datenstro, relisiert werden. Wurden sie einmal konsumiert, so werden\n"
      + "sie nicht mehr zum Parsen benötigt, weil es kein Zurücksetzen gibt.   \n"
      + "</paragraph>\n"
      + "\n"
      + "</subsubsection>\n"
      + "<subsubsection titel=\"Schieben und Reduzieren\">\n"
      + "Der rekursiv absteigende Parser geht vom Startsymbol aus und versucht\n"
      + "durch Regelanwendung den in Frage stehenden Satz abzuleiten.  \n"
      + "Eine andere Strategie ist die des Schiebens-und-Reduzierens\n"
      + "(shift-reduce).  Diese\n"
      + "geht vom im Frage stehenden Satz aus und versucht die Regeln rückwärts\n"
      + "anzuwenden, bis das Startsymbol erreicht wurde. Hierzu wird der Satz\n"
      + "von links nach rechts (oder symmetrisch von rechts nach links)\n"
      + "betrachtet und versucht, rechte Seiten von Regeln zu finden und durch\n"
      + "ihre linke Seite zu ersetzen. Dazu benötigt man einen Marker, der angibt, bis\n"
      + "zu welchen Teil man den Satz betrachtet. Wenn links des Markers keine\n"
      + "linke Seite einer Regel steht, so wird der Marker ein Zeichen weiter\n"
      + "nach rechts verschoben.\n"
      + "<example>\n"
      + "Wir leiten im folgenden unserer allseits bekannten Beispielsatz aus\n"
      + "dem Sonnensystem durch Schieben und Reduzieren ab. Als Marker benutzen\n"
      + "wir einen Punkt.\n"
      + "<p/>\n"
      + "<table layout=\"lll\">\n"
      + "<zeile><zelle></zelle><zelle></zelle><zelle>. a moon orbits mars</zelle></zeile>\n"
      + "<zeile><zelle>(shift)</zelle><zelle> <rightarrow/></zelle><zelle> a . moon orbits mars</zelle></zeile>\n"
      + "<zeile><zelle>(reduce)</zelle><zelle> <rightarrow/></zelle><zelle> <em>article</em> . moon orbits mars</zelle></zeile>\n"
      + "<zeile><zelle>(shift)</zelle><zelle> <rightarrow/></zelle><zelle> <em>article</em> moon . orbits mars</zelle></zeile>\n"
      + "<zeile><zelle>(reduce)</zelle><zelle> <rightarrow/></zelle><zelle> <em>article noun</em>  . orbits mars</zelle></zeile>\n"
      + "<zeile><zelle>(reduce)</zelle><zelle> <rightarrow/></zelle><zelle> <em>noun-phrase</em> . orbits mars</zelle></zeile>\n"
      + "<zeile><zelle>(shift)</zelle><zelle> <rightarrow/></zelle><zelle> <em>noun-phrase</em>  orbits . mars</zelle></zeile>\n"
      + "<zeile><zelle>(reduce)</zelle><zelle> <rightarrow/></zelle><zelle> <em>noun-phrase verb</em> . mars</zelle></zeile>\n"
      + "<zeile><zelle>(shift)</zelle><zelle> <rightarrow/></zelle><zelle> <em>noun-phrase verb</em> mars .</zelle></zeile>\n"
      + "<zeile><zelle>(reduce)</zelle><zelle> <rightarrow/></zelle><zelle> <em>noun-phrase verb noun</em> .</zelle></zeile>\n"
      + "<zeile><zelle>(reduce)</zelle><zelle> <rightarrow/></zelle><zelle> <em>noun-phrase verb noun-phrase</em> .</zelle></zeile>\n"
      + "<zeile><zelle>(reduce)</zelle><zelle> <rightarrow/></zelle><zelle> <em>noun-phrase verb-phrase</em> .</zelle></zeile>\n"
      + "<zeile><zelle>(reduce)</zelle><zelle> <rightarrow/></zelle><zelle> <em>start</em>.</zelle></zeile>\n"
      + "</table>\n"
      + "</example>\n"
      + "Wir werden im Laufe dieser Vorlesung diese Parserstrategie nicht\n"
      + "weiter verfolgen.\n"
      + "</subsubsection>\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "</subsection>\n"
      + "\n"
      + "<subsection titel=\"Semantik\">\n"
      + "<subsubsection titel=\"operationale Semantik\">\n"
      + "</subsubsection>\n"
      + "<subsubsection titel=\"denotationale Semantik\">\n"
      + "</subsubsection>\n"
      + "\n"
      + "</subsection>\n"
      + "</section>\n"
      + "\n"
      + "<section titel=\"Geschichte von Programmiersprachen\">\n"
      + "Auch <wikipedia  date=\"24. September 2006\" caption=\"Turingmaschine (informelle Beschreibung)\" width=\"0.7\">Die <b>Turingmaschine</b> besteht aus\n"
      + "einem unendlich langen Speicherband mit unendlich vielen sequentiell\n"
      + "angeordneten Feldern. In jedem dieser Felder kann genau ein Zeichen\n"
      + "gespeichert werden. (Man darf sich das unendliche lange Band auch als ein\n"
      + "endliches vorstellen, es muss jedoch lang genug sein, um die aktuelle\n"
      + "Berechnung ungehindert ausführen zu können, d.h. der Lese- und Schreibkopf\n"
      + "darf nicht an das Ende stoßen.) \n"
      + "einem programmgesteuerten Lese- und Schreibkopf, der sich auf dem Speicherband\n"
      + "feldweise bewegen und die Zeichen verändern kann. \n"
      + "\n"
      + "Eine Turingmaschine modifiziert die Eingabe auf dem Band nach einem gegebenen\n"
      + "Programm. Ist die Berechnung beendet, so befindet sich das Ergebnis auf dem\n"
      + "Band. Es wird somit jedem Eingabewert ein Ausgabewert zugeordnet. Eine\n"
      + "Turingmaschine muss aber nicht für alle Eingaben stoppen. In diesem Fall ist\n"
      + "die Funktion für die Eingabe undefiniert. \n"
      + "\n"
      + "Als Ergebnis der Berechnung wird manchmal diejenige Zeichenfolge definiert,\n"
      + "die nach dem Anhalten auf dem Band steht. Die Turingmaschine wird jedoch\n"
      + "meistens (wie viele andere Automaten auch) für Entscheidungsprobleme\n"
      + "eingesetzt, also für Fragen, die mit <em>ja</em> oder <em>nein</em> zu beantworten sind. Hierbei werden zum Beispiel zwei\n"
      + "Zeichen vereinbart, wobei das eine als <em>ja</em> und das andere\n"
      + "als <em>nein</em> interpretiert wird. Nach dem Anhalten der\n"
      + "Turingmaschine liegt die Antwort als eines der beiden Zeichen auf dem\n"
      + "Ausgabeband vor. Zu beachten ist dabei, dass sich jedes Problem als\n"
      + "Entscheidungsproblem formulieren lässt, indem man fragt, ob ein bestimmter\n"
      + "Wert eine Lösung für ein konkretes Problem ist. </wikipedia> wenn Programmiersprachen als formales System auf dem Papier entworfen\n"
      + "werden könnten, \n"
      + "ist die Entwicklung von Programmiersprachen stark an der zur\n"
      + "Verfügung stehenden Hardware gekoppelt. Aber es gibt durchaus auch\n"
      + "formale Systeme, die im weitesten Sinne als Programmiersprachen bezeichnet\n"
      + "werden können, die vollkommen unabhängig zu irgendeiner Hardware entwickelt\n"
      + "wurden. Die zwei einflußreichsten hiervon sind:\n"
      + "\n"
      + "<itemize>\n"
      + "<item>die Turingmaschine<cite label=\"turing\"/></item>\n"
      + "<item>der Lambdakalkül<cite label=\"kleene\"/><cite label=\"barendregt:84\"/></item></itemize> \n"
      + "Diese beiden formalen Systeme sind in etwa der gleichen Zeit entstanden, um\n"
      + "mathematisch dem Begriff der Berechenbarkeit auf die Spur zu kommen (fest\n"
      + "gemacht an dem sogenannten <em>Entscheidungsproblem</em>, das, wie man den\n"
      + "Zitaten entnehmen kann, auch in der englischsprachigen Literatur auf deutsch\n"
      + "bezeichnet wurde). Sie sind\n"
      + "entwickelt worden, lange bevor programmierbare elektronische Rechensysteme\n"
      + "überhaupt zu bauen erwogen wurden. Beide Systeme sind vollkommen\n"
      + "unterschiedlich und ermöglichen die Programmierung der gleichen Klasse\n"
      + "mathematischer Funktionen.\n"
      + "\n"
      + "\n"
      + "<wikipedia date=\"24. September 2006\" caption=\"Lambda-Kalkül (Ausschnitt)\" width=\".99\"\n"
      + ">Der <b>Lambda-Kalkül</b> ist eine formale Sprache zur Untersuchung von Funktionen.\n"
      + "\n"
      + "<subsubsections titel=\"Geschichte\">\n"
      + "\n"
      + "Der Lambda-Kalkül wurde von Alonzo Church und Stephen Kleene in den 1930er\n"
      + "Jahren eingeführt. Church benutzte den Lambda-Kalkül, sowohl um 1936 eine\n"
      + "negative Antwort auf das Entscheidungsproblem zu geben, als auch eine\n"
      + "Fundierung eines logischen Systems zu finden, wie es Russells und Whiteheads\n"
      + "Principia Mathematica zugrunde lag. Mittels des untypisierten Lambda-Kalküls\n"
      + "kann man klar definieren, was eine berechenbare Funktion ist. Die Frage, ob\n"
      + "zwei Lambda-Ausdrücke (s.u.) äquivalent sind, kann im Allgemeinen nicht\n"
      + "algorithmisch entschieden werden. In seiner typisierten Form kann der Kalkül\n"
      + "benutzt werden, um Logik höherer Stufe darzustellen. Der Lambda-Kalkül hat die\n"
      + "Entwicklung funktionaler Programmiersprachen, die Forschung um Typsysteme von\n"
      + "Programmiersprachen im Allgemeinen als auch moderne Teildisziplinen in der\n"
      + "Logik wie Typtheorie wesentlich beeinflusst. \n"
      + "\n"
      + "Meilensteine der Entwicklung waren im Einzelnen:\n"
      + "<itemize>\n"
      + "<item>\n"
      + "Nach der Einführung die frühe Entdeckung, dass der Lambda-Kalkül im Sinne des\n"
      + "Konzepts der Berechenbarkeit ebenso mächtig ist wie die Turing-Maschine oder\n"
      + "jede moderne Programmiersprache. \n"
      + "</item><item>\n"
      + "Konrad Zuse hat Ideen aus dem Lambda-Kalkül 1942 bis 1946 in seinen Plankalkül\n"
      + "einfließen lassen. \n"
      + "</item><item>\n"
      + "John McCarthy hat sie Ende der fünfziger Jahre verwendet und damit die\n"
      + "minimalen Funktionen der Programmiersprache LISP definiert. \n"
      + "</item><item>\n"
      + "Die typisierten Varianten des Lambda-Kalküls führten zu modernen\n"
      + "Programmiersprachen wie ML oder Haskell. \n"
      + "</item><item>\n"
      + "Als überaus fruchtbar erwies sich die Idee, Ausdrücke des typisierten\n"
      + "Lambda-Kalküls zur Repräsentation von Termen einer Logik zugrunde zu legen,\n"
      + "den Lambda-Kalkül also als Meta-Logik zu verwenden. Erstmals von Church 1940\n"
      + "in seiner Theory of Simple Types präsentiert, führte sie einerseits zu\n"
      + "modernen Theorembeweisern für Logiken höherer Stufe und\n"
      + "</item><item>\n"
      + "andererseits in den 70er und 80er Jahren zu Logiken mit immer mächtigeren\n"
      + "Typsystemen, in dem sich z.B. logische Beweise an sich als Lambda-Ausdruck\n"
      + "darstellen lassen.\n"
      + "</item><item>\n"
      + "In Anlehnung an den Lambda-Kalkül wurde für die Beschreibung nebenläufiger\n"
      + "Prozesse der Pi-Kalkül von Robin Milner in den 90er Jahren entwickelt. \n"
      + "</item>\n"
      + "</itemize>\n"
      + "</subsubsections>\n"
      + "<subsubsections titel=\"Der untypisierte Lambda-Kalkül \">\n"
      + "\n"
      + "Im Lambda-Kalkül steht jeder Ausdruck für eine Funktion mit nur einem\n"
      + "Argument; sowohl Argumente als auch Resultate solcher Funktionen sind wiederum\n"
      + "Funktionen. Eine Funktion kann anonym durch eine so genannte\n"
      + "Lambda-Abstraktion definiert werden, die die Zuordnung des Arguments zum\n"
      + "Resultat beschreibt. Zum Beispiel wird die erhöhe-um-2 Funktion $f(x) = x + 2$\n"
      + "im Lambda-Kalkül durch die \n"
      + "Lambda-Abstraktion $\\lambda x. x + 2$ (oder äquivalent\n"
      + "durch $\\lambda y. y + 2$; der Name des formalen Parameters ist unerheblich)\n"
      + "beschrieben; $f(3)$ (die so genannte Funktionsanwendung) kann daher als\n"
      + "$(\\lambda x. x + 2) 3$ geschrieben werden. \n"
      + "Die Funktionsanwendung ist linksassoziativ: $f x y$\n"
      + "ist syntaktisch gleichbedeutend mit $(f x) y$. Offensichtlich sollten die\n"
      + "Ausdrücke: $(\\lambda x. x +3) ((\\lambda x. x+2) 0 )$ und $(\\lambda x. x + 3) 2$    und    $3 +\n"
      + "2$ äquivalent sein - dies motiviert die $\\beta$-Kongruenzregel. \n"
      + "Eine\n"
      + "zweistellige Funktion kann im Lambda-Kalkül durch eine einstellige Funktion\n"
      + "dargestellt werden, die eine einstellige Funktion als Resultat zurückgibt\n"
      + "(siehe auch Schönfinkeln bzw. Currying). Die Funktion $f(x, y) = x - y$ kann \n"
      + "zum\n"
      + "Beispiel durch $\\lambda x. \\lambda y. x - y$ dargestellt werden. \n"
      + "Denn mit der $\\beta$-\n"
      + "Kongruenzregel sind die Ausdrücke $(\\lambda x. \\lambda y. x - y)7~2$,\n"
      + "$(\\lambda y. 7 - y) 2$ und $7 - 2$ äquivalent. \n"
      + "<br /><dots />\n"
      + "</subsubsections></wikipedia> \n"
      + "\n"
      + "\n"
      + "Erstaunlicher Weise  spiegeln sich die beiden Systeme noch heute in den großen\n"
      + "Klassen der gängigen Programmiersprachen wieder: währen die Turingmaschine als\n"
      + "der theoretische Urvater aller imperativen Sprachen betrachtet werden kann,\n"
      + "legt der Lamda-Kalkül die theoretische Grundlage für funktionale Sprachen. \n"
      + "\n"
      + "Ebenso wie in C geht die Turingmaschine von einem sequentiellen Speicher\n"
      + "aus. Speicherzellen können gelesen und neu überschrieben werden, alles\n"
      + "Konzepte, wie wir sie aus C kennen. Dieses Modell der Programmierung ist eng\n"
      + "an der noch heute gebräuchlichen Hardware gebunden.\n"
      + "\n"
      + "Der Lambda-Kalkül hingegen kennt keine Speicherzellen. Die einzige Form von\n"
      + "Datenhaltung sind die Parameter von Funktionen. Funktionen sind können dabei\n"
      + "auch wieder als Argumente anderer Funktionen verwendet werden. Mit der\n"
      + "Programmiersprache Lisp<cite label=\"lisp\"/> wurden diese Konzepte direkt in\n"
      + "eine Programmiersprache umgesetzt und damit eine lange Tradition von\n"
      + "Programmiersprachen begründet auf deren Weg sich z.B.~die \n"
      + "Sprachen Scheme, ML, Miranda, Haskell, Clean, F\\#, Pizza  und Scala befinden.  \n"
      + "\n"
      + "Man kann auch die Turingmaschine als den Versuch das Konzept der\n"
      + "Berechenbarkeit über eine operationale Semantik zu definieren und den\n"
      + "Lambdakalkül als den Versuch die Berechenbarkeit über eine denotationale\n"
      + "Semantik zu definieren, auffassen.\n"
      + "\n"
      + "Aber noch lange vor den theoretische formalen Systemen zur Berechenbarkeit und\n"
      + "weit vor der Erfindung von elektronischen Rechenanlagen, gab es \n"
      + "eine  <wikipedia date=\"24. September 2006\" \n"
      + "caption=\"analytical machine\" width=\"0.99\"\n"
      + ">Die <b>Analytical Engine</b>, die einen wichtigen Schritt in der\n"
      + "Geschichte der Computer darstellt, ist der Entwurf einer mechanischen\n"
      + "Rechenmaschine für allgemeine Anwendungen von Charles Babbage, einem\n"
      + "britischen Professor der Mathematik. Sie wurde 1837 zum ersten Mal\n"
      + "beschrieben, Babbage setzte die Arbeit an dem Entwurf aber bis zum Ende seines\n"
      + "Lebens (1871) fort. Bedingt durch finanzielle und technische Probleme wurde\n"
      + "die Analytical Engine nie gebaut. Es ist mittlerweile allerdings allgemein\n"
      + "anerkannt, dass der Entwurf korrekt war und dass das Gerät funktioniert\n"
      + "hätte. Vergleichbare Computer für allgemeine Anwendungen wurden erst 100 Jahre\n"
      + "später wirklich konstruiert. \n"
      + "\n"
      + "Babbage begann mit der Konstruktion seiner Difference Engine, einem\n"
      + "mechanischen Computer, der speziell für die Lösung polynomialer Funktionen\n"
      + "konzipiert war. Als ihm klar wurde, dass eine viel allgemeinere Bauweise\n";
      String skript9 =
       "möglich wäre, begann er mit der Arbeit an der Analytical Engine. \n"
      + "\n"
      + "Diese sollte von einer Dampfmaschine angetrieben werden und wäre über 30 Meter\n"
      + "lang und 10 Meter breit gewesen. Die Eingabe (Befehle und Daten) sollte über\n"
      + "Lochkarten erfolgen, eine Methode, die in der damaligen Zeit der Steuerung\n"
      + "mechanischer Webstühle diente. Für die Ausgabe waren ein Drucker, ein\n"
      + "Kurvenplotter und eine Glocke geplant. Die Maschine sollte außerdem Zahlen in\n"
      + "Lochkarten oder wahlweise Metallplatten stanzen können. Sie benutzte dezimale\n"
      + "Fließkommaarithmetik und es war Speicher für 1000 Wörter zu 50 Dezimalstellen\n"
      + "vorgesehen. Die Recheneinheit (<em>Mühle</em> genannt) sollte in der Lage \n"
      + "sein, die vier Grundrechenarten durchzuführen. \n"
      + "\n"
      + "Die vorgesehene Programmiersprache war ähnlich den heute verwendeten\n"
      + "Assemblersprachen. Schleifen und bedingte Verzweigungen waren möglich. Drei\n"
      + "verschiedene Arten von Lochkarten wurden benutzt: eine für arithmetische\n"
      + "Operationen, eine für numerische Konstanten und eine für Lade- und\n"
      + "Speicheroperationen, um Zahlen aus dem Speicher in die Recheneinheit und\n"
      + "wieder zurück zu transferieren. Es gab wahrscheinlich drei separate\n"
      + "Lochkartenleser für die drei Kartenarten. \n"
      + "\n"
      + "1842 schrieb der italienische Mathematiker Menabrea, der den reisenden Babbage\n"
      + "in Italien getroffen hatte, eine Beschreibung der Analytical Engine auf\n"
      + "französisch, die von Lady Ada Augusta, Countess of Lovelace ins Englische\n"
      + "übersetzt und (nach einer Anfrage von Babbage, warum sie denn nicht eine\n"
      + "eigene Abhandlung verfasst hätte) ausführlich kommentiert wurde. Ihr Interesse\n"
      + "für die Engine war bereits zehn Jahre früher geweckt worden. Ihre Anmerkungen\n"
      + "zu Menabreas Beschreibung haben ihr später den \n"
      + "Titel <em>erste Programmiererin</em> eingebracht. \n"
      + "\n"
      + "1878 empfahl ein Komitee der British Association for the Advancement of\n"
      + "Science, die Analytical Engine nicht zu bauen. \n"
      + "\n"
      + "1910 berichtete Babbages Sohn, Henry P. Babbage, dass ein Teil der\n"
      + "Recheneinheit und der Drucker gebaut und dazu benutzt worden wären, eine\n"
      + "(fehlerhafte) Liste von Vielfachen von pi auszurechnen. Dies war nur ein\n"
      + "kleiner Teil der ganzen Engine, nicht programmierbar und ohne Speicher. \n"
      + "\n"
      + "Danach geriet die Maschine in Vergessenheit. Die Pläne für ihren Aufbau gelten\n"
      + "jedoch als funktionsfähig, und erst um 1960 realisierten Computer die von\n"
      + "Babbage geplante Rechengenauigkeit (50 Dezimalstellen sind ca. 166 Bit bzw. 20\n"
      + "Byte). Howard Hathaway Aiken, der später die elektrische Rechenmaschine Havard\n"
      + "Mark I baute, wurde durch ihren Aufbau beeinflusst. \n"
      + "\n"
      + "Aus Babbages \n"
      + "Autobiographie: <em>Sobald eine Analytical Engine existiert, \n"
      + "wird sie notwendigerweise der\n"
      + "Wissenschaft die zukünftige Richtung \n"
      + "weisen.</em> </wikipedia> Programmiersprache: Es handelt sich um eine Art\n"
      + "Assemblersprache, zur Programmierung der von Charles Babbage \n"
      + "erdachten <em>analytical machine</em>. Hierbei handelte es sich um eine rein\n"
      + "mechanische Maschine, die die in gleicher Weise areiten sollte, wie wir es von\n"
      + "einem heutigen Computer kennen. Tatsächlich ist die Maschine zu Babbages\n"
      + "Lebzeiten nie gebaut worden. Theoretisch wurde die Arbeit unterstützt \n"
      + "durch  Ada Lovelace.<wikipedia date=\"24. September 2006\" \n"
      + "caption=\"Ada Lovelace\" width=\"0.99\"\n"
      + "><b>Ada Lovelace</b> (auch \n"
      + "Ada Augusta Byron, Ada King oder Countess of Lovelace) ($\\ast$10. Dezember 1815 in London; $\\dagger$27. November 1852 in London; eigentlich\n"
      + "Augusta Ada King Byron, Countess of Lovelace) war eine britische\n"
      + "Mathematikerin. Sie war die Tochter Lord Byrons und Mitarbeiterin Charles\n"
      + "Babbages.\n"
      + "\n"
      + "<subsubsections titel=\"Leben\"> \n"
      + "\n"
      + "Lord Byron hatte drei Kinder von drei Frauen, nur Ada war ehelich\n"
      + "geboren. Doch Adas Mutter Anne Isabella (Annabella) Milbanke ließ sich von dem\n"
      + "Dichter scheiden, als Ada erst einige Wochen alt war, und so lernte diese\n"
      + "ihren berühmten Vater nie kennen. Ihre mathematisch interessierte Mutter\n"
      + "ermöglichte Ada eine naturwissenschaftliche Ausbildung, in deren Verlauf sie\n"
      + "Charles Babbage und die Mathematikerin Mary Somerville kennenlernte. \n"
      + "\n"
      + "Mit 19 Jahren heiratete Ada Byron William King, 8. Baron King (1805-1893), der\n"
      + "1838 zum 1. Earl of Lovelace erhoben wurde. Sie gebar drei Kinder in sehr\n"
      + "kurzen Abständen, eine ihrer Töchter war Annabelle Isabella Blunt. In ihrer\n"
      + "Korrespondenz mit Mary Somerville schrieb sie, dass sie eine unglückliche Ehe\n"
      + "führe, weil ihr neben Schwangerschaften und Kinderbetreuung so wenig Zeit für\n"
      + "ihr Studium der Mathematik und ihrer zweite Leidenschaft, der Musik,\n"
      + "blieben. Um sich abzulenken stürzte sie sich ins Gesellschaftsleben und hatte\n"
      + "mehrere Affären. Mit großer Begeisterung wettete sie auf Pferde. Die letzten\n"
      + "Jahre ihres Lebens, bereits mit Krebs ans Bett gefesselt, soll sie mit der\n"
      + "Entwicklung eines mathematisch \n"
      + "ausgefeilten <em>sicheren</em> Wettsystems verbracht\n"
      + "haben. Ada Lovelace starb im jungen Alter von 36 Jahren. \n"
      + "</subsubsections>\n"
      + "<subsubsections titel=\"Werk\"> \n"
      + "1843 übersetzte sie die durch den italienischen Mathematiker Luigi Menebrea\n"
      + "auf Französisch angefertigte Beschreibung von Babbages Analytical Engine ins\n"
      + "Englische und ergänzte eigene Notizen und Überlegungen zur Maschine. Babbages\n"
      + "Maschine wurde zu seinen Lebzeiten niemals erbaut, da ihm das britische\n"
      + "Parlament die Finanzierung versagte. Dessen ungeachtet legte Ada Lovelace\n"
      + "einen schriftlichen Plan vor, wie man Bernoulli-Zahlen mit der Maschine\n"
      + "berechnen könnte. Dieser Plan brachte ihr den Ruhm ein, nicht nur die erste\n"
      + "Programmiererin, sondern auch der erste Programmierer überhaupt gewesen zu\n"
      + "sein. Auch deswegen wurde die Programmiersprache Ada nach ihr benannt. \n"
      + "\n"
      + "Einige Biographen vertreten die Meinung, dass Ada Lovelace trotz ihrer\n"
      + "Ausbildung einige Schwierigkeiten mit Mathematik hatte, und äußern deshalb\n"
      + "Zweifel, ob sie Babbages Maschine wirklich vollständig verstanden hatte, oder\n"
      + "nicht eher von Babbage als Aushängeschild zu Zwecken der Öffentlichkeitsarbeit\n"
      + "missbraucht wurde. Diese Frage wird wohl mit den heute zur Verfügung stehenden\n"
      + "Informationen niemals abschließend geklärt werden. \n"
      + "\n"
      + "Auf jeden Fall muss man Ada Lovelace anrechnen, dass ihre Vorstellungskraft\n"
      + "weit über die Babbages hinausging; so formulierte sie z. B. in ihren Notizen\n"
      + "zur Analytical Engine die Idee, dass ein Nachfolger der Maschine eines Tages\n"
      + "auch in der Lage sei, Musik zu komponieren oder Grafiken zu \n"
      + "zeichnen.\n"
      + "</subsubsections>\n"
      + "</wikipedia> Sie hat Kommentare zu Babbage arbeiten geschrieben, die\n"
      + "länger, genauer und ausführlicher als sein Abhandlungen sind. In diesen\n"
      + "Artikeln entwirft sie auch Programme zur Steuerung von Babbages Maschine, so\n"
      + "dass ihr zu Recht der Titel als erste Programmierin zuerkannt wird.  \n"
      + "\n"
      + "\n"
      + "</section>\n"
      + "\n"
      + "</kapitel>\n"
      + "\n"
      + "\n"
      + "<kapitel titel=\"Bibliotheken\">\n"
      + "<section titel=\"Eigene Bibliotheken bauen\">\n"
      + "Wir haben in den meisten Aufgaben bereits Wert darauf gelegt, Softwarekomponenten zu\n"
      + "erstellen, die in verschiedenen Programmen wiederverwendet werden kann, wie\n"
      + "z.B. die kleine Bibliothek zum Erzeugen von Bitmapdateien oder die Bibliothek\n"
      + "zur Bearbeitung von einfachen Listen mit beliebigen Objekten. Bisher haben wir\n"
      + "für solche Bibliotheken mit der Option <tt>-c</tt> der Compilers Objektdateien\n"
      + "erzeugt, die wir dann manuell zu unserem Programm hinzugelinkt haben. \n"
      + "\n"
      + "Dabei entstehen ausführbare Programme, die den kompletten Objektode der benutzten\n"
      + "Bibliothek enthalten. Man spricht davon, dass die Bibliothek statisch zum\n"
      + "Programm hinzugefügt wird. Dabei wird quasi der Objektcode der Bibliothek aus\n"
      + "der <tt>.o</tt>-Datei mehr oder weniger in den Code des ausführbaren Programms\n"
      + "hineinkopiert. Wenn mehrere Programme die gleiche Bibliothek benutzen, dann\n"
      + "wird dieser Code in mehrere Programme hineinkopiert. Er existiert dann also in\n"
      + "mehreren ausführbaren Programmen. Werden diese Pragramme gleichzeitig auf\n"
      + "einem Betriebssystem egstartet, dann defindet sich der Code der Bibliothek\n"
      + "mehrfach im Hauptspeicher. \n"
      + "\n"
      + " \n"
      + "<subsection titel=\"dynamische Bibliotheken\">\n"
      + "Der eigentliche Idee einer Bibliothek ist, dass sie einmal für ganz viele\n"
      + "Programme existiert und nicht für jedes Programm, das sie benutzen will, neu\n"
      + "kopiert wird. Hierzu bieten die Betriebssysteme \n"
      + "sogenannte <em>shared libraries</em> an. Dabei ist die Idee, den Objektcode\n"
      + "für die Bibliothek nur einmal im Betriebssystem vorzuhalten. Die ausführbaren\n"
      + "Pragramme enthalten nur einen Hinweis darauf, dass sie diese Bibliothek\n"
      + "benötigen. \n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"Erzeugung dynamischer Bibliotheken\">\n"
      + "<code>gcc -fPIC -c PList.c\n"
      + "  gcc -fPIC -c PListUtil.c\n"
      + "  gcc -fPIC -c PListUtil2.c\n"
      + "  gcc -shared -o libplist.so PList.o PListUtil.o PListUtil2.o</code>\n"
      + "</subsubsection>\n"
      + "\n"
      + "\n"
      + "<subsubsection titel=\"Benutzung dynamischer Bibliotheken\">\n"
      + "<code>gcc -o PlistTest -L. -lplist PListTest.c</code>\n"
      + "</subsubsection>\n"
      + "</subsection>\n"
      + "\n"
      + "\n"
      + "</section>\n"
      + "\n"
      + "<section titel=\"Kleines Beispiel einer GUI-Bibliothek\">\n"
      + "Mit die aufwendigsten und größten Bibliotheken beschäftigen sich mit dem\n"
      + "Erstellen einer graphischen Benutzeroberfläche kurz <em>GUI</em>. Eine\n"
      + "deratige Bibliothek für die Programmiersprache C ist die Bibliothek <tt>GTK</tt>. \n"
      + "\n"
      + "In diesem Abschnitt soll\n"
      + "exemplarisch ein minimaler Einstieg in die Bibliothek <tt>GTK</tt> gezeigt \n"
      + "werden.\n"
      + "\n"
      + "Jedes GUI-Programm der Bibliothek <tt>GTK</tt> benötigt einen Aufruf an die \n"
      + "Initialisierung der Bibliothek, hierzu dient die Funktion <tt>gtk_init</tt>. \n"
      + "Anschließend können Funktionen aufgerufen werden, die einzelne Gui-Komponenten\n"
      + "erzeugen. Eine solche Funktion ist die Funktion <tt>gtk_window_new</tt>, die\n"
      + "eine neues Fensterobjekt erzeugt. Sie kann mit einem Parameter aufgerufen\n"
      + "werden, der die Art des Fensters genauer spezifiziert.\n"
      + "\n"
      + "Folgende Konstanten können Sie für den Fenstertypen (GtkWindowType) verwenden:\n"
      + "<itemize>\n"
      + "<item><tt>GTK_WINDOW_TOPLEVEL</tt>  Wird meist für typische Applikationen verwendet</item> \n"
      + "<item><tt>GTK_WINDOW_DIALOG</tt>  Für Fenster die für Nachrichten oder Dialoge verwendet </item>\n"
      + "<item><tt>GTK_WINDOW_POPUP</tt>  Ein Fenster für Popup's</item>\n"
      + "</itemize>\n"
      + "\n"
      + "Schließlich können Komponenten  mit dem Aufruf der\n"
      + "Funktion <tt>gtk_widget_show</tt> sichtbar gemacht werden. Wenn auf diese\n"
      + "Weise alle Komponenten erzeugt sind, kann die GUI-Anwendung mit dem Aufruf der\n"
      + "Funktion <tt>gtk_main</tt> gestartet werden. Insgesamt läßt sich folgendes\n"
      + "minimale Programm schreiben, welches ein kleines Fenster öffnet:\n"
      + "\n"
      + "\n"
      + "<code class=\"GtkWindow\" lang=\"c\"\n"
      + "    compileoptions=\"/opt/gnome/bin/gtk-config --cflags --libs \"\n"
      + "    main=\"main\"\n"
      + "><![CDATA[#include <gtk/gtk.h>\n"
      + "\n"
      + "int main(int argc, char **argv){\n"
      + "  gtk_init(&argc, &argv);\n"
      + "\n"
      + "  GtkWidget* fenster = gtk_window_new(GTK_WINDOW_TOPLEVEL);\n"
      + "  gtk_widget_show(fenster);\n"
      + "\n"
      + "  gtk_main();\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "Wie man sieht, beginnen alle Funktionen der Bibliothek mit dem \n"
      + "Präfix <tt>gtk_</tt>. Dies soll einiegermaßen sicherstellen, dass nicht zwei\n"
      + "unterschiedliche Bibliotheken ein und denselben Funktionsnamen benutzen. Es\n"
      + "ist nicht davon auszugehen, dass eine andere Bibliothek vernünftiger Weise\n"
      + "eine Funktion mit dem Präfix <tt>gtk_</tt> definietr hat.\n"
      + "\n"
      + "Das obige Programm ist gar nicht so leicht zu kompilieren. Versuchen wir\n"
      + "dieses kommt es gleich schon am Anfang zu einer Fehlermeldung, weil die\n"
      + "Headerdateien nicht gefunden werden:\n"
      + "\n"
      + "<scode><![CDATA[ep@pc305-3:~/fh/c/tutor> gcc -c src/GtkWindow.c\n"
      + "src/GtkWindow.c:1:21: gtk/gtk.h: Datei oder Verzeichnis nicht gefunden\n"
      + "src/GtkWindow.c: In function `main':\n"
      + "src/GtkWindow.c:6: error: `GtkWidget' undeclared (first use in this function)\n"
      + "src/GtkWindow.c:6: error: (Each undeclared identifier is reported only once\n"
      + "src/GtkWindow.c:6: error: for each function it appears in.)\n"
      + "src/GtkWindow.c:6: error: `fenster' undeclared (first use in this function)\n"
      + "src/GtkWindow.c:6: error: `GTK_WINDOW_TOPLEVEL' undeclared (first use in this function)\n"
      + "sep@pc305-3:~/fh/c/tutor>]]></scode> \n"
      + "\n"
      + "\n"
      + "Tatsächlich beinhaltet die Bibliothek <tt>GTK</tt> sehr viele Headerdateien\n"
      + "und inkludiert weitere Subbibliotheken. Diese liegen aufgrund der Anzahl nicht\n"
      + "direkt in den Standardpfaden des Compilers. Daher sind sehr viele Optionen\n"
      + "anzugeben, die dem Compiler sagen, wo er überall Headerdateien  findet. Da im\n"
      + "Falle der Bibliothek <tt>GTK</tt> diese  unterschiedlichen Inkludierungsordner\n"
      + "so viele sind, das niemand diese alle im Kopf behalten kann, bedient sich die\n"
      + "Bibliothek eines kleinen Tools, das die Information verwaltet. Dieses Tool\n"
      + "heißt: <tt>gtk-config</tt>. Dieses kann mit der Option <tt>--cflags</tt> nach \n"
      + "den zusätzlichen Optionen für den Compiler gefragt werden und \n"
      + "mit <tt>--libs</tt> nach den zusätzlichen Optionen für den Linkvorgang geragt \n"
      + "werden.\n"
      + "\n"
      + "Für die Kompilerflags gibt es dabei z.B. die folgende Ausgabe:\n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/tutor> gtk-config --cflags\n"
      + "-I/opt/gnome/include -I/opt/gnome/include/gtk-1.2\n"
      + "-I/opt/gnome/include/glib-1.2 \n"
      + "-I/opt/gnome/lib/glib/include -I/usr/X11R6/include\n"
      + "]]></scode>\n"
      + "\n"
      + "Für die Linkerflags die nachfolgende Ausgabe:\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/tutor> gtk-config --libs\n"
      + "-L/opt/gnome/lib -L/usr/X11R6/lib -lgtk -lgdk -rdynamic -lgmodule -lglib \n"
      + "-ldl -lXi -lXext -lX11 -lm]]></scode>\n"
      + "\n"
      + "\n"
      + "Diese Flags sind nun eigentlich dem Compiler beim Übersetzen und beim Linken\n"
      + "jeweils anzugeben. Auf Unix-artigen Betriebssystemen gibt es eine schöne\n"
      + "Möglichkeit auf der Kommandozeile, den Aufruf an <tt>gtk-config</tt> im Aufruf\n"
      + "des Übersetzers zu integrieren. Hierzu ist der Aufruf in rückwertige einfache\n"
      + "Anführungszeichen einzuschließen, wie in den folgenden zwei Aufrufe zu sehen\n"
      + "ist. \n"
      + "\n"
      + "<scode><![CDATA[sep@pc305-3:~/fh/c/tutor> gcc `gtk-config --cflags` -c src/GtkWindow.c\n"
      + "sep@pc305-3:~/fh/c/tutor> gcc -o GtkWindow `gtk-config --libs` GtkWindow.o]]></scode>\n"
      + "\n"
      + "\n"
      + "Beispielhaft soll im folgenden eine kleine eigene Gui-Komponente erzeugt\n"
      + "werden, die ein Eingabetextfeld, ein Ausgabetextfeld und einen Knopf\n"
      + "enthält. Beim Drücken des Knopfes soll der Text des Eingabefeldes als Eingabe\n"
      + "einer Funtion genutzt werden. Diese Funktion wird als Funktionszeiger\n"
      + "gespeichert. Das Ergebnis des Funktionsaufrufs wird in Ausgabefeld angezeigt.\n"
      + "\n"
      + "Hierzu definieren wir eine Struktur für derartige Dialogobjekte. Diese\n"
      + "Struktur enthalte die drei oben genannten Bestandteile, den benötigten\n"
      + "Funktionszeiger und zusätzlich ein <tt>GtkVBox</tt>-Objekt, das die drei\n"
      + "Gui-Komponenten des Dialogs zusammenfasst:\n"
      + "\n"
      + "\n"
      + "<code class=\"Dialogue\" lang=\"h\"><![CDATA[#ifndef DIALOGUE__H\n"
      + "#define DIALOGUE__H\n"
      + "#include <gtk/gtk.h>\n"
      + "\n"
      + "typedef struct {\n"
      + "  GtkVBox super;\n"
      + "  GtkEntry* eingabe;\n"
      + "  GtkButton* okKnopf;\n"
      + "  GtkLabel* ausgabe;\n"
      + "  char* (*f)(char*);\n"
      + "} GtkDialogue;\n"
      + "\n"
      + "GtkWidget* dialogue_new(char* f(char*));\n"
      + "\n"
      + "#endif]]></code>\n"
      + "\n"
      + "Es folgt die Implementierung der Klasse <tt>Dialogue</tt>. Im Rahmen dieser\n"
      + "Vorlesung soll nicht weiter auf diese Implementierung eingegangen werden.\n"
      + "\n"
      + "<code class=\"Dialogue\" lang=\"c\"\n"
      + "    compileoptions=\"/opt/gnome/bin/gtk-config --cflags \"\n"
      + "><![CDATA[#include \"Dialogue.h\"\n"
      + "#include <stdlib.h>\n"
      + "#include \"StringLength.h\"\n"
      + "\n"
      + "void reagiere(GtkObject* object){\n"
      + "  GtkDialogue* dialogue = (GtkDialogue*)object;\n"
      + "  char* eingabeText = gtk_entry_get_text(dialogue->eingabe);\n"
      + "  char* ausgabeText = dialogue->f(eingabeText);\n"
      + "  gtk_label_set_text(dialogue->ausgabe,ausgabeText);\n"
      + "  free(ausgabeText);\n"
      + "}\n"
      + "\n"
      + "void addToBox(GtkBox* box,GtkWidget* item){\n"
      + "  gtk_box_pack_start(box,GTK_WIDGET(item), FALSE, FALSE, 0);\n"
      + "}\n"
      + "\n"
      + "GtkWidget* dialogue_new(char* f(char*)){\n"
      + "  GtkDialogue* dialogue = (GtkDialogue*) malloc(sizeof(GtkDialogue));\n"
      + "\n"
      + "  GtkVBox* tmp = GTK_VBOX(gtk_vbox_new (FALSE, 0));\n"
      + "  dialogue->super =  *tmp;\n"
      + "  gtk_widget_destroy(GTK_WIDGET(tmp));\n"
      + "    \n"
      + "  dialogue->f = f;\n"
      + "  dialogue->eingabe = (GtkEntry*)gtk_entry_new();\n"
      + "  addToBox(GTK_BOX(dialogue), GTK_WIDGET(dialogue->eingabe));\n"
      + "\n"
      + "  dialogue->okKnopf = (GtkButton*)gtk_button_new_with_label(\"Run\");\n"
      + "  addToBox(GTK_BOX(dialogue), GTK_WIDGET(dialogue->okKnopf));\n"
      + "\n"
      + "  dialogue->ausgabe = (GtkLabel*)gtk_label_new(\"\");\n"
      + "  addToBox(GTK_BOX(dialogue), GTK_WIDGET(dialogue->ausgabe));\n"
      + "\n"
      + "  gtk_signal_connect_object\n"
      + "    (GTK_OBJECT(dialogue->okKnopf), \"clicked\"\n"
      + "    ,GTK_SIGNAL_FUNC(reagiere)    , GTK_OBJECT(dialogue));\n"
      + "\n"
      + "  return GTK_WIDGET(dialogue);\n"
      + "}]]></code>\n"
      + "\n"
      + "Die somit entstandene Komponente von einfachen Dialogfenster ist nun recht\n"
      + "einfach zu benutzen. Hierzu braucht nur die Funktion angegeben zu werden, die\n"
      + "ausgeführt wird, wenn auf dem Knopf gedrückt wird. In unserem Beispiel soll\n"
      + "dabei der Eingabetext in Großbuchstaben umgewandelt werden.\n"
      + "\n"
      + "<code class=\"TestDialogue\" lang=\"c\"\n"
      + "    compileoptions=\"/opt/gnome/bin/gtk-config --cflags  \"\n"
      + "    main=\"gcc `/opt/gnome/bin/gtk-config --libs` -o TestDialogue\n"
      + "    ../obj/Dialogue.o ../obj/TestDialogue.o  \"\n"
      + "><![CDATA[#include <gtk/gtk.h>\n"
      + "#include <stdlib.h>\n"
      + "#include \"Dialogue.h\"\n"
      + "\n"
      + "unsigned int length(char* text){\n"
      + "  unsigned int i;for (i=0;*(text+i)!='\\0';i++){}return i;\n"
      + "}\n"
      + "\n"
      + "#define LOWER_TO_UPPER  'A'-'a';\n"
      + "\n"
      + "char charToUpper(char c){\n"
      + "  if (c>='a' && c <= 'z') return c+LOWER_TO_UPPER;\n"
      + "  return c;\n"
      + "} \n"
      + "\n"
      + "char* toUpper(char* text){\n"
      + "  char* result = malloc((length(text)+1)*sizeof(char));\n"
      + "  int i=0;\n"
      + "  for(;text[i]!='\\0';i++) result[i]=charToUpper(text[i]);\n"
      + "  result[i]='\\0';\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "int main(int argc, char **argv){\n"
      + "  gtk_init(&argc, &argv);\n"
      + "  GtkWidget* fenster = gtk_window_new (GTK_WINDOW_TOPLEVEL);\n"
      + "  \n"
      + "  GtkWidget* dialogue = dialogue_new(toUpper);\n"
      + "  gtk_container_add (GTK_CONTAINER(fenster), dialogue);\n"
      + "\n"
      + "  gtk_widget_show_all(fenster);\n"
      + "  gtk_main();\n"
      + "  return 0;\n"
      + "}]]></code>\n"
      + "\n"
      + "\n"
      + "Klassischer Weise sind GUI-Bibliotheken in einer objektorientierten\n"
      + "Programmiesprache geschrieben, da sich die graphischen Komponenten sehr\n"
      + "anschaulich als abgeschlossene eigenständige Objekte betrachten\n"
      + "lassen. Tatsächlich hält die Bibliothek <tt>Gtk</tt>  sich weitgehendst an einen\n"
      + "objektorientierten Entwurf. Im nächsten Semester werden wir in\n"
      + "GUI-Bibliohteken für C++ kennenlernen.\n"
      + "\n"
      + "</section>\n"
      + "</kapitel>\n"
      + "\n"
      + "<kapitel titel=\"Schlußkapitel\">\n"
      + "Hiermit endet das erste Semester.\n"
      + "\n"
      + "Ein paar einzelne kleinere Themen sind im Laufe der Vorlesung schlichtweg\n"
      + "vergessen worden oder absichtlich übergangen worden. In diesem Kapitel werden\n"
      + "diese Themen kurz an Beispielen angesprochen.\n"
      + "\n"
      + "<section titel=\"weitere Tricks des Präprozessors\">\n"
      + "C Programmieren sind geradezu verliebt in den Präprozessor. Er wird nicht nur\n"
      + "zum Deklarieren von Konstanten und Inkludieren von Kopfdateien benutzt,\n"
      + "sondern für noch recht unterschiedliche Aufgaben ge-(miß-)braucht.\n"
      + "\n"
      + "<subsection titel=\"Auskommentierung\">\n"
      + "Ein Problem der Programmiersprache C ist, dass die Kommentare nicht\n"
      + "verschachtelt möglich sind. Die Zeichenfolge <tt>*/</tt> beendet einen\n"
      + "Kommentarblock. Nach dieser Zeichenfolde werden die nachfolgenden Zeichen\n"
      + "garantiert als Code und nicht als Kommentar betrachtet. Dieses ist\n"
      + "unabhängig davon wie of zuvor die Zeichenfolge <tt>/*</tt>, die den Kommentar\n"
      + "eröffnet, aufgetreten ist.\n"
      + "\n"
      + "Dieses führt dazu, dass man nicht beliebigen Code, schnell einmal\n"
      + "auskommentieren kann, wenn innerhalb dieses Codes bereits \n"
      + "Kommentare stehen. Hierzu\n"
      + "betrachte man folgendes Codefragment:\n"
      + "<code>  /* <bluev>Dieser Code soll auskommentiert werden </bluev>*/\n"
      + "  if (a != 0) {\n"
      + "    b = 0; /* <bluev>setze b auf 0 </bluev>*/\n"
      + "  }</code>\n"
      + "\n"
      + "Schließt man diesen Code nun komplett in einen Kommentar ein, so endet der\n"
      + "Kommentar sobald die Zeichenkette <tt>*/</tt> auftritt, also schon am Ende des\n"
      + "ersten Kommentars.\n"
      + "\n"
      + "<code>/*<bluev>\n"
      + "  /* Dieser Code soll auskommentiert werden </bluev>*/\n"
      + "  if (a != 0) {\n"
      + "    b = 0; /* <bluev>setze b auf 0 </bluev>*/\n"
      + "  }\n"
      + "*/</code>\n"
      + "\n"
      + "Mit der <tt>if</tt>-Anweisung des Präprozessors, kann man Blöcke unabhängig\n"
      + "von ihrer C-Bedeutung komplett aus der Übersetzung \n"
      + "ausschließen: <tt>#if 0</tt> bedeutet, das der nun folgende Text vom\n"
      + "Präprozessor nicht zu berücksichtigen ist. Die so eingeleitete Kommentierung\n"
      + "endet mit <tt>#endif</tt>.\n"
      + "\n"
      + "So läßt sich der obige Code wie folgt von der Kompilierung ausschließen:\n"
      + "\n"
      + "<code>#if 0 <bluev>\n"
      + "  /* Dieser Code soll auskommentiert werden */\n"
      + "  if (a != 0) {\n"
      + "    b = 0; /* setze b auf 0 */\n"
      + "  }\n"
      + "</bluev>#endif</code>\n"
      + "</subsection>\n"
      + "<subsection titel=\"Parameterisierte Makros\">\n"
      + "<code><![CDATA[#define square(x) ((x) * (x))]]></code>\n"
      + "<code><![CDATA[#define swap(x, y) { int tmp = x; x = y; y = tmp }]]></code>\n"
      + "</subsection>\n"
      + "</section> \n"
      + "\n"
      + "<section titel=\"register, extern, auto Variablen\">\n"
      + "</section>\n"
      + "\n"
      + "<section titel=\"der Kommaoperator\">\n"
      + "</section>\n"
      + "\n"
      + "\n"
      + "<section titel=\"Labels und Goto\">\n"
      + "Artikel <cite label=\"Dijkstra:1968:GSC\"/>.\n"
      + "\n"
      + "<code lang=\"c\" main=\"main\" class=\"GoTo\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "double power1(double x,unsigned int e){\n"
      + "  double result=1;\n"
      + "  while (e>0){\n"
      + "    result=result*x;\n"
      + "    e=e-1;\n"
      + "  }\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "double power2(double x,unsigned int e){\n"
      + "  double result=1;\n"
      + " startWhile: \n"
      + "  if (e==0) goto endWhile;\n"
      + "  result=result*x;\n"
      + "  e=e-1;\n"
      + "  goto startWhile;\n"
      + " endWhile:\n"
      + "  return result;\n"
      + "}\n"
      + "\n"
      + "\n"
      + "int main(){\n"
      + "    printf(\"%f\n\",power2(2,10));\n"
      + "    return 0;\n"
      + "}\n"
      + "]]></code>\n"
      + "\n"
      + "\n"
      + "<wikipedia date=\"5. Februar 2007\" caption=\"George Boole\" width=\"0.4\"\n"
      + ">In computer science and related disciplines, <em>considered \n"
      + "harmful</em> is a phrase\n"
      + "popularly used in the titles of diatribes and other critical essays. It\n"
      + "originates with Edsger Dijkstra's letter <em>Go To Statement Considered\n"
      + "Harmful</em>,<cite lael=\"Dijkstra:1968:GSC\"/> published in the \n"
      + "March 1968 Communications of the ACM, in which\n"
      + "he criticized the excessive use of the GOTO statement in programming languages\n"
      + "of the day and advocated structured programming instead. The original title of\n"
      + "the letter, as submitted to ACM was <em>A Case Against the Goto \n"
      + "Statement,</em> but\n"
      + "ACM editor, Niklaus Wirth changed the title to the now immortalized <em>Go To\n"
      + "Statement Considered Harmful.</em> \n"
      + "\n"
      + "Frank Rubin published a criticism of Dijkstra's letter in the March \n"
      + "1987 Communications of the ACM \n"
      + "titled <em>``GOTO Considered Harmful'' Considered Harmful</em>. Donald Moore et\n"
      + "al. published \n"
      + "a reply in the May 1987 CACM titled <em>` ``GOTO Considered \n"
      + "Harmful'' Considered Harmful' Considered Harmful?</em>. (Dijkstra's \n"
      + "own response to this controversy was thankfully \n"
      + "titled <em>On a somewhat disappointing correspondence</em>.)\n"
      + "\n"
      + "Some variants with replacement adjectives (<em>considered silly</em>, \n"
      + "etc.) have been noted in hacker jargon. The phrase is also occasionally\n"
      + "capitalized for effect.</wikipedia> \n"
      + "\n"
      + "\n"
      + "<subsection titel=\"Tailcall-Optimierung\">\n"
      + "\n"
      + "<code lang=\"c\" class=\"tailcall1\" main=\"main\"><![CDATA[#include <stdio.h>\n"
      + "\n"
      + "void printNTimes(char* text,int i){\n"
      + "  if (i==0) return;\n"
      + "  printf(\"%s\n\",text);\n"
      + "  printNTimes(text,i-1);\n"
      + "}\n"
      + "\n"
      + "void printNTimesOpt(char* text,int i){\n"
      + " start:\n"
      + "  if (i==0) return;\n"
      + "  printf(\"%s\n\",text);\n"
      + " \n"
      + "  text=text;\n"
      + "  i=i-1;\n"
      + "  goto start;\n"
      + "}\n"
      + "\n"
      + "int main(){\n"
      + "    printNTimes(\"hallo\",5);\n"
      + "    printNTimesOpt(\"hallo\",5);\n"
      + "    return 0;\n"
      + "}\n"
      + "]]></code>\n"
      + "\n"
      + "</subsection>\n"
      + "<subsection titel=\"Ergebnis akkumulieren\">\n"
      + "<code  lang=\"c\" class=\"tailcall2\" \n"
      + "main=\"gcc -lplist -o tailcall2 ../obj/tailcall2.o\"\n"
      + "><![CDATA[#include <stdio.h>\n"
      + "#include <PList.h>\n"
      + "\n"
      + "int laenge(PList xs){\n"
      + "  if (isEmpty(xs)) return 0;\n"
      + "  return 1+laenge(xs->tail);\n"
      + "}\n"
      + "\n"
      + "int lengthAcc(int result,PList xs){\n"
      + "  if (isEmpty(xs)) return result;\n"
      + "  return lengthAcc(result+1,xs->tail);\n"
      + "}\n"
      + "\n"
      + "int lengthAccOpt(int result,PList xs){\n"
      + " start:\n"
      + "   if (isEmpty(xs)) return result;\n"
      + "   result=result+1;\n"
      + "   xs=xs->tail;\n"
      + "   goto start;\n"
      + "}\n"
      + "\n"
      + "int size(PList xs){return lengthAccOpt(0,xs);}\n"
      + "\n"
      + "int main(){\n"
      + "    int x=42;\n"
      + "    PList xs=cons(&x,cons(&x,cons(&x,cons(&x,cons(&x,nil())))));\n"
      + "    printf(\"%i\n\",laenge(xs));\n"
      + "    printf(\"%i\n\",lengthAcc(0,xs));\n"
      + "    printf(\"%i\n\",lengthAccOpt(0,xs));\n"
      + "    printf(\"%i\n\",size(xs));\n"
      + "    return 0;\n"
      + "}\n"
      + "]]></code>\n"
      + "</subsection>\n"
      + "\n"
      + "</section>\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "\n"
      + "</kapitel>\n"
      + "\n"
      + "\n"
      + "<anhang>\n"
      + "<kapitel titel=\"C Operatoren\">\n"
      + "\n"
      + "<table layout=\"|r|r|\"><hline/>\n"
      + "<zeile><zelle><b>Operator</b></zelle><zelle><b>Beschreibung</b></zelle></zeile><hline/>\n"
      + "<zeile><zelle><tt>()</tt></zelle><zelle>Gruppierung und Funktionsanwendung</zelle></zeile>\n"
      + "<zeile><zelle><tt>[]</tt></zelle><zelle>Array Index</zelle></zeile>\n"
      + "<zeile><zelle><tt>.</tt></zelle><zelle>Auswahl von Objekteigenschaft</zelle></zeile>\n"
      + "<zeile><zelle><tt>-></tt></zelle><zelle>Auswahl von Objekteigenschaft über Zeiger</zelle></zeile><hline/>\n"
      + "<zeile><zelle><tt>++</tt>~<tt>--</tt></zelle><zelle>einstelliges Increment und Decrement</zelle></zeile>\n"
      + "<zeile><zelle><tt>+</tt>~<tt>-</tt></zelle><zelle>einstelliges plus und minus</zelle></zeile>\n"
      + "<zeile><zelle><tt>!</tt>~<tt>~</tt></zelle><zelle>logische Negation, bitweises Komplement</zelle></zeile>\n"
      + "<zeile><zelle><tt>(type)</tt></zelle><zelle>Typkonversion</zelle></zeile>\n"
      + "<zeile><zelle><tt>*</tt></zelle><zelle>Dereferenzierung</zelle></zeile>\n"
      + "<zeile><zelle><tt>&amp;</tt></zelle><zelle>Adressoperator</zelle></zeile>\n"
      + "<zeile><zelle><tt>sizeof</tt></zelle><zelle>Berechnung der Länge in Bytes</zelle></zeile><hline/>\n"
      + "<zeile><zelle><tt>*</tt>~<tt>/</tt>~<tt>%</tt></zelle><zelle>Multiplikation,\n"
      + "Division, Modulo</zelle></zeile><hline/>\n"
      + "<zeile><zelle><tt>+</tt>~<tt>-</tt></zelle><zelle>Addition, Subtraktion</zelle></zeile><hline/>\n"
      + "<zeile><zelle><tt>&lt;&lt;</tt>~<tt>&gt;&gt;</tt></zelle><zelle>bitweise links-/Rechts-Shift</zelle></zeile><hline/>\n"
      + "<zeile><zelle><tt>&lt;</tt>~<tt>&lt;=</tt></zelle><zelle>kleiner- und\n"
      + "kleiner-gleich-Relation</zelle></zeile>\n"
      + "<zeile><zelle><tt>&gt;</tt>~<tt>&gt;=</tt></zelle><zelle>größer- und größer-gleich-Relation</zelle></zeile><hline/>\n"
      + "<zeile><zelle><tt>==</tt>~<tt>!=</tt></zelle><zelle>gleich- und ungleich-Relation</zelle></zeile><hline/>\n"
      + "<zeile><zelle><tt>&amp;</tt></zelle><zelle>bitweises Und</zelle></zeile><hline/>\n"
      + "<zeile><zelle><tt>^</tt></zelle><zelle>bitweises exklusives\n"
      + "Oder</zelle></zeile><hline/>\n"
      + "<zeile><zelle><tt>|</tt></zelle><zelle>bitweises inklusives Oder</zelle></zeile><hline/>\n"
      + "<zeile><zelle><tt>&amp;&amp;</tt></zelle><zelle>logisches Und</zelle></zeile><hline/>\n"
      + "<zeile><zelle><tt>||</tt></zelle><zelle>logisches Oder</zelle></zeile><hline/>\n"
      + "<zeile><zelle><tt>?:</tt></zelle><zelle>dreistelliger Bedingungsoperator</zelle></zeile><hline/>\n"
      + "<zeile><zelle><tt>=</tt></zelle><zelle>Zuweisung</zelle></zeile>\n"
      + "<zeile><zelle><tt>+=</tt>~<tt>-=</tt></zelle><zelle>Additions-/Subtraktions-Zuweisung</zelle></zeile>\n"
      + "<zeile><zelle><tt>*=</tt>~<tt>/=</tt></zelle><zelle>Multiplikations-/Divisions-Zuweisung</zelle></zeile>\n"
      + "<zeile><zelle><tt>%=</tt>~<tt>&amp;=</tt></zelle><zelle>Modulo-/bitweise-Und-Zuweisung</zelle></zeile>\n"
      + "<zeile><zelle><tt>^=</tt>~<tt>|=</tt></zelle><zelle>bitweise\n"
      + "exklusive/inklusive Oder-Zuweisung</zelle></zeile>\n"
      + "<zeile><zelle><tt>&lt;&lt;=</tt>~<tt>&gt;&gt;=</tt></zelle><zelle>Bitshift-Zuweisung</zelle></zeile><hline/>\n"
      + "<zeile><zelle><tt>,</tt></zelle><zelle>Folge von Ausdrücken</zelle></zeile><hline/>\n"
      + "</table>\n"
      + "</kapitel>\n"
      + "\n"
      + "<kapitel titel=\"primitive Typen\"> <label name=\"primTyp\"/>\n"
      + "In diesem Anhang findet sich ein Auszug aus \n"
      + "dem <exlink address=\"http://www.gnu.org/software/gnu-c-manual/gnu-c-manual.html\"\n"
      + ">The GNU C Reference Manual</exlink>.\n"
      + "\n"
      + "<section titel=\"4.1 Integer Data Types\">\n"
      + "\n"
      + "\n"
      + "The integer data types range in size from at least 8 bits to at least 64 bits. \n"
      + "You should use them for storing whole number values (and the <tt>char</tt>\n"
      + "data type for storing characters).  (Note that the sizes and ranges listed\n"
      + "for these types are minimums; your particular compiler may allow for larger\n"
      + "values.)\n"
      + "\n"
      + "     <ul>\n"
      + "<li><tt>signed char</tt><br/>\n"
      + "The 8-bit <tt>signed char</tt> data type can hold integer values in\n"
      + "the range of -128 to 127.\n"
      + "</li>\n"
      + "     <li><tt>unsigned char</tt>\n"
      + "<br/>\n"
      + "The 8-bit <tt>unsigned char</tt> data type can hold integer values in\n"
      + "the range of 0 to 255.\n"
      + "</li>\n"
      + "     <li><tt>char</tt><br/>\n"
      + "Depending on your system, the <tt>char</tt> data type is defined as\n"
      + "equivalent to either the <tt>signed char</tt> or the <tt>unsigned char</tt>\n"
      + "data type.  By convention, you should use the <tt>char</tt> data type\n"
      + "specifically for storing ASCII characters (such as `m') or escape\n"
      + "sequences (such as <tt>`\n'</tt>).\n"
      + "</li>\n"
      + "     <li><tt>int</tt><br/>\n"
      + "The 32-bit <tt>int</tt> data type can hold integer values in the range\n"
      + "of -2,147,483,648 to 2,147,483,647.  You may also refer to this data type\n"
      + "as <tt>signed int</tt> or <tt>signed</tt>.\n"
      + "</li>\n"
      + "     <li><tt>unsigned int</tt><br />\n"
      + "The 32-bit <tt>unsigned int</tt> data type can hold integer values in\n"
      + "the range of 0 to 4,294,967,295.  You may also refer to this data type\n"
      + "simply as <tt>unsigned</tt>.\n"
      + "</li>\n"
      + "     <li><tt>long int</tt><br/>\n"
      + "The 32-bit <tt>long int</tt> data type can hold integer values in\n"
      + "the range of at least -2,147,483,648 to 2,147,483,647.  (Depending on\n"
      + "your system, this data type might be 64-bit, in which case its range is\n"
      + "identical to that of the <tt>long long int</tt> data type.)  You may also\n"
      + "refer to this data type as <tt>long</tt>, <tt>signed long int</tt>,\n"
      + "or <tt>signed long</tt>.\n"
      + "</li>\n"
      + "     <li><tt>unsigned long int</tt><br/>\n"
      + "The 32-bit <tt>unsigned long int</tt> data type can hold integer values\n"
      + "in the range of at least 0 to 4,294,967,295.  (Depending on your\n"
      + "system, this data type might be 64-bit, in which case its range is\n"
      + "identical to that of the <tt>unsigned long long int</tt> data type.)  You may\n"
      + "also refer to this data type as <tt>unsigned long</tt>.\n"
      + "</li>\n"
      + "     <li><tt>short int</tt><br/>\n"
      + "The 16-bit <tt>short int</tt> data type can hold integer values in the\n"
      + "range of -32,768 to 32,767.  You may also refer to this data type \n"
      + "as <tt>short</tt>, <tt>signed short int</tt>, or <tt>signed short</tt>.\n"
      + "</li>\n"
      + "     <li><tt>unsigned short int</tt><br/>\n"
      + "The 16-bit <tt>unsigned short int</tt> data type can hold integer values\n"
      + "in the range of 0 to 65,535.  You may also refer to this data type\n"
      + "as <tt>unsigned short</tt>.\n"
      + "</li>\n"
      + "     <li><tt>long long int</tt><br/>\n"
      + "The 64-bit <tt>long int</tt> data type can hold integer values in\n"
      + "the range of -9,223,372,036,854,775,808 to 9,223,372,036,854,775,807. You\n"
      + "may also refer to this data type as <tt>long long</tt>, <tt\n"
      + ">signed long long int</tt> or <tt>signed long long</tt>.\n"
      + "</li>\n"
      + "     <li><tt>unsigned long long int</tt><br/>\n"
      + "The 64-bit <tt>unsigned long long int</tt> data type can hold integer\n"
      + "values in the range of at least 0 to 18,446,744,073,709,551,615.  You may\n"
      + "also refer to this data type as <tt>unsigned long long</tt>.\n"
      + "</li>\n"
      + "   </ul>\n"
      + "   <!-- End of the integer types -->\n"
      + "</section>\n"
      + "<section titel=\"4.2 Floating Point Data Types\">\n"
      + "\n"
      + "\n"
      + "There are several data types that represent fractional numbers, such as\n"
      + "3.14159 and 2.83.  The exact sizes and ranges for the floating point data\n"
      + "types can vary from system to system; these values are stored in macro\n"
      + "definitions in the library header file <tt>float.h</tt>.  In this section,\n"
      + "we include the names of the macro definitions in place of their possible\n"
      + "values:\n"
      + "\n"
      + "     <ul>\n"
      + "<li><tt>float</tt><br/>\n"
      + "The <tt>float</tt> data type is the smallest of the three floating point\n"
      + "types, if they differ in size at all.  Its minimum value is stored in\n"
      + "the <tt>FLT_MIN</tt>, and is supposed to be no greater than 1e(-37). \n"
      + "Its maximum value is stored in <tt>FLT_MAX</tt>, and is supposed to be no\n"
      + "less than 1e37.\n"
      + "</li>\n"
      + "     <li><tt>double</tt><br/>\n"
      + "The <tt>double</tt> data type is at least as large as the <tt>float</tt> type, \n"
      + "and it may be larger.  Its minimum value is stored \n"
      + "in <tt>DBL_MIN</tt>, and its maximum value is stored in <tt>DBL_MAX</tt>.\n"
      + "</li>\n"
      + "     <li><tt>long double</tt><br/>\n"
      + "The <tt>long double</tt> data type is at least as large as \n"
      + "the <tt>float</tt> type, and it may be larger.  Its minimum value is stored \n"
      + "in <tt>LDBL_MIN</tt>, and its maximum value is stored in <tt>LDBL_MAX</tt>.\n"
      + "</li>\n"
      + "   </ul>\n"
      + "\n"
      + "\n"
      + " All floating point data types are signed; trying to use <tt>unsigned float</tt>,\n"
      + "for example, will cause a compile-time error.\n"
      + "\n"
      + "</section>\n"
      + "</kapitel>\n"
      + "\n"
      + "<printindex name=\"term\" titel=\"Begriffsindex\"/>\n"
      + "\n"
      + "<printindex name=\"Klassen\" titel=\"Programmverzeichnis\"/>\n"
      + "\n"
      + "\n"
      + "<listoffigures></listoffigures> \n"
      + "\n"
      + "\n"
      + "<bibliography></bibliography>\n"
      + "\n"
      + "<dontshow>\n"
      + "</dontshow>\n"
      + "\n"
      + "\n"
      + "\n"
      + "</anhang>\n"
      + "\n"
      + "</skript>"; 

  String skript = skript1+skript3+skript4+skript5+skript2+skript6+skript7+skript8+skript9;
      
  static void parse( String s, DefaultHandler handler) throws Exception {
    SAXParserFactory
    .newInstance()
    .newSAXParser()
    .parse(new InputSource(new StringReader(s)), handler);
  }  
  
  @Before
  public void setUp() throws Exception {
  }

  @Test
  public void test1() {
    handler = new GetCode("c", "Li");
    try {
      parse(skript, handler);
    } catch (Exception e) {
      e.printStackTrace();
    }
    assertEquals("Falsch extrahiert. class=\"Li\" existiert nicht in code Tag.","", handler.result.toString());
  }
  @Test
  public void test2() {
    handler = new GetCode("c", "VoidPointer");
    try {
      parse(skript, handler);
    } catch (Exception e) {
      e.printStackTrace();
    }
    String result ="#include <stdio.h>\n"
      + "\n"
      + "typedef struct {\n"
      + "  int x;\n"
      + "  int y;\n"
      + "} Punkt;int main(){\n"
      + "  void* object;  int x = 17;\n"
      + "  object = &x;  *(int*)object += 4; \n"
      + "  *(int*)object *= 2; \n"
      + "  printf(\"x = %i\\n\",x);  Punkt p = {2,6};\n"
      + "  object = &p;\n"
      + "\n"
      + "  printf(\"p.x: %i\\n\",p.x);\n"
      + "  printf(\"((Punkt*)object)->x: %i\\n\",((Punkt*)object)->x);\n"
      + "\n"
      + "  return 0;\n"
      + "}";
    assertEquals("Falsch extrahiert. class=\"VoidPointer\" mit lang=\"c\" wurde gesucht. Findet sich in mehreren code Tags.", result, handler.result.toString());
  }
  @Test
  public void test3() {
    handler = new GetCode("h", "Answer4");
    try {
      parse(skript, handler);
    } catch (Exception e) {
      e.printStackTrace();
    }
    String result ="#include <stdio.h>\n"
      + "\n"
      + "int getAnswer();";
    assertEquals("Falsch extrahiert. class=\"Answer4\" mit lang=\"h\" wurde gesucht.",result, handler.result.toString());
  }

  String simple = "<?xml version=\"1.0\"?>\n"
      + "<code class=\"Era\">murx<code>\n"
      + "<code lang=\"hs\" class=\"Era\">sieb (x:xs) = x:sieb[y|y&lt;-xs,y `mod` x /=0]</code>\n"
      + "</code><code/>\n"
      + "</code>\n"
      + "";
  
  @Test
  public void test4() {
    handler = new GetCode("h", "Answer4");
    try {
      parse(simple, handler);
    } catch (Exception e) {
      e.printStackTrace();
    }
    assertEquals("Falsch extrahiert. class=\"Answer4\" existiert nicht in code Tag.","", handler.result.toString());
  }
  @Test
  public void test5() {
    handler = new GetCode("hs", "Era");
    try {
      parse(simple, handler);
    } catch (Exception e) {
      e.printStackTrace();
    }
    String result ="sieb (x:xs) = x:sieb[y|y<-xs,y `mod` x /=0]";
    assertEquals("Falsch extrahiert.",result, handler.result.toString());
  }

  String complicated = "<?xml version=\"1.0\"?>\n"
      + "<code lang=\"hs\" class=\"Era\">sieb <code>(x:xs)</code> = x:sieb[y|y&lt;-xs,y `mod` x /=0]</code>";
  
  @Test
  public void test6() {
    handler = new GetCode("hs", "Era");
    try {
      parse(complicated, handler);
    } catch (Exception e) {
      e.printStackTrace();
    }
    String result ="sieb (x:xs) = x:sieb[y|y<-xs,y `mod` x /=0]";
    assertEquals("Dieses ist echt ein schwerer Test. Aus \n<code lang=\"hs\" class=\"Era\">sieb <code>(x:xs)</code> = x:sieb[y|y&lt;-xs,y `mod` x /=0]</code>\n das Programm Era.hs extrahieren.",result, handler.result.toString());
  }
}