import static org.junit.Assert.*;

import org.junit.Before;
import org.junit.Test;

public class DateTest {

  @Before
  public void setUp() throws Exception {
  }

  @Test
  public void test1() {
    Date d1 = new Date(1,1, 1919);
    Date d2 = new Date(2,1, 1919);
    assertTrue("Der "+d1+" liegt vor dem "+d2,d1.isEarlierThan(d2));
    assertFalse("Der "+d1+" liegt nicht nach dem "+d2,d1.isLaterThan(d2));
    assertFalse("Der "+d1+" und der "+d2+ " sind nicht dasselbe Datum",d1.isSameDate(d2));
  }

  @Test
  public void test2() {
    Date d1 = new Date(1,1, 1919);
    Date d2 = new Date(1,2, 1919);
    assertTrue("Der "+d1+" liegt vor dem "+d2,d1.isEarlierThan(d2));
    assertFalse("Der "+d1+" liegt nicht nach dem "+d2,d1.isLaterThan(d2));
    assertFalse("Der "+d1+" und der "+d2+ " sind nicht dasselbe Datum",d1.isSameDate(d2));
  }
  @Test
  public void test3() {
    Date d1 = new Date(1,1, 1919);
    Date d2 = new Date(1,1, 1920);
    assertTrue("Der "+d1+" liegt vor dem "+d2,d1.isEarlierThan(d2));
    assertFalse("Der "+d1+" liegt nicht nach dem "+d2,d1.isLaterThan(d2));
    assertFalse("Der "+d1+" und der "+d2+ " sind nicht dasselbe Datum",d1.isSameDate(d2));
  }
  @Test
  public void test4() {
    Date d1 = new Date(2,1, 1919);
    Date d2 = new Date(2,1, 1919);
    assertFalse("Der "+d1+" liegt nicht vor dem "+d2,d1.isEarlierThan(d2));
    assertFalse("Der "+d1+" liegt nicht nach dem "+d2,d1.isLaterThan(d2));
    assertTrue("Der "+d1+" und der "+d2+ " sind dasselbe Datum",d1.isSameDate(d2));
  }
  @Test
  public void test5() {
    Date d1 = new Date(2,1, 1900);
    assertFalse(d1.year+" war kein Schaltjahr", d1.isLeapYear());
  }  
  @Test
  public void test6() {
    Date d1 = new Date(2,1, 2017);
    assertFalse(d1.year+" war kein Schaltjahr", d1.isLeapYear());
  }  
  @Test
  public void test7() {
    Date d1 = new Date(2,1, 1984);
    assertTrue(d1.year+" war ein Schaltjahr", d1.isLeapYear());
  }  
  @Test
  public void test8() {
    Date d1 = new Date(2,1, 2000);
    assertTrue(d1.year+" war ein Schaltjahr", d1.isLeapYear());
  }  
  @Test
  public void test9() {
    Date d1 = new Date(2,1, 1900);
    assertEquals(d1.year+" war kein Schaltjahr", 365, d1.getAbsoluteDaysInYear());;
  }  

  @Test
  public void test10() {
    Date d1 = new Date(2,1, 1983);
    assertEquals(d1.year+" war kein Schaltjahr", 365, d1.getAbsoluteDaysInYear());;
  }  
  
  @Test
  public void test11() {
    Date d1 = new Date(2,1, 2000);
    assertEquals(d1.year+" war ein Schaltjahr", 366, d1.getAbsoluteDaysInYear());;
  }  
  @Test
  public void test12() {
    Date d1 = new Date(2,1, 1984);
    assertEquals(d1.year+" war ein Schaltjahr", 366, d1.getAbsoluteDaysInYear());;
  }

  @Test
  public void test13() {
    Date d1 = new Date(2,10, 1984);
    Date d2 = new Date(2,9, 1985);
    assertFalse(d2+" ist nicht früher als "+d1,d2.isEarlierThan(d1));
  }  
  
}
