import static org.junit.Assert.*;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import org.junit.Before;
import org.junit.Test;

public class AppointmentTest {

  static boolean eq(DateTime dt1,DateTime dt2){
    return
      dt1.date.day == dt2.date.day &&
      dt1.date.month == dt2.date.month &&
      dt1.date.year == dt2.date.year && 
      dt1.time.hour == dt2.time.hour &&
      dt1.time.minute == dt2.time.minute &&
      dt1.time.second == dt2.time.second ;
  }

  @Before
  public void setUp() throws Exception {
  }

  @Test
  public void test0() {
    Date d = new Date(14,7,1789);
    Time t = new Time(13, 22, 56);
    DateTime dt = new DateTime(d, t);
    Appointment ap = new Appointment(dt, 5, "Zahnarzt", "Burgstraße 4");
    DateTime exp = new DateTime(d,new Time(13, 27, 56));
    DateTime end = ap.endingTime();
    assertTrue("falscher Endzeitpunkt expected: "+exp+" but was: "+end,eq(exp,end));
    
  }

  @Test
  public void test1() {
    Date d = new Date(14,7,1789);
    Time t = new Time(13, 22, 56);
    DateTime dt = new DateTime(d, t);
    Appointment ap = new Appointment(dt, 45, "Zahnarzt", "Burgstraße 4");
    DateTime exp = new DateTime(d,new Time(14, 7, 56));
    DateTime end = ap.endingTime();
    assertTrue("falscher Endzeitpunkt expected: "+exp+" but was: "+end,eq(exp,end));
    
  }

  @Test
  public void test2() {
    Date d = new Date(14,7,1789);
    Time t = new Time(13, 22, 56);
    DateTime dt = new DateTime(d, t);
    Appointment ap = new Appointment(dt, 90, "Zahnarzt", "Burgstraße 4");
    DateTime exp = new DateTime(d,new Time(14, 52, 56));
    DateTime end = ap.endingTime();
    assertTrue("falscher Endzeitpunkt expected: "+exp+" but was: "+end,eq(exp,end));
    
  }



  @Test
  public void test3() {
    Date d = new Date(14,7,1789);
    Time t = new Time(13, 22, 56);
    DateTime dt = new DateTime(d, t);
    Appointment ap = new Appointment(dt, 150, "Zahnarzt", "Burgstraße 4");
    DateTime exp = new DateTime(d,new Time(15, 52, 56));
    DateTime end = ap.endingTime();
    assertTrue("falscher Endzeitpunkt expected: "+exp+" but was: "+end,eq(exp,end));
    
  }



  @Test
  public void test4() {
    Date d = new Date(14,7,1789);
    Time t = new Time(13, 22, 56);
    DateTime dt = new DateTime(d, t);
    Appointment ap = new Appointment(dt, 750, "Zahnarzt", "Burgstraße 4");
    DateTime exp = new DateTime(new Date(15,7,1789),new Time(1, 52, 56));
    DateTime end = ap.endingTime();
    assertTrue("falscher Endzeitpunkt expected: "+exp+" but was: "+end,eq(exp,end));
    
  }
  
  @Test
  public void test5() {
    Date d = new Date(14,7,1789);
    Time t = new Time(13, 22, 56);
    DateTime dt = new DateTime(d, t);
    Appointment ap = new Appointment(dt, 2190, "Zahnarzt", "Burgstraße 4");
    DateTime exp = new DateTime(new Date(16,7,1789),new Time(1, 52, 56));
    DateTime end = ap.endingTime();
    assertTrue("falscher Endzeitpunkt expected: "+exp+" but was: "+end,eq(exp,end));
    
  }
 @Test
  public void test6() {
    Date d = new Date(14,7,1789);
    Time t = new Time(23, 52, 56);
    DateTime dt = new DateTime(d, t);
    Appointment ap = new Appointment(dt, 10, "Zahnarzt", "Burgstraße 4");
    DateTime exp = new DateTime(new Date(15,7,1789),new Time(0, 2, 56));
    DateTime end = ap.endingTime();
    assertTrue("falscher Endzeitpunkt expected: "+exp+" but was: "+end,eq(exp,end));
    
  }

  
}