package name.panitz.util;

public interface List<E>{

  int size();

  E get(int i);

  void add(E el);

class AL<E> implements List<E>  {

  private int theSize = 0;
  private Object[] store = new Object[10];

  @Override public int size(){
    return theSize;
  }

  @SuppressWarnings("unchecked")  
  public E get(int i){
    if (i>=size()||i<0) throw new IndexOutOfBoundsException();

    return (E)store[i];
  }      


  public void add(E e){
    if (theSize>=store.length) enlargeStore();
    store[theSize++] = e;
  }

  private void enlargeStore(){
    Object[] newStore = new Object[store.length+10];
    for (int i=0;i<theSize;i++) newStore[i]=store[i];
    store=newStore;
  }

  @Override public String toString(){
    StringBuffer result = new StringBuffer("[");
    for (var i=0;i<size();i++){
      if (i>0) result.append(", ");
      result.append(store[i]);
    }
    result.append("]");
    return result.toString();
  }

  @Override public boolean equals(Object o){
    if (o instanceof List that){
      if (this.size()!=that.size()) return false;
      for (int i=0;i<size();i++){
        if (!this.get(i).equals(that.get(i)))return false;
      }
      return true;
    }
    return false;
  }
}

  static <E> List<E> of(){return new AL<>();}

  @SafeVarargs static <E> List<E> of(E...es){
    List<E> r = of();
    for (var e:es) r.add(e);
    return r; 
  }

  default boolean isEmpty(){return size()==0;}

  default List<E> take(int i){
    List<E> rs = of();
    /*ToDo*/
    return rs;  
  }

  default List<E> append(List<E> that){
    List<E> rs = of();
    return rs;  /*ToDo*/
  }

  default List<E> reverse(){
    return of();   /*ToDo*/
  }

  default boolean contains(E el) {
    return false;  /*ToDo*/
  }

  default E last(){
    return null;   /*ToDo*/
  }

  default void addAll(List<E> that){
    /*ToDo*/
  }

  default List<E> drop(int i){
    List<E> rs = of();
    return rs;  /*ToDo*/
  }

  default List<E> sublist(int from, int length) {
    return of();  /*ToDo*/
  }

  default List<E> intersperse(E e){
    return of();      /*ToDo*/
  }

  default boolean isPrefixOf(List<E> that){
    return false;     /*ToDo*/
  }

  default boolean isSuffixOf(List<E> that){
    return false;     /*ToDo*/
  }

  default boolean isInfixOf(List<E> that){
    return false;     /*ToDo*/
  }

  default List<E> rotate(){
    return of();  /*ToDo*/
  }

  default List<List<E>> tails(){
    return of(of());  /*ToDo*/
  }

  record Pair<A,B>(A fst,B snd){
    @Override public String toString(){
      return "("+fst()+", "+snd()+")";
    }
  }

  default <B> List<Pair<E,B>> zip(List<B> that){
    return of();   /*ToDo*/
  }

}