> module XML where



> data XML
>  =  Text (Maybe XML) Index  String
>    |Element  (Maybe XML)  Index Name Attributes ChildNodes



> type Name = String
> type ChildNodes = [XML]
> type Attribute = (Key,Value)
> type Attributes = [Attribute]
> type Key = String  
> type Value = String 
> type Index = Int



> instance (Show XML) where
>   show (Text _ _ txt) = txt
>   show (Element _ _ name attrs cs)
>      = "<"++name++concatMap showAttr attrs++">"
>            ++concatMap show cs++"</"++name++">"
>      where
>        showAttr (k,v) = " "++k++"=\""++v++"\"" 



> instance (Eq XML) where
>   (Text _ i1 txt1) == (Text _ i2 txt2) = txt1 == txt2
>   (Element _ i1 name1 attrs1 cs1) == (Element _ i2 name2 attrs2 cs2)
>    = name1==name2 && attrs1==attrs2 && cs1==cs2
>   _ == y = False



> mkElement :: Name -> Attributes -> [XML] -> XML
> mkElement n as cs = r
>   where
>     r = Element Nothing (-1) n as (map (setParent r)(zip [0..] cs))



>     setParent p (n, (Text _ _ txt) ) = Text (Just p) n txt
>     setParent p (n, (Element _ _ na as cs)) = r
>      where
>        r = Element (Just p) n na as (map (setParent r)(zip [0..] cs))



> mkText :: String -> XML
> mkText = Text Nothing (-1)



> type XPathAchsis = XML -> [XML]



> self ::  XPathAchsis
> self n = []



> parent :: XPathAchsis
> parent _ = []



> ancestor :: XPathAchsis
> ancestor x = []



> ancestorOrSelf :: XPathAchsis
> ancestorOrSelf _ = []



> child :: XPathAchsis
> child _ = []



> descendant :: XPathAchsis
> descendant x = []



> descendantOrSelf :: XPathAchsis
> descendantOrSelf x = []



> followingSibbling :: XPathAchsis
> followingSibbling _ = [] 



> precedingSibbling :: XPathAchsis
> precedingSibbling _ = [] 



> following :: XPathAchsis
> following xml = [ ]



> preceding :: XPathAchsis
> preceding xml = [ ]

