package name.panitz.util.tree;

import static org.junit.Assert.*;
import java.util.function.Consumer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.Spliterator;
import org.junit.Before;
import org.junit.Test;
import java.util.stream.StreamSupport;

public class TTest {
  Tree<String> george;
  Tree<String> elizabeth;
  Tree<String> charles;
  Tree<String> william;
  Tree<String> george2;
  Tree<String> charlotte;
  Tree<String> louis;
  Tree<String> harry;
  Tree<String> archie;
  Tree<String> anne;
  Tree<String> peter;
  Tree<String> savannah;
  Tree<String> isla;
  Tree<String> zara;
  Tree<String> mia;
  Tree<String> lena;
  Tree<String> andrew;
  Tree<String> beatrice;
  Tree<String> eugenie;
  Tree<String> edward;
  Tree<String> louise;
  Tree<String> james;
  Tree<String> magaret;
  Tree<String> david;
  Tree<String> charles2;
  Tree<String> margarita;
  Tree<String> sarah;
  Tree<String> samuel;
  Tree<String> arthur;
  int i = 0;  
  
  @Before
  public void init() {
    i = 0;
    george2 = new Tree<>("George");
    charlotte = new Tree<>("Charlotte");
    louis= new Tree<>("Louis");
    william = new Tree<>("William",george2,charlotte,louis);

    archie = new Tree<>("Archie");    
    harry = new Tree<>("Harry",archie);
        
    charles = new Tree<>("Charles",william,harry);
   

    savannah = new Tree<>("Savannah");
    isla = new Tree<>("Isla");
    peter = new Tree<>("Peter",savannah,isla);
    
    mia = new Tree<>("Mia");
    lena=new Tree<>("Lena");
    zara = new Tree<>("Zara",mia,lena);

    anne = new Tree<>("Anne",peter,zara);                

    beatrice = new Tree<>("Beatrice");
    eugenie = new Tree<>("Eugenie");
    andrew = new Tree<>("Andrew",beatrice,eugenie);
  
    louise = new Tree<>("Louise");      
    james = new Tree<>("James");
    edward = new Tree<>("Edward",louise,james);
    
    elizabeth = new Tree<>("Elizabeth",charles,anne,andrew,edward);


    charles2 = new Tree<>("Charles");
    margarita = new Tree<>("Margarita");
    david = new Tree<>("David",charles2,margarita);

    samuel = new Tree<>("Samuel");
    arthur = new Tree<>("Arthur");
    sarah = new Tree<>("Sarah",samuel,arthur);  

    magaret = new Tree<>("Magaret",david,sarah);
  
    george = new Tree<>("George",elizabeth,magaret);
  }

  @Test
  public void testCount1() {
    assertEquals("falsche Knotenanzahl im Sequenziellen",29L,george.stream().reduce(0L,(r,x)->r+1,(x,y)->x+y).longValue());
  }

  @Test
  public void testCount2() {
    assertEquals("falsche Knotenanzahl im Parallelen",29L,george.parallelStream().reduce(0L,(r,x)->r+1,(x,y)->x+y).longValue());
  }
  @Test
  public void testContains1() {
    assertTrue("falsche contains im Sequenziellen",george.stream().reduce(false,(r,x)->r||x.equals("Louis"),(x,y)->x||y));
  }
  @Test
  public void testContains2() {
    assertTrue("falsche contains im Parallelen",george.parallelStream().reduce(false,(r,x)->r||x.equals("Louis"),(x,y)->x||y));
  }
  @Test
  public void testContains3() {
    assertTrue("falsche not contains im Sequenziellen",!george.stream().reduce(false,(r,x)->r||x.equals("Wilhelm"),(x,y)->x||y));
  }
  @Test
  public void testContains4() {
    assertTrue("falsche not contains im Parallelen",!george.parallelStream().reduce(false,(r,x)->r||x.equals("Wilhelm"),(x,y)->x||y));
  }
  @Test
  public void testtrySplit1() {
    Spliterator<String> splitter = george.getSpliterator();
    var splitter2 = splitter.trySplit();
    assertNotNull(splitter2);
    var s1 = StreamSupport.stream(splitter,true);
    var s2 = StreamSupport.stream(splitter2,true);
    var i1 = s1.reduce(0L,(r,x)->r+1,(x,y)->x+y).longValue();
    var i2 = s2.reduce(0L,(r,x)->r+1,(x,y)->x+y).longValue();
    assertEquals(29L,i1+i2);
  }
  class S<E> implements Spliterator<E>{
    Spliterator<E> sp;
    S(Spliterator<E> sp){this.sp=sp;}
    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
      return sp.tryAdvance(action);
    }
  
    @Override
    public Spliterator<E> trySplit() {
      var r = sp.trySplit();
      if (r==null) return null;
      i++;
      return new S<>(r);
    }
    @Override
    public long estimateSize() {
      return sp.estimateSize();
    }
    @Override
    public int characteristics() {
      return sp.characteristics();
    }
  }

  @Test
  public void testtrySplit2() {
    Spliterator<String> splitter = new S<>(george.getSpliterator());
    var s1 = StreamSupport.stream(splitter,true);
    var i1 = s1.reduce(0L,(r,x)->r+1,(x,y)->x+y).longValue();
    assertEquals(29L,i1);
    assertTrue("it seems, that it could have been splitted more often",20L<i);
  }

}