package name.panitz.util.tree;
import java.util.ArrayList;
import java.util.List;
import java.util.function.*;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Tree<E> {
  final E element;
  final List<Tree<E>> children;
  private Tree<E> parent=null;
    
  public Tree<E> getParent() {
    return parent;
  }

  public void setParent(Tree<E> p) {
    if (null!=parent)throw new RuntimeException("Multiple assignment to parent node.");
    this.parent = p;
  }

  @SafeVarargs
  public Tree(E element, Tree<E>... children) {
    this.element = element;
    this.children = List.of(children);
    this.children.parallelStream().forEach(child->child.setParent(this));
  }

  public int size(){
    return
      children.parallelStream().reduce(0, (r,c)->c.size()+r,(x,y)->x+y)+1;
  }

  @Override
  public String toString() {
    return element.toString()+children.toString();
  }
  
  public MySplit getSpliterator(){
    return new MySplit();
  }
  private class MySplit implements Spliterator<E>{  
    /*TODO*/
  }

  public Stream<E> stream(){return StreamSupport.stream(getSpliterator(), false);}
  public Stream<E> parallelStream(){return StreamSupport.stream(getSpliterator(), true);}

  
}
    